﻿---

[[toc]]

---

# Справка по программе demo_testbench.pas

Программа **demo_testbench** - это демонстрационная и тестовая программа,
на которой проверяются и отлаживаются различные процедуры и функции,
а также иллюстрируются некоторые возможности **DAQ** системы.

---

## Использование программы demo_testbench

Тестовая система **demo_testbench** является консольной программой, т.е.
ввод-вывод делается в консольном окне **Консоль demo_testbench**.
Для вызова тестов следует набрать команду:
```
@test n
```
где **n** - номер теста, отличный от нуля.

Тесты с отрицательными номерами **n** используются для проверки кодов,
содержащих (серьезные) ошибки. Они служат для проверки устойчивости системы
к сбоям и нештатным ситуациям и для тестирования системы диагностики
 и обработки ошибок.

Тесты с положительными номерами **n** используются для программных кодов,
проверяющих и иллюстрирующих обычную (штатную) работу **DAQ Pascal**.


Справку по программе можно получить по команде **`@help`**.

---

## Краткое описание тестов demo_testbench

Следующие тесты вызывают (фатальные) ошибки с генерацией исключения
и перезапуском программы **demo_testbench** (пакет **CRW-DAQ** при этом
должен продолжать работу).

+ **`@Test -4`**  - проверка фатальной ошибки типа "мертвая петля"
  со стрессовой нагрузкой на **100%**.

+ **`@Test -3`**  - проверка фатальной ошибки типа "мертвая петля"
  без нагрузки (с засыпанием).
  
+ **`@Test -2`**  - проверка фатальной ошибки типа "неверный индекс массива".

+ **`@Test -1`**  - проверка фатальной ошибки типа "целочисленное деление на ноль".

Следующие тесты иллюстрируют работу **DAQ Pascal** с выводом результатов
в консольное окно программы **demo_testbench**.

+ **`@Test +1`**  - измеряет скорость (производительность) некоторых операций **DAQ Pascal**.

+ **`@Test +2`**  - иллюстрирует вызов функции времени **msecnow** и измеряет её скорость.

+ **`@Test +3`**  - иллюстрирует функции анализа аргументов командной строки.

+ **`@Test +4`**  - иллюстрирует синтаксический анализ строк с помощью функций **IsLexeme**.

+ **`@Test +5`**  - проверяет работу регулярных выражений **regexp**.

+ **`@Test +6`**  - проверяет работу функций **backslash_encode/decode**.

+ **`@Test +7`**  - проверяет работу функции **ColorToString**.

+ **`@Test +8`**  - проверяет работу функций **FSM** (конечных автоматов).

+ **`@Test +9`**  - проверяет работу функций **UpCase/LoCase**.

+ **`@Test 10`**  - проверяет работу функций **htonl/ntohl**.

+ **`@Test 11`**  - проверяет работу оператора **case**.

+ **`@Test 12`**  - проверяет работу функций **DbApi** с базой данных **Firebird**.

+ **`@Test 13`**  - проверяет работу функций **DbApi** с базой данных **SQLite3**.

+ **`@Test 14`**  - проверяет работу функций **DbApi** с базой данных **Firebird**.
  При этом используется библиотека шаблонов строк подключения и кодирование пароля.

+ **`@Test 15`**  - проверяет работу функции **poseol**.

+ **`@Test 16`**  - проверяет работу функций **DbApi** с базой данных **Firebird**.
  При этом используется добавление полей/обновление (db_addnew/db_update) через
  набор записей (*recordset*), без явного **SQL** запроса (insert,update).
  Это наиболее быстрый и точный (без ошибок округления) способ записи данных
  в **БД**, рекомендуемый к применению.

+ **`@Test 17`**  - проверяет работу функций преобразования времени **StrTimeFmt**, **GetDateTime**.

+ **`@Test 18`**  - проверяет работу констант - **`$HEX`**, **`&OCT`**, **`%BIN`**.

+ **`@Test 19`**  - проверяет работу функций работы с векторами (динамическими массивами).

+ **`@Test 20`**  - проверяет работу операторов сравнения и арифметических операций при использовании Nan и Inf.

+ **`@Test 21`**  - проверяет работу функций разбора слов и фраз (набора слов с кавычками).

+ **`@Test 22`**  - проверяет работу функций чтения/записи файлов и измеряет скорость вызова некоторых функций.

+ **`@Test 23`**  - измеряет скорость вызова **InRange**, **EnsureRange** и других функций.

---

Желаем приятного использования тестовой программы **demo_testbench**.

---

> **CRW-DAQ** *Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru*

---
