 {
 А.Н.Вьюшин
 Последняя редакция: Ю.И.Виноградов 26.07.2007

 Драйвер, осуществляющий управление,обмен данными
 с цифровым регистратором "Tektronix" TDS3034.
 Переменные в конфиге:
 ComPort       = 2			- номер порта
 ChanMap       = 1111		- список каналов чтения
 IndexNumber   = 1			- номер регистратора
 }
program TDS_DRV;					         	{ Программа управления Tektronix TDS3034 }
const							         	{ Константы:                             }
 dfTrouble    = 1;       					{ DebugFlags - Trouble       }
 dfSuccess    = 2;       					{ DebugFlags - Success       }
 Debug         = false;                        	{ Флаг вывода отладочных сообщений       }
 Timeout		= 2000;            		         	{ Таймаут для приёма сообщений COM порта }
 MaxNumPoints	= 100;				         	{ Макс. кол-во точек, считываемых за раз }
 cmdStatus	= 1;					         	{ Индекс команды чтения статуса          }
 NegConst		= 65536;				         	{ Константа для преобразования отр.чисел }
 MaxSmallInt	= 32767;				         	{ Максимальное положительное 2 байтовое  }
 TrigSrcList  = '1,2,3,4,5';					{ Возможные источники запуска}
 TrigRejList	= 'AC,DC,HFREJ,LFREJ,NOISEREJ';	{ Возможные значения фильтров триггера}
 AdcCoefX		= 1e6;						{ Коэффициент для шкалы времени}
 AdcCoefY		= 1;							{ Коэффициент для шкалы вольт}
 DivTCoef	= 0.1; 						     { Коэффициент для задания шкалы времени}
 DivVCoef	= 0.25;						     { Коэффициент для задания шкалы вольт}
 {
 Идентификаторы сообщений
 }
 cmHelp       	= '@HELP';		{ справка                                }
 cmRegMode	= '@REG_MODE';		{ =i Регистратор в дистанционном режиме  }
 cmRegFile	= '@REG_FILE';		{ =s Файл данных s готов                 }
 cmRegEnd		= '@REG_END';		{ =i Все каналы прочитаны                }
 cmRegArm		= '@REG_ARM';		{ =i Насторожить регистратор             }
 cmTrigTdelay	= '@TRIG_DELAY';	{ =r Предыстория, секунды                }
 cmTrigTsource	= '@TRIG_SOURCE';	{ =i Канал-источник запуска (5=EXT)      }
 cmTrigTlevel	= '@TRIG_LEVEL';	{ =r Уровень запуска в вольтах           }
 cmTrigTcoupl	= '@TRIG_COUPLING';	{ =s AC,DC,HFREJ,LFREJ-синхрон. запуска  }
 cmTrigTslope	= '@TRIG_SLOPE';	{ =i Знак запуска (NEG-0,POS-1)          }
 cmDivT		= '@DIV_T';		{ =r Установить гориз. развертку, сек    }
 cmDivV1		= '@DIV_V1';		{ =r Вертик. развертка 1 в вольтах       }
 cmDivV2		= '@DIV_V2';		{ =r Вертик. развертка 2 в вольтах       }
 cmDivV3		= '@DIV_V3';		{ =r Вертик. развертка 3 в вольтах       }
 cmDivV4		= '@DIV_V4';		{ =r Вертик. развертка 4 в вольтах       }
 cmReadData	= '@READ_DATA';	{ =i Начать чтение данных регистратра    }
 cmPreset  	= '@PRESET';      	{ вызов диалога уставок                  }
var
 b			  : boolean;              { Временная                              }
 Ok			  : boolean;              { Флаг "все в порядке"                   }
 errors		  : integer;              { Счетчик ошибок                         }
 errorcode	  : integer;              { Код ошибок модуля                      }
 fixmaxavail     : integer;
 DebugFlags      : Integer;             { see dfXXX constants        }
 s			  : string;               { Временная                              }
 CR			  : char;                 { Cимвол возврата каретки                }
 ComPort		  : integer;              { Номер COM порта                        }
 ChanMap		  : string;               { Список каналов, навроде 1010           }
 ComBuff		  : string;               { Буфер для ввода из COM порта           }
 cmdIdent		  : string;               { Идентификатор принятой команды ЦЭВМ    }
 cmdValue		  : string;               { Значение принятой команды ЦЭВМ         }
 cmdIndex		  : integer;              { Индекс выполняемой внутренней команды  }
 cmdFormat	  : integer;              { Индекс команды установки форматов      }
 QueryTime	  : real;                 { Время DataQuery, для проверки таймаута }
 Query		  : string;               { Посланый запрос, сброс по обработке    }
 Reply		  : string;               { Ответ TDS на посланный запрос          }
 CurrChan		  : integer;              { Текущий канал считывания регистратора  }
 ExpectBinary	  : boolean;              { Ожидается чтение двоичных данных       }
 ExpectHeader	  : boolean;              { Ожидается чтение заголовка блока данных}
 PosCR		  : integer;              { Позиция символа возврата каретки       }
 NumPoints	  : integer;              { Количество считываемых точек данных    }
 FirstPoint	  : integer;              { Номер первой считываемой точки         }
 HeaderSize	  : integer;              { Размер заголовка блока бинарных данных }
 HorRecord	  : integer;              { Колич-во точек на одну читаемую запись }
 ChanCount	  : integer;              { Сколько каналов прочитали              }
 i,j,code		  : integer;              { Временные                              }
 r			  : real;                 { Временная                              }
 hoff		  : real;                 { Позиция триггера по оси абсцисс        }
 voff		  : real;                 { Вертикальное смещение формы сигнала    }
 hgan		  : real;                 { Интервал времени между оцифровкой      }
 vgan		  : real;                 { Масштаб по оси ординат                 }
 hsft		  : real;                 { 0,если канал включен;иначе код 2244    }
 vsft		  : real;                 { Вертикальная позиция формы отн.центра  }
 x, y            : real;                 { Ордината и абсцисса точки кривой }
 cref            : real;                 { Ссылки на кривые }
 
 tag               : record           {в этой записи хранятся все теги}
  RegOnline        : integer;         {индикаторы связи ЛЭВМ с регистраторами}
  RegReady         : integer;         {индикаторы готовности регистраторов к измерению}
  RegMode          : integer;         {индикаторы дистанционного режима}
  TrigSrc          : integer;         {источник запуска триггера регистратора}
  TrigRej          : integer;         {тип фильтра триггера}
  TrigHisUnit      : integer;         {единицы измерения задержки}
  TrigHisUnits     : integer;         {единицы предыстории (задержки) }
  TrigHis          : integer;         {предыстория (задержка) }
  TrigSlp          : integer;         {запуск по переднему/заднему фронту}
  TrigLev          : integer;         {уровень запуска триггера}
  DivTUnit         : integer;         {единицы измерения развертки}
  DivTUnits        : integer;         {единицы развертки по времени}
  DivT             : integer;         {развертка по времени}
  DivV1            : integer;         {развертка канала 1 по вольтажу}
  DivV2            : integer;         {развертка канала 2 по вольтажу}
  DivV3            : integer;         {развертка канала 3 по вольтажу}
  DivV4            : integer;         {развертка канала 4 по вольтажу}
  DataDone         : integer;         {чтение данных с регистратора завершено}
  Notify           : integer;         {теги уведомления диалогов}
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:boolean;
 begin
  if iand(DebugFlags,dfTrouble)>0 then
  if Length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)>0 then
  if Length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Очистка всех строк
 }
 procedure ClearStrings;
 begin
  s:='';
  ChanMap:='';
  ComBuff:='';
  cmdIdent:='';
  cmdValue:='';
  Query:='';
  Reply:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Фиксация ошибки.
 }
 procedure IoError(Reason:string);
 begin
  if Length(Reason)>0 then writeln(devname,': ERROR="',Reason,'"');
  b:=fixerror(errorcode);
 end;
 {
 Проверить, существует ли канал в списке ChanMap
 }
 function ChanExists(n:integer):boolean;
 begin
  ChanExists:=(n>=1) and (n<=length(ChanMap));
 end;
 {
 Проверить, включен ли канал в списке ChanMap
 }
 function ChanOn(n:integer):boolean;
 begin
  if (n>=1) and (n<=length(ChanMap))
  then ChanOn:=(ChanMap[n]='1')
  else ChanOn:=false;
 end;
 {
 Получить координату последней точки кривой
 }
 procedure getcrvxyn(ref:real; var x,y:real);
 var n:integer; b:boolean;
 begin
  x:=0;
  y:=0;
  if ref<>_nil then begin
   b:=crvlock(ref);
   n:=round(crvlen(ref));
   if n>0 then begin
    x:=crvx(ref,n);
    y:=crvy(ref,n);
   end;
   b:=crvunlock(ref);
  end;
 end;
 {
 Принять команды из консоли
 1 слово - имя переменной
 2 слово - значение 
 Например: REG_TRIG_SLOPE=FALL
 }
 procedure cmdReceive;
 begin
  if Length(cmdIdent)=0 then
  if not eof then begin
   readln(cmdValue);
   if ioresult=0 then begin
    cmdIdent:=upcasestr(extractword(1,cmdValue));
    cmdValue:=upcasestr(extractword(2,cmdValue));
   end else begin
    cmdIdent:='';
    cmdValue:='';
    IoError('cmdReceive fails');
   end;
  end;
 end;
 {
 Очистить приемник COM-порта и передать в порт новый запрос
 }
 procedure SendQuery(aQuery:string);
 begin
  Query:='';
  Reply:='';
  ComBuff:='';
  while length(comread(80))>0 do;
  if Length(aQuery)>0 then
  if comwrite(aQuery+CR) then begin
   Query:=aQuery;
   QueryTime:=msecnow;
   if Debug then writeln(devname,': QUERY ',aQuery);
  end else IoError('SendQuery fails');
 end;
 {
 Очистить запрос
 }
 procedure FreeQuery(aReply:string);
 begin
  if ( ( Length(aReply)>0 ) and ( Debug ) ) then writeln(devname,': REPLY ',aReply);
  Query:='';
  Reply:='';
  ComBuff:='';
  while length(comread(80))>0 do;
 end;
 {
 Инициализировать и проверить тег
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Инициализировать и проверить кривую
 }      
 procedure InitCrv(var crv:real; name:string);
 begin
  crv:=crvfind(name);
  if crv=_nil then errors:=errors+1;
 end;
 {
 Посылка команды cmd в очередь команд
 }
 procedure SendCmd(ident,value:string);
 var b:boolean;
     i:integer;
 begin
  if (Length(ident)>0) and (Length(value)>0) then begin
   r:=devmsg(devname+' '+ident+'='+value+CRLF);
   if r=0 then IoError('Command queue overflow on "'+ident+'='+value+'"');
  end;
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 procedure GetDateTime(var s:String);
 var ms:Real;
 begin
  s:='';
  ms:=msecnow;
  s:=str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
 end;
 {
 Save parameters
 }
 procedure SaveParams;
 var IniFile,Section:String; i,j:Integer;
  procedure SaveItem(Item:String);
  begin
   Writeln(Item);
{   b:=Echo(DevName+' : '+Item);}
  end;
 begin
  IniFile:=AdaptFileName(ReadIni('PresetIniFile'));
  Section:=ReadIni('PresetSection');
  if Length(IniFile)>0 then
  if Length(Section)>0 then begin
   IniFile:=DaqFileRef(IniFile,'.ini');
   i:=Rewrite(IniFile);
   SaveItem(Section);
   GetDateTime(s);
   SaveItem(';Modified: '+s);

   writeln('TrigSrc      = ',igettag(tag.TrigSrc));
   writeln('TrigRej      = ',igettag(tag.TrigRej));
   writeln('TrigHisUnit  = ',igettag(tag.TrigHisUnit));
   writeln('TrigHisUnits = ',rgettag(tag.TrigHisUnits));
   writeln('TrigSlp      = ',igettag(tag.TrigSlp));
   writeln('TrigLev      = ',rgettag(tag.TrigLev));
   writeln('DivTUnit     = ',igettag(tag.DivTUnit));
   writeln('DivTUnits    = ',rgettag(tag.DivTUnits));
   writeln('DivV1        = ',rgettag(tag.DivV1));
   writeln('DivV2        = ',rgettag(tag.DivV2));
   writeln('DivV3        = ',rgettag(tag.DivV3));
   writeln('DivV4        = ',rgettag(tag.DivV4));

   SaveItem('[]');
   i:=Rewrite('');
  end;
  IniFile:='';
  Section:='';
 end;
 {
 Load parameters
 }
 procedure LoadParams;
 var IniFile,Section:String; i,j,Content:Integer;
 begin
  IniFile:=AdaptFileName(ReadIni('PresetIniFile'));
  Section:=ReadIni('PresetSection');
  if Length(IniFile)>0 then
  if Length(Section)>0 then begin
   IniFile:=DaqFileRef(IniFile,'.ini');
   if FileExists(IniFile) then begin
   b:=isettag(tag.TrigSrc,     val(readini(IniFile+   ' '+Section+' TrigSrc')));
   b:=isettag(tag.TrigRej,     val(readini(IniFile+   ' '+Section+' TrigRej')));
   b:=isettag(tag.TrigHisUnit, val(readini(IniFile+   ' '+Section+' TrigHisUnit')));
   b:=rsettag(tag.TrigHisUnits,rval(readini(IniFile+  ' '+Section+' TrigHisUnits')));
   b:=isettag(tag.TrigSlp,     val(readini(IniFile+   ' '+Section+' TrigSlp')));
   b:=rsettag(tag.TrigLev,     rval(readini(IniFile+  ' '+Section+' TrigLev')));
   b:=isettag(tag.DivTUnit, 	  val(readini(IniFile+   ' '+Section+' DivTUnit')));
   b:=rsettag(tag.DivTUnits,   rval(readini(IniFile+  ' '+Section+' DivTUnits')));
   b:=rsettag(tag.DivV1,       rval(readini(IniFile+  ' '+Section+' DivV1')));
   b:=rsettag(tag.DivV2,       rval(readini(IniFile+  ' '+Section+' DivV2')));
   b:=rsettag(tag.DivV3,       rval(readini(IniFile+  ' '+Section+' DivV3')));
   b:=rsettag(tag.DivV4,       rval(readini(IniFile+  ' '+Section+' DivV4')));
   end;
  end;
  IniFile:='';
  Section:='';
 end;
 {
 Посылка команд уставки регистратора
 }
 procedure SendPresets;
 var
  r   : real;
  ini : string;
 begin
  ini:='';
  SendCmd(cmTrigTsource,extractword(igettag(tag.TrigSrc)+1,TrigSrcList));
  SendCmd(cmTrigTcoupl,	extractword(igettag(tag.TrigRej)+1,TrigRejList));
  case (igettag(tag.TrigHisUnit)) of  
   0: r:=rgettag(tag.TrigHisUnits);
   1: r:=1E-3*rgettag(tag.TrigHisUnits);
   2: r:=1E-6*rgettag(tag.TrigHisUnits);
   3: r:=1E-9*rgettag(tag.TrigHisUnits);
  end;
  SendCmd(cmTrigTdelay,	str(r));
  SendCmd(cmTrigTslope, extractword(1+ord(igettag(tag.TrigSlp)=1), 'FALL, RIS'));
  SendCmd(cmTrigTlevel,	str(rgettag(tag.TrigLev)));
  case (igettag(tag.DivTUnit)) of
   0: r:=rgettag(tag.DivTUnits);
   1: r:=1E-3*rgettag(tag.DivTUnits);
   2: r:=1E-6*rgettag(tag.DivTUnits);
   3: r:=1E-9*rgettag(tag.DivTUnits);
  end;
  SendCmd(cmDivT,	str(r));
  SendCmd(cmDivV1,	str(rgettag(tag.DivV1)));
  SendCmd(cmDivV2,	str(rgettag(tag.DivV2)));
  SendCmd(cmDivV3,	str(rgettag(tag.DivV3)));
  SendCmd(cmDivV4,	str(rgettag(tag.DivV4)));
  SaveParams;
 end;
 {
 Тело основной программы
 }
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {
  Инициализация счетчиков ошибок
  }
  errors:=0;
  errorcode:=registererr(devname+' - '+progname);
  {
  Инициализация общих констант и строк
  }
  CR:=chr(13);
  cmdIndex:=0;
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  {
  Инициализация тегов
  }
  InitTag(tag.RegOnline,    readini('TagRegOnline'),   1);
  InitTag(tag.RegReady,	    readini('TagRegReady'),    1);
  InitTag(tag.RegMode,	    readini('TagRegMode'),     1);
  InitTag(tag.TrigSrc,	    readini('TagTrigSrc'),     1);
  InitTag(tag.TrigRej,	    readini('TagTrigRej'),     1);
  InitTag(tag.TrigHisUnit,  readini('TagTrigHisUnit'), 1);
  InitTag(tag.TrigHisUnits, readini('TagTrigHisUnits'),2);
  InitTag(tag.TrigHis,	    readini('TagTrigHis'),     2);
  InitTag(tag.TrigSlp,	    readini('TagTrigSlp'),     1);
  InitTag(tag.TrigLev,	    readini('TagTrigLev'),     2);
  InitTag(tag.DivTUnit,     readini('TagDivTUnit'),    1);
  InitTag(tag.DivTUnits,    readini('TagDivTUnits'),   2);
  InitTag(tag.DivT,	         readini('TagDivT'),        2);
  InitTag(tag.DivV1,	    readini('TagDivV1'),       2);
  InitTag(tag.DivV2,	    readini('TagDivV2'),       2);
  InitTag(tag.DivV3,	    readini('TagDivV3'),       2);
  InitTag(tag.DivV4,	    readini('TagDivV4'),       2);
  InitTag(tag.DataDone,     readini('TagDataDone'),    1);
  InitTag(tag.Notify,       readini('TagNotify'),      1);

(*
  {
  Открыть консольное окно
  }
  b:=winhide('КОНСОЛЬ '+devname);
  b:=winshow('КОНСОЛЬ '+devname);
  b:=windraw('КОНСОЛЬ '+devname+
             '|width=300'+
             '|height=300'+
             '|top='+ str(((regNUM-1) div 4)*300)+
             '|left='+str(((regNUM-1) mod 4)*300+300));
*)
  {
  Прочитать ComPort, ChanMap, распечатать
  }
  ComPort:=val(readini('ComPort'));
  errors:=errors+ord(ComPort=0);
  ChanMap:=copy(readini('ChanMap'),1,4);
  errors:=errors+ord(length(ChanMap)=0);
  writeln(devname,': START');
  writeln(devname,': Com ChanMap');
  writeln(devname,': ',ComPort:3,' ',ChanMap:7);
  {
  Открыть COM порт
  }
  if not comopen('[SerialPort-COM'+readini('ComPort')+']') then begin
   writeln('COM',readini('ComPort'),' порт не открывается!');
   writeln('Закрывайте конфигурацию!');
   errors:=errors+1;
  end;
  Ok:=(errors=0);
  if Ok then begin
   LoadParams;
  end;
  {
  Анализ ошибок
  }
  if errors=0 then Success('Start Ok') else Trouble('Start Fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Stop actions
 }
 if isinf(runcount) then begin
  writeln(devname,': STOP');
  ClearStrings;
 end else
 {
 Действия в процессе опроса
 }
 if Ok then begin
  {
  Проверка статуса ввода-вывода
  }
  if ioresult<>0 then IoError('File I/O error.');
  {
  Прием команд от центральной машины: cmdIdent-имя переменной; cmdValue-ее значение
  }
  cmdReceive;
  {
  Если ожидаем ответа, накапливаем данные в ComBuff и формируем Reply
  }
  if (Length(Query)>0) and (Length(Reply)=0) then begin
   if ExpectBinary then begin
    {
    При чтении двоичных данных сначала читаем заголовок блока, потом тело блока.
    Символ CR здесь роли не играет. По таймауту сбрасываем операцию чтения.
    }
    if msecnow<QueryTime+Timeout then begin
     if ExpectHeader then begin
      if length(ComBuff)<2 then ComBuff:=ComBuff+comread(2) else begin
       HeaderSize:=2+ord(ComBuff[2])-ord('0');
       ExpectHeader:=false;
      end;
     end else begin
      if length(ComBuff)<(HeaderSize+NumPoints*2) then ComBuff:=ComBuff+comread(255) else begin
       Reply:=copy(ComBuff,1+HeaderSize,NumPoints*2);
       ComBuff:=copy(ComBuff,1+HeaderSize+NumPoints*2,255);
       ExpectBinary:=false;
       ExpectHeader:=false;
       b:=isettag(tag.RegOnline, 1);
      end;
     end;
    end else begin
     ExpectBinary:=false;
     ExpectHeader:=false;
     cmdIndex:=cmdStatus;
     FreeQuery('TIMEOUT, BINARY');
     IOError('TimeOut, Binary');
     b:=isettag(tag.RegOnline, 0);
    end;
   end else begin
    {
    При чтении ASCII данных ищем символ CR для выделения сообщения.
    По таймауту сбрасываем операцию чтения.
    }
    if msecnow<QueryTime+Timeout then begin
     if pos(CR,ComBuff)=0 then ComBuff:=ComBuff+comread(255) else begin
      PosCR:=pos(CR,ComBuff);
      if PosCR>0 then begin
       Reply:=copy(ComBuff,1,PosCR-1);
       ComBuff:=copy(ComBuff,PosCR+1,255);
       b:=isettag(tag.RegOnline, 1);
      end else begin
       if Length(ComBuff)>250 then begin
        FreeQuery('Line is too long.');
        IOError('Line is too long.');
       end;
      end;
     end;
    end else begin
     FreeQuery('TIMEOUT, QUERY');
     IOError('TimeOut, Query');
     b:=isettag(tag.RegOnline, 0);
    end;
   end;
  end else begin
   {
   Основной цикл команд
   }
   if (cmdIndex<0) or (cmdIndex>7) then begin
    IOError('Invalid cmdIndex='+str(cmdIndex));
    cmdIndex:=cmdStatus;
   end else
   case cmdIndex of
    {
    Инициализация, выполняется один раз в начале работы
    }
    0: begin
        if Length(Query)=0
        then SendQuery(':RS232:TRAN:TERM?;:RS232:HARDF?;:MESS:STATE?;:VERB?;:HEAD?')
        else
        if Length(Reply)>0 then begin
         cmdIndex:=cmdIndex+ord((extractword(1,Reply)='CR') and
                                (extractword(2,Reply)='0')  and
                                (extractword(3,Reply)='0')  and
                                (extractword(4,Reply)='0')  and
                                (extractword(5,Reply)='0'));
         FreeQuery(Reply);
        end;
       end;
    {
    Чтение статуса.
    Для снижения трафика передаем только 2 раза в секунду или при изменении статуса.
    }
    1: begin
        if Length(Query)=0
        then SendQuery(':TRIG:STATE?;:LOC?')
        else
        if Length(Reply)>0 then begin
         i:=ord(extractword(1,Reply)='READY');
         j:=ord(extractword(2,Reply)='ALL');
         b:=isettag(tag.RegReady, i);
         b:=isettag(tag.RegMode, j);
         cmdIndex:=cmdIndex+1;
         FreeQuery(Reply);
        end;
       end;
    {
    Выполнение команд от центральной машины
    }
    2: begin
        if igettag(tag.Notify)<>0 then begin
         if igettag(tag.Notify)=1 then SendPresets;
         b:=isettag(tag.Notify,0);
        end;

       if cmdIdent=cmHelp then begin
        writeln('@REG_READY - Регистратор готов');
        writeln('@REG_MODE  - Регистратор готов');
       end;
(**
 cmRegOnline	= '@REG_ONLINE';	{ =i Извещение "регистратор на линии"    }
 cmRegReady	= '@REG_READY';	{ =i Регистратор готов                   }
 cmRegMode	= '@REG_MODE';		{ =i Регистратор в дистанционном режиме  }
 cmRegFile	= '@REG_FILE';		{ =s Файл данных s готов                 }
 cmRegEnd		= '@REG_END';		{ =i Все каналы прочитаны                }
 cmRegArm		= '@REG_ARM';		{ =i Насторожить регистратор             }
 cmRegTdelay	= '@TRIG_DELAY';	{ =r Предыстория, секунды                }
 cmRegTsource	= '@TRIG_SOURCE';	{ =i Канал-источник запуска (5=EXT)      }
 cmRegTlevel	= '@TRIG_LEVEL';	{ =r Уровень запуска в вольтах           }
 cmRegTcoupl	= '@TRIG_COUPLING';	{ =s AC,DC,HFREJ,LFREJ-синхрон. запуска  }
 cmRegTslope	= '@TRIG_SLOPE';	{ =i Знак запуска (NEG-0,POS-1)          }
 cmRegDivT	= '@DIV_T';		{ =r Установить гориз. развертку, сек    }
 cmRegDivV1	= '@DIV_V1';		{ =r Вертик. развертка 1 в вольтах       }
 cmRegDivV2	= '@DIV_V2';		{ =r Вертик. развертка 2 в вольтах       }
 cmRegDivV3	= '@DIV_V3';		{ =r Вертик. развертка 3 в вольтах       }
 cmRegDivV4	= '@DIV_V4';		{ =r Вертик. развертка 4 в вольтах       }
**)


        if cmdIdent=cmRegArm then begin
         b:=comwrite(':SEL:CH1 ON;CH2 ON;CH3 ON;CH4 ON;'+  { выбор каналов }
                     ':HOR:RESO LOW;'+                    { 10000 точек }
                     ':TRIG:A:TYP EDG;'+                   { по фронту }
                     ':TRIG:A:MOD NORM;'+                  { нормальный режим }
                     ':TRIG:B:STATE OFF;'+                 { выкл. триггер B }
                     ':ACQ:MODE SAM;'+                     { обычный }
                     ':ACQ:STOPA SEQ;'+                    { останов после измерений }
                     ':ACQ:STATE ON'+CR);                  { взвели }
         cmdIdent:='';
        end;
        if cmdIdent=cmRegMode then begin
         if cmdValue='ALL' then b:=comwrite(':LOC ALL'+CR) else
         if cmdValue='NON' then b:=comwrite(':LOC NON'+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmDivT then begin
         b:=comwrite(':HOR:SCA '+str(rval(cmdValue)*DivTCoef)+CR);
         b:=rsettag(tag.DivT,rval(cmdValue));
         cmdIdent:='';
        end;
        if cmdIdent=cmTrigTdelay then begin
         b:=comwrite(':HOR:DEL:STATE ON;:HOR:DEL:TIM '+cmdValue+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmTrigTsource then begin
         if val(cmdValue)=1 then b:=comwrite(':TRIG:A:EDG:SOU CH1'+CR) else
         if val(cmdValue)=2 then b:=comwrite(':TRIG:A:EDG:SOU CH2'+CR) else
         if val(cmdValue)=3 then b:=comwrite(':TRIG:A:EDG:SOU CH3'+CR) else
         if val(cmdValue)=4 then b:=comwrite(':TRIG:A:EDG:SOU CH4'+CR) else
         if val(cmdValue)=5 then b:=comwrite(':TRIG:A:EDG:SOU EXT'+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmTrigTlevel then begin
         b:=comwrite(':TRIG:A:LEV '+cmdValue+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmTrigTcoupl then begin
         b:=comwrite(':TRIG:A:EDG:COUP '+cmdValue+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmTrigTslope then begin
         if cmdValue='FALL' then b:=comwrite(':TRIG:A:EDG:SLO FALL'+CR) else
         if cmdValue='RIS' then b:=comwrite(':TRIG:A:EDG:SLO RIS'+CR);
         cmdIdent:='';
        end;

        if cmdIdent=cmDivV1 then begin
         b:=comwrite(':CH1:VOL '+str(rval(cmdValue)*DivVCoef)+';BAN FUL'+';OFFS 0'+';POS 0'+';INV 0'+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmDivV2 then begin
         b := comwrite(':CH2:VOL '+str(rval(cmdValue)*DivVCoef)+';BAN FUL'+';OFFS 0'+';POS 0'+';INV 0'+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmDivV3 then begin
         b := comwrite(':CH3:VOL '+str(rval(cmdValue)*DivVCoef)+';BAN FUL'+';OFFS 0'+';POS 0'+';INV 0'+CR);
         cmdIdent:='';
        end;
        if cmdIdent=cmDivV4 then begin
         b:=comwrite(':CH4:VOL '+str(rval(cmdValue)*DivVCoef)+';BAN FUL'+';OFFS 0'+';POS 0'+';INV 0'+CR);
         cmdIdent:='';
        end;

        if cmdIdent=cmPreset then begin
         b:=action(readini('DevPreset'));
         r:=devmsg(readini('DevPreset')+' Confirm=2');
         cmdIdent:='';
        end;

        if cmdIdent=cmReadData then begin
         cmdIdent:='';
         cmdIndex:=cmdIndex+1;
        end else begin
         cmdIdent:='';
         cmdIndex:=cmdStatus;
        end;
        if Length(cmdIdent)>0 then begin
         IoError('Unknown request-> '+cmdIdent+'='+cmdValue);
         cmdIdent:='';
        end;
       end;
    3: begin
        CurrChan:=1;
        cmdIndex:=cmdIndex+1;
       end;
    {
    Установка форматов
    }
    4: begin
        cmdFormat:=cmdIndex;
        b:=comwrite(':DAT:SOU CH'+str(CurrChan)+';:DAT:ENC SRI;:DAT:WID 2;:WFMP:PT_F Y'+CR);
        cmdIndex:=cmdIndex+1;
       end;
    {
    Чтение параметров
    }
    5: begin
        if Length(Query)=0 
        then SendQuery(':WFMP:XZE?;:WFMP:YZE?;:WFMP:XIN?;:WFMP:YMU?;:WFMP:PT_O?;:WFMP:YOF?;:HOR:RECORD?')
        else
        if Length(Reply)>0 then begin
         hoff:=rval(extractword(1,Reply));
         voff:=rval(extractword(2,Reply));
         hgan:=rval(extractword(3,Reply));
         vgan:=rval(extractword(4,Reply));
         hsft:=rval(extractword(5,Reply));
         vsft:=rval(extractword(6,Reply));
         HorRecord:=val(extractword(7,Reply));
         writeln('hoff=',str(hoff));
         writeln('voff=',str(voff));
         writeln('hgan=',str(hgan));
         writeln('vgan=',str(vgan));
         writeln('hsft=',str(hsft));
         writeln('vsft=',str(vsft));
         writeln('count=',str(HorRecord));
         cmdIndex:=cmdIndex+1;
         FreeQuery(Reply);
        end;
       end;
    {
    Действия перед чтением канала
    }
    6: {if Length(Query)=0 then}
       begin
        FreeQuery('');
        if ChanOn(CurrChan) then begin
         cref:= refao(CurrChan);
         y := crvdel(cref, 1, crvlen(cref));
         b:=isettag(tag.DataDone, 0);
         ChanCount:=0;
         FirstPoint:=0;
         NumPoints:=MaxNumPoints;
         cmdIndex:=cmdIndex+1;
        end else
        if ChanExists(CurrChan+1) then begin
         CurrChan:=CurrChan+1;
         cmdIndex:=cmdFormat;
        end else begin
         CurrChan:=1;
         cmdIndex:=cmdStatus;
        end;
       end;
    {
    Чтение канала
    }
    7: begin
        if Length(Query)=0 then begin
         if FirstPoint<HorRecord then begin
          if FirstPoint+MaxNumPoints>HorRecord then NumPoints:=HorRecord-FirstPoint;
          {Установка размера запрашиваемых данных и запрос блока данных}
          SendQuery(':DAT:STAR '+str(FirstPoint+1)+
                    ';:DAT:STOP '+str(FirstPoint+NumPoints)+
                    ';:CURV?');
          ExpectBinary:=true;
          ExpectHeader:=true;
         end;
        end else begin
         if Length(Reply)>0 then begin
          j:=0;
          for i:=0 to NumPoints-1 do begin

           { время }
           x := (i + FirstPoint - hsft) * hgan + hoff;
           if Length(Reply)>j+1 then begin
            code:=dump2i(copy(Reply,j+1,2));
            j:=j+2;
           end else begin
            IoError('Invalid binary reply.');
            code:=0;
           end;
           r:=code;
           if code>MaxSmallInt then r:=code-NegConst else r:=code;

           { значение }
           y := ((r-vsft)*vgan+voff)*AdcCoefY;
           if not isnan(x+y) then b:=crvput(cref, crvlen(cref)+1, x, y);
          end;
          FreeQuery('CURV:'+str(FirstPoint)+':'+str(FirstPoint+NumPoints)+' READ');
          FirstPoint:=FirstPoint+NumPoints;{в конце цикла}
          if not (FirstPoint<HorRecord) then begin
           ChanCount:=ChanCount+1;
           if ChanExists(CurrChan+1) then begin
            {закончили чтение, перешли на другой канал}
            CurrChan:=CurrChan+1;
            cmdIndex:=cmdFormat;
           end else begin
            {закончили чтение, перешли на статус}
            b:=isettag(tag.DataDone, 1);
            CurrChan:=1;
            cmdIndex:=cmdStatus;
            ChanCount:=0;
           end;
          end;
         end;
        end;
       end;
   end;
  end;
 end;
end.
