 {
 Виноградов 27-07-2007
 }
program TDS_CTRL;
const
 dfTrouble    = 1;       { DebugFlags - Trouble       }
 dfSuccess    = 2;       { DebugFlags - Success       }
 dfViewExp    = 4;       { DebugFlags - ViewExp       }
 dfViewImp    = 8;       { DebugFlags - ViewImp       }
 snd_Click    = 'Click'; { Sound on button click      }
 snd_Fails    = 'Fails'; { Sound on operation failure }
 hideDelay    = 7;       { Delay to hide windows      }
 Driver       = '&TDS1.DRV';
 stFull       = False;
var
 r            : Real;    { Temporary variable         }
 s            : string;  { Temporary variable         }
 b            : Boolean; { Temporary variable         }
 i            : Integer; { Temporary variable         }
 Ok           : Boolean; { Is initialization Ok ?     }
 errors       : Integer; { Error count                }
 errorcode    : Integer; { Error code for this device }
 fixmaxavail  : Integer; { String manager leak test   }
 DebugFlags   : Integer; { see dfXXX constants        }
 winPanel     : String;  { panel window        }
 devDriver    : Integer;
 ToolBar      : Boolean;
 StatusBar    : Boolean;
 DaqSystem    : Boolean;
 tag               : record           {в этой записи хранятся все теги}
  RegOnline        : integer;         {индикаторы связи ЛЭВМ с регистраторами}
  RegReady         : integer;         {индикаторы готовности регистраторов к измерению}
  RegMode          : integer;         {индикаторы дистанционного режима}
  TrigSrc          : integer;         {источник запуска триггера регистратора}
  TrigRej          : integer;         {тип фильтра триггера}
  TrigHisUnit      : integer;         {единицы измерения задержки}
  TrigHisUnits     : integer;         {единицы предыстории (задержки) }
  TrigHis          : integer;         {предыстория (задержка) }
  TrigSlp          : integer;         {запуск по переднему/заднему фронту}
  TrigLev          : integer;         {уровень запуска триггера}
  DivTUnit         : integer;         {единицы измерения развертки}
  DivTUnits        : integer;         {единицы развертки по времени}
  DivT             : integer;         {развертка по времени}
  DivV1            : integer;         {развертка канала 1 по вольтажу}
  DivV2            : integer;         {развертка канала 2 по вольтажу}
  DivV3            : integer;         {развертка канала 3 по вольтажу}
  DivV4            : integer;         {развертка канала 4 по вольтажу}
  DataDone         : integer;         {чтение данных с регистратора завершено}
  Notify           : integer;         {теги уведомления диалогов}
  ReadBt           : integer;
  SaveBt           : integer;
  WinCaption       : integer;
  WinTitle         : integer;
  WinLabel         : integer;
 end;
 WinCaption        : string;
 WinTitle          : string;
 WinLabel          : string;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  winPanel:='';
  WinCaption:='';
  WinTitle:='';
  WinLabel:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Инициирует диалог-предупреждение
 }
 procedure Warning(msg:string);
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else writeln(msg);
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Initialize dialog to edit tag
 }
 procedure StartEditTag(tag:integer; Caption:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(igettag(tag)) else
    if typetag(tag)=2 then s:=str(rGetTag(tag)) else
    if typetag(tag)=3 then s:=sGetTag(tag) else s:='';
    if pos('?',edit('(Редактировать тег '+nametag(tag))
              +edit(' '+Caption+'|'+s)
              +edit(')StringGridEdit EDIT_TAG_'+nametag(tag)))>0
    then Warning('Error starting edit tag "'+nametag(tag)+'"!');
   end else Warning('Could not edit tag "'+nametag(tag)+'" right now!');
  end;
  s:='';
 end;
 {
 Check if tag editing done.
 }
 function CheckEditTag(tag:integer; var newValue:String):Boolean;
 var s,d:string; r:real; b:boolean;
 begin
  r:=0;
  s:='';
  d:='';
  CheckEditTag:=false;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)='EDIT_TAG_'+nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if not isnan(r) then begin
       r:=Round(r);
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if not isnan(r) then begin
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=3 then begin
      newValue:=s;
      CheckEditTag:=true;
     end;
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Invalid input!')
  end;
  s:='';
  d:='';
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 var b:Boolean; ref:Integer;
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then begin
   ref:=RefFind('Device &SpeakSrv');
   if ref<>0 then b:=DevSend(ref,'@speak='+msg+CRLF)>0;
  end;
 end;
 {
 Send a message to driver.
 }
 procedure Drv_Send(msg:String);
 begin
  if Length(msg)>0 then
  if DevSend(devDriver,msg)=0
  then Trouble('Could not send message to '+Driver);
 end;
 {
 Спрятать\показать панель инструментов
 }
 procedure DoToolBar;
 begin
  if ToolBar
  then r:=eval('@system @async @view show FormCrw32.ToolBar')
  else r:=eval('@system @async @view hide FormCrw32.ToolBar');
  ToolBar:=not ToolBar;
 end;
 {
 Спрятать\показать статусную строку
 }
 procedure DoStatusBar;
 begin
  if StatusBar
  then r:=eval('@system @async @view show FormCrw32.StatusBar')
  else r:=eval('@system @async @view hide FormCrw32.StatusBar');
  StatusBar:=not StatusBar;
 end;
 {
 Спрятать\показать DAQ SYSTEM
 }
 procedure DoDaqSystem;
 begin
  if DaqSystem
  then r:=eval('@system @async @view norm FormDaqControlDialog')
  else r:=eval('@system @async @view min  FormDaqControlDialog');
  DaqSystem:=not DaqSystem;
 end;
 {
 Выход из DAQ
 }
 procedure DoExitDaq;
 var r:Real;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Выход из CRW
 }
 procedure DoExitCrw;
 begin
  r:=eval('@system @async SaveGuard=@guard');
  r:=eval('@system @async @guard root');
  r:=eval('@system @async _Daq_Force_Stop_=1');
  r:=eval('@system @async _Daq_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @view norm FormDaqControlDialog');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqStop');
  r:=eval('@system @async @menu run FormDaqControlDialog.ActionDaqDone');
  r:=eval('@system @async _Crw_Force_Exit_=1');
  r:=eval('@system @async @view max FormCrw32');
  r:=eval('@system @async @menu run FormCrw32.ActionFileExit');
  r:=eval('@system @async @guard %SaveGuard');
  r:=eval('@system @async SaveGuard=');
  b:=voice(snd_Click);
 end;
 {
 Показать график
 }
 procedure GrfDraw;
 begin
  if RefFind('Window '+winCaption)<>0 then begin
   b:=WinShow(winCaption);
   b:=WinDraw(winCaption+'|Top=300|Left=0|Width=210|Height=300');
   b:=WinDraw(winCaption+'|Options=-Close,-HScroll,-VScroll,+StatusBar');
   b:=WinDraw(winCaption+'|Range = xmin; ymin; xmax; ymax');
   b:=WinDraw(winCaption+'|LegendX = '+WinLabel);
   b:=WinDraw(winCaption+'|LegendY = '+WinTitle);
   b:=WinSelect(winCaption);
  end;
 end;

begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  {
  Инициализация тегов
  }
  InitTag(tag.DataDone,   ReadIni('TagDataDone'),  1);
  InitTag(tag.ReadBt,     ReadIni('TagReadBt'),    1);
  InitTag(tag.SaveBt,     ReadIni('TagSaveBt'),    1);
  InitTag(tag.WinCaption, ReadIni('TagWinCaption'),3);
  InitTag(tag.WinTitle,   ReadIni('TagWinTitle'),  3);
  InitTag(tag.WinLabel,   ReadIni('TagWinLabel'),  3);
  WinCaption:=sGetTag(tag.WinCaption);
  WinTitle:=sGetTag(tag.WinTitle);
  WinLabel:=sGetTag(tag.WinLabel);
  {
  Initialize driver device reference...
  }
  devDriver:=RefFind('Device '+Driver);
  if devDriver=0 then Trouble('Could not find '+Driver);
  {
  Open PANEL window...
  }
  winPanel:=ReadIni('winPanel');
  if RefFind('Window '+winPanel)<>0 then begin
   b:=winshow(winPanel);
   b:=windraw(winPanel+'|top=0|left=0|Width=210|Height=300');
   b:=windraw(winPanel+'| Options=-Close,-HScroll,-VScroll,+StatusBar');
   b:=winselect(winPanel);
  end;
  {
  Open GRF window...
  }
  GrfDraw;
  if devmsg('&DAQ.CTRL @Full')=0 then begin end;
  {
  Hide StatusBar, ToolBar, etc
  }
  if stFull then begin
   DoDaqSystem;
   DoStatusBar;
   DoToolBar; 
  end;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  Success('Stop.');
  ClearStrings;
  if stFull then begin
   DoDaqSystem;
   DoStatusBar;
   DoToolBar; 
  end;
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Handle edit...
  }
  if editstate=1 then begin
   if IsSameText(edit('?ans 0'),'EXIT=7') then begin end; 
   if IsSameText(edit('?ans 0'),'EXIT=6') then begin
    Speak('Выход из программы');   
    DoExitDaq;
   end;
   s:=edit('');
  end;
  {
  ----------------------------------------------------------------------
  Если в программе уже открыт какой-либо модальный диалог, то попытка
  инициировать диалог даст ошибку. При этом editstate=8.
  При обнаружении ошибки надо сделать сброс, вызвав edit('').
  ----------------------------------------------------------------------
  } 
  if editstate=8 then begin
   writeln('Error detected when try open dialog!');
   s:=edit('');
  end;
  {
  Спрятать лишние окна
  }
  if runcount=hideDelay then begin
   b:=WinHide('ГЛАВНАЯ КОНСОЛЬ');
   b:=WinHide('DAQ-СИСТЕМА'); 
  end;
  {
  Данные прочитаны?
  }
  if iGetTag(tag.ReadBt)=1 then begin
   if iGetTag(tag.DataDone)=1 then begin
    b:=iSetTag(Tag.DataDone,0);
    b:=iSetTag(Tag.ReadBt,0);
    GrfDraw;
   end;   
  end;
  {
  Handle sensor clicks.
  }
  if ClickButton=1 then begin
   {
   Обработка нажатий левой клавиши
   }
   if IsSameText(ClickSensor,'EXIT') then begin
    b:=Voice(snd_Click);
    {
    Инициировать диалог - Да/Нет
    }
    if editstate=0 then begin
     if pos('?',edit('(Вы действительно хотите завершить сеанс?')
               +edit(')YesNo EXIT'))>0
     then writeln('Ошибка инициирования диалога!');
    end else writeln('Cannot edit right now!');
   end;
   if IsSameText(ClickSensor,'READ') then begin
    b:=iSetTag(tag.ReadBt,1);
    Drv_Send('@READ_DATA');
    b:=Voice(snd_Click);
   end;
   if IsSameText(ClickSensor,'CLEAR') then begin
    for i:=1 to 4 do r:=crvdel(refai(i),1,maxint);
    b:=Voice(snd_Click);
    GrfDraw;
   end;
   if IsSameText(ClickSensor,'GRF') then begin
    b:=Voice(snd_Click);
    GrfDraw;
   end;
   if IsSameText(ClickSensor,'SAVE') then begin
    b:=iSetTag(tag.SaveBt,1);
    b:=Voice(snd_Click);
   end;
   if IsSameText(ClickSensor,'PRESET') then begin
    Drv_Send('@PRESET');
    b:=Voice(snd_Click);
   end;
   if IsSameText(ClickSensor,'HELP') then begin
    i:=ShellExecute('open | '+DaqFileRef('..\help\TDS.HTM',''));
    b:=Voice(snd_Click);
   end;
  end else
  {
  Обработка нажатий правой клавиши
  }
  if clickbutton=2 then begin
  end;
 end;
end.

