 {
 ***********************************************************************
 SPVZK main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2  - Evaluate 2 expressions, just for demo.
|********************************************************
[]
 }
program spvzk_main_control;      { SPVZK main control program       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 NumChans          = 4;          { Number of F740/encoder channels  }
 DeltaXMin         = 0.01;       { Minimum DeltaX value             }

 type
 TTagRef     = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagGO      : Integer;           { Start Move button                }
 tagDeltaX1 : Integer;           { Delta X1 (small)                 }
 tagDeltaX2 : Integer;           { Delta X2 (large)                 }
 tagMinFreq : Integer;           { Minimum frequency                }
 tagMaxFreq : Integer;           { Maximum frequency                }
 tagEnable  : array[1..NumChans] of Integer; { Enable motors        }
 tagDPOS    : array[1..NumChans] of Integer; { Destination position }
 tagPol     : array[1..NumChans] of Integer; { Check Polling button }
 tagPow     : array[1..NumChans] of Integer; { Check Power button   }
 tagFwd     : array[1..NumChans] of Integer; { Forward button       }
 tagRev     : array[1..NumChans] of Integer; { Revers button        }
 tagStt     : array[1..NumChans] of Integer; { Status indication    }
 tagFrq     : array[1..NumChans] of Integer; { Frequency            }
 CurPos     : array[1..NumChans] of Real; { Current position value  }
 DesPos     : array[1..NumChans] of Real; { Target position value   }
 EnMove     : array[1..NumChans] of Integer; { Enable moving        }
 deltaFreq  : Integer;           { Delta of frequency               }
 FreqMin    : Integer;           { Minimum frequency, Hz            }
 FreqMax    : Integer;           { Maximum frequency, Hz            }
 PowInv     : Integer;           { Switch on inverter               }
 EmergStop  : Integer;           { Emergency Stop button            }
 PowTime    : Real;              { Delay power or polling switch on }
 State      : Integer;           {                                  }
 Differ     : array[1..2] of Real;{ Different position              }
 EngineName : array[1..NumChans] of String;{ Engine names           }
 
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Apply bit XOR mask to tag
 }
 procedure iBitXorTag(tag,XorMask:Integer);
 begin
  bNul(iSetTagXor(tag,XorMask));
 end;
 {
 Calculation of frequency, depending on the delta X large(X2),
 X small(X1), and current values of the sensors
 }
 function CalcFreq(curr,x1,x2:Real):Real;
 var f,r,k:Real;
 begin
  r:=abs(curr-x1);
  k:=deltaFreq/(x2-x1);
  f:=r*k;
  f:=FreqMin+f;
  CalcFreq:=f;
 end;
 {
 Frequency setting. If the current value is greater than X2, set the maximum frequency
 If the current value in the range from X1 to X2, the output frequency is calculated function CalcFreq
 If the value is less than X1 frequency is minimal
 }
 procedure SetFreq(curr,dest,x1,x2:Real; n:Integer);
 var f:Real;
 begin
  curr:=abs(curr-dest);
  f:=CalcFreq(curr,x1,x2);
  if curr>x2 then bNul(rsettag(tagFrq[n],FreqMax)) else
  if curr<x1 then bNul(rsettag(tagFrq[n],FreqMin)) else bNul(rsettag(tagFrq[n],f));
 end;
 {
 Reading current position
 }
 procedure ReadCurPos;
 var i:Integer;
 begin
  for i:=1 to NumChans do CurPos[i]:=getai_yn(i-1)
 end;
 {
 Reading destination position
 }
 procedure ReadDesPos;
 var i:Integer;
 begin
  for i:=1 to NumChans do DesPos[i]:=rgettag(tagDPOS[i]);
 end;
 {
 Enable motors, warning display when device is offline
 }
 procedure EnabMot;
 var i:Integer;
 begin
  for i:=1 to NumChans do
  if clicktag=tagEnable[i] then
   if igettag(tagGO)<>1 then begin
   if igettag(tagEnable[i])=0 then begin
    if (igettag(tagPow[i])=1) and (igettag(tagPol[i])=1) then begin
     bNul(isettag(tagEnable[i], 1));
    end else if i=Val(Copy(EngineName[i],1,1)) then
    ShowTooltip('text "Нет связи с двигателем '+EngineName[i]+'" preset stdWarning delay 15000');
   end else begin
    bNul(isettag(tagEnable[i],0));
    bNul(isettag(tagStt[i],0));
   end;
  end;
 end;
 {
 Selection the movement direction at the target value and changing indication at movement
 }
 procedure DirectMove(curr,dest:Real;n:Integer);
 begin
  if (abs(CurPos[n]-DesPos[n])>rgettag(tagDeltaX1)) then begin
   if sign(curr-dest)=1 then bNul(isettag(tagRev[n],1));
   if sign(curr-dest)=-1 then bNul(isettag(tagFwd[n],1));
   bNul(isettag(tagStt[n],3));
   EnMove[n]:=1;
  end else begin
   EnMove[n]:=0;
   bNul(isettag(tagEnable[n],0));
  end;
 end;
 {
 Move tracking and display message about the successful or unsuccessful completion of movement
 }
 procedure MovTrack;
 var i,Enab:Integer;
 begin
  Enab:=0;
  if igettag(tagGO)=1 then begin
   for i:=1 to NumChans do if EnMove[i]<>0 then begin
    if igettag(tagEnable[i])=1 then Enab:=Enab+1;
    if (igettag(tagStt[i])=2) and (igettag(tagEnable[i])=1) then begin
     if i=Val(Copy(EngineName[i],1,1)) then
     ShowTooltip('text "Двигатель '+EngineName[i]+' перемещен в положение '
     +str(DesPos[i])+'" preset stdSuccess delay 15000');
     bNul(isettag(tagEnable[i],0));
    end else
    if (igettag(tagStt[i])=1) and (igettag(tagEnable[i])=1) then begin
     if i=Val(Copy(EngineName[i],1,1)) then
     ShowTooltip('text "Ошибка перемещения двигателя '+EngineName[i]+'" preset stdError delay 15000');
     bNul(isettag(tagEnable[i],0));
    end;
   end;
   if Enab=0 then bNul(isettag(tagGO,0));
  end;
 end;
 {
 Indication when error occurs during movement, changes the status tag and stops the engine if left outside X1
 }
 procedure StateErr(curr,dest,x1:Real;n:Integer);
 begin
  if (curr>dest+x1) then
  if (igettag(tagRev[n])=0) then begin
   bNul(isettag(tagStt[n],1));
   bNul(isettag(tagFwd[n],0));
  end;
  if (curr<dest-x1) then
  if (igettag(tagFwd[n])=0) then begin
   bNul(isettag(tagStt[n],1));
   bNul(isettag(tagRev[n],0));
  end;
 end;
 {
 Calculate difference of position
 }
 procedure CalcDifPos;
 var i,n:Integer;
 begin
  n:=0;
  for i:=1 to 2 do begin
   Differ[i]:=abs(CurPos[i+n]-CurPos[i+n+1]);
   n:=n+1;
   UpdateAo(i-1, time, Differ[i]);
  end;
 end;
 {
 SPVZK initialization
 }
 procedure SPVZK_INIT;
 var i:Integer;
 begin
  {
  Initialize tags
  }
  InitTag(tagGO,         ReadIni('tagSPVZK')+'.AUTOMOVE.MBTN',    1);
  InitTag(tagDeltaX1,    ReadIni('tagSPVZK')+'.AUTOMOVE.DELTAX1', 2);
  InitTag(tagDeltaX2,    ReadIni('tagSPVZK')+'.AUTOMOVE.DELTAX2', 2);
  InitTag(tagMinFreq,    ReadIni('tagSPVZK')+'.AUTOMOVE.FREQMIN', 1);
  InitTag(tagMaxFreq,    ReadIni('tagSPVZK')+'.AUTOMOVE.FREQMAX', 1);
  InitTag(PowInv,        ReadIni('tagSPVZK')+'.MAIN.POWER.INV',   1);
  InitTag(EmergStop,     ReadIni('tagSPVZK')+'.MAIN.EMERG.STOP',  1);
  for i:=1 to NumChans do begin
   InitTag(tagDPOS[i],   ReadIni('tagSPVZK')+'.AUTOMOVE.dpos'+Str(i), 2);
   InitTag(tagEnable[i], ReadIni('tagSPVZK')+'.AUTOMOVE.Enab'+Str(i), 1);
   Inittag(tagStt[i],    ReadIni('tagSPVZK')+'.AUTOMOVE.stt'+Str(i),  1);
   InitTag(tagPow[i],    ReadIni('tagSPVZK')+'.F740.'+Str(i)+'.POWER',   1);
   InitTag(tagPol[i],    ReadIni('tagSPVZK')+'.F740.'+Str(i)+'.POLLING', 1);
   InitTag(tagFwd[i],    ReadIni('tagSPVZK')+'.F740.'+Str(i)+'.FORWARD', 1);
   InitTag(tagRev[i],    ReadIni('tagSPVZK')+'.F740.'+Str(i)+'.REVERSE', 1);
   InitTag(tagFrq[i],    ReadIni('tagSPVZK')+'.F740.'+Str(i)+'.INPFREQ', 2);
  end;
  {
  Initialize values
  }
  for i:=1 to NumChans do EnMove[i]:=0;
  PowTime:=0;
  State:=0;
  EngineName[1]:='1 «Передний Вертикальный»';
  EngineName[2]:='2 «Задний Вертикальный»';
  EngineName[3]:='3 «Передний Горизонтальный»';
  EngineName[4]:='4 «Задний Горизонтальный»';
 end;
 {
 SPVZK finalization
 }
 procedure SPVZK_FREE;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
 end;
 {
 SPVZK automove polling
 }
 procedure SPVZK_automove_polling;
 var i,ClickCurve:Integer; XSmall,XLarge:Real;
 begin
  XSmall:=rgettag(tagDeltaX1);
  XLarge:=rgettag(tagDeltaX2);
  ReadCurPos;
  ReadDesPos;
  MovTrack;
  CalcDifPos;
  for i:=1 to NumChans do begin
   if igettag(tagGO)<>0 then
   if igettag(tagEnable[i])<>0 then begin
    {
    Frequency setting
    }
    SetFreq(CurPos[i],DesPos[i],XSmall,XLarge,i);
    {
    Change status tag by error
    }
    StateErr(CurPos[i],DesPos[i],XSmall,i);
    {
    Stopping the motor to achieve the goal
    }
    if (abs(CurPos[i]-DesPos[i])<XSmall) then begin
     bNul(isettag(tagFwd[i],0));
     bNul(isettag(tagRev[i],0));
     if ((igettag(tagEnable[i])=1) and (igettag(tagGO)=1)) then bNul(isettag(tagStt[i],2));
    end;
   end;
   {
   Reset checkboxes (On / Off) and status tag, if MAIN.GUI reset Power or Polling
   And displays error message if during movement the engine was disabled
   }
   if igettag(tagPol[i])=0 then begin
    if igettag(tagGO)=1 then
    if igettag(tagEnable[i])=1 then begin
     if i=Val(Copy(EngineName[i],1,1)) then
     ShowTooltip('text "Связь с двигателем '+EngineName[i]+' нарушена" preset stdError delay 15000');
     bNul(isettag(tagStt[i],1));
    end;
    bNul(isettag(tagEnable[i],0));
   end;
  end;
  {
  Handle GUI Commands...
  }
  if State<>0 then begin
   if mSecNow>PowTime+5000 then begin
    for i:=1 to NumChans do begin
     if State=1 then begin
      bNul(iSetTag(PowInv,1));
      bNul(iSetTag(tagPol[i],iGetTag(PowInv)));
     end;
     if State=2 then begin
      bNul(iSetTag(PowInv,0));
      bNul(iSetTag(tagPow[i],iGetTag(PowInv)));
     end;
    end;
    State:=0;
   end;
  end;
  if iGetTag(EmergStop)<>0 then begin
   bNul(iSetTag(EmergStop,0));
   bNul(iSetTag(PowInv,0));
  end;
  {
  Handle left button clicks...
  }
  if clickbutton=1 then begin
   //
   // Click button Start Move
   //
   if ClickTag=PowInv then begin
    PowTime:=mSecNow;
    if iGetTag(PowInv)=0 then begin
     State:=1;
     for i:=1 to NumChans do bNul(iSetTag(tagPow[i],1));
    end else begin
     State:=2;
     for i:=1 to NumChans do bNul(iSetTag(tagPol[i],0));
    end;
    bNul(iSetTag(PowInv,2));
    bNul(Voice(snd_Click));
   end;
   if ClickTag=EmergStop then begin
    for i:=1 to NumChans do begin
     bNul(iSetTag(tagPow[i],0));
     bNul(iSetTag(tagPol[i],0));
    end;
    iBitXorTag(EmergStop,1);
    bNul(Voice(snd_Click));
   end;
   if (clicksensor='GOBTN') or (clicksensor='SPVZK.AUTO.MOV.BTN') then begin
    bNul(Voice(snd_Click));
    if igettag(tagGO)=0 then begin
     FreqMin:=iGetTag(tagMinFreq);
     FreqMax:=iGetTag(tagMaxFreq);
     deltaFreq:=FreqMax-FreqMin;
     for i:=1 to NumChans do
     if igettag(tagEnable[i])=1 then begin
      bNul(isettag(tagFwd[i],0));
      bNul(isettag(tagRev[i],0));
      bNul(isettag(tagGO,1));
      DirectMove(CurPos[i],DesPos[i],i);
     end;
    end else
    begin
     for i:=1 to NumChans do begin
      bNul(isettag(tagFwd[i],0));
      bNul(isettag(tagRev[i],0));
      bNul(isettag(tagStt[i],0));
     end;
     bNul(isettag(tagGO,0));
    end;
   end;
   EnabMot;
   {
   Start edit tags
   }
   if igettag(tagGO)=0 then begin
    for i:=1 to NumChans do if ClickTag=tagDPOS[i] then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=tagDeltaX1 then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
   end;
  end;
  {
  Plot & Tab windows
  }
  ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
  if ClickCurve<>0 then begin
   iNul(WinSelectByCurve(ClickCurve,ClickCurve));
   bNul(Voice(snd_Wheel));
  end;
  {
  Accept tag edit
  }
  if editstate=1 then begin
   for i:=1 to NumChans do begin
    CheckEditTagUpdate(tagDPOS[i],_MinusInf,_PlusInf);
    bNul(isettag(tagStt[i],0));
   end;
   CheckEditTagUpdate(tagDeltaX1,DeltaXMin,_PlusInf);
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  SPVZK_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  SPVZK_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  SPVZK_automove_polling;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Demo 123 2*2
   }
   if IsSameText(cmd,'@Demo') then begin
    i:=iEvalDef(ExtractWord(1,arg),0);
    r:=rEvalDef(ExtractWord(2,arg),_NaN);
    Success(cmd+'='+Str(i)+_Comma+Str(r));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
