 {
  02.12.2006
 }
program _WRK;
const
 maxndat       = 100;    { Max. number of items to save     }
 snd_Click     = 'Click'; { Sound on button click            }
 snd_Fails     = 'Fails'; { Sound on operation failure       }
 dfTrouble     = 1;       { DebugFlags - Trouble             }
 dfSuccess     = 2;       { DebugFlags - Success             }
 dfViewInp     = 4;       { DebugFlags - ViewInp             }
 dfViewOut     = 8;       { DebugFlags - ViewOut             }
 idCurveList   = 'CurveList';
 tmPeriod      = 300;
 green         = 0;
 yellow        = 4;
var
 s             : String;  { Temporary                        }
 b             : Boolean; { Temporary                        }
 Ok            : Boolean; { Program initialization is Ok?    }
 errors        : Integer; { Program error counter            }
 errorcode     : Integer; { Error code for this device       }
 fixmaxavail   : Integer; { String manager leak control      }
 DebugFlags    : Integer; { Debug bit flags                  }
 winConsole    : String;  { Console window name              }
 i,j,txt       : Integer; { Temporary                        }
 ndat          : integer; { Number of items to save          }
 crvref        : array[1..maxndat] of Integer;
 crvOk         : array[1..maxndat] of boolean;
 devSelf       : Integer;
 timeOut       : Real;
 tagWRK        : Integer;
 crvOR         : boolean;
 crvAND        : boolean;
 tm            : Real;    { таймер}
 cnt           : integer;
 color         : integer;
 
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data input.
 }
 procedure ViewInp(msg:String);
 begin
  if iand(DebugFlags,dfViewInp)>0 then
  if Length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data output.
 }
 procedure ViewOut(msg:String);
 begin
  if iand(DebugFlags,dfViewOut)>0 then
  if Length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var s:string):boolean;
 begin
  StdIn_Readln:=false;
  if not IoError then 
  if not eof then begin
   readln(s);
   if not IoError then StdIn_Readln:=true;
  end;
 end;
 {
 Clear all strings.
 }
 procedure ClearStrings;
 begin
  s:='';
  winConsole:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Clear curve list and counter.
 }
 procedure ClearCurveList;
 var i:Integer;
 begin
  ndat:=0;
  for i:=1 to maxndat do crvref[i]:=0;
 end;
 {
 Read CurveList=C1,C2,...,[Sec1],[Sec2]
 Use recursion to read sections. 
 }
 procedure ReadCurveList(Section:String);
 var line,item:String; i,j,k,n,crv,txt:Integer;
 begin
  line:='';item:='';
  txt:=ReadIniSection(text_new,28,ParamStr('DaqConfigFile'),Section);
  for i:=0 to text_numln(txt)-1 do begin
   line:=Trim(text_getln(txt,i));
   if IsSameText(ExtractWord(1,line),idCurveList) then
   for j:=2 to WordCount(line) do begin
    item:=ExtractWord(j,line);
    crv:=RefFind('Curve '+item);
    if crv<>0 then begin
     n:=0;
     for k:=1 to ndat do if crv=crvref[k] then n:=n+1;
     if n=0 then
     if ndat<maxndat then begin
      crvref[ndat+1]:=crv;
      ndat:=ndat+1;
     end;
    end else
    if (pos('[',item)=1)and (pos(']',item)=Length(item))
    then ReadCurveList(item)
    else Trouble('Could not find curve '+item);
   end;
  end;
  b:=text_free(txt);
  line:='';item:='';
 end;
 {
 Write CurveList=C1,C2,... in readable form
 }
 procedure WriteCurveList(Prefix:String);
 var s:String; i:Integer;
 begin
  s:='';
  for i:=1 to ndat do begin
   if Length(s)>0 then s:=s+',';
   s:=s+crvname(crvref[i]);
   if Length(s)>60 then begin
    writeln(Prefix,'CurveList='+s);
    s:='';
   end;
  end;
  if Length(s)>0 then writeln(Prefix,'CurveList='+s);
  s:='';
 end;
 {
 Clear text with given reference "ref"
 }
 procedure ClearText(ref:Integer);
 var b:Boolean;
 begin
  while text_numln(ref)>0 do b:=text_delln(ref,text_numln(ref)-1);
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then Trouble('Could not init tag '+name);
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  {
  Initialize errors & strings, clear variables.
  }
  errors:=0;
  errorcode:=registererr(devname);
  ClearStrings;
  {
  Open console window...
  }
  if val(ReadIni('OpenConsole'))>0 then begin
   winConsole:=ParamStr('Console '+devname);
   b:=winshow(winConsole);
   b:=windraw(winConsole+'|top=317|left=0|Width=600|Height=317');
   b:=winselect(winConsole);
  end;
  {
  Read parameters from config file
  }
  DebugFlags:=Val(readini('DebugFlags'));
  InitTag( tagWRK,readini('tagWRK'), 1);
  b:=isettag(tagWRK,0);
  {
  Read & check data list
  }
  ClearCurveList;
  ReadCurveList('['+devname+']');
  if ndat>0
  then WriteCurveList(devname+' : ')
  else Trouble('CurveList not found!');
  {
  Initialize 
  }
  timeOut:=rval(readini('timeOut'));
  if isnan(timeOut) then timeOut:=5000;
  devSelf:=RefFind('Device '+devname);
  tm:=tm_new;
  if not (tm_addint(tm,tmPeriod) and tm_start(tm)) then begin
   b:=tm_free(tm);
   tm:=0;
  end;
  cnt:=1;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok') else Trouble('Start fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop.
 }
 if isinf(runcount) then begin
  ClearStrings;
  if tm<>0 then b:=tm_free(tm);
  tm:=0;
 end else 
 {
 Actions on Poll.
 }
 if Ok then begin
  {
  Process StdIn
  }
  while StdIn_Readln(s) do begin
  end;
  if tm<>0 then if tm_event(tm) then begin
   crvAND:=true;
   crvOR:=false;
   for i:=1 to ndat do begin
    crvOk[i]:=(crvlen(crvref[i])<>0) and (((time-crvx(crvref[i],crvlen(crvref[i])))*timeunits)<timeOut);
    crvAND:=crvAND and crvOk[i];
    crvOR:=crvOR or crvOk[i];
   end;
   if crvOR then begin
    cnt:=cnt+1;
    if cnt>4 then cnt:=1;
   end;
   if crvAND then color:=green else color:=yellow;
   b:=isettag(tagWRK, cnt+color);
  end;
 end;
end.
