 {
 ***********************************************************************
 SMITEST main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsOpen - open Menu Tools dialog.
|********************************************************
[]
 }
{
[Compiler.Options]
Compiler.dtabmax = 16384*2  ; Data segment
Compiler.stabmax = 1024*8   ; String table
Compiler.dtabmin = 1024*1   ; Min stack  space
Compiler.stabmin = 512*1    ; Min string space
[]
}
program smitest_main_ctrl;       { SMITEST main control program     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_SmiuiSrv}              { Include SmiuiSrv     constants   }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TSMITESTMainRec = record        { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_SmiuiSrv}              { Include SmiuiSrv     variables   }
 SMITEST     : record            { All SMITEST data                 }
  MAIN       : TSMITESTMainRec;  { Main control & GUI               }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 cmd_SmiTclTkGui   : Integer;    { @SmiTclTkGui                     }
 cmd_SmiGenGui     : Integer;    { @SmiGenGui                       }
 cmd_smi_repost    : Integer;    { @smi_repost                      }
 InitialDimDnsNode : String;     { Initial DIM_DNS_NODE             }
 tagLoggerRepState : Integer;    {                                  }
 tagLoggerSimDelay  : Integer;   {                                  }
 tagEvtBuilderRepState : Integer;   {                               }
 tagEvtBuilderSimDelay  : Integer;  {                               }
 tagEvtBuilderSimKicker : Integer;  {                               }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_SmiuiSrv}              { Include SmiuiSrv   functions   }


 {
 FSM testing procedure.
 }
 procedure fsm_testing;
 var fsm:Integer;
 begin
  Success('FSM testing:');
  writeln('Read SML file...');
  fsm:=fsm_init('-dns localhost -name FsmTest -dom DEMO -sml run_con.sml');
  writeln(LineEnding,'Readback SML:',LineEnding,fsm_readback_sml(fsm));
  //writeln('FSM Dump:',LineEnding,fsm_dump(fsm,1));
  bNul(WinSelect(ParamStr('Console '+DevName)));
  fsm_kill(fsm);
 end;

 {
 Call Tcl/Tk GUI
 }
 procedure SmiTclTkGui(tcl:String);
 var cmd,exe,dir,tmp:String; code:Integer;
 begin
  cmd:=''; exe:=''; dir:='';
  tcl:=DaqFileRef(Trim(tcl),'.tcl');
  if FileExists(tcl) then begin
   Success('Start Tcl/Tk file '+tcl);
   if IsUnix then exe:=ParamStr('FileSearch wish');
   if IsWindows then exe:=ParamStr('GetSystemAssocExe .tcl');
   if FileExists(exe) then begin
    dir:=ExtractFilePath(tcl);
    if IsWindows then cmd:='@run -cd '+dir+' '+exe+' '+tcl;
    if IsUnix then cmd:='@run unix -L '+ExtractFileName(tcl)+ExtractFileExt(tcl);
    DevPostCmdLocal('@syseval '+cmd);
   end else Problem('Tcl/Tk is not installed.');
  end else Problem('Could not find Tcl file '+tcl);
  cmd:=''; exe:=''; dir:='';
 end;
 {
 Call LM9 GUI
 }
 procedure SmiGenGui(lm9:String);
 var cmd,exe,dir,tmp:String;
 begin
  cmd:=''; exe:=''; dir:='';
  lm9:=DaqFileRef(Trim(lm9),'.lm9');
  if FileExists(lm9) then begin
   Success('Start LM9 file '+lm9);
   if IsUnix then exe:=ParamStr('FileSearch CrossMachine');
   if IsWindows then exe:=ParamStr('GetSystemAssocExe .lm9');
   if FileExists(exe) then begin
    dir:=ExtractFilePath(lm9);
    cmd:='@run /cd '+dir+' '+AnsiQuotedStr(exe,'"')+' '+lm9;
    cmd:='@run '+lm9;
    DevPostCmdLocal('@syseval '+cmd);
   end else Problem('DieselPascal is not installed.');
  end else Problem('Could not find LM9 file '+lm9);
  cmd:=''; exe:=''; dir:='';
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize SMITEST.MAIN record tags
 }
 procedure TSMITESTMainRec_Init(var Rec:TSMITESTMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Тестировать библиотеку FsmManager');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@fsm_testing');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  SMITEST.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 SMITEST clear strings
 }
 procedure SMITEST_CLEAR;
 begin
  InitialDimDnsNode:='';
 end;
 {
 Read SMIUISRV_DNS to set DIM_DNS_NODE.
 }
 function ReadDnsNode:String;
 begin
  ReadDnsNode:=LoCaseStr(ReadIniAlter('SMIUISRV_DNS',risModeDefault+risModeAlter));
 end;
 {
 SMITEST initialization
 }
 procedure SMITEST_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TSMITESTMainRec_Init(SMITEST.MAIN,ReadIni('tagSMITEST')+'.MAIN');
  InitTag(SMITEST.DatSrvGate.tag,'DATSRV.GATE',-1);
  InitTag(tagLoggerRepState,      'SmiProxyLogger.RepState',      -3);
  InitTag(tagLoggerSimDelay,      'SmiProxyLogger.SimDelay',      -1);
  InitTag(tagEvtBuilderRepState,  'SmiProxyEvtBuilder.RepState',  -3);
  InitTag(tagEvtBuilderSimDelay,  'SmiProxyEvtBuilder.SimDelay',  -1);
  InitTag(tagEvtBuilderSimKicker, 'SmiProxyEvtBuilder.SimKicker', -1);
  //
  // Initialize values...
  //
  SMITEST.AwokeTime:=0;
  //
  // Save and set DIM_DNS_NODE
  //
  InitialDimDnsNode:=GetEnv('DIM_DNS_NODE');
  Assertion(SetEnv('DIM_DNS_NODE',ReadDnsNode),'DIM_DNS_NODE='+GetEnv('DIM_DNS_NODE'));
 end;
 {
 SMITEST finalization
 }
 procedure SMITEST_FREE;
 begin
  bNul(SetEnv('DIM_DNS_NODE',InitialDimDnsNode));
 end;
 {
 SMITEST polling
 }
 procedure SMITEST_POLL;
 var nerrors:Real; ClickCurve:Integer; s:String;
 begin
  s:='';
  {
  Awake DatSrv to enforce data save.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then bNul(iSetTag(SMITEST.DatSrvGate.tag,Ord(iGetTag(SMITEST.MAIN.CMD.SAVE.tag)<>0)));
  {
  Execute GUI commands
  }
  if iGetTag(SMITEST.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(SMITEST.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(SMITEST.MAIN.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(SMITEST.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>SMITEST.MAIN.CMD.SMILE.val then bNul(iSetTag(SMITEST.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(SMITEST.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(SMITEST.MAIN.CMD.SMILE.tag,1));
   SMITEST.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditState=ef_Done then begin
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Edit params.
   }
   CheckEditTagUpdate(tagLoggerRepState,0,MaxInt);
   CheckEditTagUpdate(tagLoggerSimDelay,0,MaxInt);
   CheckEditTagUpdate(tagEvtBuilderRepState,0,MaxInt);
   CheckEditTagUpdate(tagEvtBuilderSimDelay,0,MaxInt);
   CheckEditTagUpdate(tagEvtBuilderSimKicker,0,MaxInt);
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(SMITEST.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(SMITEST.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(SMITEST.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(SMITEST.MAIN.CMD.CLOSE.tag,1);
     if ClickTag=SMITEST.MAIN.CMD.SAVE.tag then begin
      bNul(iSetTag(SMITEST.DatSrvGate.tag,Ord(iGetTag(SMITEST.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(SMITEST.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'SMITEST.MAIN.CMD.HOME') then begin
      DevPostCmdLocal('@Cron @Cron.Run SMITEST.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'SMITEST.MAIN.CMD.HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'SMITEST.MAIN.CMD.TOOLS') then begin
      DevPostCmdLocal('@MenuToolsOpen');
      bNul(Voice(snd_Click));
     end;
     s:=SetFormUnderSensorLeftBottom(ClickParams(''));
     if ClickTag=tagLoggerRepState then StartEditTagEx(ClickTag,'Задать новое состояние Logger',s);
     if ClickTag=tagLoggerSimDelay then StartEditTagEx(ClickTag,'Задать задержку переходов Logger',s);
     if ClickTag=tagEvtBuilderRepState then StartEditTagEx(ClickTag,'Задать новое состояние EvtBuilder',s);
     if ClickTag=tagEvtBuilderSimDelay then StartEditTagEx(ClickTag,'Задать задержку переходов EvtBuilder',s);
     if ClickTag=tagEvtBuilderSimKicker then StartEditTagEx(ClickTag,'Задать период генерации ERROR EvtBuilder',s);
     //
     // Smile face button...
     //
     if ClickTag=SMITEST.MAIN.CMD.SMILE.tag then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(SMITEST.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
     //
     // SMI FSM click handler
     //
     if (smiuisrv_click_fsm<>0) then begin
      smiuisrv_click_fsm_default_handler(ClickParams(''));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  s:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearSmiuiSrv;
  SMITEST_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitSmiuiSrv;
  SMITEST_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_MenuToolsOpen :=RegisterStdInCmd('@MenuToolsOpen', '');
  cmd_SmiTclTkGui   :=RegisterStdInCmd('@SmiTclTkGui',   'Вызов Tcl/Tk GUI для SMI');
  cmd_SmiGenGui     :=RegisterStdInCmd('@SmiGenGui',     'Вызов SmiGenGui.LM9');
  cmd_smi_repost    :=RegisterStdInCmd('@smi_repost',    'Посылка нового состояния');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  SMITEST_FREE;
  FreeSmiuiSrv;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollSmiuiSrv then PollSmiuiSrv;
  SMITEST_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; dev,tag:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   !!! Handle SMIUISRV by default handler !!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   }
   if smiuisrv_default_handler(Data,cmd,arg,cmdid) then begin
    if (Data<>'') then Success(smiuisrv_prompt+Data);
    Data:='';
   end else
   {
   @fsm_testing
   }
   if IsSameText(cmd,'@fsm_testing') then begin
    fsm_testing;
    Data:='';
   end else
   {
   @PidKillSmiSM
   }
   if IsSameText(cmd,'@PidKillSmiSM') then begin
    DevPostCmdLocal('@syseval @pid kill '+AdaptExeFileName('smiSM.exe'));
    Data:='';
   end else
   {
   @SmiTclTkGui ~~\Resource\SmiSite\smi\src\tclTkGUI\main.tcl
   }
   if (cmdid=cmd_SmiTclTkGui) then begin
    SmiTclTkGui(ReadIni('SmiTclTkGui'));
    Data:='';
   end else
   {
   @SmiGenGui ~~\Resource\DaqSite\SmiServer\SmiGenGui.lm9
   }
   if (cmdid=cmd_SmiGenGui) then begin
    SmiGenGui(ReadIni('SmiGenGui'));
    Data:='';
   end else
   {
   @smi_repost
   }
   if (cmdid=cmd_smi_repost) then begin
    dev:=RefFind('device '+ExtractWord(1,arg));
    tag:=RefFind('tag '+ExtractWord(2,arg));
    if (dev<>0) then
    if TypeTag(tag)<>3
    then DevPostCmd(dev,'@smi_repost')
    else DevPostCmd(dev,'@smi_repost '+sGetTag(tag));
    Data:='';
   end else
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsStarter;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
