########################################################################################################################
# State Manager Language (SML) Source file.
# Extra cookies uses for GUI declarations:
#  !visible: v      - Action visability (v=0/1) in popup menu.
#  !color: c        - Display color (c) for entity declared above.
#  !panel: p        - Panel name (p) to be opened on click. Substututions (_DOMAIN_,_OBJECT_,_STATE_,_ACTION_) is allowed.
#  !title: t        - Display title (t) for entity declared above.
#  !busy_title: t   - Display title (t) for BUSY state.
#  !busy_color: c   - Display color (c) for BUSY state.
#  !confirm: c      - Action required (c=0/1) confirmation dialog.
########################################################################################################################
!title: ВАКУУМ
!busy_title: &ЗАНЯТ
!busy_color: FwStateAttention1

# Vacuum System Section class
#############################

class: SECT_CLASS /associated
!color: Silver
    state: DEAD /dead_state                                 !color: FwDead
    state: OFF /initial_state                               !color: _BtnFace
        action: GO_STANDBY                                  !visible: 1
    state: STANDBY                                          !color: FwStateOKNotPhysics
        action: GO_MANUAL                                   !visible: 1
        action: SWITCH_OFF                                  !visible: 1
        action: START_PUMP                                  !visible: 1
    state: MANUAL                                           !color: _BtnFace
        action: GO_STANDBY                                  !visible: 1
    state: PUMPING                                          !color: FwStateOKNotPhysics
        action: STOP_PUMP                                   !visible: 1
        action: OPEN_SECTION                                !visible: 1
    state: READY                                            !color: FwStateOKPhysics
        action: CLOSE_SECTION                               !visible: 1
    state: WARNING                                          !color: FwAlarmWarnAck
        action: RESET                                       !visible: 1
        action: OPEN_SECTION                                !visible: 1
        action: CLOSE_SECTION                               !visible: 1
    state: ERROR                                            !color: FwAlarmFatalAck
        action: RESET                                       !visible: 1

object: SEC1 is_of_class SECT_CLASS !title: СЕКЦИЯ1
object: SEC2 is_of_class SECT_CLASS !title: СЕКЦИЯ2
object: SEC3 is_of_class SECT_CLASS !title: СЕКЦИЯ3
object: SEC4 is_of_class SECT_CLASS !title: СЕКЦИЯ4
object: SEC5 is_of_class SECT_CLASS !title: СЕКЦИЯ5
object: SEC6 is_of_class SECT_CLASS !title: СЕКЦИЯ6

objectset: SECTIONS is_of_class VOID {SEC1,SEC2,SEC3,SEC4,SEC5,SEC6}


# Vacuum System class
#####################

class: VACS_CLASS
!color: Silver
    state: OFF /initial_state                               !color: _BtnFace
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( any_in SECTIONS not_in_state OFF )  move_to MIXED
        action: GO_STANDBY                                  !visible: 1
            do GO_STANDBY all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to STANDBY
    state: STANDBY                                          !color: FwStateOKNotPhysics
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( any_in SECTIONS not_in_state STANDBY )  move_to MIXED
        action: GO_MANUAL                                   !visible: 1
            do GO_MANUAL all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to MANUAL
        action: SWITCH_OFF                                  !visible: 1
            do SWITCH_OFF all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to OFF
        action: START_PUMP                                  !visible: 1
            do START_PUMP all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to PUMPING
    state: MIXED                                            !color: FwStateAttention2
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( any_in SECTIONS in_state PUMPING )  move_to PUMPING
        when ( all_in SECTIONS in_state READY )  move_to READY
        when ( all_in SECTIONS in_state STANDBY )  move_to STANDBY
        when ( all_in SECTIONS in_state MANUAL )  move_to MANUAL
        when ( all_in SECTIONS in_state OFF )  move_to OFF
    state: MANUAL                                           !color: _BtnFace
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( any_in SECTIONS not_in_state MANUAL )  move_to MIXED
        action: GO_STANDBY                                  !visible: 1
            do GO_STANDBY all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to STANDBY
    state: PUMPING                                          !color: FwStateOKNotPhysics
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( all_in SECTIONS not_in_state PUMPING )  move_to MIXED
        action: STOP_PUMP                                   !visible: 1
            do STOP_PUMP all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to STANDBY
        action: OPEN_SECTION                                !visible: 1
            do OPEN_SECTION all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to READY
    state: READY                                            !color: FwStateOKPhysics
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( any_in SECTIONS in_state WARNING )  move_to WARNING
        when ( any_in SECTIONS not_in_state READY )  move_to MIXED
        action: CLOSE_SECTION                               !visible: 1
            do CLOSE_SECTION all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to PUMPING
    state: WARNING                                          !color: FwAlarmWarnAck
        when ( any_in SECTIONS in_state ERROR )  move_to ERROR
        when ( all_in SECTIONS not_in_state WARNING )  move_to MIXED
        action: RESET                                       !visible: 1
            do RESET all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to STANDBY
        action: OPEN_SECTION                                !visible: 1
            do OPEN_SECTION all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to READY
        action: CLOSE_SECTION                               !visible: 1
            do CLOSE_SECTION all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to PUMPING
    state: ERROR                                            !color: FwAlarmFatalAck
        when ( (all_in SECTIONS not_in_state ERROR) and (all_in SECTIONS not_in_state WARNING) )  move_to MIXED
        action: RESET                                       !visible: 1
            do STOP_PUMP all_in SECTIONS
            do RESET all_in SECTIONS
            wait ( all_in SECTIONS )
            move_to STANDBY

object: VACS is_of_class VACS_CLASS !title: СИСТЕМА

