 {
 ***********************************************************************
 Daq Pascal application program UH_PULSE.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 ***********************************************************************
 Программа генерации импульсов скважности для управления печами UniHeat.
 Конфигурирование и описание: (здесь i-номер печи)
 1) К входам AnalogInput(1..30) подключаются каналы скважностей печей.
    Их генерирует &UH_CTRL, &UH_PULSE только генерирует заданный меандр. 
    На выходе DigitalOutput(1..30) выдается сигнал управления для печей.
    Нулевые каналы не используются!
 2) Число печей определяется по числу тегов номера печи UH_HNUMi.
    Следите за соответствием числа печей и соответствующих тегов.
 3) Период генерируемого меандра задан в теге UH_PERIODi.
 ***********************************************************************
 20000903 Alexey Kuryakin
 20131013 Alexey Kuryakin
 ***********************************************************************
 }
program UH_PULSE;                { UniHeat pulse generator          }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxHeat           = 30;         { Maximal number of heaters        }
 MaxCycle          = 100;        { Maximal number of cycles to reset}
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 NumHeats          : Integer;    { Current number of heaters        }
 tStart            : array [1..MaxHeat] of Real; { Time of start    }
 tagPERIOD         : array [1..MaxHeat] of Integer; { Pulse period  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var i:Integer;
 begin
  {
  Find number of heaters by max. number of tags UH_HNUMi
  }
  NumHeats:=0;
  for i:=1 to MaxHeat do if FindTag('UH_HNUM'+Str(i))<>0 then NumHeats:=i;
  {
  Initialize timers...
  }
  for i:=1 to NumHeats do begin
   tStart[i]:=mSecNow-Int(rGetTag(tagPERIOD[i])*(i-1)/Max(1,NumHeats-1));
  end;
  {
  Initialize tags...
  }
  for i:=1 to NumHeats do begin
   InitTag( tagPERIOD[i], 'UH_PERIOD'+Str(i), 2);
  end;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i:Integer; qx,dt,Period:Real; b:Boolean;
 begin
  {
  Calculate meander for all heaters
  }
  for i:=1 to NumHeats do begin                                     // For all heaters
   if RefDo(i)<>_Nil then begin                                     // If DO connected
    Period:=rGetTag(tagPeriod[i]);                                  // Get pulse period, ms
    dt:=(mSecNow-tStart[i])/Period;                                 // Time since tStart, ms
    qx:=Max(0.0,Min(1.0,GetAi_Yn(i)/100.0));                        // Get off-duty factor in 0..1 range
    b:=PutDo(i,time,Ord( (qx>0) and (frac(dt)<=qx) ));              // Enpack event
    if Int(dt)>MaxCycle then tStart[i]:=tStart[i]+Int(dt)*Period;   // Update tStart to avoid rounding errors
   end;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
