{
                     ПРОТОКОЛ ОБМЕНА:
 Запрос:  @befCH1_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH1on_GR1on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH2_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH2on_GR1on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befGR2_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH1_GR2on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH1on_GR2on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH2_GR2on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH2on_GR2on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @pastCH2_GR2on         --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @GR2off                --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @LAUNCH_on             --> Поджиг вкл.
 Ответ:   @DevName Y             --> OK

 Запрос:  @LAUNCH_off            --> Поджиг выкл.
 Ответ:   @DevName Y             --> OK

 Запрос:  @STOP                  --> остановка любых запущенных команд и обесточивание силовых цепей
 Ответ:   @DevName Y             --> OK

 Запрос:  @ADC                   --> запрос 8-ми каналов АЦП в шестнадцатиричном формате
 Ответ:   @DevName XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX --> в ответе 32 hex символа АЦП

 Запрос:  @AUTO   --> запуск автономного алгоритма автоматики
 Ответ:   @DevName Y

 Запрос:  @ENDAUTO   --> подтверждение окончания алгоритма автоматики, (в нижнем уровне нет)
 Ответ:   @DevName N --> алгоритм не закончен
          @DevName Y --> алгоритм закончен

 Запрос:  @MODE      --> запросить режим, в котором сейчас находится прибор
 Ответ:   @DevName 0 --> автономный автоматический
          @DevName 1 --> ручной
          @DevName 2 --> программный
          @DevName 3 --> режим не определен

                         НЕШТАТНЫЕ СИТУАЦИИ:
 Ответ:  @DevName Error       --> ошибка синтаксиса сообщения драйверу
         @DevName PikError    --> внутренняя ошибка прибора
         @DevName BUSY        --> драйвер еще не обработал предыдущее сообщение
         @DevName T           --> Команда проигнорирована, так как устройство находится не
                                  в программном режиме.
         @DevName AUTO        --> Не послали запрос "@ENDAUTO", чтобы проверить окончание
                                  автономной работы по алгоритму
                                  Примечание: завершить автономный режим по алгоритму можно командой
                                              @STOP
}
program PIK_DRV_SIM;
const
 dfTrouble         = 1;          { DebugFlags - Trouble             }
 dfSuccess         = 2;          { DebugFlags - Success             }
 dfViewExp         = 4;          { DebugFlags - ViewExp             }
 dfViewImp         = 8;          { DebugFlags - ViewImp             }
 snd_Click         = 'Click';    { Sound on button click            }
 snd_Fails         = 'Fails';    { Sound on operation failure       }
var
 s                 : String;     { Temporary                        }
 sx                 : String;     { Temporary                        }
 i                 : Integer;    { Temporary                        }
 r                 : Real;       { Temporary                        }
 b                 : Boolean;    { Temporary                        }
 Ok                : Boolean;    { Program initialization is Ok?    }
 errors            : Integer;
 errorcode         : Integer;
 fixmaxavail       : Integer;    { String manager leak control      }
 DebugFlags        : Integer;    { Debug bit flags                  }
 StdIn_Line        : String;     { Temporary variable               }

 ref       : integer;  { ссылка на устройство пользователя }
 UserDev   : string;   { имя устройства пользователя }

 wdtms             : real;

 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if RunCount=1 then errors:=errors+1 else b:=FixError(errorcode);
 end;
 {
 Report on problem.
 }
 procedure Problem(msg:String);
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iAnd(DebugFlags,dfSuccess)<>0 then
  if Length(msg)>0 then Writeln(DevName+' : '+msg);
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 var i:Integer;
 begin
  s:='';
  sx:='';
  StdIn_Line:='';
  UserDev:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
{
инкремент счетчика ошибок
}
procedure error(s:string);
begin
 errors:=errors+1;
 if length(s)>0 then writeln('ERROR:'+s);
end;

{
Initialize and check tag
}      
procedure InitTag(var tag:integer; name:string; typ:integer);
begin
 tag:=findtag(name);
 if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Calculate time since tag switch on
 }
 procedure CalcWdtTime(var wdt:Real);
 begin
  if wdt<=0 then wdt:=msecnow;
 end;
 {
 Calculate time since tag switch on
 }
 function GetWdtTime(wdt:Real):Real;
 begin
  if wdt>0 then GetWdtTime:=msecnow-wdt else GetWdtTime:=0;
 end;

begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  UserDev := readini( 'UserDev' );
//writeln('UserDev=', UserDev);
  ref:=reffind( 'Device ' + UserDev );

  wdtms:=0; CalcWdtTime(wdtms);
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  ClearStrings;
  Success('Stop.');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  s := '';
  while not eof do begin
   readln( s );
   if IoResult <> 0 then writeln( 'Error input message' );
  end;
  if s <> '' then begin
   sx:=s;
   if DebugFlags>0 then writeln( 'User talk: ', sx );
  end;

  if GetWdtTime(WDTms)>random(20,200)  then if sx <> '' then begin
   if (sx='@MODE') then s:=' 2';
   if (sx<>'@MODE') then s:=' Y';
   r:=devsend( ref, '@' + devname + s + CrLf );;
   if DebugFlags>0 then writeln(time,s);
   wdtms:=0; CalcWdtTime(wdtms);
   sx:='';
   s:='';
  end;
 end;
end.
