{
 Драйвер для обмена тегами с контроллером прибора по последовательному порту.
 Последняя редакция: 17.05.2010
 Автор:              Вьюшин Алексей, vjushin@mail.ru

                     САМОЕ ГЛАВНОЕ, ЧТО НУЖНО ИМЕТЬ В ВИДУ:
 На любое сообщение драйверу, пусть даже бессмысленное, всегда приходит ответ!

                     ПРОТОКОЛ ОБМЕНА:
 Запрос:  @befCH1_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH1on_GR1on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH2_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH2on_GR1on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befGR2_GR1on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH1_GR2on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH1on_GR2on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @befCH2_GR2on          --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @CH2on_GR2on_befLANCH  --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @pastCH2_GR2on         --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @GR2off                --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @contGR1CH1            --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @contGR1CH2            --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @contGR2CH1            --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @contGR2CH2            --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @contGRCHoff           --> аббревиатура по алгоритму
 Ответ:   @DevName Y             --> OK

 Запрос:  @LAUNCH_on             --> Поджиг вкл.
 Ответ:   @DevName Y             --> OK

 Запрос:  @LAUNCH_off            --> Поджиг выкл.
 Ответ:   @DevName Y             --> OK

 Запрос:  @STOP                  --> остановка любых запущенных команд и обесточивание силовых цепей
 Ответ:   @DevName Y             --> OK

 Запрос:  @ADC                   --> запрос 8-ми каналов АЦП в шестнадцатиричном формате
 Ответ:   @DevName XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX --> в ответе 32 hex символа АЦП

 Запрос:  @AUTO   --> запуск автономного алгоритма автоматики
 Ответ:   @DevName Y

 Запрос:  @ENDAUTO   --> подтверждение окончания алгоритма автоматики, (в нижнем уровне нет)
 Ответ:   @DevName N --> алгоритм не закончен
          @DevName Y --> алгоритм закончен

 Запрос:  @MODE      --> запросить режим, в котором сейчас находится прибор
 Ответ:   @DevName 0 --> автономный автоматический
          @DevName 1 --> ручной
          @DevName 2 --> программный
          @DevName 3 --> режим не определен

                         НЕШТАТНЫЕ СИТУАЦИИ:
 Ответ:  @DevName Error       --> ошибка синтаксиса сообщения драйверу
         @DevName PikError    --> внутренняя ошибка прибора
         @DevName BUSY        --> драйвер еще не обработал предыдущее сообщение
         @DevName T           --> Команда проигнорирована, так как устройство находится не
                                  в программном режиме.
         @DevName AUTO        --> Не послали запрос "@ENDAUTO", чтобы проверить окончание
                                  автономной работы по алгоритму
                                  Примечание: завершить автономный режим по алгоритму можно командой
                                              @STOP
}
program PIK_DRV;
const
 dfTrouble         = 1;          { DebugFlags - Trouble             }
 dfSuccess         = 2;          { DebugFlags - Success             }
 dfViewExp         = 4;          { DebugFlags - ViewExp             }
 dfViewImp         = 8;          { DebugFlags - ViewImp             }
 snd_Click         = 'Click';    { Sound on button click            }
 snd_Fails         = 'Fails';    { Sound on operation failure       }

 Dev           = 'Слот: '; { Название устройства }
 Debug         = false;     { отладка }
 PeriodOnline = 2000;      { период проверки связи с прибором }
 MaxNumCmd    = 32;        { максимальное количество команд }

 { Индексы команд в таблице, в контроллере +1 }
 befCH1_GR1on = 0;
 CH1on_GR1on_befLANCH = 1;
 befCH2_GR1on = 2;
 CH2on_GR1on_befLANCH = 3;
 befGR2_GR1on = 4;
 befCH1_GR2on = 5;
 CH1on_GR2on_befLANCH = 6;
 befCH2_GR2on = 7;
 CH2on_GR2on_befLANCH = 8;
 pastCH2_GR2on = 9;
 GR2off = 10;
 contGR1CH1 = 11;
 contGR1CH2 = 12;
 contGR2CH1 = 13;
 contGR2CH2 = 14;
 contGRCHoff = 15;
 LAUNCH_on = 16;
 LAUNCH_off = 17;
 AUTO = 18;
 STOP = 19;
 ADC = 20;
 MODE = 21;
 ENDAUTO = 22;  { подтверждение окончания алгоритма автоматики, (в нижнем уровне нет) }

 { идентификаторы при ответе модулей или контроллера }
 cSET          = 0; { запрос команды }
 cSET_ACK      = 1; { запрос подтверждения на выполнение команды }
 cADC          = 2; { чтение АЦП }
 cMODE         = 3; { чтение режима прибора }
 cENDAUTO      = 4; { чтение подтверждения окончания алгоритма автоматики }

                           { Коды adam_status:                                       }
 rs_NotAvail   = 0;        { RS-485 недоступен, вероятно, неверен Adam_Slot_Device   }
 rs_NoRequest  = 1;        { Запрос очищен - можно слать новый запрос Adam_Request   }
 rs_WaitQueue  = 2;        { Запрос послан в слот, ждем его передачи на линию RS     }
 rs_WaitAnswer = 3;        { Запрос послан, передан на линию RS, ждем ответа с линии }
 rs_Answer     = 4;        { Пришел ответ Adam_Get('Answer') на запрос               }
 rs_TimeOut    = 5;        { TimeOut - не пришел ответ в течение заданного срока     }
 timeout       = 7000;     { время ожидания ответа }
 senttype_req  = 0;        { был запрос }
 senttype_set  = 1;        { была установка }
 acktimeout    = 4000;     { время ожидания изменения PIK_MEM_ACK }
var
 b         : Boolean;
 Ok        : Boolean;
 errors    : Integer;
 errorcode : Integer;
 DebugFlags: Integer;    { Debug bit flags                  }
 Status    : integer;      { статус ADAM }
 addr      : string;       { адрес контроллера в сети }
 bTimeout  : boolean;      { был timeout }
 i         : integer;      { вре'менная }
 r         : real;         { вре'менная }

{*} s         : string;       { Вре'менная }
{*} sDelims   : string;       { Текущий набор разделителей  }
{*} AnchTime  : real;         { Начальное время для timeout }
{*} bAnswer   : integer;      { прием сообщения (0) или ответ на него (1) }
{*} wordsmsg  : integer;      { число слов в сообщении }
{*} answmsg   : string;       { строка ответа от слота }
{*} inmsg     : string;       { строка запроса драйверу }
{*} outmsg    : string;       { строка ответа просящему }
{*} sToSlot   : string;       { строка запроса для слота }
{*} cmdtab1       : record
{*}  bAllow       : boolean;  { Принимаем команды сообщений }
{*}  count        : integer;  { Количество команд }
{*}  current      : integer;  { Текущая команда }
{*}  id           : array[0..MaxNumCmd] of string; { строковый id команды }
{*}  cmdID        : array[0..MaxNumCmd] of integer; { Идентификатор команды }
{*} end;
{*} Indx      : integer;      { индекс команды }

{*} bAUTO         : boolean;  { запущен автономный режим по алгоритму }
{*} bPikError     : boolean;  { ошибка Pik }
{*} ref           : integer;  { ссылка на устройство пользователя }
{*} bSet          : boolean;  { флаг существующего запроса по Set }
{*} UserDev       : string;   { имя устройства пользователя }
{*} cmdtab2        : record
{*}  count        : integer;
{*}  current      : integer;
{*}  sentcmd      : integer;
{*}  sentnum      : integer;
{*}  enabled      : array[0..MaxNumCmd] of boolean;
{*}  cmdID        : array[0..MaxNumCmd] of integer;
{*} end;
{*} AA            : string;
{*} msStart       : real;    { время отсчета для проверки связи с прибором }
{*} bCheckOnline  : boolean; { проверяем связь с прибором }



 counts    : integer;      { общее число устанавливаемых или считываемых уставок }
 cntArr    : integer;      { счетчик устанавливаемых или считываемых уставок }
 bAck      : Boolean;      { идет опрос PIK_MEM_ACK }
 tAck      : real;         { время начала опроса PIK_MEM_ACK }
 senttype  : integer;      { тип посылки - запрос или установка }
 anstype   : integer;      { ожидаемый тип тега при запросе 1-integer,2-real,3-string }
 anstag    : integer;      { ожидаемая ссылка на тег при ответе на запрос }

 tagArr        : array[1..32] of integer; { устанавливаемые или считываемые уставки }
 tagGR1        : integer;  { разрешение ГР1 }
 tagGR2        : integer;  { разрешение ГР2 }
 tagMEM_ACK    : integer;  { подтверждение записи в EEPROM }
 tagMEM        : integer;  { тег записи в EEPROM }
 tagREAD       : integer;  { 0-не читаем, 1-читаем }
 tagWRITE      : integer;  { 0-не записано, 1-пишем, 2-записано }
 tagTIMEOUT    : integer;  { признак timeout }
 tagERR        : integer;  { ошибка слота }
 tagONLINE     : integer;  { постоянная проверка связи }
 tagENB_ONLINE : integer;  { разрешение постоянной проверки связи }

 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
  if RunCount=1 then errors:=errors+1 else b:=FixError(errorcode);
 end;
 {
 Report on problem.
 }
 procedure Problem(msg:String);
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iAnd(DebugFlags,dfSuccess)<>0 then
  if Length(msg)>0 then Writeln(DevName+' : '+msg);
 end;
procedure ClearStr;
begin
 addr:='';
{*} s:='';
{*} sDelims:='';
{*} answmsg:='';
{*} for i := 0 to MaxNumCmd do cmdtab1.id := '';
{*} inmsg:='';
{*} outmsg:='';
{*} sToSlot:='';
{*} UserDev := '';
{*} AA:='';
end;

{*}
{*}{Reset command table}
{*}
{*}procedure ResetCmd1;
{*}begin
{*} cmdtab1.bAllow := true;
{*} cmdtab1.count := 0;
{*} cmdtab1.current := -1;
{*} bAUTO := false;
{*}end;


{*}{Add command to command table}
{*}function AddCmd1( id :string; cmdID :integer ) :boolean;
{*}var
{*} i :integer;
{*} rslt :boolean;
{*}begin
{*} if cmdtab1.count < MaxNumCmd then begin
{*}  rslt := true;
{*}  for i := 0 to cmdtab1.count-1 do
{*}   if cmdtab1.cmdID[i] = cmdID then rslt := false;
{*}  if rslt = true then begin
{*}   cmdtab1.id[cmdtab1.count] := id;
{*}   cmdtab1.cmdID[cmdtab1.count] := cmdID;
{*}   cmdtab1.count := cmdtab1.count + 1;
{*}  end;
{*} end
{*} else rslt := false;
{*} AddCmd1 := rslt;
{*}end;

{*}{Поиск индекса в таблице по строковому идентификатору команды}
{*}function IndxFromCmd( s :string ) :integer;
{*}var i, rslt :integer;
{*}begin
{*} rslt := -1;
{*} for i := 0 to cmdtab1.count-1 do begin
{*}  if cmdtab1.id[i] = s then rslt := i;
{*} end;
{*} IndxFromCmd := rslt;
{*}end;


{*}{Поиск индекса по числовому индентификатору команды}
{*}function IndxFromCmdID( cmdID :integer ) :integer;
{*}var i, rslt :integer;
{*}begin
{*} rslt := -1;
{*} for i := 0 to cmdtab1.count-1 do begin
{*}  if cmdtab1.cmdID[i] = cmdID then rslt := i;
{*} end;
{*} IndxFromCmdID := rslt;
{*}end;


{*}{Reset command table}
{*}procedure ResetCmd2;
{*}begin
{*} cmdtab2.count:=0;
{*} cmdtab2.current:=0;
{*} cmdtab2.sentcmd:=0;
{*} cmdtab2.sentnum:=0;
{*}end;

{*}{Add command to command table}
{*}procedure AddCmd2(cmdID:integer;enabled:boolean);
{*}begin
{*} if cmdtab2.count<MaxNumCmd then begin
{*}  cmdtab2.cmdID[cmdtab2.count]:=cmdID;
{*}  cmdtab2.enabled[cmdtab2.count]:=enabled;
{*}  cmdtab2.count:=cmdtab2.count+1;
{*} end;
{*}end;

{*}{Запрет всех команд слота}
{*}procedure DisableCmd2;
{*}var i :integer;
{*}begin
{*} bSet := false;
{*} for i := 0 to cmdtab2.count - 1 do cmdtab2.enabled[i] := false;
{*}end;


{*}{Обработка ошибки PIK}
{*}procedure PikError;
{*}begin
{*} if ( ( bAnswer = 1 ) and ( bPikError ) ) then begin
{*}  bPikError := false;
{*}  outmsg := 'PikError';
{*}  cmdtab1.current := -1;
{*}  cmdtab1.bAllow := true;
{*}  bAnswer := 0;
{*}  DisableCmd2;
{*}  bAUTO := false;
{*} end;
{*}end;
{
инкремент счетчика ошибок
}
procedure error(s:string);
begin
 errors:=errors+1;
 if length(s)>0 then writeln('ERROR:'+s);
end;

{
Initialize and check tag
}      
procedure InitTag(var tag:integer; name:string; typ:integer);
begin
 tag:=findtag(name);
 if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
end;

 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
{
 t - тип запроса (1-integer;2-real, 3-string)
}
procedure SendReq(tag :integer; t :integer);
var
 s : string;
begin
 senttype:=senttype_req;
 anstag:=tag;
 anstype:=t;
 if not adam_request('$'+addr+'V'+nametag(tag)+chr(13),-timeout)
 then begin
  error('Can not send request');
  b:=ssettag(tagERR, Dev+'Can not send request');
 end
 else begin
  b:=isettag(tagTIMEOUT,0);
  b:=ssettag(tagERR, '');
 end;
 s:='';
end;

{
 t - тип запроса (1-integer;2-real, 3-string)
}
procedure Send(tag :integer; t :integer);
var
 s : string;
begin
 senttype:=senttype_set;
 if t=2 then begin { вещественные уставки }
  s:=mime_encode(dump(rgettag(tag)));
  s:='d'+s;
 end
 else if t=1 then begin { уставки разрешения ГР }
  if igettag(tag)=0 then s:=''''+'N'+''''
  else s:=''''+'Y'+'''';
 end
 else if t=3 then s:=''''+sgettag(tag)+'''';
 if not adam_request('$'+addr+'V'+nametag(tag)+'='+s+chr(13),-timeout)
 then begin
  error('Can not send request');
  b:=ssettag(tagERR, Dev+'Can not send request');
 end
 else begin
  b:=isettag(tagTIMEOUT,0);
  b:=ssettag(tagERR, '');
 end;
 s:='';
end;

procedure OnNotAvail;
begin
 if Debug then writeln('NotAvail...');
 b:=ssettag(tagERR, Dev+'Not Available');
end;

procedure  OnNoRequest;
var
 s :string;
{*} i   : integer;
{*} cmd : string;
begin
 if( (igettag(tagWRITE)=1) and cmdtab1.bAllow ) then begin
  { cntArr инкрементируется в OnAnswer или же сбрасывается в OnTimeout }
  if cntArr <= counts then Send(tagArr[cntArr], 2)
  else if (cntArr-counts)=1 then Send(tagGR1, 1)
  else if (cntArr-counts)=2 then Send(tagGR2, 1)
  else if (cntArr-counts)=3 then begin
   b:=ssettag(tagMEM_ACK,'N');
   Send(tagMEM_ACK, 3);
  end
  else if (cntArr-counts)=4 then begin
   b:=ssettag(tagMEM,'Y');
   Send(tagMEM, 3);
   tAck:=msecnow;
  end
  else if (cntArr-counts)=5 then begin
   SendReq(tagMEM_ACK, 3);
  end
  else begin
   if (msecnow-tAck) < acktimeout then begin
    if sgettag(tagMEM_ACK)='Y' then begin
     b:=isettag(tagWRITE,2); { ЗАПИСАНО }
     cntArr:=1;
    end
    else if sgettag(tagMEM_ACK)='E' then begin
     b:=isettag(tagWRITE,0); { НЕ ЗАПИСАЛОСЬ, НЕ КОРРЕКТНЫЕ УСТАВКИ }
     b:=ssettag(tagERR, 'Запись не прошла - некорректные уставки');
     cntArr:=1;
    end
    else cntArr:=cntArr-1;
   end
   else begin
    b:=isettag(tagWRITE,0); { НЕ ЗАПИСАЛОСЬ, TIMEOUT}
    b:=ssettag(tagERR, 'Нет подтверждения записи в контроллере');
    cntArr:=1;
   end;
  end;
 end {tagWRITE=1}
 else if( (igettag(tagREAD)=1) and cmdtab1.bAllow ) then begin
  if cntArr <= counts then SendReq(tagArr[cntArr], 2)
  else if (cntArr-counts)=1 then SendReq(tagGR1, 3)
  else if (cntArr-counts)=2 then SendReq(tagGR2, 3)
  else if (cntArr-counts)=3 then begin
   b:=isettag(tagREAD,0);  { ПРОЧИТАЛИ }
   b:=isettag(tagWRITE,2); { УСТАВКИ СОВПАДАЮТ }
   cntArr:=1;
  end;
 end; {tagREAD=1}
 {*******************Для команд**********************************}
{*} {Pass disabled commands...}
{*} i:=0;
{*} while (i<MaxNumCmd) and not cmdtab2.enabled[cmdtab2.current] do begin
{*}  cmdtab2.current:=cmdtab2.current+1;
{*}  if cmdtab2.current>=cmdtab2.count then cmdtab2.current:=0;
{*}  i:=i+1;
{*} end;
{*} { If has command to send, try to send this command... }
{*} cmd:='';
{*} if cmdtab2.enabled[cmdtab2.current] then begin
{*}  cmdtab2.sentnum:=cmdtab2.current;
{*}  cmdtab2.sentcmd:=cmdtab2.cmdID[cmdtab2.sentnum];
{*}  r:=cmdtab1.current+1; { Индекс команы в таблице, в контроллере +1 }
{*}  case cmdtab2.sentcmd of
{*}   cSET     : cmd:='$'+AA+'VPRG_ACK=''N'';PRG=d'+mime_encode(dump(r)); { !AA }
{*}   cSET_ACK : cmd:='$'+AA+'VPRG_ACK';                                  { !AA'Y' }
{*}   cADC     : cmd:='$'+AA+'VADC';
{*}   cMODE    : cmd:='$'+AA+'VMODE';
{*}   cENDAUTO : cmd:='$'+AA+'VPRG_ACK';
{*}  end;
{*}  if Adam_Request(cmd+chr(13),-200) then begin
{*}   //b:=echo(cmd);
{*}   if Debug then writeln('Request: ',cmd);
{*}   cmdtab2.current:=cmdtab2.current+1;
{*}   if cmdtab2.current>=cmdtab2.count then cmdtab2.current:=0;
{*}  end else begin
{*}   b:=fixError(errorcode);
{*}   if Debug then writeln('Could not raise request: ',cmd);
{*}  end;
{*} end;
 s:='';
{*} cmd:='';
end;

procedure  OnWaitQueue;
begin
 if Debug then writeln('WaitQueue...');
end;

procedure  OnWaitAnswer;
begin
 if Debug then writeln('WaitAnswer...');
end;

procedure  OnAnswer;
var
 r :real;
 i :integer;
 s :string;
 AnsTime : real;
begin
 s:='';
 bTimeout:=false;
 s:=adam_get('answer');
 if Debug then writeln('answer->', s);
 if( ((igettag(tagREAD)=1)or(igettag(tagWRITE)=1)) and
     cmdtab1.bAllow ) then begin {чтение, запись уставок контроллера}
  if( s<>'' ) then begin
   i:=length(s);
   case senttype of
    senttype_set: begin
     if( (i=3) and (pos('!', s)=1)) then cntArr:=cntArr+1;
    end;
    senttype_req: begin
     if( i>3 ) then begin
      case anstype of
       2: begin
           if(s[4]='d') then begin
            s:=mime_decode(copy(s,5,i-4));
            r:=dump2r(s);
            b:=rsettag(anstag,r);
            cntArr:=cntArr+1;
           end;
       end;
       3: begin
           if (s[4]='''')and(s[i]='''') then begin
            s:=copy(s,5,i-5);
            if (anstag=tagGR1)or(anstag=tagGR2) then begin
             if s='N' then b:=isettag(anstag,0)
             else if s='Y' then b:=isettag(anstag,1);
             cntArr:=cntArr+1;
            end
            else begin
             b:=ssettag(anstag, s);
             cntArr:=cntArr+1;
            end;
           end;
       end;
      end; {case anstype}
     end;
    end;
   end; {case senttype}
  end;
 end
 else begin
{*}  AnsTime:=Adam_ReqTime;
{*}  if Debug then writeln('Time=',AnsTime:11:4,' Answer=',s);
{*}  if pos('!'+AA,s)=1 then begin
{*}   case cmdtab2.sentcmd of
{*}    cSET      : begin{ !AA }
{*}                 cmdtab2.enabled[cSET]:=false;
{*}                 if length(s)=3 then begin end
{*}                 else begin 
{*}                  b:=fixError(errorcode);
{*}                  bPikError := true;
{*}                 end;
{*}                end;
{*}    cSET_ACK  : begin{ !AA'Y' }
{*}                 if length(s)=6 then begin
{*}                  if cmdtab1.cmdID[cmdtab1.current] = AUTO then begin
{*}                   if( (pos('N',s)=5) or (pos('Y',s)=5) ) then begin
{*}                    cmdtab2.enabled[cSET_ACK]:=false;
{*}                    if bSet then begin
{*}                     bSet := false;
{*}                     answmsg := 'Y';
{*}                     bAUTO := true;
{*}                    end;
{*}                   end
{*}                   else begin
{*}                    cmdtab2.enabled[cSET_ACK]:=false;
{*}                    if bSet then begin
{*}                     bSet := false;
{*}                     answmsg := 'T';
{*}                     bAUTO := false;
{*}                    end;
{*}                   end;
{*}                  end
{*}                  else begin
{*}                   if pos('N',s)=5 then cmdtab2.current:=cmdtab2.current-1
{*}                   else begin
{*}                    cmdtab2.enabled[cSET_ACK]:=false;
{*}                    if bSet then begin
{*}                     bSet := false;
{*}                     if cmdtab1.cmdID[cmdtab1.current] = STOP then bAUTO := false;
{*}                     if pos('Y',s)=5 then answmsg := 'Y'
{*}                     else answmsg := 'T';
{*}                    end;
{*}                   end;
{*}                  end;
{*}                 end
{*}                 else begin 
{*}                  b:=fixError(errorcode);
{*}                  bPikError := true;
{*}                 end;
{*}                end;
{*}    cADC      : begin
{*}                 cmdtab2.enabled[cADC]:=false;
{*}                 if length(s)>=11 then begin
{*}                  answmsg := copy(s,5,length(s)-5);
{*}                 end
{*}                 else begin 
{*}                  b:=fixError(errorcode);
{*}                  bPikError := true;
{*}                 end;
{*}                end;
{*}    cMODE     : begin{ !AA'0' or ... }
{*}                 if length(s)=6 then begin
{*}                  cmdtab2.enabled[cMODE]:=false;
{*}                  answmsg := copy(s,5,1);
{*}                 end
{*}                 else begin 
{*}                  b:=fixError(errorcode);
{*}                  bPikError := true;
{*}                 end;
{*}                end;
{*}    cENDAUTO  : begin{ !AA'Y' or !AA'N' }
{*}                 if length(s)=6 then begin
{*}                  if pos('N',s)=5 then begin
{*}                   cmdtab2.enabled[cENDAUTO]:=false;
{*}                   answmsg := 'N'
{*}                  end
{*}                  else begin
{*}                   cmdtab2.enabled[cENDAUTO]:=false;
{*}                   bAUTO := false;
{*}                   if pos('Y',s)=5 then answmsg := 'Y'
{*}                   else answmsg := 'T';
{*}                  end;
{*}                 end
{*}                 else begin 
{*}                  b:=fixError(errorcode);
{*}                  bPikError := true;
{*}                 end;
{*}                end;

{*}   end;
{*}  end
{*}  else bPikError := true;
{*}  PikError;
{*}  if( (outmsg <> '') and (bCheckOnline=false) ) then
{*}   if devsend( ref, '@' + devname + ' ' + outmsg + CrLf ) > 0 then begin end;
{*}  outmsg := '';
{*}  OnNoRequest;
 end;
 s:='';
end;

procedure  OnTimeOut;
begin
 if Debug then writeln('TimeOut...');
 b:=ssettag(tagERR, Dev+'Timeout');
 b:=isettag(tagTIMEOUT,1);
 b:=isettag(tagONLINE,0);
 bTimeout:=true;
 DisableCmd2;
 if igettag(tagWRITE)=1 then b:=isettag(tagWRITE,0);
 if igettag(tagREAD)=1  then b:=isettag(tagREAD,0);
 cntArr:=1;
end;

begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname+'-'+progname);
  cntArr:=1;
  bAck:=false;
  bTimeout:=false;
  ClearStr;

  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));

  if Debug then writeln(devname+' start');

  msStart:=msecnow;
  bCheckOnline:=false;
  addr:=adam_get('address');
  if Debug then writeln(addr);

{*}  s := worddelims( worddelims( '' ) + '@' );
{*}  sDelims := worddelims( '' );
{*}  bAnswer := 0;

{*}  { Заполнение таблицы команд }
{*}  ResetCmd1;
{*}  errors := errors + ord( not AddCmd1( 'befCH1_GR1on', befCH1_GR1on ) );
{*}  errors := errors + ord( not AddCmd1( 'CH1on_GR1on_befLANCH', CH1on_GR1on_befLANCH ) );
{*}  errors := errors + ord( not AddCmd1( 'befCH2_GR1on', befCH2_GR1on ) );
{*}  errors := errors + ord( not AddCmd1( 'CH2on_GR1on_befLANCH', CH2on_GR1on_befLANCH ) );
{*}  errors := errors + ord( not AddCmd1( 'befGR2_GR1on', befGR2_GR1on ) );
{*}  errors := errors + ord( not AddCmd1( 'befCH1_GR2on', befCH1_GR2on ) );
{*}  errors := errors + ord( not AddCmd1( 'CH1on_GR2on_befLANCH', CH1on_GR2on_befLANCH ) );
{*}  errors := errors + ord( not AddCmd1( 'befCH2_GR2on', befCH2_GR2on ) );
{*}  errors := errors + ord( not AddCmd1( 'CH2on_GR2on_befLANCH', CH2on_GR2on_befLANCH ) );
{*}  errors := errors + ord( not AddCmd1( 'pastCH2_GR2on', pastCH2_GR2on ) );
{*}  errors := errors + ord( not AddCmd1( 'GR2off', GR2off ) );
{*}  errors := errors + ord( not AddCmd1( 'contGR1CH1', contGR1CH1 ) );
{*}  errors := errors + ord( not AddCmd1( 'contGR1CH2', contGR1CH2 ) );
{*}  errors := errors + ord( not AddCmd1( 'contGR2CH1', contGR2CH1 ) );
{*}  errors := errors + ord( not AddCmd1( 'contGR2CH2', contGR2CH2 ) );
{*}  errors := errors + ord( not AddCmd1( 'contGRCHoff', contGRCHoff ) );
{*}  errors := errors + ord( not AddCmd1( 'LAUNCH_on', LAUNCH_on ) );
{*}  errors := errors + ord( not AddCmd1( 'LAUNCH_off', LAUNCH_off ) );
{*}  errors := errors + ord( not AddCmd1( 'AUTO', AUTO ) );
{*}  errors := errors + ord( not AddCmd1( 'STOP', STOP ) );
{*}  errors := errors + ord( not AddCmd1( 'ADC', ADC ) );
{*}  errors := errors + ord( not AddCmd1( 'MODE', MODE ) );
{*}  errors := errors + ord( not AddCmd1( 'ENDAUTO', ENDAUTO ) );
{********************************************************}

{*}  bPikError := false;

{*}  ResetCmd2;
{*}  UserDev := readini( 'UserDev' );
{*}  ref:=reffind( 'Device ' + UserDev );
     writeln('UserDev=', UserDev);
{*}  bSet := false;
{*}  bAUTO := false;

{*}  AddCmd2(cSET,  false);
{*}  AddCmd2(cSET_ACK,  false);
{*}  AddCmd2(cADC,  false);
{*}  AddCmd2(cMODE, false);
{*}  AddCmd2(cENDAUTO,  false);
{*}  AA:=Adam_Get('ADDRESS');

  { инициализация вещественных уставок }
  counts:=1;
  InitTag(tagArr[counts], readini('tagSOUNDS'),      2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagT_SOUND1'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagT_SOUND0'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD1_GR1'),     2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTCH1_GR1'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD2_GR1'),     2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTCH2_GR1'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD_GR2'),      2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD1_GR2'),     2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTCH1_GR2'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD2_GR2'),     2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTCH2_GR2'),    2);
  counts:=counts+1;
  InitTag(tagArr[counts], readini('tagTD3_GR2'),     2);

  InitTag(tagGR1,         readini('tagENB_GR1'),     1);
  InitTag(tagGR2,         readini('tagENB_GR2'),     1);
  InitTag(tagMEM,         readini('tagMEM'),         3);
  InitTag(tagMEM_ACK,     readini('tagMEM_ACK'),     3);

  InitTag(tagWRITE,       readini('tagWRITE'),       1);
  InitTag(tagREAD,        readini('tagREAD'),        1);

  InitTag(tagTIMEOUT,     readini('tagTIMEOUT'),     1);
  InitTag(tagERR,         readini('tagERR'),         3);
  InitTag(tagONLINE,      readini('tagONLINE'),      1);
  InitTag(tagENB_ONLINE,  readini('tagENB_ONLINE'),  1);
  if Debug then writeln(msecnow);
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
writeln('errors=', errors);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  ResetCmd2;
  ClearStr;
  if Debug then writeln(devname+' stop');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  if( runcount>1 ) then begin
{*}   s := '';
{*}   inmsg := '';
{*}   answmsg := '';
{*}   while not eof do begin
{*}    readln( s );
{*}    if IoResult <> 0 then writeln( 'Error input message' );
{*}   end;

{*}  if( (s='') and cmdtab1.bAllow and (igettag(tagENB_ONLINE)=1) ) then
{*}  if (msecnow-msStart)>PeriodOnline then begin
{*}   s:='@MODE'; bCheckOnline:=true;
{*}   msStart:=msecnow;
{*}  end;

{*}   if cmdtab1.bAllow = false then begin
{*}    if s <> '' then begin
{*}     if Debug then writeln( 'User talk: ', s );
{*}     if devsend( ref, '@' + devname + ' BUSY' + CrLf ) > 0 then begin end;
{*}    end;
{*}   end
{*}   else { сообщение от пользователя }
{*}    if s <> '' then begin
{*}     Indx := IndxFromCmd(extractword( 1, s ));
{*}     if Debug then writeln( 'User talks: ', s );
{*}     if ( (igettag(tagREAD)=1) or (igettag(tagWRITE)=1) ) then begin
{*}      if( bCheckOnline=false ) then
{*}      if devsend( ref, '@' + devname + ' BUSY' + CrLf ) > 0 then begin end;
{*}     end
{*}     else if( Indx > (-1) ) then begin
{*}      if( ( cmdtab1.cmdID[Indx]>-1) and
{*}          (cmdtab1.cmdID[Indx]<STOP) and
{*}          (bAUTO=true) ) then begin
{*}       if( bCheckOnline=false ) then
{*}       if devsend( ref, '@' + devname + ' AUTO' + CrLf ) > 0 then begin end;
{*}      end
{*}      else begin
{*}       inmsg := s;
{*}       if inmsg[1] = '@' then begin
{*}        cmdtab1.current := Indx;
{*}       end;
{*}      end;
{*}     end
{*}     else inmsg := s;
{*}    end
{*}    else cmdtab1.current := -1;

{*}   if cmdtab1.current > ( -1 ) then begin
{*}    cmdtab1.bAllow := false;
{*}    wordsmsg := wordcount( inmsg );
{*}    case cmdtab1.cmdID[cmdtab1.current] of
{*}     befCH1_GR1on,
{*}     CH1on_GR1on_befLANCH,
{*}     befCH2_GR1on,
{*}     CH2on_GR1on_befLANCH,
{*}     befGR2_GR1on,
{*}     befCH1_GR2on,
{*}     CH1on_GR2on_befLANCH,
{*}     befCH2_GR2on,
{*}     CH2on_GR2on_befLANCH,
{*}     pastCH2_GR2on,
{*}     GR2off,
{*}     contGR1CH1,
{*}     contGR1CH2,
{*}     contGR2CH1,
{*}     contGR2CH2,
{*}     contGRCHoff,
{*}     LAUNCH_on,
{*}     LAUNCH_off,
{*}     AUTO,
{*}     STOP,
{*}     ADC,
{*}     MODE,
{*}     ENDAUTO : begin
{*}      case bAnswer of
{*}       0: begin {прием сообщения}
{*}        if wordsmsg = 1 then begin
{*}         sToSlot := extractword(1, inmsg);
{*}         outmsg := '';
{*}         bAnswer := 1; { будем формировать ответ }
{*}         AnchTime := msecnow;
{*}        end
{*}        else begin    { ошибка при запросе разрешенных модулей }
{*}         outmsg := 'Error';
{*}         cmdtab1.current := -1;
{*}         cmdtab1.bAllow := true;
{*}         bAnswer := 0;
{*}         bAUTO := false;
{*}        end;
{*}       end;                                          
{*}       1: begin {ответ на принятое сообщение @BUK.1  ASCIIval}
{*}       end;
{*}      end;
{*}     end;
{*}    end;
{*}    if( (outmsg <> '') and (bCheckOnline=false) ) then
{*}     if devsend( ref, '@' + devname + ' ' + outmsg + CrLf ) > 0 then begin end;
{*}    outmsg := '';
{*}   end;

{*}   if ( (cmdtab1.current = -1) and (inmsg <> '') ) then begin
{*}    outmsg := 'Error';
{*}    cmdtab1.current := -1;
{*}    cmdtab1.bAllow := true;
{*}    bAnswer := 0;
{*}    bAUTO := false;
{*}    if( bCheckOnline=false ) then
{*}    if devsend( ref, '@' + devname + ' ' + outmsg + CrLf ) > 0 then begin end;
{*}    outmsg := '';
{*}   end;

{*}   {******************************************************************************}


{*}   {*********************************************SLOT***********************************************}
{*}   { RS-485 }
{*}   Status:=Adam_Status;
{*}   if (Status<rs_NotAvail) or (Status>rs_TimeOut) then begin
{*}    b:=FixError(errorcode);
{*}    if Debug then writeln('Invalid status value!');
{*}   end else begin
{*}    s := sToSlot;
{*}    sToSlot := '';
{*}    {if s <> '' then b := echo( 'Server talk: ' + s );}

{*}    if s <> '' then begin
{*}     { @BUK.1.DRV READADC }
{*}     if  extractword( 1, s ) = 'ADC' then begin
{*}      cmdtab2.enabled[cADC]:=true;
{*}      cmdtab2.current:=cADC;
{*}     end
{*}     else if  extractword( 1, s ) = 'MODE' then begin
{*}      cmdtab2.enabled[cMODE]:=true;
{*}      cmdtab2.current:=cMODE;
{*}     end
{*}     else if  extractword( 1, s ) = 'ENDAUTO' then begin
{*}      cmdtab2.enabled[cENDAUTO]:=true;
{*}      cmdtab2.current:=cENDAUTO;
{*}     end
{*}     else if( (cmdtab1.cmdID[cmdtab1.current]>-1) and
{*}              (cmdtab1.cmdID[cmdtab1.current]<=STOP) ) then begin
{*}      if cmdtab1.cmdID[cmdtab1.current] = AUTO then begin
{*}       cmdtab2.enabled[cSET]:=true;
{*}       cmdtab2.enabled[cSET_ACK]:=true;
{*}       cmdtab2.current:=cSET;
{*}       bSet := true;
{*}      end
{*}      else begin
{*}       cmdtab2.enabled[cSET]:=true;
{*}       cmdtab2.enabled[cSET_ACK]:=true;
{*}       cmdtab2.current:=cSET;
{*}       bSet := true;
{*}      end;
{*}     end;
{*}    end;
{*}    case Status of
{*}     rs_NotAvail   : OnNotAvail;
{*}     rs_NoRequest  : OnNoRequest;
{*}     rs_WaitQueue  : OnWaitQueue;
{*}     rs_WaitAnswer : OnWaitAnswer;
{*}     rs_Answer     : OnAnswer;
{*}     rs_TimeOut    : OnTimeOut;
{*}    end;
{*}   end;

{*}   {********************************DRIVER***********************************************}
{*}   if cmdtab1.current > ( -1 ) then begin
{*}    cmdtab1.bAllow := false;
{*}    wordsmsg := wordcount( inmsg );
{*}    case cmdtab1.cmdID[cmdtab1.current] of
{*}     befCH1_GR1on,
{*}     CH1on_GR1on_befLANCH,
{*}     befCH2_GR1on,
{*}     CH2on_GR1on_befLANCH,
{*}     befGR2_GR1on,
{*}     befCH1_GR2on,
{*}     CH1on_GR2on_befLANCH,
{*}     befCH2_GR2on,
{*}     CH2on_GR2on_befLANCH,
{*}     pastCH2_GR2on,
{*}     GR2off,
{*}     contGR1CH1,
{*}     contGR1CH2,
{*}     contGR2CH1,
{*}     contGR2CH2,
{*}     contGRCHoff,
{*}     LAUNCH_on,
{*}     LAUNCH_off,
{*}     AUTO,
{*}     STOP,
{*}     ADC,
{*}     MODE,
{*}     ENDAUTO : begin
{*}      case bAnswer of
{*}       0: begin {прием сообщения}
{*}       end;                                          
{*}       1: begin {ответ на принятое сообщение @BUK.1  ASCIIval}
{*}        if answmsg <> '' then begin
{*}         s := '';
{*}         s := extractword( 1, answmsg );
{*}         outmsg := s;
{*}         if cmdtab1.cmdID[cmdtab1.current]=MODE then begin
{*}          if s='0' then b:=isettag(tagONLINE, 1)
{*}          else if s='1' then b:=isettag(tagONLINE, 2)
{*}          else if s='2' then b:=isettag(tagONLINE, 3)
{*}          else if s='4' then b:=isettag(tagONLINE, 4);
{*}         end;
{*}         cmdtab1.current := -1;
{*}         cmdtab1.bAllow := true;
{*}         bAnswer := 0;
{*}        end;
{*}       end;
{*}      end;
{*}     end;
{*}    end;
{*}    if ( ( bAnswer = 1 ) and ( bTimeout ) ) then begin
{*}     bTimeout := false;
{*}     outmsg := 'Timeout';
{*}     cmdtab1.current := -1;
{*}     cmdtab1.bAllow := true;
{*}     bAnswer := 0;
{*}     bAUTO := false;
{*}    end;
{*}    if( (outmsg <> '') and (bCheckOnline=false) ) then
{*}     if devsend( ref, '@' + devname + ' ' + outmsg + CrLf ) > 0 then begin end;
{*}    outmsg := '';
{*}   end;


  end;

 end;
end.
