 {
 ***********************************************************************
 Daq Pascal application program Template.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2  - Evaluate 2 expressions, just for demo.
|********************************************************
[]
 }
program PIK_CTRL;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 nameDRV           : String;     { driver device name     }
 devDRV            : Integer;    { reference           }

 tagChkMode        : integer;
 tagMsg            : integer;
 tagOnline         : integer;

 enbPikDRV         : boolean;
 answPikDRV        : String;     { ответ     }
 ChkStep           : integer;
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var b:Boolean; nv:Integer;
 begin
  if ClickTag=tag then begin
   b:=iSetTag(tag,iXor(iGetTag(tag),XorMask));
   b:=Voice(snd_Click);
  end;
 end;
 {
 }
 function PikSend(devPikDRV:integer; s: string): boolean;
 begin
  PikSend:=DevSend(devPikDRV,s)>0;
  enbPikDRV:=false;
 end;
 {
  Проверка
 }
 procedure RunChkMode;
  procedure IncStep(var i: integer);
  begin i:=i+1; end;

 begin
  case CHKStep of
  0:  if enbPikDRV then begin
       speak('Режим '); 
       enbPikDRV:=false;
       answPikDRV:='';
       bnul(PikSend(devDRV,'@MODE'+CRLF));
       bnul(iSetTag(tagOnline,0));
       IncStep(CHKStep);
      end;
  1:  if answPikDRV<>'' then begin
       if answPikDRV='Timeout' then begin
        bnul(sSetTag(tagMsg,'Timeout'));
        speak('Таймаут');
       end else
       if answPikDRV='0' then begin
        bnul(sSetTag(tagMsg,'Автономный'));
        speak('Автономный');
       end else
       if answPikDRV='1' then begin
        bnul(sSetTag(tagMsg,'Ручной'));
        speak('Ручной');
       end else
       if answPikDRV='2' then begin
        bnul(sSetTag(tagMsg,'Программный'));
        speak('Программный');
        bnul(iSetTag(tagOnline,1));
       end else
       if answPikDRV='3' then begin
        bnul(sSetTag(tagMsg,'Не определен'));
        speak('Не определен');
       end;

       bnul(iSetTag(tagChkMode,0));
       CHKStep:=0;    
      end;
  end;
 end;

 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  nameDRV:='';
  answPikDRV:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  nameDRV:=readini('nameDRV');
  InitDevice(devDRV,   nameDRV, 1);

  InitTag(tagChkMode,   'PIK_CHK_MODE', 1);
  InitTag(tagMSG,       'PIK_MSG', 3);
  InitTag(tagOnline,    'PIK_ONLINE', 0);
  ChkStep:=0;
  enbPikDRV:=true;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if iGetTag(tagChkMode)<>0   then RunChkMode;

  if clickbutton=1 then begin
//   ClickBitXorLocal(tagEnbOnline,1);
   if ClickTag=tagChkMode then begin
    if igettag(ClickTag)=0 then begin
     bnul(iSetTag(ClickTag,1));
     CHKStep:=0;
     enbPikDRV:=true;
     answPikDRV:='';
     bnul(sSetTag(tagMsg,'xxx'));
    end;
    bnul(Voice(snd_Click));
   end;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Demo 123 2*2
   }
   if IsSameText(cmd,'@Demo') then begin
    i:=iEvalDef(ExtractWord(1,arg),0);
    r:=rEvalDef(ExtractWord(2,arg),_NaN);
    Success(cmd+'='+Str(i)+_Comma+Str(r));
    Data:='';
   end else
   {
   Example: @PIK.DRV Y
   }
   if IsSameText(cmd,'@&PIK.DRV') then begin
    enbPikDRV:=true;
    answPikDRV:=arg;
    bnul(echo(cmd+'='+answPikDRV));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
