 {
 ***********************************************************************
 P20 - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuCloseConfirmation - for internal use.
| @IncTag x t a b        - inc tag t + x, in (a,b) range.
| @DecTag x t a b        - dec tag t - x, in (a,b) range.
| @Cmd.LoadIni           - load params from INI.
| @Cmd.SaveIni           - save params to   INI.
| @Cmd.SaveCrw           - save exposition data to CRW.
| @AssignTag t v         - assign value v to tag t.
| @Zero t c              - zero correction (tag t, curve c)
|********************************************************
[]
 }
program p20_main_ctrl;           { P20 - main control program       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 AwakePeriod       = 100;        { Period of checks to awake DatSrv }
 DrumPeriod        = 200;        { Period to update drum & resttime }
 BlockPeriod       = 100;        { Blocking check period            }
 OnlinePeriod      = 100;        { Period of ONLINE check           }
 OnlineTimeout     = 2000;       { Timeout for ONLINE check         }
 DatSrvBufLeng     = 50000;      { Buffer length to queue data      }
 DatSrvStdPeriod   = 300;        { Standard DatSrv period           }
 ExpoNumPtsLimit   = 100000;     { Exposition num.points limit      }
 MaxUHs            = 10;         { Max. number of UniHeat heaters   }
 NumUHs            = 2;          { Number of UniHeat heaters        }
 NumVEs            = 5;          { Number of VE valves              }
 NumVNs            = 1;          { Number of VN pumps               }
 NumPIKs           = 1;          { Number of PIK                    }          
 NumADCs           = 3;          { Number of E140 cards             }
 NumDACs           = 23;         { Number of DAC's for balance      }
 NumAdcChans       = 16;         { Number of ADC channels in use    }
 MinDacValue       = 0;          { Minimal DAC value                }
 MaxDacValue       = +10000;     { Maximal DAC value                }
 MinAdcFreq        = 1;          { Minimal ADC frequency, Hz        }
 MaxAdcFreq        = 1000;       { Maximal ADC frequency, Hz        }
 MinAdcTime        = 0;          { Minimal ADC duration, sec        }
 MaxAdcTime        = 999;        { Maximal ADC duration, sec        }
 MaxMapTab         = 256;        { Maximal size of map table        }
 NumEvals          = 10;         { Number of fast evaluators        }
 PikDrvTimeOut     = 5000;       { Timeout for PIK driver I/O, ms   }
 doADC1Online      = 6;          { DigitalOutput of ADC1 ONLINE     }

type
 TTagRef   = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TValveRec = record BTN,TYP,CHK,BLK,WDT:TTagRef; WDTms:Real; end;
 TEvalRec  = record BTN,EXPR,ENAB:TTagRef; end;
 TPIKRec   = record ONLINE:TTagRef; end;
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 P20               : record      { All P20 data                     }
  VE               : array[1..NumVEs]   of TValveRec; { Valves      }
  VN               : array[1..NumVNs]   of TValveRec; { Pumps       }
  CMD              : record      { CoMmandDs to control GUI         }
   HELP            : TTagRef;    { Open Help                        }
   HOME            : TTagRef;    { Exec Home                        }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   LOADINI         : TTagRef;    { Load INI file                    }
   SAVEINI         : TTagRef;    { Save INI file                    }
   TOOLS           : TTagRef;    { Tools menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
  end;                           {                                  }
  Ready            : Integer;    { READY state                      }
  ADC              : record      { E140 ADC data                    }
   START           : TTagRef;    { Start button                     }
   ONLINE          : array[1..NumADCs] of TTagRef; { Online states  }
   Starts          : array[1..NumADCs] of TTagRef; { Start buttons  }
   WdtXn,WdtTm     : array[1..NumADCs] of Real;    { Watchdog timer }
   FREQ            : TTagRef;    { Frequency per channel, Hz        }
   KHZ             : array[1..NumADCs] of TTagRef; { ADC freq, kHz  }
   FIR             : array[1..NumADCs] of array [1..NumAdcChans] of TTagRef;
  end;                           {                                  }
  SLOW             : record      { Slow measurements control        }
   FREQ            : TTagRef;    { Frequency, in slow mode, Hz      }
  end;                           {                                  }
  FAST             : record      { Fast measurements control        }
   EXPO            : TTagRef;    { Exposition number                }
   DRUM            : TTagRef;    { Drum indicator                   }
   CLEAR           : TTagRef;    { Clear button                     }
   EGATE           : TTagRef;    { Exposition gate                  }
   ETIME           : TTagRef;    { Exposition start time            }
   TFACT           : TTagRef;    { Exposition time factor           }
   TREST           : TTagRef;    { Time rest of exposition          }
   FEXPR           : TTagRef;    { Exposition frequency expression  }
   DURAT           : TTagRef;    { Exposition duration, sec         }
   AUTOSAVE        : TTagRef;    { Auto save after exposition       }
   EVAL            : array[1..NumEvals] of TEvalRec; { Evaluators   }
  end;                           {                                  }
  FIRE11           : TEvalRec;   { Fire1.1 expression               }
  FIRE12           : TEvalRec;   { Fire1.2 expression               }
  FIRE21           : TEvalRec;   { Fire2.1 expression               }
  FIRE22           : TEvalRec;   { Fire2.2 expression               }
  VE1              : TEvalRec;   { VE1 expression                   }
  VE2              : TEvalRec;   { VE2 expression                   }
  VE3              : TEvalRec;   { VE3 expression                   }
  VE4              : TEvalRec;   { VE4 expression                   }
  VE5              : TEvalRec;   { VE5 expression                   }
  VN1              : TEvalRec;   { VN1 expression                   }
  CRWSVR           : record      { CRWSVR tags                      }
   SAVE            : TTagRef;    { Save button                      }
   BUGS            : TTagRef;    { Error counter                    }
   WCAP            : TTagRef;    { Window caption                   }
   WTIT            : TTagRef;    { Window title                     }
   WLAB            : TTagRef;    { Window lable                     }
   FNAM            : TTagRef;    { Last saved File Name             }
  end;                           {                                  }
  DAC              : array[1..NumDACs] of TTagRef;  { Balance DAC's }
  AwokeTime        : Real;       { Time when DatSrv last awoke      }
  AwakePeriod      : Real;       { Period to awake DatSrv           }
  DatSrvGate       : TTagRef;    { Save data to DatSrv              }
  devGateEx        : Integer;    { &P20.GATE.EX reference           }
  LastEditTag      : Integer;    { Last edited tag                  }
 end;                            {                                  }
 PIK               : record      { PIK related data                 }
  Drv              : record      { PIK driver data                  }
   dev             : Integer;    { PIK device reference             }
   ans             : String;     { Driver last answer               }
   tim             : Real;       { Time of last send, ms            }
  end;                           {                                  }
  Step             : record      { Step of process                  }
   Fire            : Integer;    { Step of Fire                     }
   GR1CH1          : Integer;    {         GR 1 channel 1           }
   GR1CH2          : Integer;    {         GR 1 channel 2           }
   GR2CH1          : Integer;    {         GR 2 channel 1           }
   GR2CH2          : Integer;    {         GR 2 channel 2           }
  end;                           {                                  }
 end;                            {                                  }
 MapTab            : record      { Mapping table                    }
  devMapper        : Integer;    { Mapper device reference          }
  Count            : Integer;    { Number of items                  }
  ai,ao            : array[0..MaxMapTab] of record { Analog in/out  }
   Curve           : Integer;    { Ai,Ao curves                     }
   Gain            : TTagRef;    { Ai,Ao gains                      }
  end;                           {                                  }
 end;                            {                                  }
 UH_EBLK           : array[1..MaxUHs] of TTagRef;   { Ext. blocking }
 UH_HENABL         : array[1..MaxUHs] of TTagRef;   { Heater enable }
 UH_SOUNDX         : TTagRef;    { Enable sound                     }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Increment integer
 }
 procedure Inc(var i: integer);
 begin
  i:=i+1;
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Calculate time since tag switch on
 }
 procedure CalcWdtTime(var wdt:Real);
 begin
  if wdt<=0 then wdt:=msecnow;
 end;
 {
 Calculate time since tag switch on
 }
 function GetWdtTime(wdt:Real):Real;
 begin
  if wdt>0 then GetWdtTime:=msecnow-wdt else GetWdtTime:=0;
 end;
 {
 Check if bit modified
 }
 function ModifiedBit(val1,val2:Real; mask:Integer):Integer;
 begin
  ModifiedBit:=Ord( iAnd(Trunc(val1),mask)<>iAnd(Trunc(val2),mask) );
 end;
 {
 Initialize valve tags.
 }
 procedure Valve_InitTag(var Valve:TValveRec;Prefix:String);
 begin
  InitTag(Valve.BTN.tag, Prefix+'.BTN', 1);
  InitTag(Valve.TYP.tag, Prefix+'.TYP', 1);
  InitTag(Valve.CHK.tag, Prefix+'.CHK', 1);
  InitTag(Valve.BLK.tag, Prefix+'.BLK', 1);
  InitTag(Valve.WDT.tag, Prefix+'.WDT', 1);
 end;
 {
 Initialize valve values.
 }
 procedure Valve_InitVal(var Valve:TValveRec);
 begin
  Valve.BTN.val:=iAnd(iNot(iGetTag(Valve.BTN.tag)),1);
  Valve.WDTms:=0;
 end;
 {
 Readout/control/update valves.
 }
 procedure Valve_Ctrl(var Valve:TValveRec; ndi,ndo,dim:Integer);
 var diw,dow,btn,typ,chk,blk,wdt:Integer;
 begin
  {
  Readout Digital Input Word  diw: bit0:opened, bit1:closed
  Readout sensor button state btn: bit0:ON
  Readout valve control type 0:Level, 1:Level with dead time, 2:Pulse
  Readout check flag chk: 0:no sensor, 1:open sensor, 2:open+close sensors
  Readout block flag blk: 0:no blocks, 1:disabled, 2:disabled+OFF, 3:disabled+ON
  Readout watchdog timer, ms
  }
  diw:=Trunc(DiWord(ndi,2));
  btn:=iAnd(iGetTag(Valve.BTN.tag),1);
  typ:=iGetTag(Valve.TYP.tag);
  chk:=iGetTag(Valve.CHK.tag);
  blk:=iGetTag(Valve.BLK.tag);
  wdt:=iGetTag(Valve.WDT.tag);
  {
  Apply blocking:
  BLK=0 : no blocking, work normal
  BLK=1 : disable sensor clicks
  BLK=2 : disable and force OFF
  BLK=3 : disable and force ON
  Note that blocking working only when watchdog is turned off.
  }
  if Valve.WDTms=0 then begin
   if blk=2 then btn:=0;
   if blk=3 then btn:=1;
  end;
  {
  Apply check state:
  CHK=2 : bit0:ON, bit1:opened, bit2:closed        2  sensors  (opened,closed)
  CHK=1 : bit0:ON, bit1:opened, bit2:not(opened)   1  sensor   (opened)
  CHK=0 : bit0:ON, bit1:ON,     bit2:not(ON)       no sensors, simulation
  }
  if chk=0 then btn:=iAnd(btn,1)+2*iAnd(btn,1)+4*iAnd(iNot(btn),1);
  if chk=1 then btn:=iAnd(btn,1)+2*iAnd(diw,1)+4*iAnd(iNot(diw),1);
  if chk=2 then btn:=iAnd(btn,1)+2*iAnd(diw,3);
  btn:=btn+8*Ord(blk>0);
  {
  If ON/OFF bit changed, start WDT timer
  }
  if ModifiedBit(Valve.BTN.val,btn,1)>0
  then CalcWdtTime(Valve.WDTms);
  Valve.BTN.val:=btn;
  {
  If WDT timer timeout finished, stop WDT timer.
  }
  if Valve.WDTms>0 then
  if GetWdtTime(Valve.WDTms)>wdt
  then Valve.WDTms:=0;
  {
  Find Digital Output Word:
  TYP=0 : bit0:ON, bit1:opened, bit2:closed, bit3:blocked, bit4:ON, bit5:not(ON)
  TYP=1 : bit0:ON, bit1:opened, bit2:closed, bit3:blocked, bit4:opening, bit5:closing with dead time
  TYP=2 : bit0:ON, bit1:opened, bit2:closed, bit3:blocked, bit4:opening, bit5:closing pulse
  }
  dow:=btn+16*iAnd(btn,1)+32*iAnd(iNot(btn),1);
  if typ=1 then dow:=btn+Ord(Valve.WDTms=0)*(16*iAnd(btn,1)+32*iAnd(iNot(btn),1));
  if typ=2 then dow:=btn+Ord(Valve.WDTms>0)*(16*iAnd(btn,1)+32*iAnd(iNot(btn),1));
  {
  Write result control values
  }
  bNul(iSetTag(Valve.BTN.tag,btn));
  UpdateDo(ndo,time,dow);
 end;
 {
 Get text of Close menu items
 }
 function MenuCloseItem(MenuClose:Integer):String;
 begin
  if MenuClose=0 then MenuCloseItem:='Завершить пакет CRW-DAQ' else
  if MenuClose=1 then MenuCloseItem:='Завершить     сеанс DAQ' else
  if MenuClose=2 then MenuCloseItem:='Перезагрузить сеанс DAQ' else
  if MenuClose=3 then MenuCloseItem:='Рестарт сервера '+DatSrv else
  if MenuClose=4 then MenuCloseItem:='Рестарт сервера '+CronSrv else
  if MenuClose=5 then MenuCloseItem:='Завершить сеанс Windows' else
  if MenuClose=6 then MenuCloseItem:='Перезагрузить компьютер' else
  if MenuClose=7 then MenuCloseItem:='Выключить     компьютер' else
  MenuCloseItem:='';
 end;
 {
 Execute Close menu commands
 }
 procedure MenuCloseCmnd(MenuClose:Integer);
 begin
  if MenuClose=0  then Cron('@Shutdown Crw Exit');
  if MenuClose=1  then Cron('@Shutdown Daq Exit');
  if MenuClose=2  then Cron('@Shutdown Daq Restart');
  if MenuClose=3  then Cron('@Eval @System @Async @Daq Compile '+DatSrv);
  if MenuClose=4  then Cron('@Eval @System @Async @Daq Compile '+CronSrv);
  if MenuClose=5  then Cron('@Shutdown Win Logout');
  if MenuClose=6  then Cron('@Shutdown Win Restart');
  if MenuClose=7  then Cron('@Shutdown Win Exit');
 end;
 {
 Enumerate all devices n=0..NumDev-1
 }
 function EnumDeviceList(n:Integer):Integer;
 begin
  if not IsEmptyStr(ParamStr('DeviceName '+Str(n)))
  then EnumDeviceList:=RefFind('Device '+ParamStr('DeviceName '+Str(n)))
  else EnumDeviceList:=0;
 end;
 {
 Open calibration by curve.
 }
 procedure OpenCalibrByCurve(crv:Integer);
 var n,nc,t,i,j,dev,cao,nao:Integer;
 begin
  if not IsEmptyStr(CrvName(crv)) then begin
   n:=0;
   repeat
    dev:=EnumDeviceList(n);
    if IsSameText(ParamStr('DeviceModel '+Str(n)),'Program') then
    if IsSameText(ParamStr('DeviceFamily '+Str(n)),'Software') then
    if dev<>0 then begin
     nc:=iValDef(ReadIni(StrAddBrackets(RefInfo(dev,'Name'),'[',']')+' Calibrations'),0);
     if nc>0 then begin
      t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(RefInfo(dev,'Name'),'[',']'));
      for i:=0 to Text_NumLn(t)-1 do
      if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'Link') then begin
       cao:=0; nao:=-1;
       for j:=2 to WordCount(Text_GetLn(t,i)) do begin
        if IsSameText(ExtractWord(j,Text_GetLn(t,i)),'Curve') then
        if IsSameText(ExtractWord(j+1,Text_GetLn(t,i)),CrvName(crv)) then cao:=crv;
        if IsSameText(ExtractWord(j,Text_GetLn(t,i)),'AnalogOutput')
        then nao:=iValDef(ExtractWord(j+1,Text_GetLn(t,i)),-1);
       end;
       if cao=crv then if nao>=0 then begin
        Cron('@Eval @System @Async @Open DAQ:\DeviceList\'
            +RefInfo(dev,'Name')+'\Calibration#'+Str(nao));
        dev:=0;
       end;
      end;
      bNul(Text_Free(t));
     end;
    end;
    n:=n+1;
   until IsEmptyStr(RefInfo(dev,'Name'));
   bNul(Echo(CrvName(crv)));
  end;
 end;
 {
 Initialize mapping table by device dev.
 }
 procedure MAP_CLEAR;
 var i:Integer;
 begin
  MapTab.Count:=0;
  MapTab.devMapper:=0;
  for i:=0 to MaxMapTab do begin
   MapTab.ai[i].Curve:=0;
   MapTab.ao[i].Curve:=0;
   MapTab.ai[i].Gain.tag:=0;
   MapTab.ao[i].Gain.tag:=0;
  end;
 end;
 {
 Initialize mapping table by device dev.
 }
 procedure MAP_INIT;
 var i,j,sec,nao,nai,crv:Integer;
 begin
  MAP_CLEAR;
  InitDevice(MapTab.devMapper,ReadIni('devMapper'),1);
  if IsSameText(RefInfo(MapTab.devMapper,'Type'),'Device') then begin
   sec:=ReadIniSection(Text_New,16+8+4+1,'',StrAddBrackets(RefInfo(MapTab.devMapper,'Name'),'[',']'));
   for i:=0 to Text_NumLn(sec)-1 do
   if IsSameText(ExtractWord(1,Text_GetLn(sec,i)),'Link') then begin
    nao:=-1; nai:=-1; crv:=0;
    for j:=2 to WordCount(Text_GetLn(sec,i)) do begin
     if IsSameText(ExtractWord(j,Text_GetLn(sec,i)),'AnalogInput')
     then nai:=iValDef(ExtractWord(j+1,Text_GetLn(sec,i)),-1);
     if IsSameText(ExtractWord(j,Text_GetLn(sec,i)),'AnalogOutput')
     then nao:=iValDef(ExtractWord(j+1,Text_GetLn(sec,i)),-1);
     if IsSameText(ExtractWord(j,Text_GetLn(sec,i)),'Curve')
     then crv:=RefFind('Curve '+ExtractWord(j+1,Text_GetLn(sec,i)));
    end;
    if (nao>=0) and (nao<=MaxMapTab) then begin
     if nao>=MapTab.Count then MapTab.Count:=nao+1;
     MapTab.ao[nao].Curve:=crv;
     InitTag(MapTab.ao[nao].Gain.tag,ForceExtension(CrvName(crv),'.GAIN'),-1);
    end;
    if (nai>=0) and (nai<=MaxMapTab) then begin
     if nai>=MapTab.Count then MapTab.Count:=nai+1;
     MapTab.ai[nai].Curve:=crv;
     InitTag(MapTab.ai[nai].Gain.tag,StrReplace(CrvName(crv),'.AO.','.GAIN.',3),-1);
    end;
   end;
   bNul(Text_Free(sec));
  end;
  if MapTab.Count>0 then begin
   Success(RefInfo(MapTab.devMapper,'Name')+' mappping['+Str(MapTab.Count)+']:');
   for i:=0 to MapTab.Count-1 do
   if (MapTab.ai[i].Curve<>0) or (MapTab.ao[i].Curve<>0) then
   Success(' '+CrvName(MapTab.ai[i].Curve)+' -> '+CrvName(MapTab.ao[i].Curve));
   for i:=0 to MapTab.Count-1 do
   if (TypeTag(MapTab.ai[i].Gain.tag)>0) or (TypeTag(MapTab.ao[i].Gain.tag)>0) then
   Success(' '+NameTag(MapTab.ai[i].Gain.tag)+' -> '+NameTag(MapTab.ao[i].Gain.tag));
  end;
 end;
 {
 Map table finalization
 }
 procedure MAP_FREE;
 begin
 end;
 {
 Poll map table
 }
 procedure MAP_POLL;
 var i:Integer;
  function AdcStarted:Integer;
  var i,n:Integer;
  begin
   n:=0;
   for i:=1 to NumADCs do n:=n+Ord(iGetTag(P20.ADC.Starts[i].tag)<>0);
   AdcStarted:=n;
  end;
 begin
  {
  Update gain tags
  }
  if SysTimer_Pulse(100)>0 then begin
   for i:=0 to MapTab.Count-1 do
   if TypeTag(MapTab.ai[i].Gain.tag)=1 then
   if TypeTag(MapTab.ao[i].Gain.tag)=1 then
   bNul(iSetTag(MapTab.ao[i].Gain.tag,iGetTag(MapTab.ai[i].Gain.tag)));
  end;
  {
  Handle sensor clicks
  }
  if ClickButton=1 then begin
   for i:=0 to MapTab.Count-1 do
   if TypeTag(MapTab.ai[i].Gain.tag)=1 then
   if TypeTag(MapTab.ao[i].Gain.tag)=1 then
   if ClickTag=MapTab.ao[i].Gain.tag then begin
    if AdcStarted>0 then bNul(Voice(snd_Fails)) else begin
     if EditState=0 then begin
      if Pos('?',Edit('(Выбор диапазона ADC... ')
                +Edit(' Диапазон ADC канала '+ExtractFileName(NameTag(MapTab.ao[i].Gain.tag))+':')
                +Edit(' Gain 0 : 10   V')
                +Edit(' Gain 1 : 2.5  V')
                +Edit(' Gain 2 : 625 mV')
                +Edit(' Gain 3 : 156 mV')
                +Edit(')MenuList MENU_'+NameTag(MapTab.ai[i].Gain.tag)+' '+Str(iGetTag(MapTab.ai[i].Gain.tag))))>0
      then Warning('Error initializing MenuList!');
     end else Warning('Cannot edit right now!');
     bNul(Voice(snd_Click));
    end;
   end;
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   for i:=0 to MapTab.Count-1 do
   if TypeTag(MapTab.ai[i].Gain.tag)=1 then
   if TypeTag(MapTab.ao[i].Gain.tag)=1 then begin
    if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(MapTab.ai[i].Gain.tag)) then begin
     if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
      MapTab.ai[i].Gain.val:=Val(Edit('?ans 1'));
      if MapTab.ai[i].Gain.val>=0 then
      if MapTab.ai[i].Gain.val<=3 then
      bNul(iSetTag(MapTab.ai[i].Gain.tag,Round(MapTab.ai[i].Gain.val)));
     end;
     sNul(Edit(''));
    end;
   end;
  end;
 end;
 {
 Update ADC frequency
 }
 procedure UpdateAdcFreq(Hz:Real);
 var i,j,fir:Integer; kHz:Real;
 begin
  for i:=1 to NumADCs do begin
   kHz:=iGetTag(P20.ADC.KHZ[i].tag);
   fir:=Round(Max(1,kHz*1e3/NumADCChans/Hz));
   for j:=1 to NumAdcChans do
   bNul(iSetTag(P20.ADC.FIR[i,j].tag,fir));
  end;
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  P20.AwokeTime:=mSecNow;
  DevSendCmd(devDatSrv,'  ');
 end;
 {
 Initiate data save to CRW after delay via CRON.
 }
 procedure PendingSaveCrw(msdelay:Integer);
 begin
  Cron('@cron.tab '+DevName+'@Cmd.SaveCrw 0 0 0'+CRLF+
       '@cron.job '+DevName+'@Cmd.SaveCrw @DevSend '+DevName+' @Cmd.SaveCrw'+CRLF+
       '@cron.pul '+DevName+'@Cmd.SaveCrw '+Str(msdelay)+' 1'+CRLF);
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then begin
   if iGetTag(UH_SOUNDX.tag)<>0  then Speak(s) else
   InfoBox(s);
  end;
 end;
 {
 Evaluate simple hash sum of string Buffer.
 Calculate MODBUS/RTU CRC checksum.
 }
 function EvalHash(Buffer:String):Integer;
 const hFFFF=65535; hA001=40961;
 var data,i,j:Integer;
 begin
  data:=hFFFF;
  for i:=1 to Length(Buffer) do begin
   data:=iXor(data,Ord(Buffer[i]));
   for j:=1 to 8 do if Odd(data)
   then data:=iXor(data div 2,hA001)
   else data:=data div 2;
  end;
  EvalHash:=data;
 end;
 {
 Evaluate frequency at time t sec since exposition start by given expression.
 }
 function EvalFreq(t:Real; expr:String):Real;
 var Freq:Real;
 begin
  Freq:=rGetTag(P20.SLOW.FREQ.tag);
  if t>=0 then if t<=rGetTag(P20.FAST.DURAT.tag) then
  if evar('t',t) then Freq:=eval(expr) else Freq:=_Nan;
  if IsNan(Freq) or IsInf(Freq) then Freq:=rGetTag(P20.SLOW.FREQ.tag);
  EvalFreq:=Max(MinAdcFreq,Min(MaxAdcFreq,Freq));
 end;
 {
 Evaluate tag by expression.
 }
 procedure EvalTag(tag:Integer; expr:String);
 var r:Real;
 begin
  if TypeTag(tag)>0 then begin
   r:=eval(expr);
   if IsNan(r) or IsInf(r) then Trouble(NameTag(tag)+' eval bug: '+expr) else
   if TypeTag(tag)=1 then bNul(iSetTag(tag,Trunc(r))) else
   if TypeTag(tag)=2 then bNul(rSetTag(tag,r)) else
   if TypeTag(tag)=3 then bNul(sSetTag(tag,Str(r)));
  end; 
 end;
 {
 Evaluate button tag by expression.
 }
 procedure EvalButton(tag:Integer; expr:String);
 var r:Real;
 begin
  if TypeTag(tag)=1 then begin
   r:=eval(expr);
   if IsNan(r) or IsInf(r) then Trouble(NameTag(tag)+' eval bug: '+expr) else
   bNul(iSetTag(tag,Ord(Round(r)<>0)));
  end; 
 end;
 {
 Evaluate valve state by expression.
 }
 procedure EvalValve(var Valve:TValveRec; expr:String);
 var r:Real; tag:Integer;
 begin
  if Valve.WDTms=0 then
  if iGetTag(Valve.BLK.tag)=0 then begin
   r:=eval(expr);
   tag:=Valve.BTN.tag;
   if TypeTag(tag)=1 then
   if IsNan(r) or IsInf(r) then Trouble(NameTag(tag)+' eval bug: '+expr) else
   bNul(iSetTag(tag,iOr(iAnd(iGetTag(tag),iNot(1)),iAnd(Ord(Round(r)<>0),1))));
  end;
 end;
 {
 Evaluate expected number of points of exposition.
 That is integral of EvalFreq(t,expr) at (0<=t<=duration) range. 
 }
 function EvalNumPoints(duration:Real; expr:String):Real;
 const n=1000; var sum,dt:Real; i:Integer;
 begin
  sum:=0; dt:=duration/n;
  for i:=0 to n-1 do sum:=sum+dt*EvalFreq(dt*i,expr);
  EvalNumPoints:=sum;
 end;
 {
 Check exposition is Ok (by number of points).
 }
 procedure CheckExposition(ExpectedNumPts:Real);
 begin
  if ExpectedNumPts>ExpoNumPtsLimit then
  UnixWBox('Ошибка ввода.','Экспозиция имеет слишком большое число точек ('+Str(Round(ExpectedNumPts))
           +'). Это может взвать потерю данных. Уменьшите частоту или длительность экспозиции.',
           800, 16, 60);  
 end;
 {
 Assign TValveRec a:=b.
 }
 procedure AssignValveRec(var a,b:TValveRec);
 begin
  a:=b;
 end;
 {
 Assign TEvalRec a:=b.
 }
 procedure AssignEvalRec(var a,b:TEvalRec);
 begin
  a:=b;
 end;
 {
 Check if tagBTN belong to valve (VE,VN). Copy this valve to aValve.
 }
 function IsValve(tagBTN:Integer; var aValve:TValveRec):Boolean;
 var i:Integer; flag:Boolean;
 begin
  flag:=False;
  if TypeTag(tagBTN)=1 then begin
   for i:=1 to NumVEs do if not flag then
   if tagBTN=P20.VE[i].BTN.tag then begin
    AssignValveRec(aValve,P20.VE[i]);
    flag:=True;
   end;
   for i:=1 to NumVNs do if not flag then
   if tagBTN=P20.VN[i].BTN.tag then begin
    AssignValveRec(aValve,P20.VN[i]);
    flag:=True;
   end;
  end;
  IsValve:=flag;
 end;
 {
 PIK clear
 }
 procedure PIK_CLEAR;
 begin
  PIK.Drv.tim:=0;
  PIK.Drv.ans:='';
  PIK.Step.Fire:=0;
  PIK.Step.GR1CH1:=0;
  PIK.Step.GR1CH2:=0;
  PIK.Step.GR2CH1:=0;
  PIK.Step.GR2CH2:=0;
 end;
 {
 PIK driver initialization
 }
 procedure PIK_INIT;
 begin
  PIK.Drv.tim:=0;
  PIK.Drv.ans:='';
  InitDevice(PIK.Drv.dev,ReadIni('devPikDrv'),1);
  PIK.Step.Fire:=0;
  PIK.Step.GR1CH1:=0;
  PIK.Step.GR1CH2:=0;
  PIK.Step.GR2CH1:=0;
  PIK.Step.GR2CH2:=0;
 end;
 {
 PIK finalization 
 }
 procedure PIK_FREE;
 begin
 end;
 {
 PIK polling
 }
 procedure PIK_POLL;
 var SecSinceStart:Real; PIK_Code:Integer;
  function CheckStep(var Step:Integer; min,max,def:Integer):Integer;
  begin
   if Step<min then Step:=def;
   if Step>max then Step:=def;
   CheckStep:=Step;
  end;
  procedure PIK_STOP(prn,spk:String);
  begin
   if not IsEmptyStr(prn) then Success(prn);
   if not IsEmptyStr(spk) then Speak(spk);
   PIK_CLEAR;
  end;
  function PIK_Send(cmd,comment:String):Boolean;
  begin
   if PIK.Drv.dev<>0 then begin
    ViewExp(StrFix(SecSinceStart,7,3)+': PIK send '+cmd);
    if not IsEmptyStr(comment) then begin Success(comment); Speak(comment); end;
    DevSendCmd(PIK.Drv.dev,cmd);
    PIK.Drv.tim:=mSecNow;
    PIK.Drv.ans:='';
    PIK_Send:=True;
   end else PIK_Send:=False;
  end;
  function PIK_GotAns(What:String):Integer; // 0:Wait,1:Ok,2:Error;3:Timeout
  begin
   PIK_Code:=0;
   if Length(PIK.Drv.ans)>0 then begin
    ViewImp(StrFix(SecSinceStart,7,3)+': PIK ans '+PIK.Drv.ans);
    if IsSameText(Trim(PIK.Drv.ans),Trim(What)) then PIK_Code:=1 else PIK_Code:=2;
    PIK.Drv.ans:='';
    PIK.Drv.Tim:=0;
   end else begin
    if mSecNow>PIK.Drv.tim+PikDrvTimeOut then begin
     Problem('PIK Timeout');
     PIK_Code:=3;
    end;
   end;
   PIK_GotAns:=PIK_Code;
  end;
  procedure PIK_FAIL;
  begin
   if PIK_Code>1 then PIK_STOP('PIK error','Сбой блока поджига');
  end;
 begin
  if iGetTag(P20.FAST.EGATE.tag)<>0 then begin
   SecSinceStart:=(Time-rGetTag(P20.FAST.ETIME.tag))*TimeUnits/1000;
   {
   Fire steps, GR choice
   }
   case CheckStep(PIK.Step.Fire,0,7,0) of
    0: ;
    1: if PIK_Send('@MODE','') then Inc(PIK.Step.Fire);
    2: if PIK_GotAns(Dump('2'))=1 then Inc(PIK.Step.Fire) else
       if PIK_Code>1 then PIK_STOP('PIK not ready.'+CRLF+'Turn to program mode.','Блок поджига не готов.');
    3: if iGetTag(P20.FAST.EVAL[1].ENAB.tag)<>0 then begin
        PIK.Step.Fire:=0; PIK.Step.GR1CH1:=1;
       end else Inc(PIK.Step.Fire);
    4: if iGetTag(P20.FAST.EVAL[2].ENAB.tag)<>0 then begin
        PIK.Step.Fire:=0; PIK.Step.GR1CH2:=1;
       end else Inc(PIK.Step.Fire);
    5: if iGetTag(P20.FAST.EVAL[3].ENAB.tag)<>0 then begin
        PIK.Step.Fire:=0; PIK.Step.GR2CH1:=1;
       end else Inc(PIK.Step.Fire);
    6: if iGetTag(P20.FAST.EVAL[4].ENAB.tag)<>0 then begin
        PIK.Step.Fire:=0; PIK.Step.GR2CH2:=1;
       end else Inc(PIK.Step.Fire);
    7: PIK_STOP('PIK works without Fire.','');
   end;
   {  
   Fire GR 1 CH 1
   }
   case CheckStep(PIK.Step.GR1CH1,0,12,0) of
    0:  ;
    1:  if PIK_Send('@befCH1_GR1on','') then Inc(PIK.Step.GR1CH1);
    2:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH1) else if PIK_Code>1 then PIK_FAIL;
    3:  if PIK_Send('@CH1on_GR1on_befLANCH','') then Inc(PIK.Step.GR1CH1);
    4:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH1) else if PIK_Code>1 then PIK_FAIL;
    5:  if iGetTag(P20.FAST.EVAL[1].BTN.tag)<>0 then
        if PIK_Send('@LAUNCH_on','Поджиг ГР 1 1') then Inc(PIK.Step.GR1CH1);
    6:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH1) else if PIK_Code>1 then PIK_FAIL;
    7:  if PIK_Send('@LAUNCH_off','') then Inc(PIK.Step.GR1CH1);
    8:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH1) else if PIK_Code>1 then PIK_FAIL;
    9:  if iGetTag(P20.FAST.EVAL[2].ENAB.tag)<>0 then begin
         PIK.Step.GR1CH1:=0; PIK.Step.GR1CH2:=1;
        end else Inc(PIK.Step.GR1CH1);
    10: if iGetTag(P20.FAST.EVAL[3].ENAB.tag)<>0 then begin
         PIK.Step.GR1CH1:=0; PIK.Step.GR2CH1:=1;
        end else Inc(PIK.Step.GR1CH1);
    11: if iGetTag(P20.FAST.EVAL[4].ENAB.tag)<>0 then begin
         PIK.Step.GR1CH1:=0; PIK.Step.GR2CH2:=1;
        end else Inc(PIK.Step.GR1CH1);
    12: PIK_STOP('PIK done.','');
   end;
   {  
   Fire GR 1 CH 2
   }
   case CheckStep(PIK.Step.GR1CH2,0,11,0) of
    0:  ;
    1:  if PIK_Send('@befCH2_GR1on','') then Inc(PIK.Step.GR1CH2);
    2:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH2) else if PIK_Code>1 then PIK_FAIL;
    3:  if PIK_Send('@CH2on_GR1on_befLANCH','') then Inc(PIK.Step.GR1CH2);
    4:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH2) else if PIK_Code>1 then PIK_FAIL;
    5:  if iGetTag(P20.FAST.EVAL[2].BTN.tag)<>0 then
        if PIK_Send('@LAUNCH_on','Поджиг ГР 1 2') then Inc(PIK.Step.GR1CH2);
    6:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH2) else if PIK_Code>1 then PIK_FAIL;
    7:  if iGetTag(P20.FAST.EVAL[2].BTN.tag)=0 then
        if PIK_Send('@LAUNCH_off','') then Inc(PIK.Step.GR1CH2);
    8:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR1CH2) else if PIK_Code>1 then PIK_FAIL;
    9:  if iGetTag(P20.FAST.EVAL[3].ENAB.tag)>0 then begin
         PIK.Step.GR1CH2:=0; PIK.Step.GR2CH1:=1;
        end else Inc(PIK.Step.GR1CH2);
    10: if iGetTag(P20.FAST.EVAL[4].ENAB.tag)>0 then begin
         PIK.Step.GR1CH2:=0; PIK.Step.GR2CH2:=1;
        end else Inc(PIK.Step.GR1CH2);
    11: PIK_STOP('PIK done.','');
   end;
   {  
   Fire GR 2 CH 1
   }
   case CheckStep(PIK.Step.GR2CH1,0,10,0) of
    0:  ;
    1:  if PIK_Send('@befCH1_GR2on','') then Inc(PIK.Step.GR2CH1);
    2:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH1) else if PIK_Code>1 then PIK_FAIL;
    3:  if PIK_Send('@CH1on_GR2on_befLANCH','') then Inc(PIK.Step.GR2CH1);
    4:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH1) else if PIK_Code>1 then PIK_FAIL;
    5:  if iGetTag(P20.FAST.EVAL[3].BTN.tag)<>0 then
        if PIK_Send('@LAUNCH_on','Поджиг ГР 2 1') then Inc(PIK.Step.GR2CH1);
    6:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH1) else if PIK_Code>1 then PIK_FAIL;
    7:  if iGetTag(P20.FAST.EVAL[3].BTN.tag)=0 then
        if PIK_Send('@LAUNCH_off','') then Inc(PIK.Step.GR2CH1);
    8:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH1) else if PIK_Code>1 then PIK_FAIL;
    9:  if iGetTag(P20.FAST.EVAL[4].ENAB.tag)<>0 then begin
         PIK.Step.GR2CH1:=0; PIK.Step.GR2CH2:=1;
        end else Inc(PIK.Step.GR2CH1);
    10: PIK_STOP('PIK done','');
   end;
   {  
   Fire GR 2 CH 2
   }
   case CheckStep(PIK.Step.GR2CH2,0,9,0) of
    0:  ;
    1:  if PIK_Send('@befCH2_GR2on','') then Inc(PIK.Step.GR2CH2);
    2:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH2) else if PIK_Code>1 then PIK_FAIL;
    3:  if PIK_Send('@CH2on_GR2on_befLANCH','') then Inc(PIK.Step.GR2CH2);
    4:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH2) else if PIK_Code>1 then PIK_FAIL;
    5:  if iGetTag(P20.FAST.EVAL[4].BTN.tag)<>0 then
        if PIK_Send('@LAUNCH_on','Поджиг ГР 2 2') then Inc(PIK.Step.GR2CH2);
    6:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH2) else if PIK_Code>1 then PIK_FAIL;
    7:  if iGetTag(P20.FAST.EVAL[4].BTN.tag)=0 then
        if PIK_Send('@LAUNCH_off','') then Inc(PIK.Step.GR2CH2);
    8:  if PIK_GotAns(Dump('Y'))=1 then Inc(PIK.Step.GR2CH2) else if PIK_Code>1 then PIK_FAIL;
    9:  PIK_STOP('PIK done.','');
   end;
  end;
 end;
 {
 P20 clear strings
 }
 procedure P20_CLEAR;
 begin
 end;
 {
 P20 initialization
 }
 procedure P20_INIT;
 var i,j:Integer;
 begin  
  {
  Initialize tags & devices...
  }
  InitDevice(P20.devGateEx,     ReadIni('devGateEx'),               1);
  InitTag(P20.DatSrvGate.tag,   'DATSRV.GATE',                      1);
  InitTag(P20.CMD.HELP.tag,     ReadIni('tagP20')+'.CMD.HELP',      1);
  InitTag(P20.CMD.HOME.tag,     ReadIni('tagP20')+'.CMD.HOME',      1);
  InitTag(P20.CMD.OPEN.tag,     ReadIni('tagP20')+'.CMD.OPEN',      1);
  InitTag(P20.CMD.SAVE.tag,     ReadIni('tagP20')+'.CMD.SAVE',      1);
  InitTag(P20.CMD.LOADINI.tag,  ReadIni('tagP20')+'.CMD.LOADINI',   1);
  InitTag(P20.CMD.SAVEINI.tag,  ReadIni('tagP20')+'.CMD.SAVEINI',   1);
  InitTag(P20.CMD.TOOLS.tag,    ReadIni('tagP20')+'.CMD.TOOLS',     1);
  InitTag(P20.CMD.SMILE.tag,    ReadIni('tagP20')+'.CMD.SMILE',     1);
  InitTag(P20.CMD.CLOSE.tag,    ReadIni('tagP20')+'.CMD.CLOSE',     1);
  InitTag(P20.ADC.START.tag,    ReadIni('tagP20')+'.ADC.START',     1);
  InitTag(P20.FAST.CLEAR.tag,   ReadIni('tagP20')+'.FAST.CLEAR',    1);
  InitTag(P20.FAST.EXPO.tag,    ReadIni('tagP20')+'.FAST.EXPO',     1);
  InitTag(P20.FAST.DRUM.tag,    ReadIni('tagP20')+'.FAST.DRUM',     1);
  InitTag(P20.FAST.TREST.tag,   ReadIni('tagP20')+'.FAST.TREST',    2);
  InitTag(P20.FAST.EGATE.tag,   ReadIni('tagP20')+'.FAST.EGATE',    1);
  InitTag(P20.FAST.ETIME.tag,   ReadIni('tagP20')+'.FAST.ETIME',    2);
  InitTag(P20.FAST.TFACT.tag,   ReadIni('tagP20')+'.FAST.TFACT',    2);
  InitTag(P20.ADC.FREQ.tag,     ReadIni('tagP20')+'.ADC.FREQ',      2);
  InitTag(P20.SLOW.FREQ.tag,    ReadIni('tagP20')+'.SLOW.FREQ',     2);
  InitTag(P20.FAST.FEXPR.tag,   ReadIni('tagP20')+'.FAST.FEXPR',    3);
  InitTag(P20.FAST.DURAT.tag,   ReadIni('tagP20')+'.FAST.DURAT',    2);
  InitTag(P20.FAST.AUTOSAVE.tag,ReadIni('tagP20')+'.FAST.AUTOSAVE', 1);
  InitTag(P20.FIRE11.EXPR.tag,  ReadIni('tagP20')+'.FIRE11.EXPR',   3);
  InitTag(P20.FIRE12.EXPR.tag,  ReadIni('tagP20')+'.FIRE12.EXPR',   3);
  InitTag(P20.FIRE21.EXPR.tag,  ReadIni('tagP20')+'.FIRE21.EXPR',   3);
  InitTag(P20.FIRE22.EXPR.tag,  ReadIni('tagP20')+'.FIRE22.EXPR',   3);
  InitTag(P20.FIRE11.ENAB.tag,  ReadIni('tagP20')+'.FIRE11.ENAB',   1);
  InitTag(P20.FIRE12.ENAB.tag,  ReadIni('tagP20')+'.FIRE12.ENAB',   1);
  InitTag(P20.FIRE21.ENAB.tag,  ReadIni('tagP20')+'.FIRE21.ENAB',   1);
  InitTag(P20.FIRE22.ENAB.tag,  ReadIni('tagP20')+'.FIRE22.ENAB',   1);
  InitTag(P20.FIRE11.BTN.tag,   ReadIni('tagP20')+'.FIRE11.BTN',    1);
  InitTag(P20.FIRE12.BTN.tag,   ReadIni('tagP20')+'.FIRE12.BTN',    1);
  InitTag(P20.FIRE21.BTN.tag,   ReadIni('tagP20')+'.FIRE21.BTN',    1);
  InitTag(P20.FIRE22.BTN.tag,   ReadIni('tagP20')+'.FIRE22.BTN',    1);
  InitTag(P20.VE1.EXPR.tag,     ReadIni('tagP20')+'.VE1.EXPR',      3);
  InitTag(P20.VE2.EXPR.tag,     ReadIni('tagP20')+'.VE2.EXPR',      3);
  InitTag(P20.VE3.EXPR.tag,     ReadIni('tagP20')+'.VE3.EXPR',      3);
  InitTag(P20.VE4.EXPR.tag,     ReadIni('tagP20')+'.VE4.EXPR',      3);
  InitTag(P20.VE5.EXPR.tag,     ReadIni('tagP20')+'.VE5.EXPR',      3);
  InitTag(P20.VN1.EXPR.tag,     ReadIni('tagP20')+'.VN1.EXPR',      3);
  InitTag(P20.VE1.ENAB.tag,     ReadIni('tagP20')+'.VE1.ENAB',      1);
  InitTag(P20.VE2.ENAB.tag,     ReadIni('tagP20')+'.VE2.ENAB',      1);
  InitTag(P20.VE3.ENAB.tag,     ReadIni('tagP20')+'.VE3.ENAB',      1);
  InitTag(P20.VE4.ENAB.tag,     ReadIni('tagP20')+'.VE4.ENAB',      1);
  InitTag(P20.VE5.ENAB.tag,     ReadIni('tagP20')+'.VE5.ENAB',      1);
  InitTag(P20.VN1.ENAB.tag,     ReadIni('tagP20')+'.VN1.ENAB',      1);
  InitTag(P20.VE1.BTN.tag,      ReadIni('tagP20')+'.VE1.BTN',       1);
  InitTag(P20.VE2.BTN.tag,      ReadIni('tagP20')+'.VE2.BTN',       1);
  InitTag(P20.VE3.BTN.tag,      ReadIni('tagP20')+'.VE3.BTN',       1);
  InitTag(P20.VE4.BTN.tag,      ReadIni('tagP20')+'.VE4.BTN',       1);
  InitTag(P20.VE5.BTN.tag,      ReadIni('tagP20')+'.VE5.BTN',       1);
  InitTag(P20.VN1.BTN.tag,      ReadIni('tagP20')+'.VN1.BTN',       1);
  InitTag(P20.CRWSVR.SAVE.tag,  ReadIni('tagP20')+'.CRWSVR.SAVE',   1);
  InitTag(P20.CRWSVR.BUGS.tag,  ReadIni('tagP20')+'.CRWSVR.BUGS',   2);
  InitTag(P20.CRWSVR.WCAP.tag,  ReadIni('tagP20')+'.CRWSVR.WCAP',   3);
  InitTag(P20.CRWSVR.WTIT.tag,  ReadIni('tagP20')+'.CRWSVR.WTIT',   3);
  InitTag(P20.CRWSVR.WLAB.tag,  ReadIni('tagP20')+'.CRWSVR.WLAB',   3);
  InitTag(P20.CRWSVR.FNAM.tag,  ReadIni('tagP20')+'.CRWSVR.FILE',   3);
  for i:=1 to NumVEs do begin
   Valve_InitTag(P20.VE[i], 'P20.VE'+Str(i));
   Valve_InitVal(P20.VE[i]);
   P20.VE[i].BTN.ndi:=i-1;
   P20.VE[i].BTN.ndo:=i-1;
  end;
  for i:=1 to NumVNs do begin
   Valve_InitTag(P20.VN[i], 'P20.VN'+Str(i));
   Valve_InitVal(P20.VN[i]);
   P20.VN[i].BTN.ndi:=i-1;
   P20.VN[i].BTN.ndo:=NumVEs+i-1;
  end;
  for i:=1 to NumPIKs do begin
  end;
  for i:=1 to NumADCs do begin
   InitTag(P20.ADC.ONLINE[i].tag, ReadIni('tagP20')+'.ADC.ONLINE'+Str(i),      1);
   InitTag(P20.ADC.Starts[i].tag, ReadIni('tagP20')+'.E140_'+Str(i)+'.START',  1);
   InitTag(P20.ADC.KHZ[i].tag,    ReadIni('tagP20')+'.E140_'+Str(i)+'.FREQ',   1);
   for j:=1 to NumAdcChans do
   InitTag(P20.ADC.FIR[i,j].tag,  ReadIni('tagP20')+'.E140_'+Str(i)+'.FIR.'+Str(j-1), 1);
   P20.ADC.ONLINE[i].ndo:=doADC1Online+i-1;
   P20.ADC.WdtXn[i]:=_MinusInf;
   P20.ADC.WdtTm[i]:=0;
  end;
  for i:=1 to NumDACs do begin
   InitTag(P20.DAC[i].tag,RefInfo(RefAo(i-1),'Name'),2);
   P20.DAC[i].nao:=i-1;
  end;
  for i:=1 to MaxUHs do begin
   InitTag(UH_EBLK[i].tag,'UH_EBLK'+Str(i),1);
   InitTag(UH_HENABL[i].tag,'UH_HENABL'+Str(i),1);
   bNul(iSetTag(UH_HENABL[i].tag,Ord(i<=NumUHs)));
  end;
  InitTag(UH_SOUNDX.tag,'UH_SOUNDX',1);
  AssignEvalRec(P20.FAST.EVAL[1],P20.FIRE11);
  AssignEvalRec(P20.FAST.EVAL[2],P20.FIRE12);
  AssignEvalRec(P20.FAST.EVAL[3],P20.FIRE21);
  AssignEvalRec(P20.FAST.EVAL[4],P20.FIRE22);
  AssignEvalRec(P20.FAST.EVAL[5],P20.VE1);
  AssignEvalRec(P20.FAST.EVAL[6],P20.VE2);
  AssignEvalRec(P20.FAST.EVAL[7],P20.VE3);
  AssignEvalRec(P20.FAST.EVAL[8],P20.VE4);
  AssignEvalRec(P20.FAST.EVAL[9],P20.VE5);
  AssignEvalRec(P20.FAST.EVAL[10],P20.VN1);
  {
  Initialize values
  }
  P20.LastEditTag:=0;
  P20.CMD.CLOSE.val:=-1;
  P20.CMD.SMILE.val:=GetErrCount(-2);
  P20.AwakePeriod:=DatSrvBufLeng; P20.AwokeTime:=0;
  bNul(iSetTag(P20.FAST.EXPO.tag,0));
  bNul(iSetTag(P20.FAST.EGATE.tag,0));
  bNul(rSetTag(P20.FAST.TFACT.tag,TimeUnits/1000));
  iNul(ShouldRefresh(P20.FAST.EXPO.val,iGetTag(P20.FAST.EXPO.tag)));
  iNul(ShouldRefresh(P20.ADC.START.val,iGetTag(P20.ADC.START.tag)));
  bNul(sSetTag(P20.CRWSVR.FNAM.tag,''));
  bNul(sSetTag(P20.CRWSVR.WTIT.tag,'^CData_in_Physics_Units^N^L___{bar/°C/mA}'));
  bNul(sSetTag(P20.CRWSVR.WLAB.tag,'^R{Seconds_since_exposition_start}___^N^CTime'));
 end;
 {
 P20 finalization
 }
 procedure P20_FREE;
 begin
 end;
 {
 P20 polling
 }
 procedure P20_POLL;
 var nerrors,xn,SecSinceStart,TimeRest,Freq:Real; i,j,k,card,ClickCurve,expo:Integer; aValve:TValveRec;
 begin
  {
  UniVent control
  }
  for i:=1 to NumVEs do Valve_Ctrl(P20.VE[i], P20.VE[i].BTN.ndi,P20.VE[i].BTN.ndo,0);  
  for i:=1 to NumVNs do Valve_Ctrl(P20.VN[i], P20.VN[i].BTN.ndi,P20.VN[i].BTN.ndo,0);
  {
  Balance DAC control
  }
  for i:=1 to NumDACs do UpdateAo(P20.DAC[i].nao,time,rGetTag(P20.DAC[i].tag));
  {
  Fast measurements (Exposition) forbidden while ADC is not started.
  }
  if iGetTag(P20.ADC.START.tag)=0 then bNul(iSetTag(P20.FAST.EXPO.tag,0));
  {
  Handle Fast measurements: Exposition start button (P20.FAST.EXPO) control.
  }
  expo:=iGetTag(P20.FAST.EXPO.tag);                                 // Get exposition state
  if ShouldRefresh(P20.FAST.EXPO.val,expo)>0 then begin             // If one changed
   if expo<>0 then begin                                            // Start exposition
    bNul(sSetTag(P20.CRWSVR.FNAM.tag,''));                          // Clear last saved CRW file name
    bNul(rSetTag(P20.FAST.ETIME.tag,time));                         // Remember exposition start time
    bNul(iSetTag(P20.FAST.EGATE.tag,1));                            // Open exposition gate
    DevSendCmd(P20.devGateEx,'@Reset');                             // Clear curves & reset
    Cron('@cron.run P20.FAST.START');                               // Cron actions on start
    bNul(Voice(snd_Inc));                                           // Sound notification
    PIK_CLEAR;                                                      // Clear PIK data
    PIK.Step.Fire:=1;                                               // Start PIK fire steps
   end else begin                                                   // End of expositions
    bNul(iSetTag(P20.FAST.EGATE.tag,0));                            // Close exposition gate
    if iGetTag(P20.FAST.AUTOSAVE.tag)<>0 then PendingSaveCrw(1000); // Auto save CRW if one enabled
    Cron('@cron.run P20.FAST.STOP');                                // Cron actions on stop
    bNul(Voice(snd_Dec));                                           // Sound notification
    PIK_CLEAR;                                                      // Clear PIK data
   end;
  end;
  if expo<>0 then begin                                             // Exposition polling:
   xn:=rGetTag(P20.FAST.ETIME.tag);                                 // Take start time
   xn:=xn+rGetTag(P20.FAST.DURAT.tag)*1000/TimeUnits;               // End of exposition
   if Time>xn then bNul(iSetTag(P20.FAST.EXPO.tag,0));              // Exposition expired?
  end;
  {
  ADC Frequency control: depend on exposition number
  }
  expo:=iGetTag(P20.FAST.EXPO.tag);
  if expo=0 then bNul(rSetTag(P20.ADC.FREQ.tag,rGetTag(P20.SLOW.FREQ.tag))) else begin
   SecSinceStart:=(Time-rGetTag(P20.FAST.ETIME.tag))*TimeUnits/1000;
   bNul(rSetTag(P20.ADC.FREQ.tag,EvalFreq(SecSinceStart,sGetTag(P20.FAST.FEXPR.tag))));
  end;
  UpdateAdcFreq(Max(MinAdcFreq,Min(MaxAdcFreq,rGetTag(P20.ADC.FREQ.tag))));
  {
  Check exposition frequency & time correctness
  }
  if SysTimer_Pulse(100)>0 then
  if ShouldRefresh(P20.FAST.DURAT.val,rGetTag(P20.FAST.DURAT.tag))
    +ShouldRefresh(P20.FAST.FEXPR.val,EvalHash(sGetTag(P20.FAST.FEXPR.tag)))>0
  then CheckExposition(EvalNumPoints(rGetTag(P20.FAST.DURAT.tag),sGetTag(P20.FAST.FEXPR.tag)));
  {
  Awake DatSrv to enforce data save. Awake period depends on current ADC frequency.
  }
  if SysTimer_Pulse(AwakePeriod)>0 then begin
   bNul(iSetTag(P20.DatSrvGate.tag,Ord(iGetTag(P20.CMD.SAVE.tag)<>0)));
   P20.AwakePeriod:=DatSrvBufLeng/Max(MinAdcFreq,Min(MaxAdcFreq,rGetTag(P20.ADC.FREQ.tag)));
   if iGetTag(P20.CMD.SAVE.tag)<>0 then begin
    if P20.AwakePeriod<DatSrvStdPeriod then
    if mSecNow>P20.AwokeTime+P20.AwakePeriod*1000 then AwakeDatSrv;
   end;
  end;
  {
  Update drum indicator during Exposition
  }
  if SysTimer_Pulse(DrumPeriod)>0 then
  if iGetTag(P20.FAST.EGATE.tag)<>0
  then bNul(iSetTag(P20.FAST.DRUM.tag,1+iGetTag(P20.FAST.DRUM.tag) mod 4))
  else bNul(iSetTag(P20.FAST.DRUM.tag,0));
  {
  Update rest time during Exposition
  }
  if SysTimer_Pulse(100)>0 then
  if iGetTag(P20.FAST.EGATE.tag)<>0 then begin
   SecSinceStart:=(Time-rGetTag(P20.FAST.ETIME.tag))*TimeUnits/1000;
   TimeRest:=rGetTag(P20.FAST.DURAT.tag)-SecSinceStart;
   bNul(rSetTag(P20.FAST.TREST.tag,Max(0,TimeRest)));
  end else bNul(rSetTag(P20.FAST.TREST.tag,0));
  {
  Calculate evaluated expressions (FIREi,VEi,VNi), if one enabled, during Exposition.
  Typical formula: ge(t,1)*le(t,5) - ON in (1..5) range, OFF otherwise,
  where t - time since start, sec.
  }
  if iGetTag(P20.FAST.EGATE.tag)<>0 then begin
   SecSinceStart:=(Time-rGetTag(P20.FAST.ETIME.tag))*TimeUnits/1000;
   if evar('t',SecSinceStart) then begin
    for i:=1 to NumEvals do begin
     if iGetTag(P20.FAST.EVAL[i].ENAB.tag)<>0 then begin
      if IsValve(P20.FAST.EVAL[i].BTN.tag,aValve)
      then EvalValve(aValve,sGetTag(P20.FAST.EVAL[i].EXPR.tag))
      else EvalButton(P20.FAST.EVAL[i].BTN.tag,sGetTag(P20.FAST.EVAL[i].EXPR.tag));
     end;
    end;
   end else Trouble('Unable to set formula`s  params');
  end;
  {
  Execute GUI commands
  }
  if iGetTag(P20.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(P20.CMD.HELP.tag,0));
  end;
  if iGetTag(P20.CMD.HOME.tag)<>0 then begin
   Cron('@cron.run P20.MAIN.GUI.HOME');
   bNul(iSetTag(P20.CMD.HOME.tag,0));
  end;
  if iGetTag(P20.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(AdaptFileName(ReadIni('['+DatSrv+'] DataPath')),''))+'*.dat;*.crw'));
   bNul(iSetTag(P20.CMD.OPEN.tag,0));
  end;
  if iGetTag(P20.CMD.LOADINI.tag)<>0 then begin
   DevSendCmd(devMySelf,'@Cmd.LoadIni');
   bNul(iSetTag(P20.CMD.LOADINI.tag,0)); 
  end;
  if iGetTag(P20.CMD.SAVEINI.tag)<>0 then begin
   DevSendCmd(devMySelf,'@Cmd.SaveIni');
   bNul(iSetTag(P20.CMD.SAVEINI.tag,0));
  end;
  if iGetTag(P20.CMD.TOOLS.tag)<>0 then begin
   bNul(iSetTag(P20.CMD.TOOLS.tag,0));
  end;
  if iGetTag(P20.CMD.CLOSE.tag)<>0 then begin
   if EditState=0 then begin
    if Pos('?',Edit('(Команда "Закрыть"... ')
              +Edit(' Что выбираете:')
              +Edit(' '+MenuCloseItem(0))
              +Edit(' '+MenuCloseItem(1))
              +Edit(' '+MenuCloseItem(2))
              +Edit(' '+MenuCloseItem(3))
              +Edit(' '+MenuCloseItem(4))
              +Edit(' '+MenuCloseItem(5))
              +Edit(' '+MenuCloseItem(6))
              +Edit(' '+MenuCloseItem(7))
              +Edit(')MenuList MENU_'+NameTag(P20.CMD.CLOSE.tag)))>0
    then Warning('Error initializing MenuList!');
   end else Warning('Cannot edit right now!');
   bNul(iSetTag(P20.CMD.CLOSE.tag,0));
   P20.CMD.CLOSE.val:=-1;
  end;
  if iGetTag(P20.FAST.CLEAR.tag)<>0 then begin
   bNul(iSetTag(P20.FAST.CLEAR.tag,0));
   DevSendCmd(P20.devGateEx,'@Reset');
    Cron('@cron.run P20.FAST.CLEAR');
  end;
  {
  Handle Smile button state
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   nerrors:=GetErrCount(-2);
   if nerrors>P20.CMD.SMILE.val then bNul(iSetTag(P20.CMD.SMILE.tag,2)) else
   if iGetTag(P20.CMD.SMILE.tag)>1 then bNul(iSetTag(P20.CMD.SMILE.tag,1));
   P20.CMD.SMILE.val:=nerrors;
  end;
  {
  Press ADC Start button
  }
  if ShouldRefresh(P20.ADC.Start.val,iGetTag(P20.ADC.Start.tag))>0 then begin
   if iGetTag(P20.ADC.Start.tag)<>0 then begin
    for i:=1 to NumADCs do
    if iGetTag(P20.ADC.Starts[i].tag)=0 then bNul(iSetTag(P20.ADC.Starts[i].tag,1));
   end;
   if iGetTag(P20.ADC.Start.tag)=0 then begin
    for i:=1 to NumADCs do
    if iGetTag(P20.ADC.Starts[i].tag)<>0 then bNul(iSetTag(P20.ADC.Starts[i].tag,0));
   end;
  end;
  {
  Update ADC ONLINE flags
  }
  if SysTimer_Pulse(OnlinePeriod)>0 then begin
   k:=0;
   for i:=1 to NumADCs do begin
    xn:=_MinusInf;
    for j:=0 to NumADCChans-1 do begin
     xn:=Max(xn,GetAi_Xn(k));
     k:=k+1;
    end;
    if ShouldRefresh(P20.ADC.WdtXn[i],xn)>0 then P20.ADC.WdtTm[i]:=mSecNow;
    bNul(iSetTag(P20.ADC.ONLINE[i].tag,Ord(mSecNow-P20.ADC.WdtTm[i]<=OnlineTimeout)));
    UpdateDo(P20.ADC.ONLINE[i].ndo,time,iGetTag(P20.ADC.ONLINE[i].tag));
   end;
  end;
  {
  Update UniHeat blocking flags if ADC is not online
  }
  if SysTimer_Pulse(BlockPeriod)>0 then begin
   k:=0;
   for i:=1 to NumADCs do if (iGetTag(P20.ADC.ONLINE[i].tag)=0) then k:=k+1;
   for i:=1 to NumUHs do bNul(iSetTag(UH_EBLK[i].tag,Ord(k>0)));
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then begin
    sNul(Edit(''));
   end;
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then begin
    sNul(Edit(''));
   end;
   {
   CLOSE menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(P20.CMD.CLOSE.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     P20.CMD.CLOSE.val:=Val(Edit('?ans 1'));
     if P20.CMD.CLOSE.val>=0 then
     if (P20.CMD.CLOSE.val>2) then begin
      DevSendCmd(devMySelf,'@MenuCloseConfirmation '+UpCaseStr(StrReplace(StrReplace(
                  MenuCloseItem(Round(P20.CMD.CLOSE.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuCloseCmnd(Round(P20.CMD.CLOSE.val));
      P20.CMD.CLOSE.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   CLOSE menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(P20.CMD.CLOSE.tag)) then begin
    if P20.CMD.CLOSE.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuCloseCmnd(Round(P20.CMD.CLOSE.val));
    P20.CMD.CLOSE.val:=-1;
    sNul(Edit(''));
   end;
   {
   Edit balance DAC's
   }
   for i:=1 to NumDACs do begin
    CheckEditTagUpdate(P20.DAC[i].tag,MinDacValue,MaxDacValue);
   end;
   {
   Edit exposition params
   }
   CheckEditTagUpdate(P20.SLOW.FREQ.tag,MinAdcFreq,MaxAdcFreq);
   CheckEditTagUpdate(P20.FAST.FEXPR.tag,MinAdcFreq,MaxAdcFreq);
   CheckEditTagUpdate(P20.FAST.DURAT.tag,MinAdcTime,MaxAdcTime);
   CheckEditTagUpdate(P20.FIRE11.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.FIRE12.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.FIRE21.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.FIRE22.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VE1.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VE2.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VE3.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VE4.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VE5.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.VN1.EXPR.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(P20.LastEditTag,_MinusInf,_PlusInf);
   P20.LastEditTag:=0;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(P20.CMD.HELP.tag,1);
   ClickBitXorLocal(P20.CMD.HOME.tag,1);
   ClickBitXorLocal(P20.CMD.OPEN.tag,1);
   ClickBitXorLocal(P20.CMD.SAVE.tag,1);
   ClickBitXorLocal(P20.CMD.LOADINI.tag,1);
   ClickBitXorLocal(P20.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(P20.CMD.TOOLS.tag,1);
   ClickBitXorLocal(P20.CMD.CLOSE.tag,1);
   ClickBitXorLocal(P20.ADC.START.tag,1);
   for i:=1 to NumVEs do ClickBitXorLocal(P20.VE[i].BTN.tag,1);
   for i:=1 to NumVNs do ClickBitXorLocal(P20.VN[i].BTN.tag,1);
   if ClickTag=P20.CMD.SAVE.tag then AwakeDatSrv;
   {
   Smile face button...
   }
   if ClickTag=P20.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(P20.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Exposition start/stop button
   }
   if IsSameText(ClickSensor,NameTag(P20.FAST.EXPO.tag)) then begin
    bNul(iSetTag(P20.FAST.EXPO.tag,Ord(iGetTag(P20.FAST.EXPO.tag)=0)));
    bNul(Voice(snd_Click));
   end;
   {
   Edit ADC exposition params
   }
   if iGetTag(P20.FAST.EXPO.tag)=0 then begin
    if ClickTag=P20.SLOW.FREQ.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FAST.FEXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FAST.DURAT.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FIRE11.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FIRE12.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FIRE21.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.FIRE22.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VE1.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VE2.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VE3.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VE4.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VE5.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    if ClickTag=P20.VN1.EXPR.tag then StartEditTag(ClickTag,URL_Decode(ClickParams('Hint')));
    ClickBitXorLocal(P20.FIRE11.ENAB.tag,1);
    ClickBitXorLocal(P20.FIRE12.ENAB.tag,1);
    ClickBitXorLocal(P20.FIRE21.ENAB.tag,1);
    ClickBitXorLocal(P20.FIRE22.ENAB.tag,1);
    ClickBitXorLocal(P20.VE1.ENAB.tag,1);
    ClickBitXorLocal(P20.VE2.ENAB.tag,1);
    ClickBitXorLocal(P20.VE3.ENAB.tag,1);
    ClickBitXorLocal(P20.VE4.ENAB.tag,1);
    ClickBitXorLocal(P20.VE5.ENAB.tag,1);
    ClickBitXorLocal(P20.VN1.ENAB.tag,1);
    ClickBitXorLocal(P20.FAST.AUTOSAVE.tag,1);
    ClickBitXorLocal(P20.FAST.CLEAR.tag,1);
   end;
   {
   Edit ADC shift
   }
   if TypeTag(ClickTag)=2 then
   if IsSameText(ExtractFileExt(NameTag(ClickTag)),'.PUSH') then begin
    StartEditTag(ClickTag,'Смещение нуля датчика '+ExtractFileName(NameTag(ClickTag)));
    P20.LastEditTag:=ClickTag;
   end;
   {
   CRWSVR.SAVE button
   }
   if iGetTag(P20.FAST.EXPO.tag)=0 then begin
    if ClickTag=P20.CRWSVR.SAVE.tag then begin
     bNul(iSetTag(P20.CRWSVR.SAVE.tag,1));
     bNul(Voice(snd_Click))
    end;
   end;
   {
   Open CRW file
   }
   if ClickTag=P20.CRWSVR.FNAM.tag then begin
    Cron('@Eval @System @Async @Open -d '
        +DaqFileRef(AdaptFileName('..\..\p20_data\'+sGetTag(P20.CRWSVR.FNAM.tag)),'.crw'));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then iNul(WinSelectByCurve(ClickCurve,ClickCurve));
   {
   Calibrations
   }
   if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
    OpenCalibrByCurve(RefFind('Curve '+ExtractFileName(ClickSensor)));
    bNul(Voice(snd_Click));
   end;
   {
   Cron actions
   }
   if IsSameText(Copy(Trim(ClickSensor),1,6),'@Cron.') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end else
   {
   Console commands: @url_encoded_sensor ...
   }
   if LooksLikeCommand(ClickSensor) then begin
    DevSendCmdLocal(url_decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Device messages
   }
   if IsSameText(Copy(Trim(ClickSensor),1,8),'@DevMsg+') then begin
    Cron(URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Inc/Dec actions
   }
   if IsSameText(Copy(Trim(ClickSensor),1,8),'@IncTag+') then begin
    DevSendCmd(devMySelf,URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   if IsSameText(Copy(Trim(ClickSensor),1,8),'@DecTag+') then begin
    DevSendCmd(devMySelf,URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Zero correction
   }
   if IsSameText(Copy(Trim(ClickSensor),1,6),'@Zero+') then begin
    DevSendCmd(devMySelf,URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   {
   Sensor gate, like P20.WK1.GATE
   }
   if TypeTag(ClickTag)=1 then
   if IsSameText(ExtractFileExt(NameTag(ClickTag)),'.GATE') then
   ClickBitXorLocal(ClickTag,1);
   {
   Edit balance DAC's
   }
   for i:=1 to NumDACs do
   if IsSameText(NameTag(P20.DAC[i].tag),ClickSensor) then begin
    StartEditTag(P20.DAC[i].tag,'Баланс ЦАП '+NameTag(P20.DAC[i].tag)+', mV');
    bNul(Voice(snd_Click));
   end;
   {
   E140
   }
   if IsSameText(ClickSensor,'P20.ADC.ONLINE1') then begin
    Cron('@WinOpenSelect P20.E140_1.CTRL.GUI');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'P20.ADC.ONLINE2') then begin
    Cron('@WinOpenSelect P20.E140_2.CTRL.GUI');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'P20.ADC.ONLINE3') then begin
    Cron('@WinOpenSelect P20.E140_3.CTRL.GUI');
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  MAP_CLEAR;
  PIK_CLEAR;
  P20_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  MAP_INIT;
  PIK_INIT;
  P20_INIT;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  P20_FREE;
  PIK_FREE;
  MAP_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  MAP_POLL;
  PIK_POLL;
  P20_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n,tag,crv:Integer; r,a,b:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @&PIK.DRV Y
   }
   if IsSameText(cmd,'@&PIK.DRV') then begin
    PIK.Drv.ans:=arg;
    Data:='';
   end else
   {
   @MenuCloseConfirmation
   }
   if IsSameText(cmd,'@MenuCloseConfirmation') then begin
    if P20.CMD.CLOSE.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(P20.CMD.CLOSE.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   @IncTag 10 P20.TR1.DAC 0 1e4
   }
   if IsSameText(cmd,'@IncTag') then begin
    r:=rValDef(ExtractWord(1,arg),0);
    tag:=FindTag(ExtractWord(2,arg));
    a:=rValDef(ExtractWord(3,arg),_MinusInf);
    b:=rValDef(ExtractWord(4,arg),_PlusInf);
    if r<>0 then begin
     if TypeTag(tag)=1 then bNul(iSetTag(tag,Round(Max(a,Min(b,iGetTag(tag)+r)))));
     if TypeTag(tag)=2 then bNul(rSetTag(tag,Max(a,Min(b,rGetTag(tag)+r))));
    end;
    Data:='';
   end else
   {
   @DecTag 10 P20.TR1.DAC 0 1e4
   }
   if IsSameText(cmd,'@DecTag') then begin
    r:=rValDef(ExtractWord(1,arg),0);
    tag:=FindTag(ExtractWord(2,arg));
    a:=rValDef(ExtractWord(3,arg),_MinusInf);
    b:=rValDef(ExtractWord(4,arg),_PlusInf);
    if r<>0 then begin
     if TypeTag(tag)=1 then bNul(iSetTag(tag,Round(Max(a,Min(b,iGetTag(tag)-r)))));
     if TypeTag(tag)=2 then bNul(rSetTag(tag,Max(a,Min(b,rGetTag(tag)-r))));
    end;
    Data:='';
   end else
   {
   @Cmd.LoadIni
   }
   if IsSameText(cmd,'@Cmd.LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if IsSameText(cmd,'@Cmd.SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveCrw
   }
   if IsSameText(cmd,'@Cmd.SaveCrw') then begin
    bNul(iSetTag(P20.CRWSVR.SAVE.tag,1));
    Data:='';
   end else
   {
   @AssignTag UH_NAMES T1/T2/T3
   }
   if IsSameText(cmd,'@AssignTag') then begin
    tag:=FindTag(ExtractWord(1,arg));
    if TypeTag(tag)>0 then UpdateTag(tag,Trim(SkipWords(1,arg)),_MinusInf,_PlusInf);
    Data:='';
   end else
   {
   @ZERO P20.WK1.PUSH P20.WK1.MV
   }
   if IsSameText(cmd,'@Zero') then begin
    tag:=FindTag(ExtractWord(1,arg));
    crv:=RefFind('Curve '+ExtractWord(2,arg));
    if (TypeTag(tag)=2) and (crv<>0) then begin
     if rGetTag(tag)<>0
     then bNul(rSetTag(tag,0))
     else bNul(rSetTag(tag,CrvGetLastY(crv)))
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
