 {
 ***********************************************************************
 Daq Pascal application program _GATEXY.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Reset                 - reset all channels.
| @Reset n               - reset channel number n.
| @Clear                 - clear all AO curves connected.
| @Clear n               - clear AO[n] curve connected.
|********************************************************
[]
 ***********************************************************************
 Description:
  Apply Gate, X & Y shift & scale & AI/AO map.
  Uses for mapping, linear data transformations.
  Uses for exposition - based fast measurements.
  Gate            - uses to cut exposition data, for example.
  X shift & scale - uses to convert X (time) to seconds since
                    exposition start, for example.
  Y shift & scale - uses to cut ADC drift and convert units.
 Configuration:
  AI/AO`s - Input/Output data.
  AutoReset - 0/1 manual/auto data reset by gate front.
  tagGate    or tagGateN   (N=0..NumAos-1) - Integer gate tag(s).
  tagShiftX  or tagShiftXN (N=0..NumAos-1) - Real X shift tag(s).
  tagScaleX  or tagScaleXN (N=0..NumAos-1) - Real X scale tag(s).
  tagShiftY  or tagShiftYN (N=0..NumAos-1) - Real Y shift tag(s).
  tagScaleY  or tagScaleYN (N=0..NumAos-1) - Real Y scale tag(s).
  tagMapAON  - Integer tag contains AI number to map AI to AO.
  All tags may be passed, by default Gate=1, Shift=0, Scale=1,
  and MapAON=N.
 Example:
  tagGate    = DemoGate
  tagShiftX  = DemoTimeBase
  tagScaleY  = DemoTimeUnits
  tagShiftY0 = DemoAdcDrift0
  tagShiftY1 = DemoAdcDrift1
  tagScaleY  = DemoConvertUnits
  tagMapAO0  = DemoSelectorAO0
  tagMapAO1  = DemoSelectorAO1
  AutoReset  = 0
 ***********************************************************************
 }
program _gatexy;                 { Apply gate & X,Y shift/scale     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxNumAos         = 1024;       { Maximum number of AnalogOutputs  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 LastX             : array[0..MaxNumAos] of Real; { Last X marker   }
 tagGate           : array[0..MaxNumAos] of Integer; { Gate tags    }
 tagShiftX         : array[0..MaxNumAos] of Integer; { Shift X tags }
 tagScaleX         : array[0..MaxNumAos] of Integer; { Scale X tags }
 tagShiftY         : array[0..MaxNumAos] of Integer; { Shift Y tags }
 tagScaleY         : array[0..MaxNumAos] of Integer; { Scale Y tags }
 tagMapAO          : array[0..MaxNumAos] of Integer; { MapAO tags   }
 LastGate          : array[0..MaxNumAos] of Integer; { Last value   }
 AutoReset         : Boolean;    { Auto reset on Gate front         }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear AO[n] curve or all AO curves if n<0.
 }
 procedure GATEXY_Clear(n:Integer);
 var nao,cao:Integer;
 begin
  for nao:=0 to NumAos-1 do
  if (n=nao) or (n<0) then begin
   cao:=RefAo(nao);
   if cao<>0 then rNul(CrvDel(cao,1,MaxInt));
  end;
 end;
 {
 Reset channel n or all channels if n<0.
 Reset includes AO clear & LastX marker.
 }
 procedure GATEXY_Reset(n:Integer);
 var nao,nai,cai:Integer;
 begin
  for nao:=0 to NumAos-1 do
  if (n=nao) or (n<0) then begin
   nai:=nao;
   cai:=RefAi(nai);
   if cai<>0 then begin
    bNul(CrvLock(cai));
    if CrvLen(cai)=0
    then LastX[nao]:=_MinusInf
    else LastX[nao]:=CrvX(cai,CrvLen(cai));
    bNul(CrvUnLock(cai));
   end;
  end;
  GATEXY_Clear(n);
 end;
 {
 Initialize tag from INI file nick names.
 For example InitTagByNick(tagGate,'tagGate1 tagGate',1)
 will seach for Integer tag ReadIni('tagGate1'), then ReadIni('tagGate').
 }
 procedure InitTagByNicks(var tag:Integer; nicks:String; typ:Integer);
 var i:Integer;
 begin
  tag:=0;
  for i:=1 to WordCount(nicks) do
  if TypeTag(tag)=0 then begin
   tag:=FindTag(ReadIni(ExtractWord(i,nicks)));
   if (typ<>0) and (TypeTag(tag)<>abs(typ)) then tag:=0;
   if (typ<>0) and (TypeTag(tag)>0) then Success('Init tag '+NameTag(tag)+' by nick '+ExtractWord(i,nicks));
  end;
  if TypeTag(tag)=0 then begin
   if typ>0 then Trouble('Can`t init tag by nicks:'+nicks);
   if typ<0 then Problem('Can`t init tag by nicks:'+nicks);
  end;
 end;
 {
 Initialize.
 }
 procedure GATEXY_Init;
 var nao:Integer;
 begin
  AutoReset:=(Val(ReadIni('AutoReset'))=1);
  for nao:=0 to NumAos-1 do begin
   LastGate[nao]:=0;
   InitTagByNicks(tagGate[nao],   'tagGate'  +Str(nao)+' tagGate',   -1);
   InitTagByNicks(tagShiftX[nao], 'tagShiftX'+Str(nao)+' tagShiftX', -2);
   InitTagByNicks(tagScaleX[nao], 'tagScaleX'+Str(nao)+' tagScaleX', -2);
   InitTagByNicks(tagShiftY[nao], 'tagShiftY'+Str(nao)+' tagShiftY', -2);
   InitTagByNicks(tagScaleY[nao], 'tagScaleY'+Str(nao)+' tagScaleY', -2);
   InitTagByNicks(tagMapAO[nao],  'tagMapAO' +Str(nao),              -1);
  end;
  GATEXY_Reset(-1);
 end;
 {
 Polling.
 }
 procedure GATEXY_Poll;
 var nao,nai,tag,Gate,cai,cao,n,i,ia,ib:Integer; x,y,ShiftY,ShiftX,ScaleX,ScaleY:Real;
 begin
  for nao:=0 to NumAos-1 do begin
   tag:=tagGate[nao]; if TypeTag(tag)=1 then Gate:=iGetTag(tag) else Gate:=1;
   if LastGate[nao]<>Ord(Gate<>0) then begin
    if Gate<>0 then if AutoReset then GATEXY_Reset(-1);
    LastGate[nao]:=Ord(Gate<>0);
   end;
   if Gate<>0 then begin
    nai:=nao;
    tag:=tagMapAO[nao]; if TypeTag(tag)=1 then nai:=iGetTag(tag) else nai:=nao;
    cai:=RefAi(nai);
    cao:=RefAo(nao);
    if cao<>0 then
    if cai<>0 then begin
     tag:=tagShiftX[nao]; if TypeTag(tag)=2 then ShiftX:=rGetTag(tag) else ShiftX:=0;
     tag:=tagScaleX[nao]; if TypeTag(tag)=2 then ScaleX:=rGetTag(tag) else ScaleX:=1;
     tag:=tagShiftY[nao]; if TypeTag(tag)=2 then ShiftY:=rGetTag(tag) else ShiftY:=0;
     tag:=tagScaleY[nao]; if TypeTag(tag)=2 then ScaleY:=rGetTag(tag) else ScaleY:=1;
     n:=0;
     bNul(CrvLock(cai));
     ib:=Round(CrvLen(cai));
     if ib>0 then begin
      ia:=Round(CrvWhere(cai,LastX[nao]));
      for i:=ia to ib do begin
       x:=CrvX(cai,i);
       if x>LastX[nao] then begin
        LastX[nao]:=x;
        y:=CrvY(cai,i);
        if ShiftX<>0 then x:=x-ShiftX;
        if ScaleX<>1 then x:=x*ScaleX;
        if ShiftY<>0 then y:=y-ShiftY;
        if ScaleY<>0 then y:=y*ScaleY;
        UpdateAo(nao,x,y);
        n:=n+1;
       end;
      end;
     end;
     bNul(CrvUnlock(cai));
     if n>0 then if iAnd(DebugFlags,dfDetails)>0 then
     Details('Update '+Str(n)+' points of '+CrvName(cao)+' from '+CrvName(cai));
    end;
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  GATEXY_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GATEXY_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Reset
   @Reset 1
   }
   if IsSameText(cmd,'@Reset') then begin
    n:=iValDef(arg,-1); GATEXY_Reset(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @Clear
   @Clear 1
   }
   if IsSameText(cmd,'@Clear') then begin
    n:=iValDef(arg,-1); GATEXY_Clear(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
