 {
 ***********************************************************************
 INTEK Modbus Driver.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Modbus.XXX    - response come from &ModbusProxy server:
| @Modbus.Reply    ref cid tim port uid fid $$ans
| @Modbus.Refuse   ref cid tim port uid fid   msg
| @Modbus.Timeout  ref cid tim port uid fid $$req
|  ref  - sender device reference, expected &ModbusProxy.
|  cid  - command id, any user defined custom data.
|  tim  - request-response time, ms.
|  port - logical port on &ModbusProxy, expected 1..16.
|  uid  - unit id, i.e.MODBUS address, expected 1..247.
|  fid  - function id, expected 1,2,3,4,5,6,15,16.
|  ans  - answer  (response), in HEX_ENCODE format.
|  req  - request (original), in HEX_ENCODE format.
|  msg  - plain text message to explain reason of Refuse.
| @PARAM.XX      - write parameter, i.e. send to MODBUS
| @Edit PARAM.XX - edit parameter and write it
| @LoadIni - load params from INI file.
| @SaveIni - save params to   INI file.
|********************************************************
[]
 Configuration:
 ***********************************************************************
  [DeviceList]
  &INTEK.DRIVER = device software program
  [&INTEK.DRIVER]
  Comment        = INTEK MODBUS DRIVER.
  InquiryPeriod  = 0
  DevicePolling  = 10, tpNormal
  ProgramSource  = ..\DaqPas\intek_INTEK.pas
  DigitalFifo    = 1024
  AnalogFifo     = 1024
  DebugFlags     = 3
  OpenConsole    = 2
  Simulator      = 0
  ModbusPort     = 1
  ModbusUnitId   = 1
  ModbusTimeout  = 250
  ModbusDeadline = 60000
  ModbusPolling  = 100
  DelayOnStart   = 1000
  tagPrefix      = INTEK
  ...etc...
 ***********************************************************************
 }
program INTEK_Modbus_Driver;     { INTEK Modbus Driver              }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 dfStatist       = 32;           { DebugFlags - polling statistics  }
 MaxCmdNum       = 11;           { Maximal number of commands:      }
 cm_ReadHRSys    = 1;            { Read System Holding Registers    }
 cm_ReadHRMeas   = 2;            { Read Regs 37-38 Measure Cur,Volt }
 cm_ReadHRSets   = 3;            { Read Regs 54-55 Setting Cur,Volt }
 cm_ReadHRCtrl   = 4;            { Read Control Register 100        }
 cm_WritAddress  = 5;            { Write new device address         }
 cm_WritCmdCtrl  = 6;            { Write control instructions       }
 cm_WritAcptCnt  = 7;            { Write Accept packets conunt to 0 }
 cm_WritFlptCnt  = 8;            { Write Fault  packets conunt to 0 }
 cm_WritSetVolt  = 9;            { Write volt setpoint              }
 cm_WritSetCurr  = 10;           { Write current setpoint           }
 cm_WritSetCtrl  = 11;           { Write Source control register    }
 ao_ADDRESS      = 0;            { Device address (modbus)          }
 ao_CMDCTRL      = 1;            { Control instructions register    }
 ao_DIAGNOS      = 2;            { Source diagnostics               }
 ao_ACPTCNT      = 3;            { Accept packet counter            }
 ao_FLPTCNT      = 4;            { Fault  packet counter            }
 ao_MEASCURR     = 5;            { Current measure                  }
 ao_MEASVOLT     = 6;            { Voltage measure                  }
 ao_SETVOLT      = 7;            { Setting voltage stabilization    }
 ao_SETCURR      = 8;            { Output current limitation        }
 ao_SETCTRL      = 9;            { Source control register          }
 do_STATE_INDIC  = 0;            { Status indicator                 }
 do_POLLRATERX   = 1;            { DigitalOutput - Poll rate Rx     }
 do_POLLRATETX   = 2;            { DigitalOutput - Poll rate Tx     }
 do_POLLRATEEX   = 3;            { DigitalOutput - Poll rate Ex     }
 do_ERRORCOUNT   = 4;            { DigitalOutput - Error counter    }
 do_POLLSUMMRX   = 5;            { DigitalOutput - Poll summ Rx     }
 do_POLLSUMMTX   = 6;            { DigitalOutput - Poll summ Tx     }
 do_POLLSUMMEX   = 7;            { DigitalOutput - Poll summ Ex     }
 SwapModeFloat   = 1;            { Byte swap mode for float values  }
 SwapModeInt32   = 3;            { Byte swap mode for integers      }
 mb_NORMAL       = 0;            { Modbus state normal              }
 mb_TIMEOUT      = 1;            { Modbus state timeout             }
 mb_REFUSE       = 2;            { Modbus state refuse              }
 mb_DEADLINE     = 3;            { Modbus state deadline            }
 st_NORMAL       = 0;            { Green                            }
 st_TIMEOUT      = 1;            { Red timeout                      }
 st_REFUSE       = 2;            { Red refuse                       }
 st_SIMULAT      = 3;            { Simulator mode                   }
 st_DISABLE      = 4;            { Polling disabled                 }

type
 TTagRef = record tag,nai,ndi,nao,ndo:Integer; val,tim:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 INTEK      : record             { INTEK Driver data record         }
  Simulator : Boolean;           { Simulator or Driver mode         }
  step2mm   : Integer;           { Conversion factor steps to mm    }
  Modbus    : record             { Modbus data record               }
   Port     : Integer;           { Logical Port on &ModbusProxy     }
   UnitId   : Integer;           { Modbus unit id                   }
   Timeout  : Integer;           { Modbus timeout, ms               }
   Polling  : Integer;           { Modbus polling period, ms        }
   Deadline : Integer;           { Modbus deadline time, ms         }
   DelayOnStart : Integer;       { Command cycle delay on start     }
   Cmd      : record             { Command cycle data record        }
    Num     : Integer;           { Current running command number   }
    Enabled : array [1..MaxCmdNum] of Boolean; { Enable polling     }
    FuncId  : array [1..MaxCmdNum] of Integer; { Modbus Function Id }
    SAddr   : array [1..MaxCmdNum] of Integer; { Start Address      }
    Quant   : array [1..MaxCmdNum] of Integer; { Quantity of data   }
    OpData  : array [1..MaxCmdNum] of Real;    { Operation data     }
    OpBuff  : array [1..MaxCmdNum] of Real;    { Operation buffer   }
   end;                          {                                  }
   Poll     : record             { Polling transaction data record  }
    ref     : Integer;           { Last sent device reference       }
    cid     : Integer;           { Last sent command id             }
    tim     : Real;              { Last polling time, ms            }
    port    : Integer;           { Last polling port                }
    uid     : Integer;           { Last polling unit id             }
    fid     : Integer;           { Last sent function id            }
    saddr   : Integer;           { Last sent start address          }
    quant   : Integer;           { Last sent quantity of registers  }
    dat     : String;            { Last sent PDU=(fid+dat) data     }
    Summ,                        { Poll summ counters               }
    Rate    : record             { Poll rate on last second         }
     Rx     : Real;              { Rx poll summ/rate - receiver     }
     Tx     : Real;              { Tx poll summ/rate - transmitter  }
     Ex     : Real;              { Ex poll summ/rate - errors       }
    end;                         {                                  }
   end;                          {                                  }
  end;                           {                                  }
  POLL      : record             { Poll parameters                  }
   ENABLE   : TTagRef;           { Poll enable flag                 }
  end;                           {                                  }
  GUI       : record             { Graphical User Interface data    }
   CMD      : record             { Commands                         }
    HELP    : TTagRef;           {                                  }
    SAVEINI : TTagRef;           {                                  }
    LOADINI : TTagRef;           {                                  }
    CONSOLE : TTagRef;           {                                  }
    TOOLS   : TTagRef;           {                                  }
   end;                          {                                  }
  end;                           {                                  }
  PARAM     : record             { Device analog parameters         }
   ADDRESS  : TTagRef;           {                                  }
   CMDCTRL  : TTagRef;           {                                  }
   DIAGNOS  : TTagRef;           {                                  }
   ACPTCNT  : TTagRef;           {                                  }
   FLPTCNT  : TTagRef;           {                                  }
   MEASCURR : TTagRef;           {                                  }
   MEASVOLT : TTagRef;           {                                  }
   SETVOLT  : TTagRef;           {                                  }
   SETCURR  : TTagRef;           {                                  }
   SETCTRL  : TTagRef;           {                                  }
  end;                           {                                  }
  SIM       : record             { Simulator data                   }
   ADDRESS  : Integer;           {                                  }
   CMDCTRL  : Integer;           {                                  }
   ACPTCNT  : Integer;           {                                  }
   FLPTCNT  : Integer;           {                                  }
   MEASCURR : Integer;           {                                  }
   MEASVOLT : Integer;           {                                  }
   SETVOLT  : Integer;           {                                  }
   SETCURR  : Integer;           {                                  }
   SETCTRL  : Integer;           {                                  }
   TimeOut  : Real;              {                                  }
  end;                           {                                  }
 end;                            {                                  }
 cmd_ClearModbusSumm       : Integer; { @ClearModbusSumm            }
 cmd_Edit                  : Integer; { @Edit                       }
 cmd_MenuToolsConfirmation : Integer; { @MenuToolsConfirmation      }
 cmd_LoadIni               : Integer; { @LoadIni                    }
 cmd_SaveIni               : Integer; { @SaveIni                    }
 cmd_SetAddr               : Integer; { @SetAddr                    }
 cmd_SetVolt               : Integer; { @SetVolt                    }
 cmd_SetCurr               : Integer; { @SetCurr                    }
 cmd_PowerOn               : Integer; { @PowerOn                    }
 cmd_SaveROM               : Integer; { @SaveROM                    }
 cmd_Restart               : Integer; { @Restart                    }
 cmd_Reset                 : Integer; { @Reset                      }
 cmd_ResAcptCnt            : Integer; { @ResAcptCnt                 }
 cmd_ResFlptCnt            : Integer; { @ResFlptCnt                 }
 cmd_SaveSetp              : Integer; { @SaveSetp                   }
 cmd_ResOverheat           : Integer; { @ResOverheat                }
 cmd_ResMaxArcs            : Integer; { @ResMaxArcs                 }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }
 //
 // Command cycle routines.
 //
 function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 function IsUsableCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsUsableCmdNum:=(INTEK.Modbus.Cmd.FuncId[Num]<>0)
  else IsUsableCmdNum:=False;
 end;
 function IsEnabledCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=(INTEK.Modbus.Cmd.FuncId[Num]<>0) and INTEK.Modbus.Cmd.Enabled[Num]
  else IsEnabledCmdNum:=False;
 end;
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer;
 begin
  i:=0;
  while (i<MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum
   else i:=i+1;
  end;
  NextEnabledCmdNum:=Num;
 end;
 procedure EnableCmdNum(Num:Integer; Enabled:Boolean);
 begin
  if IsUsableCmdNum(Num) then INTEK.Modbus.Cmd.Enabled[Num]:=Enabled;
 end;
 procedure HoldCmdOpData(Num:Integer; OpData:Real);
 begin
  if IsUsableCmdNum(Num) then begin
   INTEK.Modbus.Cmd.Enabled[Num]:=not IsNaN(OpData);
   INTEK.Modbus.Cmd.OpBuff[Num]:=OpData;
  end;
 end;
 procedure ApplyCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then
  if not IsNaN(INTEK.Modbus.Cmd.OpBuff[Num]) then begin
   INTEK.Modbus.Cmd.OpData[Num]:=INTEK.Modbus.Cmd.OpBuff[Num];
   INTEK.Modbus.Cmd.OpBuff[Num]:=_NaN;
  end;
 end;
 procedure ReleaseCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then HoldCmdOpData(Num,INTEK.Modbus.Cmd.OpBuff[Num]);
 end;
 function GetCmdOpData(Num:Integer):Real;
 begin
  if IsUsableCmdNum(Num)
  then GetCmdOpData:=INTEK.Modbus.Cmd.OpData[Num]
  else GetCmdOpData:=_NaN;
 end;
 procedure InitCmdItem(Num:Integer; Enabled:Boolean; FuncId,SAddr,Quant:Integer; OpData,OpBuff:Real);
 begin
  if IsValidCmdNum(Num) then begin
   INTEK.Modbus.Cmd.Enabled[Num]:=Enabled;
   INTEK.Modbus.Cmd.FuncId[Num]:=FuncId;
   INTEK.Modbus.Cmd.SAddr[Num]:=SAddr;
   INTEK.Modbus.Cmd.Quant[Num]:=Quant;
   INTEK.Modbus.Cmd.OpData[Num]:=OpData;
   INTEK.Modbus.Cmd.OpBuff[Num]:=OpBuff;
  end;
 end;
 //
 // Command table cleanup and initialization.
 //
 procedure ClearCmdTable;
 var Num:Integer;
 begin
  INTEK.Modbus.Cmd.Num:=0;
  for Num:=1 to MaxCmdNum do InitCmdItem(Num,False,0,0,0,0,_NaN);
 end;
 procedure InitCmdTable;
 begin
  ClearCmdTable;
  // Table of CommandId       Enabled FunctionId        SAddr  Quant OpData OpBuff
  InitCmdItem(cm_ReadHRSys,   True,   modbus_fn_ReadHR, 1,     9,   0,     _NaN);   // Read HR 0  to 9
  InitCmdItem(cm_ReadHRMeas,  True,   modbus_fn_ReadHR, 37,    2,   0,     _NaN);   // Read HR 37 to 38
  InitCmdItem(cm_ReadHRSets,  True,   modbus_fn_ReadHR, 54,    2,   0,     _NaN);   // Read HR 54 to 55
  InitCmdItem(cm_ReadHRCtrl,  True,   modbus_fn_ReadHR, 100,   2,   0,     _NaN);   // Read HR 100
  InitCmdItem(cm_WritAddress, False,  modbus_fn_WritMR, 1,     1,   0,     _NaN);   //
  InitCmdItem(cm_WritCmdCtrl, False,  modbus_fn_WritMR, 6,     1,   0,     _NaN);   //
  InitCmdItem(cm_WritAcptCnt, False,  modbus_fn_WritMR, 8,     1,   0,     _NaN);   // Accept packet counter
  InitCmdItem(cm_WritFlptCnt, False,  modbus_fn_WritMR, 9,     1,   0,     _NaN);   // Fault  packet counter
  InitCmdItem(cm_WritSetVolt, False,  modbus_fn_WritMR, 54,    1,   0,     _NaN);   //
  InitCmdItem(cm_WritSetCurr, False,  modbus_fn_WritMR, 55,    1,   0,     _NaN);   //
  InitCmdItem(cm_WritSetCtrl, False,  modbus_fn_WritMR, 100,   1,   0,     _NaN);   //
 end;
 //
 // Assign modbus last sent polling request record.
 //
 procedure AssignModbusPoll(ref,cid:Integer; tim:Real; port,uid,fid,saddr,quant:Integer; dat:String);
 begin
  INTEK.Modbus.Poll.ref:=ref;     INTEK.Modbus.Poll.cid:=cid;      INTEK.Modbus.Poll.tim:=tim;
  INTEK.Modbus.Poll.port:=port;   INTEK.Modbus.Poll.uid:=uid;      INTEK.Modbus.Poll.fid:=fid;
  INTEK.Modbus.Poll.saddr:=saddr; INTEK.Modbus.Poll.quant:=quant;  INTEK.Modbus.Poll.dat:=dat;
 end;
 //
 // Clear modbus polling request to be ready for next polling.
 //
 procedure ClearModbusPoll;
 begin
  INTEK.Modbus.Poll.cid:=0;
  INTEK.Modbus.Poll.dat:='';
 end;
 //
 // Clear modbus poll summ counters.
 //
 procedure ClearModbusSumm;
 begin
  INTEK.Modbus.Poll.Summ.Rx:=0;
  INTEK.Modbus.Poll.Summ.Tx:=0;
  INTEK.Modbus.Poll.Summ.Ex:=0;
 end;
 //
 // Clear modbus poll rate counters.
 //
 procedure ClearModbusRate;
 begin
  INTEK.Modbus.Poll.Rate.Rx:=0;
  INTEK.Modbus.Poll.Rate.Tx:=0;
  INTEK.Modbus.Poll.Rate.Ex:=0;
 end;
 //
 // Increment summ and rate counters.
 //
 procedure IncSummRate(var summ,rate:Real);
 begin
  summ:=summ+1; rate:=rate+1;
 end;
 //
 // Format error message with with error counter increment.
 // Usage is like: Trouble(GotBug(...)); Problem(GotBug(...));
 //
 function GotBug(msg:String):String;
 begin
  IncSummRate(INTEK.Modbus.Poll.Summ.Ex,INTEK.Modbus.Poll.Rate.Ex);
  GotBug:=msg;
 end;
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  if Length(aText)>0 then begin
   ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,1500);
 end;
 {
 Get text of Tools menu items
 }
 function MenuToolsItem(MenuTools:Integer):String;
 begin
  if MenuTools=0 then MenuToolsItem:='Очистка счетчиков ошибок '+DevName     else
  if MenuTools=1 then MenuToolsItem:='Очистка счетчиков ошибок '+ModbusProxy else
  if MenuTools=2 then MenuToolsItem:='Перезапустить драйвер '+DevName        else
  if MenuTools=3 then MenuToolsItem:='Вызвать окно справочной информации'    else
  if MenuTools=4 then MenuToolsItem:='Сохранить параметры в  INI файле'      else
  if MenuTools=5 then MenuToolsItem:='Загрузить параметры из INI файла'      else
  if MenuTools=6 then MenuToolsItem:='Пока не реализована'                   else
  if MenuTools=7 then MenuToolsItem:='Пока не реализована'                   else
  MenuToolsItem:='';
 end;
 {
 Execute Tools menu commands
 }
 procedure MenuToolsCmnd(MenuTools:Integer);
 begin
  if MenuTools=0 then DevSendCmd(devMySelf,'@ClearModbusSumm');
  if MenuTools=1 then DevSendCmd(devModbusProxy,'@ZeroPortCounters 0');
  if MenuTools=2 then Cron('@Eval @System @Async @Daq Compile '+DevName);
  if MenuTools=3 then Cron('@Eval @System @Async @Run '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
  if MenuTools=4 then DevSendCmd(devMySelf,'@SaveIni');
  if MenuTools=5 then DevSendCmd(devMySelf,'@LoadIni');
  if MenuTools=6 then NiceNotify('Желаю успешной работы',10000);
  if MenuTools=7 then NiceNotify('Желаю успешной работы',10000);
 end;
 //
 // Find the current Proxy device to send @Modbus.Poll message.
 //
 function devTheProxy:Integer;
 begin
  if INTEK.Simulator                // In simulation mode
  then devTheProxy:=devMySelf       // send messages to himself
  else devTheProxy:=devModbusProxy; // otherwise use &ModbusProxy
 end;
 //
 // Check if communication port is opened or not.
 // As long as we use Proxy device, check Port number & device reference.
 //
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(INTEK.Modbus.Port>0) and (devTheProxy<>0);
 end;
 //
 // Calculate Modbus request PDU by command id.
 // cid   - (in)  command id number.
 // fid   - (out) Modbus function id.
 // saddr - (out) zero-based start address of registers to read/write.
 // quant - (out) data quantity, i.e. number of r/w registers or single register r/w value.
 // dat   - (out) Modbus PDU data unit, PDU=(fid+dat).
 //
 function INTEK_CalcPDU(cid:Integer; var fid,saddr,quant:Integer; var dat:String):Boolean;
 begin
  fid:=0; saddr:=0; quant:=0; dat:='';
  if IsEnabledCmdNum(cid) then begin
   fid:=INTEK.Modbus.Cmd.FuncId[cid];
   saddr:=INTEK.Modbus.Cmd.SAddr[cid];
   quant:=INTEK.Modbus.Cmd.Quant[cid];
   if (cid=cm_ReadHRSys) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,'');
   end else
   if (cid=cm_ReadHRMeas) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,'');
   end else
   if (cid=cm_ReadHRSets) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,'');
   end else
   if (cid=cm_ReadHRCtrl) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,'');
   end else
   if (cid=cm_WritAddress) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   if (cid=cm_WritCmdCtrl) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   if (cid=cm_WritAcptCnt) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   if (cid=cm_WritFlptCnt) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   if (cid=cm_WritSetVolt) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),modbus_sw_normal));
   end else
   if (cid=cm_WritSetCurr) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   if (cid=cm_WritSetCtrl) then begin
    dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeInt32));
   end else
   Trouble(GotBug('Invalid command id '+Str(cid)));
  end;
  INTEK_CalcPDU:=modbus_func_ok(fid) and (Length(dat)>0);
 end;
 //
 // Main Modbus command handler to process Modbus device reply.
 // cid   - (in)  command id number.
 // fid   - (in)  Modbus function id.
 // saddr - (in)  zero-based start address of registers to read/write.
 // quant - (in)  data quantity, i.e. number of r/w registers or single register r/w value.
 // raw   - (in)  raw coils/registers data array.
 //
 procedure INTEK_OnCommand(cid,fid,saddr,quant:Integer; raw:String);
 var addr,offs,stat,indic,i:Integer; r:Real;
     adr,cmd,diag,acnt,fcnt,srcctrl:Integer; mcurr,mvolt,scurr,svolt:Real; s:String;
 begin
  if IsValidCmdNum(cid) then begin
   if cid=cm_ReadHRSys then begin        // Read HR ReadHRSys Reg 01-09
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs;
     if (addr=1) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.ADDRESS.tag,round(r)));
      UpdateAo(ao_ADDRESS,time,r);
      Details('address:'+Str(r));
     end else
     if (addr=6) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.CMDCTRL.tag,round(r)));
      UpdateAo(ao_CMDCTRL,time,r);
      Details('command:'+Str(r));
     end else
     if (addr=7) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.DIAGNOS.tag,round(r)));
      UpdateAo(ao_DIAGNOS,time,r);
      Details('diagnost:'+Str(r));
     end else
     if (addr=8) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.ACPTCNT.tag,round(r)));
      UpdateAo(ao_ACPTCNT,time,r);
      Details('countac:'+Str(r));
     end else
     if (addr=9) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.FLPTCNT.tag,round(r)));
      UpdateAo(ao_FLPTCNT,time,r);
      Details('countfl:'+Str(r));
     end;
    end;
   end else
   if cid=cm_ReadHRMeas then begin       // Read HR ReadHRMeas Reg 37-38
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs;
     if (addr=37) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32); r:=r*0.01;
      bNul(rSetTag(INTEK.PARAM.MEASCURR.tag,r));
      UpdateAo(ao_MEASCURR,time,r);
      Details('mcurr:'+Str(r));
     end else
     if (addr=38) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32); r:=r*0.1;
      bNul(rSetTag(INTEK.PARAM.MEASVOLT.tag,r));
      UpdateAo(ao_MEASVOLT,time,r);
      Details('mvolt:'+Str(r));
     end;
    end;
   end else
   if cid=cm_ReadHRSets then begin       // Read HR ReadHRSets Reg 54-55
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs;
     if (addr=54) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32); r:=r*0.1;
      bNul(rSetTag(INTEK.PARAM.SETVOLT.tag,r));
      UpdateAo(ao_SETVOLT,time,r);
      Details('scurr:'+Str(r));
     end else
     if (addr=55) and (quant-offs+1>=1) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32); r:=r*0.01;
      bNul(rSetTag(INTEK.PARAM.SETCURR.tag,r));
      UpdateAo(ao_SETCURR,time,r);
      Details('svolt:'+Str(r));
     end;
    end;
   end else
   if cid=cm_ReadHRCtrl then begin       // Read HR ReadHRCtrl Reg 100
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs;
     if (addr=100) and (quant-offs+1>=2) then begin
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(INTEK.PARAM.SETCTRL.tag,round(r)));
      UpdateAo(ao_SETCTRL,time,r);
      Details('srcctrl:'+Str(r));
     end;
    end;
   end else
   if (cid=cm_WritAddress) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCmdCtrl) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritAcptCnt) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritFlptCnt) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSetVolt) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSetCurr) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSetCtrl) then ReleaseCmdOpData(cid) else
   Trouble(GotBug('Unexpected command '+Str(cid)));
   if INTEK.Simulator then indic:=st_SIMULAT else
   indic:=st_NORMAL;
   UpdateDo(do_STATE_INDIC,time,indic);
  end;
 end;
 //
 // Data handler on @Modbus.Reply event. Process reply comes from Modbus device.
 //
 procedure INTEK_OnReply(ref,cid,tim,port,uid,fid:Integer; dat:String);
 var raw:String; saddr,quant:Integer;
 begin
  raw:=''; // Check is coming reply corresponded to sent request
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>INTEK.Modbus.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>INTEK.Modbus.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>INTEK.Modbus.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>INTEK.Modbus.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if (modbus_un_except(fid)<>INTEK.Modbus.Poll.fid) then Trouble(GotBug('Bad reply fid '+Str(fid))) else begin
   saddr:=INTEK.Modbus.Poll.saddr; quant:=INTEK.Modbus.Poll.quant;
   if modbus_decode_pdu('A',fid,dat,saddr,quant,raw)>0 then begin
    if (saddr<>INTEK.Modbus.Poll.saddr) then Trouble(GotBug('Bad reply saddr '+Str(saddr))) else
    if (quant<>INTEK.Modbus.Poll.quant) then Trouble(GotBug('Bad reply quant '+Str(quant))) else
    if modbus_is_except(fid) then begin
     Problem(GotBug('MODBUS EXCEPTION '+Str(modbus_ext_byte(raw,0))+' ON COMMAND '+Str(cid)));
    end else begin
     IncSummRate(INTEK.Modbus.Poll.Summ.Rx,INTEK.Modbus.Poll.Rate.Rx);
     INTEK_OnCommand(cid,fid,saddr,quant,raw);
    end;
   end else Trouble(GotBug('Bad PDU format '+modbus_errmsg(modbus_errno)));
  end;
  raw:='';
 end;
 //
 // Data handler on @Modbus.Poll event.
 // This procedure calls in simulation mode only.
 //
 procedure INTEK_OnSimPoll(ref,cid,tim,port,uid,fid:Integer; dat:String);
 var raw:String; saddr,quant,offs,addr,state,resrc:Integer; r:Real;
 begin
  raw:=''; // Check is coming reply corresponded to sent request
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>INTEK.Modbus.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>INTEK.Modbus.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>INTEK.Modbus.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>INTEK.Modbus.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if (modbus_un_except(fid)<>INTEK.Modbus.Poll.fid) then Trouble(GotBug('Bad reply fid '+Str(fid))) else begin
   saddr:=INTEK.Modbus.Poll.saddr; quant:=INTEK.Modbus.Poll.quant;
   if modbus_decode_pdu('R',fid,dat,saddr,quant,raw)>0 then begin
    if (saddr<>INTEK.Modbus.Poll.saddr) then Trouble(GotBug('Bad reply saddr '+Str(saddr))) else
    if (quant<>INTEK.Modbus.Poll.quant) then Trouble(GotBug('Bad reply quant '+Str(quant))) else begin
     if DebugFlagEnabled(dfDetails) then Details('Simulate polling '+Str(cid));
     if (cid=cm_ReadHRSys) then begin
      raw:=modbus_dump_int16(INTEK.SIM.ADDRESS,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(INTEK.SIM.CMDCTRL,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(INTEK.SIM.ACPTCNT,SwapModeInt32)
          +modbus_dump_int16(INTEK.SIM.FLPTCNT,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_ReadHRMeas) then begin
      raw:=modbus_dump_int16(INTEK.SIM.MEASCURR,SwapModeInt32)
          +modbus_dump_int16(INTEK.SIM.MEASVOLT,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_ReadHRSets) then begin
      raw:=modbus_dump_int16(INTEK.SIM.SETVOLT,SwapModeInt32)
          +modbus_dump_int16(INTEK.SIM.SETCURR,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_ReadHRCtrl) then begin
      raw:=modbus_dump_int16(INTEK.SIM.SETCTRL,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritAddress) then begin
      INTEK.SIM.ADDRESS:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritCmdCtrl) then begin
      INTEK.SIM.CMDCTRL:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritAcptCnt) then begin
      INTEK.SIM.ACPTCNT:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritFlptCnt) then begin
      INTEK.SIM.FLPTCNT:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritSetVolt) then begin
      INTEK.SIM.SETVOLT:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritSetCurr) then begin
      INTEK.SIM.SETCURR:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     if (cid=cm_WritSetCtrl) then begin
      INTEK.SIM.SETCTRL:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else
     DevSendCmd(devMySelf,modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,
                modbus_as_except(fid,true),Dump(Chr(modbus_er_ILLFUN))));
    end;
   end else Trouble(GotBug('Bad PDU format '+modbus_errmsg(modbus_errno)));
  end;
  raw:='';
 end;
 //
 // INTEK Driver Simulator mode polling.
 // This procedure calls in simulation mode only.
 //
 procedure INTEK_SIM_POLL;
 begin
  if INTEK.Simulator then begin
   if iGetTag(INTEK.POLL.ENABLE.tag)<>0 then begin
    INTEK.SIM.ACPTCNT:=INTEK.SIM.ACPTCNT+1;
    INTEK.SIM.MEASCURR:=Abs(INTEK.SIM.SETCURR+Round(Random(-1,2)));
    INTEK.SIM.MEASVOLT:=Abs(INTEK.SIM.SETVOLT+Round(Random(-1,2)));
    if INTEK.SIM.CMDCTRL<>0 then begin
     if mSecNow>=INTEK.SIM.Timeout+1000 then INTEK.SIM.CMDCTRL:=0;
    end else if INTEK.SIM.CMDCTRL=0 then if not isbit(INTEK.SIM.SETCTRL,4)
    then INTEK.SIM.Timeout:=mSecNow;
    if isbit(INTEK.SIM.SETCTRL,4) then begin
     if mSecNow>=INTEK.SIM.Timeout+1000 then INTEK.SIM.SETCTRL:=iSetBit(INTEK.SIM.SETCTRL,4,0);
    end else if not isbit(INTEK.SIM.SETCTRL,4) then if INTEK.SIM.CMDCTRL=0
    then INTEK.SIM.Timeout:=mSecNow;
   end;
  end;
  // Handle sensor clicks in simulator mode...
  if ClickButton=1 then begin
   if IsSameText(ClickSensor,'INTEK.SRC.CTRL.11') then
   INTEK.SIM.SETCTRL:=iSetBit(INTEK.SIM.SETCTRL,11,inot(iGetBit(INTEK.SIM.SETCTRL,11)));
   if IsSameText(ClickSensor,'INTEK.SRC.CTRL.12') then
   INTEK.SIM.SETCTRL:=iSetBit(INTEK.SIM.SETCTRL,12,inot(iGetBit(INTEK.SIM.SETCTRL,12)));
   if IsSameText(ClickSensor,'INTEK.SRC.CTRL.13') then
   INTEK.SIM.SETCTRL:=iSetBit(INTEK.SIM.SETCTRL,13,inot(iGetBit(INTEK.SIM.SETCTRL,13)));
  end;
 end;
 //
 // INTEK Driver GUI polling.
 //
 procedure INTEK_GUI_POLL;
 var s:String; ClickCurve,i,v:Integer; r:Real;
  //
  // Send to device (dev) command (cmd data) to set new tag value if one in range (min,max).
  //
  procedure DevSendCmdTag(dev,tag:Integer; cmd,data:String; min,max:Real);
  var v:Real;
  begin
   if IsRefTag(tag) then
   if IsRefDevice(dev) then
   if not IsEmptyStr(cmd) then
   if not IsEmptyStr(data) then
   if TypeTag(tag)<=2 then begin
    v:=rVal(data);
    if IsNaN(v) then Trouble(GotBug('Invalid tag edit')) else
    if (v<min) or (v>max) then Trouble(GotBug('Tag edit out of range')) else
    if TypeTag(tag)=1 then DevSendCmd(devMySelf,cmd+' '+Str(Round(v))) else
    if TypeTag(tag)=2 then DevSendCmd(devMySelf,cmd+' '+Trim(data));
   end else
   if TypeTag(tag)=3 then begin
    DevSendCmd(devMySelf,cmd+' '+Trim(data));
   end;
  end;
  //
  // Send command (cmd) to device (dev) on tag click.
  //
  procedure ClickTagDevSendCmd(tag,dev:Integer; cmd:String);
  begin
   if Length(cmd)>0 then
   if IsRefTag(tag) then
   if IsRefDevice(dev) then
   if ClickTag=tag then begin
    bNul(Voice(snd_Click));
    DevSendCmd(dev,cmd);
   end;
  end;
  //
  // Xor bit on click (local version).
  //
  procedure ClickTagXorLocal(tag,XorMask:Integer);
  var nv:Integer;
  begin
   if (ClickTag=tag) then begin
    bNul(iSetTagXor(tag,XorMask));
    bNul(Voice(snd_Click));
   end;
  end;
 begin
  s:='';
  //
  // Handle commands...
  //
  if iGetTag(INTEK.GUI.CMD.HELP.tag)<>0 then begin
   DevPostCmdLocal('@BrowseHelp '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
   bNul(iSetTag(INTEK.GUI.CMD.HELP.tag,0));
  end;
  if iGetTag(INTEK.GUI.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(INTEK.GUI.CMD.SAVEINI.tag,0));
   DevSendCmd(DevMySelf,'@SaveIni');
  end;
  if iGetTag(INTEK.GUI.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(INTEK.GUI.CMD.LOADINI.tag,0));
   DevSendCmd(DevMySelf,'@LoadIni');
  end;
  if iGetTag(INTEK.GUI.CMD.CONSOLE.tag)<>0 then begin
   bNul(iSetTag(INTEK.GUI.CMD.CONSOLE.tag,0));
   bNul(WinShow(ParamStr('Console '+DevName)));
   bNul(WinSelect(ParamStr('Console '+DevName)));
  end;
  //
  // Handle sensor clicks...
  //
  if ClickButton=1 then begin
   //
   // Buttons...
   //
   ClickTagXorLocal(INTEK.GUI.CMD.HELP.tag,1);
   ClickTagXorLocal(INTEK.GUI.CMD.SAVEINI.tag,1);
   ClickTagXorLocal(INTEK.GUI.CMD.LOADINI.tag,1);
   ClickTagXorLocal(INTEK.GUI.CMD.CONSOLE.tag,1);
   //ClickTagXorLocal(INTEK.GUI.CMD.TOOLS.tag,1);
   ClickTagXorLocal(INTEK.POLL.ENABLE.tag,1);
   //
   // Sensor clicks...
   //
   if IsSameText('@',Copy(ClickSensor,1,1)) then begin
    DevSendCmd(devMySelf,URL_Decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'INTEK.CMD.POWERON') then begin
    v:=iGetTag(INTEK.PARAM.SETCTRL.tag);
    v:=iSetBit(v,2,inot(iGetBit(v,2)));
    DevSendCmd(devMySelf,'@POWERON '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.CMD.SAVEROM') then begin
    v:=4369; DevSendCmd(devMySelf,'@SAVEROM '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.CMD.RESTART') then begin
    v:=26214; DevSendCmd(devMySelf,'@RESTART '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.RESET.ACPTCNT') then begin
    v:=0; DevSendCmd(devMySelf,'@RESACPTCNT '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.RESET.FLPTCNT') then begin
    v:=0; DevSendCmd(devMySelf,'@RESFLPTCNT '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.CMD.SETPROM') then begin
    v:=iGetTag(INTEK.PARAM.SETCTRL.tag); v:=iSetBit(v,4,1);
    DevSendCmd(devMySelf,'@SAVESETP '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.CMD.RESET') then begin
    v:=iGetTag(INTEK.PARAM.SETCTRL.tag);
    v:=iSetBit(v,11,0); v:=iSetBit(v,13,0);
    DevSendCmd(devMySelf,'@RESOVERHEAT '+str(v));
    DevSendCmd(devMySelf,'@RESMAXARCS '+str(v));
   end;
   if IsSameText(ClickSensor,'INTEK.PARAM') then begin     //Show parameters dialog
    if not IsEmptyStr(Copy(devname,2,12)+'PARAM') then begin
     Cron('@WinSelect '+Copy(devname,2,12)+'PARAM');
     bNul(Voice(snd_Wheel));
    end;
   end;
   //
   // Send command to edit on Click.
   //
   ClickTagDevSendCmd(INTEK.PARAM.ADDRESS.tag, devMySelf,'@Edit PARAM.ADDRESS');
   ClickTagDevSendCmd(INTEK.PARAM.SETVOLT.tag, devMySelf,'@Edit PARAM.SETVOLT');
   ClickTagDevSendCmd(INTEK.PARAM.SETCURR.tag, devMySelf,'@Edit PARAM.SETCURR');
   //
   // Tools menu
   //
   if ClickTag=INTEK.GUI.CMD.TOOLS.tag then begin
    if EditState=0 then begin
     if Pos('?',Edit('(Команда "Инструменты" '+DevName+'... ')
               +Edit(' Что выбираете:')
               +Edit(' '+MenuToolsItem(0))
               +Edit(' '+MenuToolsItem(1))
               +Edit(' '+MenuToolsItem(2))
               +Edit(' '+MenuToolsItem(3))
               +Edit(' '+MenuToolsItem(4))
               +Edit(' '+MenuToolsItem(5))
               +Edit(' '+MenuToolsItem(6))
               +Edit(' '+MenuToolsItem(7))
               +Edit(')MenuList MENU_'+NameTag(INTEK.GUI.CMD.TOOLS.tag)))>0
     then Warning('Error initializing MenuList!');
    end else Warning('Cannot edit right now!');
    INTEK.GUI.CMD.TOOLS.val:=-1;
   end;
   //
   // Plot & Tab windows
   //
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if IsRefCurve(ClickCurve) then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
  end;
  //
  // Handle right button clicks...
  //
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
  //
  // Edit tags...
  //
  if EditState=ef_Done then begin
   //CheckEditTagUpdate(INTEK..tag,0,_PlusInf);
   //
   // If tag edit complete, send command to apply changes
   //
   if CheckEditTag(INTEK.PARAM.ADDRESS.tag,s)
   then DevSendCmdTag(devMySelf,INTEK.PARAM.ADDRESS.tag,'@SETADDR',s,0,255);
   if CheckEditTag(INTEK.PARAM.SETVOLT.tag,s)
   then DevSendCmdTag(devMySelf,INTEK.PARAM.SETVOLT.tag,'@SETVOLT',s,0,30);
   if CheckEditTag(INTEK.PARAM.SETCURR.tag,s)
   then DevSendCmdTag(devMySelf,INTEK.PARAM.SETCURR.tag,'@SETCURR',s,0,3.3);
   {
   Warning.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Warning') then sNul(Edit(''));
   {
   Information.
   }
   if IsSameText(ExtractWord(1,edit('?ans 0')),'Information') then sNul(Edit(''));
   {
   TOOLS menu.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'MENU_'+NameTag(INTEK.GUI.CMD.TOOLS.tag)) then begin
    if Val(ExtractWord(2,Edit('?ans 0')))=1 then begin
     INTEK.GUI.CMD.TOOLS.val:=Val(Edit('?ans 1'));
     if INTEK.GUI.CMD.TOOLS.val>=0 then
     if (INTEK.GUI.CMD.TOOLS.val>10) then begin
      DevSendCmd(devMySelf,'@MenuToolsConfirmation '+UpCaseStr(StrReplace(StrReplace(
                 MenuToolsItem(Round(INTEK.GUI.CMD.TOOLS.val)),'  ',Dump(' '),3),'  ',Dump(' '),3)));
     end else begin
      MenuToolsCmnd(Round(INTEK.GUI.CMD.TOOLS.val));
      INTEK.GUI.CMD.TOOLS.val:=-1;
     end;
    end;
    sNul(Edit(''));
   end;
   {
   TOOLS menu (after confirmation).
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'YesNo_'+NameTag(INTEK.GUI.CMD.TOOLS.tag)) then begin
    if INTEK.GUI.CMD.TOOLS.val>=0 then
    if Val(ExtractWord(2,Edit('?ans 0')))=6 then MenuToolsCmnd(Round(INTEK.GUI.CMD.TOOLS.val));
    INTEK.GUI.CMD.TOOLS.val:=-1;
    sNul(Edit(''));
   end;
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
  s:='';
 end;
 //
 // INTEK Driver Command Cycle polling.
 //
 procedure INTEK_CMD_POLL;
  //
  // Send @Modbus.Poll ... command to &ModbusProxy and save sent request data in Modbus.Poll record.
  //
  procedure PollModbusProxy(cid:Integer);
  var dev,ref,tot,port,uid,fid,saddr,quant:Integer; dat:String;
  begin
   dat:='';
   ApplyCmdOpData(cid);
   if INTEK_CalcPDU(cid,fid,saddr,quant,dat) then begin
    dev:=devTheProxy; ref:=devMySelf; tot:=INTEK.Modbus.Timeout; port:=INTEK.Modbus.Port; uid:=INTEK.Modbus.UnitId;
    if DevSend(dev,modbus_proxy_poll('@Modbus.Poll',ref,cid,tot,port,uid,fid,dat)+CRLF)>0 then begin
     if DebugFlagEnabled(dfViewExp) then
     ViewExp('COM: '+modbus_proxy_nice('@Modbus.Poll',ref,cid,tot,port,uid,fid,dat,32));
     AssignModbusPoll(dev,cid,mSecNow,port,uid,fid,saddr,quant,dat);
     IncSummRate(INTEK.Modbus.Poll.Summ.Tx,INTEK.Modbus.Poll.Rate.Tx);
    end else begin
     Trouble(GotBug('Fail to send command '+Str(cid)));
     ClearModbusPoll;
    end;
   end else begin
    Trouble(GotBug('Fail to calc command '+Str(cid)));
    ClearModbusPoll;
   end;
   dat:='';
  end;
 begin
  if IsPortOpened then begin
   if IsValidCmdNum(INTEK.Modbus.Poll.cid) then begin
    //
    // Request in progress, waiting @Modbus.Reply/@Modbus.Refuse/@Modbus.Timeout.
    // Handle Deadline if was no responce for too long time: repeat polling again.
    //
    if iGetTag(INTEK.POLL.ENABLE.tag)<>0 then begin
     if (mSecNow>INTEK.Modbus.Poll.tim+INTEK.Modbus.Deadline) then begin
      Trouble(GotBug('Deadline detected, repeat polling again...'));
      PollModbusProxy(INTEK.Modbus.Poll.cid);
     end;
    end else if iGetTag(INTEK.POLL.ENABLE.tag)=0 then UpdateDo(do_STATE_INDIC,time,st_DISABLE);
   end else begin
    //
    // If request is cleared, send new @Modbus.Poll request by timer.
    //
    if iGetTag(INTEK.POLL.ENABLE.tag)<>0 then begin
     if (mSecNow>=INTEK.Modbus.Poll.tim+INTEK.Modbus.Polling) then begin
      INTEK.Modbus.Cmd.Num:=NextEnabledCmdNum(INTEK.Modbus.Cmd.Num);
      if IsEnabledCmdNum(INTEK.Modbus.Cmd.Num)
      then PollModbusProxy(INTEK.Modbus.Cmd.Num);
     end;
    end else if iGetTag(INTEK.POLL.ENABLE.tag)=0 then UpdateDo(do_STATE_INDIC,time,st_DISABLE);
   end;
   //
   // Update Poll Rate.
   //
   if SysTimer_Pulse(1000)>0 then begin
    UpdateDo(do_POLLRATERX,time,INTEK.Modbus.Poll.Rate.Rx);
    UpdateDo(do_POLLRATETX,time,INTEK.Modbus.Poll.Rate.Tx);
    UpdateDo(do_POLLRATEEX,time,INTEK.Modbus.Poll.Rate.Ex);
    UpdateDo(do_POLLSUMMRX,time,INTEK.Modbus.Poll.Summ.Rx);
    UpdateDo(do_POLLSUMMTX,time,INTEK.Modbus.Poll.Summ.Tx);
    UpdateDo(do_POLLSUMMEX,time,INTEK.Modbus.Poll.Summ.Ex);
    UpdateDo(do_ERRORCOUNT,time,GetErrCount(-1));
    if DebugFlagEnabled(dfStatist) then
    Success('PollRate: Rx='+Str(INTEK.Modbus.Poll.Rate.Rx)
                   +'  Tx='+Str(INTEK.Modbus.Poll.Rate.Tx)
                   +'  Ex='+Str(INTEK.Modbus.Poll.Rate.Ex));
    ClearModbusRate;
   end;
  end;
 end;
 //
 // INTEK tags initialization.
 //
 procedure INTEK_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(INTEK.GUI.CMD.HELP.tag,    Prefix+'.CMD.HELP',    1);
   InitTag(INTEK.GUI.CMD.SAVEINI.tag, Prefix+'.CMD.SAVEINI', 1);
   InitTag(INTEK.GUI.CMD.LOADINI.tag, Prefix+'.CMD.LOADINI', 1);
   InitTag(INTEK.GUI.CMD.CONSOLE.tag, Prefix+'.CMD.CONSOLE', 1);
   InitTag(INTEK.GUI.CMD.TOOLS.tag,   Prefix+'.CMD.TOOLS',   1);
   InitTag(INTEK.POLL.ENABLE.tag,     Prefix+'.POLL.ENABLE', 1);
   InitTag(INTEK.PARAM.ADDRESS.tag,   Prefix+'.ADDRESS',     1);
   InitTag(INTEK.PARAM.CMDCTRL.tag,   Prefix+'.CMDCTRL',     1);
   InitTag(INTEK.PARAM.DIAGNOS.tag,   Prefix+'.DIAGNOS',     1);
   InitTag(INTEK.PARAM.ACPTCNT.tag,   Prefix+'.ACPTCNT',     1);
   InitTag(INTEK.PARAM.MEASCURR.tag,  Prefix+'.MEAS.CURR',   2);
   InitTag(INTEK.PARAM.MEASVOLT.tag,  Prefix+'.MEAS.VOLT',   2);
   InitTag(INTEK.PARAM.SETVOLT.tag,   Prefix+'.SET.VOLT',    2);
   InitTag(INTEK.PARAM.SETCURR.tag,   Prefix+'.SET.CURR',    2);
   InitTag(INTEK.PARAM.SETCTRL.tag,   Prefix+'.SET.CTRL',    1);
  end;
 end;
 //
 // INTEK Driver cleanup.
 //
 procedure INTEK_Clear;
 begin
  INTEK.Simulator:=False;
  INTEK.Modbus.Port:=0;
  INTEK.Modbus.UnitId:=0;
  INTEK.Modbus.Timeout:=0;
  INTEK.Modbus.Polling:=0;
  INTEK.Modbus.Deadline:=0;
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  ClearCmdTable;
 end;
 //
 // INTEK Driver initialization...
 //
 procedure INTEK_Init;
 var r:integer;
 begin
  //
  // Read ini file variables
  //
  INTEK_InitTags(ReadIni('tagPrefix'));
  INTEK.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
  Success('Simulator='+Str(Ord(INTEK.Simulator)));
  INTEK.Modbus.Port:=iValDef(ReadIni('ModbusPort'),1);
  Success('ModbusPort='+Str(INTEK.Modbus.Port));
  INTEK.Modbus.UnitId:=iValDef(ReadIni('ModbusUnitId'),1);
  Success('ModbusUnitId='+Str(INTEK.Modbus.UnitId));
  INTEK.Modbus.Polling:=iValDef(ReadIni('ModbusPolling'),1000);
  Success('ModbusPolling='+Str(INTEK.Modbus.Polling));
  INTEK.Modbus.Timeout:=iValDef(ReadIni('ModbusTimeout'),250);
  Success('ModbusTimeout='+Str(INTEK.Modbus.Timeout));
  INTEK.Modbus.Deadline:=iValDef(ReadIni('ModbusDeadline'),60000);
  Success('ModbusDeadline='+Str(INTEK.Modbus.Deadline));
  INTEK.Modbus.DelayOnStart:=iValDef(ReadIni('DelayOnStart'),1000);
  Success('DelayOnStart='+Str(INTEK.Modbus.DelayOnStart));
  INTEK.SIM.ADDRESS:=iValDef(ReadIni('ModbusUnitId'),247);
  INTEK.SIM.CMDCTRL:=0;
  INTEK.SIM.ACPTCNT:=0;
  INTEK.SIM.FLPTCNT:=0;
  INTEK.SIM.MEASCURR:=0;
  INTEK.SIM.MEASVOLT:=0;
  INTEK.SIM.SETCURR:=0;
  INTEK.SIM.SETVOLT:=0;
  INTEK.SIM.SETCTRL:=8;
  INTEK.SIM.Timeout:=0;
  //
  // Initialize Cmd command table & clear Poll record.
  //
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  InitCmdTable;
 end;
 //
 // INTEK Driver Finalization.
 //
 procedure INTEK_Free;
 begin
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  ClearCmdTable;
 end;
 //
 // INTEK Driver Polling.
 //
 procedure INTEK_Poll;
 begin
  INTEK_GUI_POLL;
  if mSecNow-FixmSecNow>INTEK.Modbus.DelayOnStart then
  if IsPortOpened then begin
   if INTEK.Simulator
   then INTEK_SIM_POLL;
   INTEK_CMD_POLL;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetLibrary;
  INTEK_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  StdIn_SetScripts('@StartupScript','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  InitNetLibrary;
  INTEK_Init;
  cmd_ClearModbusSumm       := RegisterStdInCmd('@ClearModbusSumm',       '');
  cmd_Edit                  := RegisterStdInCmd('@Edit',                  '');
  cmd_MenuToolsConfirmation := RegisterStdInCmd('@MenuToolsConfirmation', '');
  cmd_LoadIni               := RegisterStdInCmd('@LoadIni',               '');
  cmd_SaveIni               := RegisterStdInCmd('@SaveIni',               '');
  cmd_SetAddr               := RegisterStdInCmd('@SetAddr',               '');
  cmd_SetVolt               := RegisterStdInCmd('@SetVolt',               '');
  cmd_SetCurr               := RegisterStdInCmd('@SetCurr',               '');
  cmd_PowerOn               := RegisterStdInCmd('@PowerOn',               '');
  cmd_SaveROM               := RegisterStdInCmd('@SaveROM',               '');
  cmd_Restart               := RegisterStdInCmd('@Restart',               '');
  cmd_Reset                 := RegisterStdInCmd('@Reset',                 '');
  cmd_ResAcptCnt            := RegisterStdInCmd('@ResAcptCnt',            '');
  cmd_ResFlptCnt            := RegisterStdInCmd('@ResFlptCnt',            '');
  cmd_SaveSetp              := RegisterStdInCmd('@SaveSetp',              '');
  cmd_ResOverheat           := RegisterStdInCmd('@ResOverheat',           '');
  cmd_ResMaxArcs            := RegisterStdInCmd('@ResMaxArcs',            '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  FreeNetLibrary;
  INTEK_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetLibrary;
  INTEK_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,dat:String; cmdid:Integer; ref,cid,tim,port,uid,fid:Integer; ms,v:Real;
  //
  // Update device parameters by ini-file load
  //
  procedure UpdateINTEKPar(n:Integer);
  begin
   if (n>=1) and (n<=MaxCmdNum) then begin
    if n=cm_WritSetVolt then
    DevSendCmd(DevMySelf,'@SETVOLT '+str(rGetTag(INTEK.PARAM.SETVOLT.tag)));
    if n=cm_WritSetCurr then
    DevSendCmd(DevMySelf,'@SETCURR '+str(rGetTag(INTEK.PARAM.SETCURR.tag)));
    if n=cm_WritSetCtrl then
    DevSendCmd(DevMySelf,'@POWERON '+str(iGetTag(INTEK.PARAM.SETCTRL.tag)));
   end;
  end;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  dat:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Modbus.Reply ref cid tim port uid fid $$dat
   }
   if (cmdid=cmd_NetModbusReply) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then INTEK_OnReply(ref,cid,tim,port,uid,fid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    ClearModbusPoll;
    Data:='';
   end else
   {
   @Modbus.Poll ref cid tim port uid fid $$dat
   This message uses in simulation mode only
   }
   if (cmdid=cmd_NetModbusPoll) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then INTEK_OnSimPoll(ref,cid,tim,port,uid,fid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    Data:='';
   end else
   {
   @Modbus.Refuse ...
   }
   if (cmdid=cmd_NetModbusRefuse) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Trouble(GotBug(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,0)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_STATE_INDIC,time,st_REFUSE);
    ClearModbusPoll;
    Data:='';
   end else
   {
   @Modbus.Timeout ...
   }
   if (cmdid=cmd_NetModbusTimeout) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Problem(GotBug(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,64)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_STATE_INDIC,time,st_TIMEOUT);
    ClearModbusPoll;
    Data:='';
   end else
   {
   @ClearModbusSumm
   }
   if (cmdid=cmd_ClearModbusSumm) then begin
    ClearModbusSumm;
    Data:='';
   end else
   {
   @SETADDR 1
   }
   if (cmdid=cmd_SetAddr) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritAddress,v);
    Data:='';
   end else
   {
   @RESET 257
   }
   if (cmdid=cmd_Reset) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritCmdCtrl,v);
    Data:='';
   end else
   {
   @SAVEROM 4369
   }
   if (cmdid=cmd_SaveROM) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritCmdCtrl,v);
    Data:='';
   end else
   {
   @RESTART 26214
   }
   if (cmdid=cmd_Restart) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritCmdCtrl,v);
    Data:='';
   end else
   {
   @RESACPTCNT 0
   }
   if (cmdid=cmd_ResAcptCnt) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritAcptCnt,v);
    Data:='';
   end else
   {
   @RESFLPTCNT 0
   }
   if (cmdid=cmd_ResFlptCnt) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritFlptCnt,v);
    Data:='';
   end else
   {
   @SETVOLT 1
   }
   if (cmdid=cmd_SetVolt) then begin
    v:=rVal(ExtractWord(1,arg));
    v:=v*10;
    if not IsNan(v) then HoldCmdOpData(cm_WritSetVolt,v);
    Data:='';
   end else
   {
   @SETCURR 1
   }
   if (cmdid=cmd_SetCurr) then begin
    v:=rVal(ExtractWord(1,arg));
    v:=v*100;
    if not IsNan(v) then HoldCmdOpData(cm_WritSetCurr,v);
    Data:='';
   end else
   {
   @POWERON 1
   }
   if (cmdid=cmd_PowerOn) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritSetCtrl,v);
    Data:='';
   end else
   {
   @SAVESETP 1
   }
   if (cmdid=cmd_SaveSetp) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritSetCtrl,v);
    Data:='';
   end else
   {
   @RESOVERHEAT 0
   }
   if (cmdid=cmd_ResOverheat) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritSetCtrl,v);
    Data:='';
   end else
   {
   @RESMAXARCS 0
   }
   if (cmdid=cmd_ResMaxArcs) then begin
    v:=rVal(ExtractWord(1,arg));
    if not IsNan(v) then HoldCmdOpData(cm_WritSetCtrl,v);
    Data:='';
   end else
   {
   @Edit PARAM.SETVOLT
   }
   if (cmdid=cmd_Edit) then begin
    if IsSameText(ExtractWord(1,arg),'PARAM.ADDRESS')
    then StartEditTag(INTEK.PARAM.ADDRESS.tag,'Задание сетевого адреса, 1-247');
    if IsSameText(ExtractWord(1,arg),'PARAM.SETVOLT')
    then StartEditTag(INTEK.PARAM.SETVOLT.tag,'Уставка стабилизации HV, от 0 до 30 кВ');
    if IsSameText(ExtractWord(1,arg),'PARAM.SETCURR')
    then StartEditTag(INTEK.PARAM.SETCURR.tag,'Уставка ограничения тока, от 0 до 3.3 мА');
    Data:='';
   end else
   {
   @MenuToolsConfirmation
   }
   if (cmdid=cmd_MenuToolsConfirmation) then begin
    if INTEK.GUI.CMD.TOOLS.val>=0 then
    if EditState=0 then begin
    if Pos('?',Edit('(Вы действительно хотите:')
              +Edit(' ')
              +Edit(' '+arg)
              +Edit(' ')
              +Edit(' Эта операция может вызвать проблемы!')
              +Edit(')YesNo YesNo_'+NameTag(INTEK.GUI.CMD.TOOLS.tag)))>0
     then Problem('Could not initialize dialog!');
    end else Problem('Could not initialize dialog!');
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid=cmd_LoadIni) then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    UpdateINTEKPar(cm_WritSetVolt);
    UpdateINTEKPar(cm_WritSetCurr);
    UpdateINTEKPar(cm_WritSetCtrl);
    Data:='';
   end else
   {
   @SaveIni
   }
   if (cmdid=cmd_SaveIni) then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  dat:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
