@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ******************************
rem GENDC devices config generator
rem GENDC are GEN DC by TDK-Lambda
rem ******************************

chcp 65001

:Main
call :InitializeVariables
pushd "%~dp0" && call :GenDcDevices
popd
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set tabcrc=..\Circuits\%~n0.crc
set devmsg=devPostMsg
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=450
set /a CTRL_TOP_STEP=50
set /a MAIN_HEIGHT=160
set /a MAIN_H_STEP=50
set /a TABCRC_TOP=0
set /a TABCRC_STEP=50
set MAIN_CTRL=GENDC.MAIN.CTRL
set PARAM_PLOT=GENDC.PARAM.PLOT
set STATE_PLOT=GENDC.STATE.PLOT
goto :EOF

:GenDcDevices
call :DeleteFiles %hdwcfg% %simcfg% %diccfg% %discfg% %tabcrc%
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::: Device  Facility    Identitier PortNum Address Polling  Model
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
call :GENDC   DEMO.GENDC  GEN1       1       6       20       "LAMBDA,GEN6-100"
call :GENDC   DEMO.GENDC  GEN2       2       6       20       "LAMBDA,GEN6-200"
call :GENDC   DEMO.GENDC  GEN3       3       6       20       "LAMBDA,GEN8-90"
::call :GENDC   DEMO.GENDC  GEN4       4       6       20       "LAMBDA,GEN8-180"
::call :GENDC   DEMO.GENDC  GEN5       5       6       20       "LAMBDA,GEN12.5-60"
::call :GENDC   DEMO.GENDC  GEN6       6       6       20       "LAMBDA,GEN12.5-120"
::call :GENDC   DEMO.GENDC  GEN7       7       6       20       "LAMBDA,GEN20-38"
::call :GENDC   DEMO.GENDC  GEN8       8       6       20       "LAMBDA,GEN20-76"
::call :GENDC   DEMO.GENDC  GEN9       9       6       20       "LAMBDA,GEN600-25"
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
call :GENDC_DONE >> %hdwcfg%
type %hdwcfg% %simcfg%
goto :EOF

:GENDC_DONE
echo.
echo [^&CronSrv.StartupScript]
echo @cron.job %MAIN_CTRL%.HOME @async @async @WinDraw %MAIN_CTRL%^|Height=%MAIN_HEIGHT%
echo []
echo.
goto :EOF

:GENDC
call :GENDC_HDW %* >> %hdwcfg%
call :GENDC_SIM %* >> %simcfg%
call :GENDC_DIC %* >> %diccfg%
call :GENDC_DIS %* >> %discfg%
call :GENDC_TABCRC >> %tabcrc%
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a MAIN_HEIGHT+=MAIN_H_STEP
goto :EOF

:GENDC_HDW
set "FACN=%~1"       & shift    & :: Facility name
set "IDEN=%~1"       & shift    & :: Device identifier name
set "ComPort=%~1"    & shift    & :: COM port number
set "ComAddr=%~1"    & shift    & :: COM port device address
set "ComPolling=%~1" & shift    & :: COM port polling period, ms
set "ModelName=%~1"  & shift    & :: Device model name
set "FACP=%FACN:.=/%"           & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"           & :: Facility file name, i.e. FACN name with . to _ replacement
echo ;**********************
echo ; GENDC Driver for %IDEN%
echo ;**********************
echo.
echo [SerialPort-COM%ComPort%]
echo Port     = COM%ComPort%
echo BaudRate = 9600
echo Parity   = NONE
echo DataBits = 8
echo StopBits = 1
echo []
echo.
echo [TagList]
echo %FACN%.%IDEN%.POLL_ENABLE = integer 0               ; Enable polling flag
echo %FACN%.%IDEN%.DIMGUICLICK = string  ?               ; The DIM click sensor data
echo %FACN%.%IDEN%.POLL_RATE   = real    0               ; Polling rate, poll/sec
echo %FACN%.%IDEN%.ERROR_CNT   = real    0               ; Device error counter
echo %FACN%.%IDEN%.ID_NAME     = string  %IDEN%          ; Device identifier string
echo %FACN%.%IDEN%.ID_IDN      = string  ?               ; Device model identifier, e.g. LAMBDA,GEN6-100
echo %FACN%.%IDEN%.ID_REV      = string  ?               ; Software revision, e.g. Ver 6-33 1.0
echo %FACN%.%IDEN%.ID_SN       = string  ?               ; Serial number, e.g. 011B431-0003
echo %FACN%.%IDEN%.ID_DATE     = string  ?               ; Date of last test, e.g. 2019/06/25
echo %FACN%.%IDEN%.PAR_PV      = real    0               ; Program Voltage (set)
echo %FACN%.%IDEN%.PAR_MV      = real    0               ; Measure Voltage, Volt
echo %FACN%.%IDEN%.PAR_MW      = real    0               ; Measure Watts (calculated as MV*MC)
echo %FACN%.%IDEN%.PAR_PC      = real    0               ; Program Current (set)
echo %FACN%.%IDEN%.PAR_MC      = real    0               ; Measure Current, Amper
echo %FACN%.%IDEN%.PAR_SR      = integer 0               ; Status Condition Register
echo %FACN%.%IDEN%.PAR_FR      = integer 0               ; Fault  Condition Register
echo %FACN%.%IDEN%.PAR_OVP     = real    0               ; Setting   OverVoltage  Protection
echo %FACN%.%IDEN%.PAR_UVL     = real    0               ; Setting   UnderVoltage Limit
echo %FACN%.%IDEN%.BT_OUT      = integer 0               ; BuTton OUTput    : bit0/1=button/state
echo %FACN%.%IDEN%.BT_FLD      = integer 0               ; BuTton FoLDback  : bit0/1=button/state
echo %FACN%.%IDEN%.BT_AST      = integer 0               ; BuTton AutoSTart : bit0/1=button/state
echo %FACN%.%IDEN%.PAR_RMT     = integer 0               ; Remote mode: 0/1/2=LOC/REM/LLO
echo %FACN%.%IDEN%.PAR_MODE    = integer 0               ; Operation mode: 0/1/2=OFF/CV/CC
echo %FACN%.%IDEN%.PAR_SENA    = integer 0               ; Status Enable Register
echo %FACN%.%IDEN%.PAR_SEVE    = integer 0               ; Status Event  Register
echo %FACN%.%IDEN%.PAR_FENA    = integer 0               ; Fault  Enable Register
echo %FACN%.%IDEN%.PAR_FEVE    = integer 0               ; Fault  Event  Register
echo %FACN%.%IDEN%.PAR_SRQ     = real    0               ; SRQ counter - service request counter
echo %FACN%.%IDEN%.RATE_A      = real    1               ; Current ramping rate, Amper/sec
echo %FACN%.%IDEN%.RATE_V      = real    1               ; Voltage ramping rate, Volt/sec
echo %FACN%.%IDEN%.RAMP_A      = integer 0               ; Current ramping state
echo %FACN%.%IDEN%.RAMP_V      = integer 0               ; Voltage ramping state
echo []
echo.
echo [DataStorage]
echo %FACN%.%IDEN%.POLL_RATE   = Curve 0 10 Black 15 1   ; Polling rate, poll/sec
echo %FACN%.%IDEN%.ERROR_CNT   = Curve 0 10 Black 15 1   ; Device error counter
echo %FACN%.%IDEN%.PAR_PV      = Curve 0 10 Black 15 1   ; Program Voltage (set)
echo %FACN%.%IDEN%.PAR_MV      = Curve 0 10 Black 15 1   ; Measure Voltage, Volt
echo %FACN%.%IDEN%.PAR_PC      = Curve 0 10 Black 15 1   ; Program Current (set)
echo %FACN%.%IDEN%.PAR_MC      = Curve 0 10 Black 15 1   ; Measure Current, Amper
echo %FACN%.%IDEN%.PAR_MW      = Curve 0 10 Black 15 1   ; Measure Watts (calculated as MV*MC)
echo %FACN%.%IDEN%.PAR_SR      = Curve 0 10 Black 15 1   ; Status Condition Register
echo %FACN%.%IDEN%.PAR_FR      = Curve 0 10 Black 15 1   ; Faults Condition Register
echo %FACN%.%IDEN%.BT_OUT      = Curve 0 10 Black 15 1   ; BuTton OUTput    : bit0/1=button/state
echo %FACN%.%IDEN%.BT_FLD      = Curve 0 10 Black 15 1   ; BuTton FoLDback  : bit0/1=button/state
echo %FACN%.%IDEN%.BT_AST      = Curve 0 10 Black 15 1   ; BuTton AutoSTart : bit0/1=button/state
echo %FACN%.%IDEN%.PAR_OVP     = Curve 0 10 Black 15 1   ; Setting   OverVoltage  Protection
echo %FACN%.%IDEN%.PAR_UVL     = Curve 0 10 Black 15 1   ; Setting   UnderVoltage Limit
echo %FACN%.%IDEN%.PAR_RMT     = Curve 0 10 Black 15 1   ; Remote mode: 0/1/2=LOC/REM/LLO
echo %FACN%.%IDEN%.PAR_MODE    = Curve 0 10 Black 15 1   ; Operation mode: 0/1/2=OFF/CV/CC
echo %FACN%.%IDEN%.PAR_FENA    = Curve 0 10 Black 15 1   ; Fault  Enable Register
echo %FACN%.%IDEN%.PAR_FEVE    = Curve 0 10 Black 15 1   ; Fault  Event  Register
echo %FACN%.%IDEN%.PAR_SENA    = Curve 0 10 Black 15 1   ; Status Enable Register
echo %FACN%.%IDEN%.PAR_SEVE    = Curve 0 10 Black 15 1   ; Status Event  Register
echo %FACN%.%IDEN%.PAR_SRQ     = Curve 0 10 Black 15 1   ; SRQ counter - service request counter
echo []
echo.
echo [DeviceList]
echo ^&%FACN%.%IDEN%.CTRL = device software program
echo [^&%FACN%.%IDEN%.CTRL]
echo Comment        = Hardware driver for GEN DC power supply %IDEN%.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpHigher
echo ProgramSource  = ..\DaqPas\gendc_drv.pas
echo StartupScript  = [^&%FACN%.%IDEN%.CTRL.StartupScript]
echo FinallyScript  = [^&%FACN%.%IDEN%.CTRL.FinallyScript]
echo DigitalFifo    = 1024
echo AnalogFifo     = 1024
echo DebugFlags     = 3
echo OpenConsole    = 2
echo Simulator      = 0
echo ComPort        = %ComPort%
echo ComAddr        = %ComAddr%
echo ComTimeOut     = 250
echo ComTimeGap     = 0
echo ComUseCheckSum = 1
echo ComInterface   = RS232
echo PollPeriod     = %ComPolling%
echo ModelName      = %ModelName%
echo tagPrefix      = %FACN%.%IDEN%
echo HelpFile       = ..\Help\gendc.htm
echo EncryptMethod  = RC6
echo TrustedUsers   = [TrustedUsers]
echo AnalogOutputs  = 21
echo Link AnalogOutput  0 with curve %FACN%.%IDEN%.POLL_RATE    history 1000
echo Link AnalogOutput  1 with curve %FACN%.%IDEN%.ERROR_CNT    history 1000
echo Link AnalogOutput  2 with curve %FACN%.%IDEN%.PAR_MC       history 1000
echo Link AnalogOutput  3 with curve %FACN%.%IDEN%.PAR_MV       history 1000
echo Link AnalogOutput  4 with curve %FACN%.%IDEN%.PAR_MW       history 1000
echo Link AnalogOutput  5 with curve %FACN%.%IDEN%.PAR_PC       history 1000
echo Link AnalogOutput  6 with curve %FACN%.%IDEN%.PAR_PV       history 1000
echo Link AnalogOutput  7 with curve %FACN%.%IDEN%.PAR_SR       history 1000
echo Link AnalogOutput  8 with curve %FACN%.%IDEN%.PAR_FR       history 1000
echo Link AnalogOutput  9 with curve %FACN%.%IDEN%.BT_OUT       history 1000
echo Link AnalogOutput 10 with curve %FACN%.%IDEN%.BT_FLD       history 1000
echo Link AnalogOutput 11 with curve %FACN%.%IDEN%.BT_AST       history 1000
echo Link AnalogOutput 12 with curve %FACN%.%IDEN%.PAR_OVP      history 1000
echo Link AnalogOutput 13 with curve %FACN%.%IDEN%.PAR_UVL      history 1000
echo Link AnalogOutput 14 with curve %FACN%.%IDEN%.PAR_RMT      history 1000
echo Link AnalogOutput 15 with curve %FACN%.%IDEN%.PAR_MODE     history 1000
echo Link AnalogOutput 16 with curve %FACN%.%IDEN%.PAR_FENA     history 1000
echo Link AnalogOutput 17 with curve %FACN%.%IDEN%.PAR_FEVE     history 1000
echo Link AnalogOutput 18 with curve %FACN%.%IDEN%.PAR_SENA     history 1000
echo Link AnalogOutput 19 with curve %FACN%.%IDEN%.PAR_SEVE     history 1000
echo Link AnalogOutput 20 with curve %FACN%.%IDEN%.PAR_SRQ      history 1000
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%FACN%.%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FACF%_%IDEN%_Custom.Ini
echo CustomIniSection  = [%FACN%.%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FACF%_%IDEN%_Custom.ini
echo []
echo [%FACN%.%IDEN%.CustomParameters.TagList]
echo TagList = %FACN%.%IDEN%.POLL_ENABLE
echo TagList = %FACN%.%IDEN%.PAR_PC
echo TagList = %FACN%.%IDEN%.PAR_PV
echo TagList = %FACN%.%IDEN%.BT_FLD
echo TagList = %FACN%.%IDEN%.BT_AST
echo TagList = %FACN%.%IDEN%.BT_OUT
echo TagList = %FACN%.%IDEN%.PAR_OVP
echo TagList = %FACN%.%IDEN%.PAR_UVL
echo TagList = %FACN%.%IDEN%.PAR_FENA
echo TagList = %FACN%.%IDEN%.PAR_SENA
echo TagList = %FACN%.%IDEN%.RATE_A
echo TagList = %FACN%.%IDEN%.RATE_V
echo []
echo [^&%FACN%.%IDEN%.CTRL.StartupScript]
echo @cron @cron.tab %FACN%.%IDEN%.CTRL.StartupLoadIni 0 0 0
echo @cron @cron.pul %FACN%.%IDEN%.CTRL.StartupLoadIni 3000 1
echo @cron @cron.job %FACN%.%IDEN%.CTRL.StartupLoadIni @DevPostMsg ^&%FACN%.%IDEN%.CTRL @LoadIni
echo @cron @cron.job %FACN%.%IDEN%.CTRL.StartupLoadIni @cron.del %FACN%.%IDEN%.CTRL.StartupLoadIni
echo []
echo [^&%FACN%.%IDEN%.CTRL.FinallyScript]
echo []
echo.
echo [Windows]
echo %FACN%.%IDEN%.CTRL = Circuit_Window 
echo [%FACN%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\gendc_ctrl.crc
echo Link sensor POLL_ENABLE       with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor POLL_MEMO         with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_NAME           with tag   %FACN%.%IDEN%.ID_NAME     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_IDN            with tag   %FACN%.%IDEN%.ID_IDN      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_REV            with tag   %FACN%.%IDEN%.ID_REV      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_SN             with tag   %FACN%.%IDEN%.ID_SN       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ID_DATE           with tag   %FACN%.%IDEN%.ID_DATE     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor POLL_RATE         with curve %FACN%.%IDEN%.POLL_RATE   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor ERROR_CNT         with curve %FACN%.%IDEN%.ERROR_CNT   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_MC            with curve %FACN%.%IDEN%.PAR_MC      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_MV            with curve %FACN%.%IDEN%.PAR_MV      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_MW            with curve %FACN%.%IDEN%.PAR_MW      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PC            with tag   %FACN%.%IDEN%.PAR_PC      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_PV            with tag   %FACN%.%IDEN%.PAR_PV      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR            with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.0          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.1          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.2          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.3          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.4          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.5          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.6          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SR.7          with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR            with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.0          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.1          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.2          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.3          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.4          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.5          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.6          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FR.7          with curve %FACN%.%IDEN%.PAR_FR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_FENA          with tag   %FACN%.%IDEN%.PAR_FENA    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SENA          with tag   %FACN%.%IDEN%.PAR_SENA    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_MODE          with curve %FACN%.%IDEN%.PAR_MODE    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_RMT           with curve %FACN%.%IDEN%.PAR_RMT     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_SRQ           with curve %FACN%.%IDEN%.PAR_SRQ     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor BT_FLD            with tag   %FACN%.%IDEN%.BT_FLD      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor BT_AST            with tag   %FACN%.%IDEN%.BT_AST      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor BT_OUT            with tag   %FACN%.%IDEN%.BT_OUT      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_OVP           with tag   %FACN%.%IDEN%.PAR_OVP     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor PAR_UVL           with tag   %FACN%.%IDEN%.PAR_UVL     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor RATE_A            with tag   %FACN%.%IDEN%.RATE_A      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor RATE_V            with tag   %FACN%.%IDEN%.RATE_V      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor RAMP_A            with tag   %FACN%.%IDEN%.RAMP_A      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor RAMP_V            with tag   %FACN%.%IDEN%.RAMP_V      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @BrowseHelp                                       with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@LoadIni                                  with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@SaveIni                                  with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @OpenConsole                                      with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @MenuToolsOpen                                    with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@Setting+RST                              with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@Setting+OVM                              with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor @Remote+@Setting+UVL+0                            with device ^&%FACN%.%IDEN%.CTRL
echo Link sensor DIM+FallBack+Mode with tag   ^&DimSrv.FallBackMode     device ^&%FACN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinShow %FACN%.%IDEN%.CTRL
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=670^|Height=312
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SHOW @WinShow %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HIDE @WinHide %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SELECT @WinSelect %FACN%.%IDEN%.CTRL
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.CTRL.HOME
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.CTRL.HIDE
echo []
echo.
echo [%MAIN_CTRL%]
echo Link sensor %IDEN%.CTRL        with                                 device ^&%MAIN_CTRL%
echo Link sensor %IDEN%.POLL_ENABLE with tag   %FACN%.%IDEN%.POLL_ENABLE device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.POLL_RATE   with curve %FACN%.%IDEN%.POLL_RATE   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_MC      with curve %FACN%.%IDEN%.PAR_MC      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_MV      with curve %FACN%.%IDEN%.PAR_MV      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_MW      with curve %FACN%.%IDEN%.PAR_MW      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_PC      with tag   %FACN%.%IDEN%.PAR_PC      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_PV      with tag   %FACN%.%IDEN%.PAR_PV      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.RAMP_A      with tag   %FACN%.%IDEN%.RAMP_A      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.RAMP_V      with tag   %FACN%.%IDEN%.RAMP_V      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_MODE    with curve %FACN%.%IDEN%.PAR_MODE    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.PAR_SR.2    with curve %FACN%.%IDEN%.PAR_SR      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %IDEN%.BT_OUT      with tag   %FACN%.%IDEN%.BT_OUT      device ^&%FACN%.%IDEN%.CTRL
echo []
echo.
echo [%PARAM_PLOT%]
echo CurveList = %FACN%.%IDEN%.PAR_MC
echo CurveList = %FACN%.%IDEN%.PAR_MV
echo CurveList = %FACN%.%IDEN%.PAR_MW
echo CurveList = %FACN%.%IDEN%.PAR_PC
echo CurveList = %FACN%.%IDEN%.PAR_PV
echo CurveList = %FACN%.%IDEN%.PAR_OVP
echo CurveList = %FACN%.%IDEN%.PAR_UVL
echo []
echo.
echo [%STATE_PLOT%]
echo CurveList = %FACN%.%IDEN%.POLL_RATE
echo CurveList = %FACN%.%IDEN%.ERROR_CNT
echo CurveList = %FACN%.%IDEN%.PAR_SR
echo CurveList = %FACN%.%IDEN%.PAR_FR
echo CurveList = %FACN%.%IDEN%.BT_OUT
echo CurveList = %FACN%.%IDEN%.BT_FLD
echo CurveList = %FACN%.%IDEN%.BT_AST
echo CurveList = %FACN%.%IDEN%.PAR_RMT
echo CurveList = %FACN%.%IDEN%.PAR_MODE
echo CurveList = %FACN%.%IDEN%.PAR_FENA
echo CurveList = %FACN%.%IDEN%.PAR_FEVE
echo CurveList = %FACN%.%IDEN%.PAR_SENA
echo CurveList = %FACN%.%IDEN%.PAR_SEVE
echo CurveList = %FACN%.%IDEN%.PAR_SRQ
echo []
echo.
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.PAR_MC
echo CurveList = %FACN%.%IDEN%.PAR_MV
echo CurveList = %FACN%.%IDEN%.PAR_MW
echo CurveList = %FACN%.%IDEN%.PAR_PC
echo CurveList = %FACN%.%IDEN%.PAR_PV
echo CurveList = %FACN%.%IDEN%.PAR_OVP
echo CurveList = %FACN%.%IDEN%.PAR_UVL
echo CurveList = %FACN%.%IDEN%.POLL_RATE
echo CurveList = %FACN%.%IDEN%.ERROR_CNT
echo CurveList = %FACN%.%IDEN%.PAR_SR
echo CurveList = %FACN%.%IDEN%.PAR_FR
echo CurveList = %FACN%.%IDEN%.BT_OUT
echo CurveList = %FACN%.%IDEN%.BT_FLD
echo CurveList = %FACN%.%IDEN%.BT_AST
echo CurveList = %FACN%.%IDEN%.PAR_RMT
echo CurveList = %FACN%.%IDEN%.PAR_MODE
echo CurveList = %FACN%.%IDEN%.PAR_FENA
echo CurveList = %FACN%.%IDEN%.PAR_FEVE
echo CurveList = %FACN%.%IDEN%.PAR_SENA
echo CurveList = %FACN%.%IDEN%.PAR_SEVE
echo CurveList = %FACN%.%IDEN%.PAR_SRQ
echo []
goto :EOF

:GENDC_SIM 
if "%numhdwcfg%" == "0" ( call :GENDC_SIM_ONCE & set /a numhdwcfg+=1 )
set /a ComPair=ComPort+10
echo [DeviceList]
echo ^&%FACN%.%IDEN%.SIM = device software program
echo [^&%FACN%.%IDEN%.SIM]
echo Comment        = Simulation for GEN DC power supply %IDEN%.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpNormal
echo ProgramSource  = ..\DaqPas\gendc_drv.pas
echo StartupScript  = [^&%FACN%.%IDEN%.SIM.StartupScript]
echo FinallyScript  = [^&%FACN%.%IDEN%.SIM.FinallyScript]
echo DebugFlags     = 3
echo OpenConsole    = 2
echo Simulator      = 1
echo ComPort        = %ComPair%
echo ComAddr        = %ComAddr%
echo ComTimeOut     = 250
echo ComTimeGap     = 20
echo PollPeriod     = %ComPolling%
echo ModelName      = %ModelName%
echo tagPrefix      = %FACN%.%IDEN%
echo []
echo [^&%FACN%.%IDEN%.SIM.StartupScript]
echo @Simulate OHM 1.0 ; Simulate Output Resistance, Ohm
echo @Simulate NLP 0.1 ; Simulate Noise Level in Percent
echo []
echo [^&%FACN%.%IDEN%.SIM.FinallyScript]
echo []
echo.
echo [SerialPort-COM%ComPort%]
echo PipeName    = %IDEN%.com%ComPort%.sim
echo PipePolling = 1, tpHighest
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo [SerialPort-COM%ComPair%]
echo PipeName    = .\%IDEN%.com%ComPort%.sim
echo PipePolling = 1, tpHighest
echo TimeOut     = 1000
echo FifoSize    = 16
echo []
echo.
goto :EOF
:GENDC_SIM_ONCE
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:GENDC_TABCRC
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.CTRL
echo [%IDEN%.CTRL]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Size:28\Style:[Bold]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_6_28_4_aqua_ptmono.bmp %IDEN%
echo Hint = %IDEN%.CTRL: Источник питания %IDEN%.
echo []
echo.
echo [Circuit.StartupScript]
echo %IDEN%_poll_enab = 0
echo %IDEN%_poll_rate = 0
echo %IDEN%_poll_norm = 5
echo %IDEN%_poll_gtrz = 0
echo %IDEN%_poll_good = 0
echo %IDEN%_ramping_a = 0
echo %IDEN%_ramping_v = 0
echo %IDEN%_par_mode  = 0
echo %IDEN%_par_rmt   = 0
echo %IDEN%_bt_out    = 0
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.PAR_PC
echo [%IDEN%.PAR_PC]
echo Pos = 150, %YPOS%
echo LED = 7, 0, 3, %%7.3f, Name:PT_Mono\Size:13\Style:[Bold]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_white_ptmono.bmp
echo Hint = %IDEN%.PAR_PC - Уставка тока, Ампер (Program Current).
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.PAR_PV
echo [%IDEN%.PAR_PV]
echo Pos = 150, %YPOS%
echo LED = 7, 0, 3, %%7.3f, Name:PT_Mono\Size:13\Style:[Bold]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_white_ptmono.bmp
echo Hint = %IDEN%.PAR_PV - Уставка напряжения, Вольт (Program Voltage).
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.RAMP_A
echo [%IDEN%.RAMP_A]
echo Pos = 231, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:13\Style:[Bold]\Color:Navy
echo TagEval(v) = ne(%IDEN%_ramping_a=v,0)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_silver_ptmono.bmp А
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_yellow_ptmono.bmp А
echo Hint = %IDEN%.RAMP_A - статус перехода по току.
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.RAMP_V
echo [%IDEN%.RAMP_V]
echo Pos = 231, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:13\Style:[Bold]\Color:Navy
echo TagEval(v) = ne(%IDEN%_ramping_v=v,0)
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_silver_ptmono.bmp В
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_yellow_ptmono.bmp В
echo Hint = %IDEN%.RAMP_V - статус перехода по напряжению.
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.PAR_MC
echo [%IDEN%.PAR_MC]
echo Pos = 255, %YPOS%
echo LED = 7, 0, 3, %%7.3f, Name:PT_Mono\Size:13\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_MC - Измерение тока, Ампер (Measure Current).
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.PAR_MV
echo [%IDEN%.PAR_MV]
echo Pos = 255, %YPOS%
echo LED = 7, 0, 3, %%7.3f, Name:PT_Mono\Size:13\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_MV - Измерение напряжения, Вольт (Measure Voltage).
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.PAR_MW
echo [%IDEN%.PAR_MW]
echo Pos = 340, %YPOS%
echo LED = 7, 0, 0, %%7.0f, Name:PT_Mono\Size:13\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_aqua_ptmono.bmp
echo Hint = %IDEN%.PAR_MW - Измерение мощности, Ватт (Measure Watt).
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.PAR_MODE
echo [%IDEN%.PAR_MODE]
echo Pos = 340, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Sans_Narrow\Size:9\Style:[Normal]
echo TagEval(v) = (%IDEN%_par_mode=v)*%IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_silver_ptmono.bmp OFF
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_lime_ptmono.bmp   CV
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_lime_ptmono.bmp   CC
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_red_ptmono.bmp    ERR
echo Hint = %IDEN%.PAR_MODE - Режим стабилизации напряжения/тока (CV/CC - const voltage/current).
echo []
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.PAR_SR.2
echo [%IDEN%.PAR_SR.2]
echo Pos = 365, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Sans_Narrow\Size:9\Style:[Normal]
echo TagEval(v) = (1+isbit(v,2))*%IDEN%_poll_good
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_silver_ptmono.bmp OFF
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_red_ptmono.bmp    FLT
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_2_13_4_lime_ptmono.bmp   OK
echo Hint = %IDEN%.PAR_SR.2 - Индикатор отсутствия ошибки (NO FAULT state indicator).
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.POLL_RATE
echo [%IDEN%.POLL_RATE]
echo Pos = 390, %YPOS%
echo LED = 2, 0, 0, %%2.0f, Name:PT_Mono\Size:13\Style:[Bold]
echo TagEval(v) = %IDEN%_poll_enab*(1+(%IDEN%_poll_gtrz=gt(%IDEN%_poll_rate=v,0))+(%IDEN%_poll_good=gt(v,%IDEN%_poll_norm)))
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_13_4_silver_ptmono.bmp
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_13_4_red_ptmono.bmp
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_13_4_yellow_ptmono.bmp
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_3_13_4_lime_ptmono.bmp
echo Hint = %IDEN%.POLL_RATE - Частота опроса, Герц.
echo []
echo.
set /a YPOS=TABCRC_TOP+60
echo [SensorList]
echo Sensor = %IDEN%.BT_OUT
echo [%IDEN%.BT_OUT]
echo Pos = 455, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = (%IDEN%_bt_out=v)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=2)
echo Painter(v) = (glButtonMoveX=2)+(glButtonMoveY=2)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_silver_ptmono.bmp Нагрузка
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_yellow_ptmono.bmp Нагрузка
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_yellow_ptmono.bmp Нагрузка
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_lime_ptmono.bmp   Нагрузка
echo Hint = %IDEN%.BT_OUT - OUTput - Включить Нагрузку (Выход).
echo []
echo.
set /a YPOS=TABCRC_TOP+83
echo [SensorList]
echo Sensor = %IDEN%.POLL_ENABLE
echo [%IDEN%.POLL_ENABLE]
echo Pos = 455, %YPOS%
echo LED = 0, 0, 0, %%s, Name:PT_Mono\Size:10\Style:[Bold]
echo TagEval(v) = (%IDEN%_poll_enab=isbit(v,0))*(1+%IDEN%_poll_gtrz+%IDEN%_poll_good)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=2)
echo Painter(v) = (glButtonMoveX=2)+(glButtonMoveY=2)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_silver_ptmono.bmp Опрос
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_red_ptmono.bmp    Опрос
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_yellow_ptmono.bmp Опрос
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_8_13_4_lime_ptmono.bmp   Опрос
echo Hint = %IDEN%.POLL_ENABLE - Разрешение опроса COM порта.
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:GENDC_DIS
unix dimcfg ^
  -n section  "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/POLL_ENABLE ^
  -n tag      %FACN%.%IDEN%.POLL_ENABLE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/POLL_RATE ^
  -n tag      %FACN%.%IDEN%.POLL_RATE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ERROR_CNT ^
  -n tag      %FACN%.%IDEN%.ERROR_CNT ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ID_IDN ^
  -n tag      %FACN%.%IDEN%.ID_IDN ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ID_REV ^
  -n tag      %FACN%.%IDEN%.ID_REV ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ID_SN ^
  -n tag      %FACN%.%IDEN%.ID_SN ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/ID_DATE ^
  -n tag      %FACN%.%IDEN%.ID_DATE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_MC ^
  -n tag      %FACN%.%IDEN%.PAR_MC ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_MV ^
  -n tag      %FACN%.%IDEN%.PAR_MV ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_MW ^
  -n tag      %FACN%.%IDEN%.PAR_MW ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PC ^
  -n tag      %FACN%.%IDEN%.PAR_PC ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_PV ^
  -n tag      %FACN%.%IDEN%.PAR_PV ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_SR ^
  -n tag      %FACN%.%IDEN%.PAR_SR ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_FR ^
  -n tag      %FACN%.%IDEN%.PAR_FR ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/BT_FLD ^
  -n tag      %FACN%.%IDEN%.BT_FLD ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/BT_AST ^
  -n tag      %FACN%.%IDEN%.BT_AST ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/BT_OUT ^
  -n tag      %FACN%.%IDEN%.BT_OUT ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_OVP ^
  -n tag      %FACN%.%IDEN%.PAR_OVP ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_UVL ^
  -n tag      %FACN%.%IDEN%.PAR_UVL ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/RATE_A ^
  -n tag      %FACN%.%IDEN%.RATE_A ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/RATE_V ^
  -n tag      %FACN%.%IDEN%.RATE_V ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/RAMP_A ^
  -n tag      %FACN%.%IDEN%.RAMP_A ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/RAMP_V ^
  -n tag      %FACN%.%IDEN%.RAMP_V ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_RMT ^
  -n tag      %FACN%.%IDEN%.PAR_RMT ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_MODE ^
  -n tag      %FACN%.%IDEN%.PAR_MODE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_FENA ^
  -n tag      %FACN%.%IDEN%.PAR_FENA ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_FEVE ^
  -n tag      %FACN%.%IDEN%.PAR_FEVE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_SENA ^
  -n tag      %FACN%.%IDEN%.PAR_SENA ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_SEVE ^
  -n tag      %FACN%.%IDEN%.PAR_SEVE ^
  -n end ^
  -n dis_info %FACP%/%IDEN%/PAR_SRQ ^
  -n tag      %FACN%.%IDEN%.PAR_SRQ ^
  -n end ^
  -n
goto :EOF

:GENDC_DIC
unix dimcfg ^
  -n section  "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd %FACP%/%IDEN%/DIMGUICLICK ^
  -n tag      %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/POLL_ENABLE ^
  -n tag      %FACN%.%IDEN%.POLL_ENABLE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.POLL_ENABLE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/POLL_RATE ^
  -n tag      %FACN%.%IDEN%.POLL_RATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.POLL_RATE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ERROR_CNT ^
  -n tag      %FACN%.%IDEN%.ERROR_CNT ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ERROR_CNT" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ID_IDN ^
  -n tag      %FACN%.%IDEN%.ID_IDN ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ID_IDN" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ID_REV ^
  -n tag      %FACN%.%IDEN%.ID_REV ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ID_REV" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ID_SN ^
  -n tag      %FACN%.%IDEN%.ID_SN ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ID_SN" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/ID_DATE ^
  -n tag      %FACN%.%IDEN%.ID_DATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.ID_DATE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_MC ^
  -n tag      %FACN%.%IDEN%.PAR_MC ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_MC" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_MV ^
  -n tag      %FACN%.%IDEN%.PAR_MV ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_MV" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_MW ^
  -n tag      %FACN%.%IDEN%.PAR_MW ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_MW" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PC ^
  -n tag      %FACN%.%IDEN%.PAR_PC ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PC" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_PV ^
  -n tag      %FACN%.%IDEN%.PAR_PV ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_PV" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_SR ^
  -n tag      %FACN%.%IDEN%.PAR_SR ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_SR" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_FR ^
  -n tag      %FACN%.%IDEN%.PAR_FR ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_FR" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/BT_FLD ^
  -n tag      %FACN%.%IDEN%.BT_FLD ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.BT_FLD" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/BT_AST ^
  -n tag      %FACN%.%IDEN%.BT_AST ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.BT_AST" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/BT_OUT ^
  -n tag      %FACN%.%IDEN%.BT_OUT ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.BT_OUT" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_OVP ^
  -n tag      %FACN%.%IDEN%.PAR_OVP ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_OVP" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_UVL ^
  -n tag      %FACN%.%IDEN%.PAR_UVL ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_UVL" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/RATE_A ^
  -n tag      %FACN%.%IDEN%.RATE_A ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RATE_A" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/RATE_V ^
  -n tag      %FACN%.%IDEN%.RATE_V ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RATE_V" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/RAMP_A ^
  -n tag      %FACN%.%IDEN%.RAMP_A ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RAMP_A" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/RAMP_V ^
  -n tag      %FACN%.%IDEN%.RAMP_V ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RAMP_V" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_RMT ^
  -n tag      %FACN%.%IDEN%.PAR_RMT ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_RMT" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_MODE ^
  -n tag      %FACN%.%IDEN%.PAR_MODE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_MODE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_FENA ^
  -n tag      %FACN%.%IDEN%.PAR_FENA ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_FENA" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_FEVE ^
  -n tag      %FACN%.%IDEN%.PAR_FEVE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_FEVE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_SENA ^
  -n tag      %FACN%.%IDEN%.PAR_SENA ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_SENA" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_SEVE ^
  -n tag      %FACN%.%IDEN%.PAR_SEVE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_SEVE" ^
  -n end ^
  -n dic_info %FACP%/%IDEN%/PAR_SRQ ^
  -n tag      %FACN%.%IDEN%.PAR_SRQ ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PAR_SRQ" ^
  -n end ^
  -n
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
