#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Generator for E140.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

declare prefix="";
declare prefixlo="";
declare history="";
declare datapath="";
declare bitmaps="";
declare daqpas="";
declare freq="";
declare fir="";
declare simx="";
declare sim="";
declare sim1="";
declare sim2="";
declare sim3="";
declare sim4="";
declare gate="";
declare gain="";
declare note="";
declare gen="";
declare cfg="";
declare suf="";
declare ser="";

declare -i local_bitmaps=0; # set 0/1 for system/local bitmaps directory
declare -i local_daqpas=0;  # set 0/1 for system/local daqpas  directory

function call(){
 echo "$@";
      "$@";
};

function replacestr(){
 sed -e "s|$1|$2|g";
};

function DeleteFile(){
 if [ -z "$1" ]; then return 0; fi;
 if [ -e "$1" ]; then rm -fv "$1"; fi;
};

function InitParams(){
 echo "Call InitParams $*";
 prefix="$1";
 history="$2";
 datapath="$3";
 freq="$4";
 fir="$5";
 prefixlo="$(echo "$prefix" | tr '[:upper:]' '[:lower:]' | tr '.' '_' | xargs)";
 daqpas="~~/resource/daqtool/lcard/e140/daqpas";
 if [[ $local_daqpas -eq 1 ]]; then daqpas="../daqpas"; fi;
 bitmaps="~~/resource/daqtool/lcard/e140/bitmaps";
 if [[ $local_bitmaps -eq 1 ]]; then bitmaps="../bitmaps"; fi;
};

function AddHeader3(){
 if [ -z "$1" ]; then return 0; fi;
 if [ -z "$2" ]; then return 0; fi;
 if [ -e "$1" ]; then cat "$1" | head -n 4 | unix2dos | tee -a "$2"; fi;
};

function AddE140Adc(){
 echo "Call AddE140Adc $*";
 if [ -z "$1" ]; then return 0; fi;
 if [ -z "$2" ]; then return 0; fi;
 suf="$(echo "$3" | tr '-' ' ' | xargs)";
 ser="$(echo "$4" | tr '-' ' ')";
 simx="$5";
 sim="0";
 sim1="-";
 sim2="-";
 sim3="-";
 sim4="-";
 if [ "${simx:0:1}" = "1" ]; then sim="1"; fi;
 if [ "${simx:1:1}" = "1" ]; then sim1=""; fi;
 if [ "${simx:2:1}" = "1" ]; then sim2=""; fi;
 if [ "${simx:3:1}" = "1" ]; then sim3=""; fi;
 if [ "${simx:4:1}" = "1" ]; then sim4=""; fi;
 gate="$6";
 gain="$7";
 note="$8";
 if [ -z "$gate" ]; then gate="11000000000000000000000000000000"; fi;
 if [ -z "$gain" ]; then gain="00000000000000000000000000000000"; fi;
 # skip first 4 lines
 if [ -e "$1" ]; then
  cat "$1"                             \
  | tail -n +5                         \
  | replacestr {PRE}    "$prefix"      \
  | replacestr {pre}    "$prefixlo"    \
  | replacestr {FREQ}   "$freq"        \
  | replacestr {FIR}    "$fir"         \
  | replacestr {HIST}   "$history"     \
  | replacestr {DPATH}  "$datapath"    \
  | replacestr {GATE0}  "${gate:0:1}"  \
  | replacestr {GATE1}  "${gate:1:1}"  \
  | replacestr {GATE2}  "${gate:2:1}"  \
  | replacestr {GATE3}  "${gate:3:1}"  \
  | replacestr {GATE4}  "${gate:4:1}"  \
  | replacestr {GATE5}  "${gate:5:1}"  \
  | replacestr {GATE6}  "${gate:6:1}"  \
  | replacestr {GATE7}  "${gate:7:1}"  \
  | replacestr {GATE8}  "${gate:8:1}"  \
  | replacestr {GATE9}  "${gate:9:1}"  \
  | replacestr {GATE10} "${gate:10:1}" \
  | replacestr {GATE11} "${gate:11:1}" \
  | replacestr {GATE12} "${gate:12:1}" \
  | replacestr {GATE13} "${gate:13:1}" \
  | replacestr {GATE14} "${gate:14:1}" \
  | replacestr {GATE15} "${gate:15:1}" \
  | replacestr {GATE16} "${gate:16:1}" \
  | replacestr {GATE17} "${gate:17:1}" \
  | replacestr {GATE18} "${gate:18:1}" \
  | replacestr {GATE19} "${gate:19:1}" \
  | replacestr {GATE20} "${gate:20:1}" \
  | replacestr {GATE21} "${gate:21:1}" \
  | replacestr {GATE22} "${gate:22:1}" \
  | replacestr {GATE23} "${gate:23:1}" \
  | replacestr {GATE24} "${gate:24:1}" \
  | replacestr {GATE25} "${gate:25:1}" \
  | replacestr {GATE26} "${gate:26:1}" \
  | replacestr {GATE27} "${gate:27:1}" \
  | replacestr {GATE28} "${gate:28:1}" \
  | replacestr {GATE29} "${gate:29:1}" \
  | replacestr {GATE30} "${gate:30:1}" \
  | replacestr {GATE31} "${gate:31:1}" \
  | replacestr {GAIN0}  "${gain:0:1}"  \
  | replacestr {GAIN1}  "${gain:1:1}"  \
  | replacestr {GAIN2}  "${gain:2:1}"  \
  | replacestr {GAIN3}  "${gain:3:1}"  \
  | replacestr {GAIN4}  "${gain:4:1}"  \
  | replacestr {GAIN5}  "${gain:5:1}"  \
  | replacestr {GAIN6}  "${gain:6:1}"  \
  | replacestr {GAIN7}  "${gain:7:1}"  \
  | replacestr {GAIN8}  "${gain:8:1}"  \
  | replacestr {GAIN9}  "${gain:9:1}"  \
  | replacestr {GAIN10} "${gain:10:1}" \
  | replacestr {GAIN11} "${gain:11:1}" \
  | replacestr {GAIN12} "${gain:12:1}" \
  | replacestr {GAIN13} "${gain:13:1}" \
  | replacestr {GAIN14} "${gain:14:1}" \
  | replacestr {GAIN15} "${gain:15:1}" \
  | replacestr {GAIN16} "${gain:16:1}" \
  | replacestr {GAIN17} "${gain:17:1}" \
  | replacestr {GAIN18} "${gain:18:1}" \
  | replacestr {GAIN19} "${gain:19:1}" \
  | replacestr {GAIN20} "${gain:20:1}" \
  | replacestr {GAIN21} "${gain:21:1}" \
  | replacestr {GAIN22} "${gain:22:1}" \
  | replacestr {GAIN23} "${gain:23:1}" \
  | replacestr {GAIN24} "${gain:24:1}" \
  | replacestr {GAIN25} "${gain:25:1}" \
  | replacestr {GAIN26} "${gain:26:1}" \
  | replacestr {GAIN27} "${gain:27:1}" \
  | replacestr {GAIN28} "${gain:28:1}" \
  | replacestr {GAIN29} "${gain:29:1}" \
  | replacestr {GAIN30} "${gain:30:1}" \
  | replacestr {GAIN31} "${gain:31:1}" \
  | replacestr {SIM}    "$sim"         \
  | replacestr {SIM1}   "$sim1"        \
  | replacestr {SIM2}   "$sim2"        \
  | replacestr {SIM3}   "$sim3"        \
  | replacestr {SIM4}   "$sim4"        \
  | replacestr {NOTE}   "$note"        \
  | replacestr {N}      "$suf"         \
  | replacestr {SN}     "$ser"         \
  | replacestr {DAQPAS} "$daqpas"      \
  | unix2dos            | tee -a "$2";
  echo "" | unix2dos    | tee -a "$2";
 fi;
 echo "$note";
};

function AddE140CtrlCrc(){
 local gen="$(basename $1 .gen)_crc.gen";
 local crc="../circuits/$(basename $1 .gen).crc";
 if [[ -e $crc ]]; then rm -fv $crc; fi;
 if [[ -e $gen ]]; then
  cat "$gen" \
  | replacestr {BITMAPS} "$bitmaps" \
  | unix2dos            | tee -a "$crc";
 fi;
};

function E140Table(){
 if [ -z "$1" ]; then fatal 1 "Error: empty arg1."; fi;
 if [ -z "$2" ]; then fatal 1 "Error: empty arg2."; fi;
 gen="$1";
 cfg="$2";
 ###  Initialize Prefix  History  DataPath         Freq,kHz  FIR
 call InitParams DEMO.   100000   ../../e140_data  1         1  ;
 call DeleteFile "$cfg";
 AddE140CtrlCrc "$gen";
 call AddHeader3 "$gen" "$cfg";
 ### Add E140 ADC  genfile  cfgfile  Suffix  SerialNum   Simul  Gate-mapping (32 channels)        Gain-mapping (32 channels)        Comment-Note
 call AddE140Adc  "$gen"    "$cfg"   "--"    "--------"  01110  11000000000000000000000000000000  11111111111111111111111111111111  "Demo test, single card.";
 return;
 call AddE140Adc  "$gen"    "$cfg"   "_1"    "1D157614"  01110  11111111000000000000000000000000  11111111111111111111111111111111  "Demo test, card #1.";
 call AddE140Adc  "$gen"    "$cfg"   "_2"    "1D699929"  01110  11111111000000000000000000000000  11111111111111111111111111111111  "Demo test, card #2.";
};

######
# main
######
function main(){
 echo "";
 echo "E14-140 config generator.";
 echo "";
 if pushd "$scriptHOME"; then
  call E140Table "$scriptbase.gen" "$scriptbase.cfg"
 fi;
 echo "";
 echo "Done.";
 echo "";
};

main "$@";

##############
## END OF FILE
##############
