 {
 ***********************************************************************
 DOZA - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @ActionDaqNavigator    - Open DAQ SYSTEM Navigator list
| @UpdateTag tag value   - Update tag value
|********************************************************
[]
 }
program doza_main_ctrl;          { DOZA - main control program      }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 SmilePeriod       = 1000;       { Polling period for smile face    }

type
 TTagRef           = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 DOZA              : record      { All DOZA data                    }
  MAIN             : record      { Main tags                        }
   CMD             : record      { CoMmandDs to control DOZA GUI    }
    HELP           : TTagRef;    { Open Help                        }
    HOME           : TTagRef;    { Home windows                     }
    OPEN           : TTagRef;    { Open DAT file(s)                 }
    SAVE           : TTagRef;    { Save DAT file(s)                 }
    LOADINI        : TTagRef;    { Load INI file                    }
    SAVEINI        : TTagRef;    { Save INI file                    }
    SOUND          : TTagRef;    { Sound on/off                     }
    TOOLS          : TTagRef;    { Tools menu                       }
    SMILE          : TTagRef;    { Smile menu                       }
    CLOSE          : TTagRef;    { Close DAQ/CRW/WIN                }
   end;                          {                                  }
  end;                           {                                  }
 end;                            {                                  }
 tagDatSrvGate     : integer;    {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }
 
 {
 Nice tooltip notifier.
 }
 procedure NiceNotify(aText:String; aDelay:Integer);
 begin
  ShowTooltip('text "'+aText+'" preset stdNotify delay '+Str(aDelay));
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@Cron @Eval @System @Async @Silent @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 950 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  55  relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Вызвать окно справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@UpdateTag '+NameTag(DOZA.MAIN.CMD.HELP.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Параметры Установки - Загрузить из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@UpdateTag '+NameTag(DOZA.MAIN.CMD.LOADINI.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Параметры Установки - Сохранить в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@UpdateTag '+NameTag(DOZA.MAIN.CMD.SAVEINI.tag)+' 1');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Очистка счетчиков ошибок &ModbusProxy');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DevPost &ModbusProxy @ZeroPortCounters 0');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Вызвать утилиту @ModbusPoll');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DevPost &ModbusProxy @ModbusPoll');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Вызвать утилиту @ModScan32');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DevPost &ModbusProxy @ModScan32');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Вызвать справку по ModBus');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DevPost &ModbusProxy @ModbusHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Вызвать Modbus-симулятор mod_rssim.exe');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Cron @Run mod_rssim.exe');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 800 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  55  relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 DOZA initialization
 }
 procedure DOZA_INIT;
  procedure DOZA_MAIN_CMD_INIT(TagPrefix:String);
  begin
   InitTag(DOZA.MAIN.CMD.HELP.tag,    TagPrefix+'.MAIN.CMD.HELP',      1);
   InitTag(DOZA.MAIN.CMD.HOME.tag,    TagPrefix+'.MAIN.CMD.HOME',      1);
   InitTag(DOZA.MAIN.CMD.OPEN.tag,    TagPrefix+'.MAIN.CMD.OPEN',      1);
   InitTag(DOZA.MAIN.CMD.SAVE.tag,    TagPrefix+'.MAIN.CMD.SAVE',      1);
   InitTag(DOZA.MAIN.CMD.TOOLS.tag,   TagPrefix+'.MAIN.CMD.TOOLS',     1);
   InitTag(DOZA.MAIN.CMD.LOADINI.tag, TagPrefix+'.MAIN.CMD.LOADINI',   1);
   InitTag(DOZA.MAIN.CMD.SAVEINI.tag, TagPrefix+'.MAIN.CMD.SAVEINI',   1);
   InitTag(DOZA.MAIN.CMD.SOUND.tag,   TagPrefix+'.MAIN.CMD.SOUND',     1);
   InitTag(DOZA.MAIN.CMD.SMILE.tag,   TagPrefix+'.MAIN.CMD.SMILE',     1);
   InitTag(DOZA.MAIN.CMD.CLOSE.tag,   TagPrefix+'.MAIN.CMD.CLOSE',     1);
   DOZA.MAIN.CMD.SMILE.val:=GetErrCount(-2);
  end;
 begin
  {
  Initialize tags...
  }
  DOZA_MAIN_CMD_INIT(ReadIni('tagDOZA'));
  InitTag(tagDatSrvGate,'DATSRV.GATE',-1);
 end;
 {
 DOZA finalization
 }
 procedure DOZA_FREE;
 begin
 end;
 {
 DOZA polling
 }
 procedure DOZA_POLL;
 var errors:Real; i,ClickCurve:Integer;
  // Xor bit of tag on click (local version)
  procedure ClickBitXorLocal(tag,XorMask:Integer);
  begin
   if ClickTag=tag then begin
    bNul(iSetTagXor(tag,XorMask));
    bNul(Voice(snd_Click));
   end;
  end;
 begin
  //
  // Update DATSRV.GATE
  //
  if tagDatSrvGate<>0 then
  if SysTimer_Pulse(1000)>0 then
  if iGetTag(tagDatSrvGate)<>iGetTag(DOZA.MAIN.CMD.SAVE.tag) then
  bNul(iSetTag(tagDatSrvGate,iGetTag(DOZA.MAIN.CMD.SAVE.tag)));
  //
  // Handle Smile
  //
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   errors:=GetErrCount(-2);
   if errors>DOZA.MAIN.CMD.SMILE.val then bNul(iSetTag(DOZA.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DOZA.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DOZA.MAIN.CMD.SMILE.tag,1));
   DOZA.MAIN.CMD.SMILE.val:=errors;
  end;
  //
  // Execute GUI commands.
  //
  if iGetTag(DOZA.MAIN.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
   bNul(iSetTag(DOZA.MAIN.CMD.HELP.tag,0));
  end;
  if iGetTag(DOZA.MAIN.CMD.HOME.tag)<>0 then begin
   bNul(iSetTag(DOZA.MAIN.CMD.HOME.tag,0));
   Cron('@cron.run DOZA.MAIN.CTRL.HOME');
  end;
  if iGetTag(DOZA.MAIN.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DOZA.MAIN.CMD.OPEN.tag,0));
  end;
  if iGetTag(DOZA.MAIN.CMD.LOADINI.tag)<>0 then begin
   bNul(iSetTag(DOZA.MAIN.CMD.LOADINI.tag,0)); 
   DevPostCmdLocal('@Cmd.LoadIni');
  end;
  if iGetTag(DOZA.MAIN.CMD.SAVEINI.tag)<>0 then begin
   bNul(iSetTag(DOZA.MAIN.CMD.SAVEINI.tag,0));
   DevPostCmdLocal('@Cmd.SaveIni');
  end;
  if iGetTag(DOZA.MAIN.CMD.TOOLS.tag)<>0 then begin
   bNul(iSetTag(DOZA.MAIN.CMD.TOOLS.tag,0));
   MenuToolsStarter;
  end;
  if iGetTag(DOZA.MAIN.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(DOZA.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Edit tags...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(DOZA.MAIN.CMD.HELP.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.HOME.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.OPEN.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.SAVE.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.LOADINI.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.SAVEINI.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.TOOLS.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.SOUND.tag,1);
   ClickBitXorLocal(DOZA.MAIN.CMD.CLOSE.tag,1);
   {
   Smile face button...
   }
   if ClickTag=DOZA.MAIN.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(DOZA.MAIN.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if IsRefCurve(ClickCurve) then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
   {
   User utilities: @...
   }
   if IsSameText('@Mod',Copy(ClickSensor,1,4)) then begin
    DevPostCmd(devModbusProxy,ClickSensor);
    bNul(Voice(snd_Click));
   end else
   if LooksLikeCommand(ClickSensor) then begin
    DevPostCmdLocal(url_decode(ClickSensor));
    bNul(Voice(snd_Click));
   end;
   //
   // DOZAxx.CTRL sensors
   //
   if IsSameText(Copy(ClickSensor,1,4),'DOZA') then
   if IsSameText(ExtractFileExt(ClickSensor),'.CTRL') then begin
    i:=0;
    while i<MaxInt do begin
     if IsEmptyStr(ParamStr('CIRWINNAME '+Str(i))) then i:=MaxInt else
     if Pos('.'+UpcaseStr(ExtractFileName(ClickSensor)+'.'),UpcaseStr(ParamStr('CIRWINNAME '+Str(i))))>0 then begin
      Cron('@WinSelect '+ParamStr('CIRWINNAME '+Str(i)));
      bNul(Voice(snd_Wheel));
      i:=MaxInt;
     end else i:=i+1;
    end;
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetLibrary;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
  InitNetLibrary;
  DOZA_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  FreeNetLibrary;
  DOZA_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetLibrary;
  DOZA_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n,tag:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @UpdateTag MAIN.CMD.CLOSE 1
   }
   if IsSameText(cmd,'@UpdateTag') then begin
    if (WordCount(arg)>1) then begin
     tag:=FindTag(ExtractWord(1,arg));
     if (TypeTag(tag)>0) then UpdateTag(tag,SkipWords(1,arg),-_inf,+_inf);
    end;
    Data:='';
   end else
   {
   @ActionDaqNavigator
   }
   if IsSameText(cmd,'@ActionDaqNavigator') then begin
    Cron('@SysEval @Silent @Menu run FormDaqControlDialog.ActionDaqNavigator');
    Data:='';
   end else
   {
   @Cmd.LoadIni
   }
   if IsSameText(cmd,'@Cmd.LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if IsSameText(cmd,'@Cmd.SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
