@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem *****************************
rem DOZA devices config generator
rem *****************************

:Main
::call :SetUnixPath
call :InitializeVariables
pushd "%~dp0" && call :DozaDevices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set impcfg=%~n0_imp.cfg
set devmsg=devPostMsg
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=450
set /a CTRL_TOP_STEP=80
set MAIN_CTRL=DOZA.MAIN.CTRL
set PARAM_PLOT=DOZA.PARAM.PLOT
set STATE_PLOT=DOZA.STATE.PLOT
goto :EOF

:DozaDevices
call :DeleteFiles %hdwcfg% %simcfg% %diccfg% %discfg% %impcfg%
rem  Device  Facility   Identitier Port UnitId Polling
call :UDGB01 DEMO.DOZA  DOZA01     1    1      100
call :UDGB01 DEMO.DOZA  DOZA02     1    2      100
call :UDGB01 DEMO.DOZA  DOZA03     1    3      100
call :UDGB01 DEMO.DOZA  DOZA04     1    4      100
call :UDGB01 DEMO.DOZA  DOZA05     1    5      100
call :UDGB01 DEMO.DOZA  DOZA06     1    6      100
call :UDGB01 DEMO.DOZA  DOZA07     1    7      100
type %hdwcfg% %simcfg%
goto :EOF

:UDGB01
call :UDGB01_SET %*
call :UDGB01_HDW %* >> %hdwcfg%
call :UDGB01_SIM %* >> %simcfg%
call :UDGB01_DIC %* >> %diccfg%
call :UDGB01_DIS %* >> %discfg%
call :UDGB01_IMP %* >> %impcfg%
set /a CTRL_TOP+=CTRL_TOP_STEP
goto :EOF

:UDGB01_HDW
call :UDGB01_DRV %*
call :UDGB01_TAG %*
call :UDGB01_WIN %*
goto :EOF

:UDGB01_IMP
call :UDGB01_RCV %*
call :UDGB01_TAG %*
call :UDGB01_DIC %*
goto :EOF

:UDGB01_SET
set "FACN=%~1"          & shift     & :: Facility name
set "IDEN=%~1"          & shift     & :: Device identifier name
set "ModbusPort=%~1"    & shift     & :: Modbus Port number
set "ModbusUnitId=%~1"  & shift     & :: Modbus Unit Id
set "ModbusPolling=%~1" & shift     & :: Modbus Polling period, ms
set "FACP=%FACN:.=/%"               & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"               & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:UDGB01_DRV
echo ;****************************
echo ; Driver for %FACN%.%IDEN%
echo ;****************************
echo [DeviceList]
echo ^&%FACN%.%IDEN%.UDGB01.CTRL = device software program
echo [^&%FACN%.%IDEN%.UDGB01.CTRL]
echo Comment         = MODBUS DRIVER FOR %FACN%.%IDEN%.UDGB01.
echo InquiryPeriod   = 0
echo DevicePolling   = 10, tpHigher
echo ProgramSource   = ..\DaqPas\doza_udgb01.pas
echo DigitalFifo     = 1024
echo AnalogFifo      = 1024
echo DebugFlags      = 3
echo OpenConsole     = 2
echo Simulator       = 0
echo ModbusPort      = %ModbusPort%
echo ModbusUnitId    = %ModbusUnitId%
echo ModbusTimeout   = 250
echo ModbusDeadline  = 60000
echo ModbusPolling   = %ModbusPolling%
echo DelayOnStart    = 1000
echo tagPrefix       = %FACN%.%IDEN%.UDGB01
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FACN%.%IDEN%.UDGB01.DIMGUICLICK
echo AnalogOutputs   = 6
echo Link AnalogOutput  0 with curve %FACN%.%IDEN%.UDGB01.PARAM.GASVA  history 10000
echo Link AnalogOutput  1 with curve %FACN%.%IDEN%.UDGB01.PARAM.YELVA  history 1000
echo Link AnalogOutput  2 with curve %FACN%.%IDEN%.UDGB01.PARAM.REDVA  history 1000
echo Link AnalogOutput  3 with curve %FACN%.%IDEN%.UDGB01.PARAM.DRYVA  history 1000
echo Link AnalogOutput  4 with curve %FACN%.%IDEN%.UDGB01.PARAM.RESRC  history 1000
echo Link AnalogOutput  5 with curve %FACN%.%IDEN%.UDGB01.PARAM.RTIME  history 1000
echo DigitalOutputs = 9
echo Link DigitalOutput  0 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS history 1000
echo Link DigitalOutput  1 with curve %FACN%.%IDEN%.UDGB01.STATE.INDIC history 1000
echo Link DigitalOutput  2 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.RX history 1000
echo Link DigitalOutput  3 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.TX history 1000
echo Link DigitalOutput  4 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.EX history 1000
echo Link DigitalOutput  5 with curve %FACN%.%IDEN%.UDGB01.ERROR.COUNT history 1000
echo Link DigitalOutput  6 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.RX history 1000
echo Link DigitalOutput  7 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.TX history 1000
echo Link DigitalOutput  8 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.EX history 1000
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%FACN%.%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FACF%_%IDEN%_Custom.Ini
echo CustomIniSection  = [%FACN%.%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FACF%_%IDEN%_Custom.ini
echo []
echo [%FACN%.%IDEN%.CustomParameters.TagList]
echo TagList = %FACN%.%IDEN%.UDGB01.POLL.ENABLE
echo []
echo.
goto :EOF

:UDGB01_RCV
echo ;******************************
echo ; Receiver for %FACN%.%IDEN%
echo ;******************************
echo [DeviceList]
echo ^&%FACN%.%IDEN%.UDGB01.CTRL = device software program
echo [^&%FACN%.%IDEN%.UDGB01.CTRL]
echo Comment         = DIM RECEIVER FOR %FACN%.%IDEN%.UDGB01.
echo InquiryPeriod   = 1
echo DevicePolling   = 10, tpNormal
echo ProgramSource   = ~~\Resource\DaqSite\DimServer\_DIMRCV.PAS
echo AnalogFifo      = 1024
echo DebugFlags      = 3
echo OpenConsole     = 2
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FACN%.%IDEN%.UDGB01.DIMGUICLICK
echo AnalogOutputs   = 15
echo Link AnalogOutput  0 with curve %FACN%.%IDEN%.UDGB01.PARAM.GASVA  history 10000
echo Link AnalogOutput  1 with curve %FACN%.%IDEN%.UDGB01.PARAM.YELVA  history 1000
echo Link AnalogOutput  2 with curve %FACN%.%IDEN%.UDGB01.PARAM.REDVA  history 1000
echo Link AnalogOutput  3 with curve %FACN%.%IDEN%.UDGB01.PARAM.DRYVA  history 1000
echo Link AnalogOutput  4 with curve %FACN%.%IDEN%.UDGB01.PARAM.RESRC  history 1000
echo Link AnalogOutput  5 with curve %FACN%.%IDEN%.UDGB01.PARAM.RTIME  history 1000
echo Link AnalogOutput  6 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS  history 1000
echo Link AnalogOutput  7 with curve %FACN%.%IDEN%.UDGB01.STATE.INDIC  history 1000
echo Link AnalogOutput  8 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.RX  history 1000
echo Link AnalogOutput  9 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.TX  history 1000
echo Link AnalogOutput 10 with curve %FACN%.%IDEN%.UDGB01.POLLRATE.EX  history 1000
echo Link AnalogOutput 11 with curve %FACN%.%IDEN%.UDGB01.ERROR.COUNT  history 1000
echo Link AnalogOutput 12 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.RX  history 1000
echo Link AnalogOutput 13 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.TX  history 1000
echo Link AnalogOutput 14 with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.EX  history 1000
echo []
echo.
goto :EOF

:UDGB01_TAG
echo [TagList]
echo %FACN%.%IDEN%.UDGB01.PARAM.IDENT = string  %IDEN%.UDGB01   ; Device identifier string
echo %FACN%.%IDEN%.UDGB01.DIMGUICLICK = string  ?               ; The DIM click sensor data
echo %FACN%.%IDEN%.UDGB01.PARAM.GASVA = real    0               ; Gas              volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.YELVA = real    0               ; Yellow (warning) volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.REDVA = real    0               ; Yellow (warning) volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.DRYVA = real    0               ; Dry contact      volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.RESRC = real    0               ; Resource time
echo %FACN%.%IDEN%.UDGB01.STATE.FLAGS = integer 0               ; Status flags register
echo %FACN%.%IDEN%.UDGB01.PARAM.DTIME = string  ?               ; Date/time by device clock
echo %FACN%.%IDEN%.UDGB01.POLL.ENABLE = integer 1               ; Enable poll cycle
echo %FACN%.%IDEN%.UDGB01.STATE.INDIC = integer 0               ; Status Indicator O..6=GREEN/YELLOW/RED/TEST/ERROR/TIMEOUT/REFUSE
echo %FACN%.%IDEN%.UDGB01.POLLRATE.RX = real    0               ; Poll rate, receiver    (per sec)
echo %FACN%.%IDEN%.UDGB01.POLLRATE.TX = real    0               ; Poll rate, transmitter (per sec)
echo %FACN%.%IDEN%.UDGB01.POLLRATE.EX = real    0               ; Poll rate, errors      (per sec)
echo %FACN%.%IDEN%.UDGB01.ERROR.COUNT = real    0               ; Error counter          (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.RX = real    0               ; Poll summ, receiver    (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.TX = real    0               ; Poll summ, transmitter (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.EX = real    0               ; Poll summ, errors      (counter)
echo []
echo.
echo [DataStorage]
echo %FACN%.%IDEN%.UDGB01.PARAM.GASVA = Curve 0 10 Black  15 1  ; Gas              volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.YELVA = Curve 0 10 Black  15 1  ; Yellow (warning) volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.REDVA = Curve 0 10 Black  15 1  ; Red    (alarm)   volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.DRYVA = Curve 0 10 Black  15 1  ; Dry contact      volume activity, Bq/m3
echo %FACN%.%IDEN%.UDGB01.PARAM.RESRC = Curve 0 10 Black  15 1  ; Resource time
echo %FACN%.%IDEN%.UDGB01.PARAM.RTIME = Curve 0 10 Black  15 1  ; Real time by device clock
echo %FACN%.%IDEN%.UDGB01.STATE.FLAGS = Curve 0 10 Black  15 1  ; Status flags: Bit 0..8 - Fail/Warning/Alarm/TestMode/Electrometer/Reserved/Pump/IndicatorOfFlow/RegimeOfTesting
echo %FACN%.%IDEN%.UDGB01.STATE.INDIC = Curve 0 10 Black  15 1  ; Status Indicator O..6=GREEN/YELLOW/RED/TEST/ERROR/TIMEOUT/REFUSE
echo %FACN%.%IDEN%.UDGB01.POLLRATE.RX = Curve 0 10 Black  15 1  ; Poll rate, receiver    (per sec)
echo %FACN%.%IDEN%.UDGB01.POLLRATE.TX = Curve 0 10 Black  15 1  ; Poll rate, transmitter (per sec)
echo %FACN%.%IDEN%.UDGB01.POLLRATE.EX = Curve 0 10 Black  15 1  ; Poll rate, errors      (per sec)
echo %FACN%.%IDEN%.UDGB01.ERROR.COUNT = Curve 0 10 Black  15 1  ; Error counter          (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.RX = Curve 0 10 Black  15 1  ; Poll summ, receiver    (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.TX = Curve 0 10 Black  15 1  ; Poll summ, transmitter (counter)
echo %FACN%.%IDEN%.UDGB01.POLLSUMM.EX = Curve 0 10 Black  15 1  ; Poll summ, errors      (counter)
echo []
echo.
goto :EOF

:UDGB01_WIN
echo [Windows]
echo %FACN%.%IDEN%.UDGB01.CTRL = Circuit_Window 
echo [%FACN%.%IDEN%.UDGB01.CTRL]
echo Circuit = ..\Circuits\doza_udgb01_ctrl.crc
echo Link sensor @Cron+@Browse+www.doza.ru                                 with device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor @Cron+@Run+doza_udgb01.htm                                with device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor @Cron+@Run+doza-help.htm                                  with device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor @EDIT+PARAM.DTIME+NOW                                     with device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.POLL.ENABLE with tag   %FACN%.%IDEN%.UDGB01.POLL.ENABLE device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.IDENT with tag   %FACN%.%IDEN%.UDGB01.PARAM.IDENT device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.GASVA with curve %FACN%.%IDEN%.UDGB01.PARAM.GASVA device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.YELVA with tag   %FACN%.%IDEN%.UDGB01.PARAM.YELVA device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.REDVA with tag   %FACN%.%IDEN%.UDGB01.PARAM.REDVA device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.DRYVA with tag   %FACN%.%IDEN%.UDGB01.PARAM.DRYVA device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.RESRC with curve %FACN%.%IDEN%.UDGB01.PARAM.RESRC device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.PARAM.DTIME with tag   %FACN%.%IDEN%.UDGB01.PARAM.DTIME device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAGS with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG0 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG1 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG2 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG3 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG4 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG5 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG6 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG7 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.FLAG8 with curve %FACN%.%IDEN%.UDGB01.STATE.FLAGS device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.STATE.INDIC with curve %FACN%.%IDEN%.UDGB01.STATE.INDIC device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.POLLRATE.RX with curve %FACN%.%IDEN%.UDGB01.POLLRATE.RX device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.POLLRATE.TX with curve %FACN%.%IDEN%.UDGB01.POLLRATE.TX device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.POLLRATE.EX with curve %FACN%.%IDEN%.UDGB01.POLLRATE.EX device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo Link sensor UDGB01.POLLSUMM.EX with curve %FACN%.%IDEN%.UDGB01.POLLSUMM.EX device ^&%FACN%.%IDEN%.UDGB01.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.UDGB01.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.HOME @WinShow %FACN%.%IDEN%.UDGB01.CTRL
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.HOME @WinDraw %FACN%.%IDEN%.UDGB01.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=660^|Height=280
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.HOME @WinDraw %FACN%.%IDEN%.UDGB01.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.HOME @WinDraw %FACN%.%IDEN%.UDGB01.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.UDGB01.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.SHOW @WinShow %FACN%.%IDEN%.UDGB01.CTRL
echo @cron.tab %FACN%.%IDEN%.UDGB01.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.HIDE @WinHide %FACN%.%IDEN%.UDGB01.CTRL
echo @cron.tab %FACN%.%IDEN%.UDGB01.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.UDGB01.CTRL.SELECT @WinSelect %FACN%.%IDEN%.UDGB01.CTRL
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.UDGB01.CTRL.HOME
echo @cron.job %MAIN_CTRL%.HOME @cron.run %FACN%.%IDEN%.UDGB01.CTRL.HIDE
echo []
echo.
echo [%MAIN_CTRL%]
echo Link sensor %IDEN%.CTRL  with                                        device ^&%MAIN_CTRL%
echo Link sensor %IDEN%.VALUE with curve %FACN%.%IDEN%.UDGB01.PARAM.GASVA device ^&%MAIN_CTRL%
echo []
echo.
echo [%PARAM_PLOT%]
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.GASVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.YELVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.REDVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.DRYVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.RESRC
echo []
echo.
echo [%STATE_PLOT%]
echo CurveList = %FACN%.%IDEN%.UDGB01.STATE.FLAGS
echo CurveList = %FACN%.%IDEN%.UDGB01.STATE.INDIC
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.RX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.TX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.EX
echo CurveList = %FACN%.%IDEN%.UDGB01.ERROR.COUNT
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLSUMM.RX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLSUMM.TX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLSUMM.EX
echo []
echo.
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.GASVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.YELVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.REDVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.DRYVA
echo CurveList = %FACN%.%IDEN%.UDGB01.PARAM.RESRC
echo CurveList = %FACN%.%IDEN%.UDGB01.STATE.FLAGS
echo CurveList = %FACN%.%IDEN%.UDGB01.STATE.INDIC
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.RX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.TX
echo CurveList = %FACN%.%IDEN%.UDGB01.POLLRATE.EX
echo CurveList = %FACN%.%IDEN%.UDGB01.ERROR.COUNT
echo []
goto :EOF

:UDGB01_SIM 
echo [^&%FACN%.%IDEN%.UDGB01.CTRL]
echo Simulator = 1
echo []
echo.
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:UDGB01_DIS
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.UDGB01.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDEN%/UDGB01/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.UDGB01.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDEN%/UDGB01/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.UDGB01.DIMGUICLICK ^
  -n end ^
  -n dis_info   %FACP%/%IDEN%/UDGB01/POLL/ENABLE ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLL.ENABLE ^
  -n end ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/PARAM/DTIME ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.DTIME ^
  -n end ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/PARAM/GASVA ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.GASVA ^
  -n end ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/PARAM/YELVA+REDVA+DRYVA+RESRC ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.YELVA ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.REDVA ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.DRYVA ^
  -n tag       %FACN%.%IDEN%.UDGB01.PARAM.RESRC ^
  -n end ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/STATE/FLAGS+INDIC ^
  -n tag       %FACN%.%IDEN%.UDGB01.STATE.FLAGS ^
  -n tag       %FACN%.%IDEN%.UDGB01.STATE.INDIC ^
  -n end ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/POLLRATE/RX+TX+EX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLRATE.RX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLRATE.TX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLRATE.EX ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/POLLSUMM/RX+TX+EX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLSUMM.RX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLSUMM.TX ^
  -n tag       %FACN%.%IDEN%.UDGB01.POLLSUMM.EX ^
  -n dis_info  %FACP%/%IDEN%/UDGB01/ERROR/COUNT ^
  -n tag       %FACN%.%IDEN%.UDGB01.ERROR.COUNT ^
  -n end
echo.
goto :EOF

:UDGB01_DIC
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.UDGB01.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDEN%/UDGB01/DIMGUICLICK ^
  -n tag        %FACN%.%IDEN%.UDGB01.DIMGUICLICK ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/POLL/ENABLE ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLL.ENABLE ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLL.ENABLE" ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/PARAM/DTIME ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.DTIME ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.DTIME" ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/PARAM/GASVA ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.GASVA ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.GASVA" ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/PARAM/YELVA+REDVA+DRYVA+RESRC ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.YELVA ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.REDVA ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.DRYVA ^
  -n tag        %FACN%.%IDEN%.UDGB01.PARAM.RESRC ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.YELVA" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.REDVA" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.DRYVA" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.PARAM.RESRC" ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/STATE/FLAGS+INDIC ^
  -n tag        %FACN%.%IDEN%.UDGB01.STATE.FLAGS ^
  -n tag        %FACN%.%IDEN%.UDGB01.STATE.INDIC ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.STATE.FLAGS" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.STATE.INDIC" ^
  -n end ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/POLLRATE/RX+TX+EX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLRATE.RX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLRATE.TX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLRATE.EX ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLRATE.RX" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLRATE.TX" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLRATE.EX" ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/POLLSUMM/RX+TX+EX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLSUMM.RX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLSUMM.TX ^
  -n tag        %FACN%.%IDEN%.UDGB01.POLLSUMM.EX ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLSUMM.RX" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLSUMM.TX" ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.POLLSUMM.EX" ^
  -n dic_info   %FACP%/%IDEN%/UDGB01/ERROR/COUNT ^
  -n tag        %FACN%.%IDEN%.UDGB01.ERROR.COUNT ^
  -n %devmsg% "&%FACN%.%IDEN%.UDGB01.CTRL @DimTagUpdate=%FACN%.%IDEN%.UDGB01.ERROR.COUNT" ^
  -n end
echo.
goto :EOF

:DeleteFile
:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
