unit unit_cctb_tester;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, Math,
  ExtCtrls, Spin, ModBusTCP, tcp_udpport, Tag, PLCStruct, PLCStructElement,
  HMICheckBox, PLCBlock, PLCBlockElement, DefaultTranslator;

type

  { TFormCctbTester }

  TFormCctbTester = class(TForm)
    ButtonTcpOpen: TButton;
    EditCommandsPerSecond: TEdit;
    EditParamG2: TEdit;
    EditParamP12: TEdit;
    EditParamP21: TEdit;
    EditParamP22: TEdit;
    EditParamP31: TEdit;
    EditParamP32: TEdit;
    EditParamP41: TEdit;
    EditParamP42: TEdit;
    EditParamP51: TEdit;
    EditParamP52: TEdit;
    EditParamT51: TEdit;
    EditParamT41: TEdit;
    EditParamT31: TEdit;
    EditParamT21: TEdit;
    EditParamT11: TEdit;
    EditParamT12: TEdit;
    EditParamT13: TEdit;
    EditParamT14: TEdit;
    EditParamT22: TEdit;
    EditParamT23: TEdit;
    EditParamT24: TEdit;
    EditParamT32: TEdit;
    EditParamT33: TEdit;
    EditParamT34: TEdit;
    EditParamT42: TEdit;
    EditParamT43: TEdit;
    EditParamT44: TEdit;
    EditParamT52: TEdit;
    EditParamT53: TEdit;
    EditParamT54: TEdit;
    EditParamG1: TEdit;
    EditStateG2: TEdit;
    EditStateReady: TEdit;
    EditStateP11: TEdit;
    EditParamP11: TEdit;
    EditHostName: TEdit;
    EditStateP12: TEdit;
    EditStateP21: TEdit;
    EditStateP22: TEdit;
    EditStateP31: TEdit;
    EditStateP32: TEdit;
    EditStateP41: TEdit;
    EditStateP42: TEdit;
    EditStateP51: TEdit;
    EditStateP52: TEdit;
    EditStateT51: TEdit;
    EditStateT41: TEdit;
    EditStateT31: TEdit;
    EditStateT21: TEdit;
    EditStateT11: TEdit;
    EditStateT12: TEdit;
    EditStateT13: TEdit;
    EditStateT14: TEdit;
    EditStateT22: TEdit;
    EditStateT23: TEdit;
    EditStateT24: TEdit;
    EditStateT32: TEdit;
    EditStateT33: TEdit;
    EditStateT34: TEdit;
    EditStateT42: TEdit;
    EditStateT43: TEdit;
    EditStateT44: TEdit;
    EditStateT52: TEdit;
    EditStateT53: TEdit;
    EditStateT54: TEdit;
    EditStateG1: TEdit;
    GroupBoxParams: TGroupBox;
    GroupBoxTcpIpSettings: TGroupBox;
    HMICheckBoxCoils0: THMICheckBox;
    HMICheckBoxCoils1: THMICheckBox;
    HMICheckBoxCoils10: THMICheckBox;
    HMICheckBoxCoils11: THMICheckBox;
    HMICheckBoxCoils12: THMICheckBox;
    HMICheckBoxCoils13: THMICheckBox;
    HMICheckBoxCoils14: THMICheckBox;
    HMICheckBoxCoils15: THMICheckBox;
    HMICheckBoxCoils16: THMICheckBox;
    HMICheckBoxCoils17: THMICheckBox;
    HMICheckBoxCoils18: THMICheckBox;
    HMICheckBoxCoils19: THMICheckBox;
    HMICheckBoxCoils2: THMICheckBox;
    HMICheckBoxCoils20: THMICheckBox;
    HMICheckBoxCoils21: THMICheckBox;
    HMICheckBoxCoils22: THMICheckBox;
    HMICheckBoxCoils23: THMICheckBox;
    HMICheckBoxCoils24: THMICheckBox;
    HMICheckBoxCoils25: THMICheckBox;
    HMICheckBoxCoils26: THMICheckBox;
    HMICheckBoxCoils27: THMICheckBox;
    HMICheckBoxCoils28: THMICheckBox;
    HMICheckBoxCoils29: THMICheckBox;
    HMICheckBoxCoils3: THMICheckBox;
    HMICheckBoxCoils30: THMICheckBox;
    HMICheckBoxCoils31: THMICheckBox;
    HMICheckBoxCoils32: THMICheckBox;
    HMICheckBoxCoils33: THMICheckBox;
    HMICheckBoxCoils34: THMICheckBox;
    HMICheckBoxCoils35: THMICheckBox;
    HMICheckBoxCoils36: THMICheckBox;
    HMICheckBoxCoils4: THMICheckBox;
    HMICheckBoxCoils5: THMICheckBox;
    HMICheckBoxCoils6: THMICheckBox;
    HMICheckBoxCoils7: THMICheckBox;
    HMICheckBoxCoils8: THMICheckBox;
    HMICheckBoxCoils9: THMICheckBox;
    LabelAckno: TLabel;
    LabelAcknoNums: TLabel;
    LabelPLCStation: TLabel;
    LabelCommandsPerSecond: TLabel;
    LabelParamG2: TLabel;
    LabelParamReady: TLabel;
    LabelParamP12: TLabel;
    LabelParamP21: TLabel;
    LabelParamP22: TLabel;
    LabelParamP31: TLabel;
    LabelParamP32: TLabel;
    LabelParamP41: TLabel;
    LabelParamP42: TLabel;
    LabelParamP51: TLabel;
    LabelParamP52: TLabel;
    LabelParamT51: TLabel;
    LabelParamT41: TLabel;
    LabelParamT31: TLabel;
    LabelParamT21: TLabel;
    LabelParamT11: TLabel;
    LabelParamT12: TLabel;
    LabelParamT13: TLabel;
    LabelParamT14: TLabel;
    LabelParamT22: TLabel;
    LabelParamT23: TLabel;
    LabelParamT24: TLabel;
    LabelParamT32: TLabel;
    LabelParamT33: TLabel;
    LabelParamT34: TLabel;
    LabelParamT42: TLabel;
    LabelParamT43: TLabel;
    LabelParamT44: TLabel;
    LabelParamT52: TLabel;
    LabelParamT53: TLabel;
    LabelParamT54: TLabel;
    LabelParamG1: TLabel;
    LabelUpdateRate: TLabel;
    LabelParamP11: TLabel;
    LabelHostName: TLabel;
    LabelTcpPort: TLabel;
    ModBusTCPDriver: TModBusTCPDriver;
    PanelTcpStateIndicator: TPanel;
    PLCBlockCoils: TPLCBlock;
    PLCBlockElementCoils0: TPLCBlockElement;
    PLCBlockElementCoils1: TPLCBlockElement;
    PLCBlockElementCoils10: TPLCBlockElement;
    PLCBlockElementCoils11: TPLCBlockElement;
    PLCBlockElementCoils12: TPLCBlockElement;
    PLCBlockElementCoils13: TPLCBlockElement;
    PLCBlockElementCoils14: TPLCBlockElement;
    PLCBlockElementCoils15: TPLCBlockElement;
    PLCBlockElementCoils16: TPLCBlockElement;
    PLCBlockElementCoils17: TPLCBlockElement;
    PLCBlockElementCoils18: TPLCBlockElement;
    PLCBlockElementCoils19: TPLCBlockElement;
    PLCBlockElementCoils2: TPLCBlockElement;
    PLCBlockElementCoils20: TPLCBlockElement;
    PLCBlockElementCoils21: TPLCBlockElement;
    PLCBlockElementCoils22: TPLCBlockElement;
    PLCBlockElementCoils23: TPLCBlockElement;
    PLCBlockElementCoils24: TPLCBlockElement;
    PLCBlockElementCoils25: TPLCBlockElement;
    PLCBlockElementCoils26: TPLCBlockElement;
    PLCBlockElementCoils27: TPLCBlockElement;
    PLCBlockElementCoils28: TPLCBlockElement;
    PLCBlockElementCoils29: TPLCBlockElement;
    PLCBlockElementCoils3: TPLCBlockElement;
    PLCBlockElementCoils30: TPLCBlockElement;
    PLCBlockElementCoils31: TPLCBlockElement;
    PLCBlockElementCoils32: TPLCBlockElement;
    PLCBlockElementCoils33: TPLCBlockElement;
    PLCBlockElementCoils34: TPLCBlockElement;
    PLCBlockElementCoils35: TPLCBlockElement;
    PLCBlockElementCoils36: TPLCBlockElement;
    PLCBlockElementCoils4: TPLCBlockElement;
    PLCBlockElementCoils5: TPLCBlockElement;
    PLCBlockElementCoils6: TPLCBlockElement;
    PLCBlockElementCoils7: TPLCBlockElement;
    PLCBlockElementCoils8: TPLCBlockElement;
    PLCBlockElementCoils9: TPLCBlockElement;
    PLCStructItemParamG2: TPLCStructItem;
    PLCStructItemParamP11: TPLCStructItem;
    PLCStructItemParamP12: TPLCStructItem;
    PLCStructItemParamP21: TPLCStructItem;
    PLCStructItemParamP22: TPLCStructItem;
    PLCStructItemParamP32: TPLCStructItem;
    PLCStructItemParamP42: TPLCStructItem;
    PLCStructItemParamP52: TPLCStructItem;
    PLCStructItemParamT51: TPLCStructItem;
    PLCStructItemParamT41: TPLCStructItem;
    PLCStructItemParamT31: TPLCStructItem;
    PLCStructItemParamT21: TPLCStructItem;
    PLCStructItemParamT11: TPLCStructItem;
    PLCStructItemParamT12: TPLCStructItem;
    PLCStructItemParamT13: TPLCStructItem;
    PLCStructItemParamT14: TPLCStructItem;
    PLCStructItemParamT22: TPLCStructItem;
    PLCStructItemParamT23: TPLCStructItem;
    PLCStructItemParamT24: TPLCStructItem;
    PLCStructItemParamP31: TPLCStructItem;
    PLCStructItemParamT32: TPLCStructItem;
    PLCStructItemParamT33: TPLCStructItem;
    PLCStructItemParamT34: TPLCStructItem;
    PLCStructItemParamP41: TPLCStructItem;
    PLCStructItemParamT42: TPLCStructItem;
    PLCStructItemParamT43: TPLCStructItem;
    PLCStructItemParamT44: TPLCStructItem;
    PLCStructItemParamP51: TPLCStructItem;
    PLCStructItemParamT52: TPLCStructItem;
    PLCStructItemParamT53: TPLCStructItem;
    PLCStructItemParamT54: TPLCStructItem;
    PLCStructItemParamG1: TPLCStructItem;
    PLCStructItemStateG2: TPLCStructItem;
    PLCStructItemStateReady: TPLCStructItem;
    PLCStructItemStateP11: TPLCStructItem;
    PLCStructItemStateP12: TPLCStructItem;
    PLCStructItemStateP21: TPLCStructItem;
    PLCStructItemStateP22: TPLCStructItem;
    PLCStructItemStateP32: TPLCStructItem;
    PLCStructItemStateP42: TPLCStructItem;
    PLCStructItemStateP52: TPLCStructItem;
    PLCStructItemStateT51: TPLCStructItem;
    PLCStructItemStateT41: TPLCStructItem;
    PLCStructItemStateT31: TPLCStructItem;
    PLCStructItemStateT21: TPLCStructItem;
    PLCStructItemStateT11: TPLCStructItem;
    PLCStructItemStateT12: TPLCStructItem;
    PLCStructItemStateT13: TPLCStructItem;
    PLCStructItemStateT14: TPLCStructItem;
    PLCStructItemStateT22: TPLCStructItem;
    PLCStructItemStateT23: TPLCStructItem;
    PLCStructItemStateT24: TPLCStructItem;
    PLCStructItemStateP31: TPLCStructItem;
    PLCStructItemStateT32: TPLCStructItem;
    PLCStructItemStateT33: TPLCStructItem;
    PLCStructItemStateT34: TPLCStructItem;
    PLCStructItemStateP41: TPLCStructItem;
    PLCStructItemStateT42: TPLCStructItem;
    PLCStructItemStateT43: TPLCStructItem;
    PLCStructItemStateT44: TPLCStructItem;
    PLCStructItemStateP51: TPLCStructItem;
    PLCStructItemStateT52: TPLCStructItem;
    PLCStructItemStateT53: TPLCStructItem;
    PLCStructItemStateT54: TPLCStructItem;
    PLCStructItemStateG1: TPLCStructItem;
    PLCStructParams: TPLCStruct;
    SpinEditPLCStation: TSpinEdit;
    SpinEditPollRate: TSpinEdit;
    SpinEditTcpPort: TSpinEdit;
    TCP_UDPPort: TTCP_UDPPort;
    TimerTcpState: TTimer;
    procedure ButtonTcpOpenClick(Sender: TObject);
    procedure EditHostNameEnter(Sender: TObject);
    procedure EditHostNameExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PLCStructParamsValueChange(Sender: TObject);
    procedure SpinEditPLCStationEditingDone(Sender: TObject);
    procedure SpinEditPLCStationEnter(Sender: TObject);
    procedure SpinEditPLCStationExit(Sender: TObject);
    procedure SpinEditPollRateChange(Sender: TObject);
    procedure SpinEditTcpPortEditingDone(Sender: TObject);
    procedure SpinEditTcpPortEnter(Sender: TObject);
    procedure SpinEditTcpPortExit(Sender: TObject);
    procedure TimerTcpStateTimer(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FormCctbTester: TFormCctbTester;

implementation

{$R *.lfm}

{ TFormCctbTester }

procedure TFormCctbTester.SpinEditTcpPortEnter(Sender: TObject);
begin
  SpinEditTcpPort.Value:=TCP_UDPPort.Port;
end;


procedure TFormCctbTester.SpinEditTcpPortEditingDone(Sender: TObject);
begin
  if TCP_UDPPort.Active
  then SpinEditTcpPort.Value:=TCP_UDPPort.Port
  else TCP_UDPPort.Port:=SpinEditTcpPort.Value;
end;

procedure TFormCctbTester.SpinEditTcpPortExit(Sender: TObject);
begin
  SpinEditTcpPortEditingDone(Sender);
end;

procedure TFormCctbTester.TimerTcpStateTimer(Sender: TObject);
begin
  if TCP_UDPPort.Active
  then PanelTcpStateIndicator.Color:=clLime
  else PanelTcpStateIndicator.Color:=clGray;
  EditCommandsPerSecond.Text:=Format('%d',[TCP_UDPPort.CommandsPerSecond]);
end;

procedure TFormCctbTester.ButtonTcpOpenClick(Sender: TObject);
begin
  TCP_UDPPort.Active:=not TCP_UDPPort.Active;
end;

procedure TFormCctbTester.EditHostNameEnter(Sender: TObject);
begin
  EditHostName.Text:=TCP_UDPPort.Host;
end;

procedure TFormCctbTester.EditHostNameExit(Sender: TObject);
begin
  if TCP_UDPPort.Active
  then EditHostName.Text:=TCP_UDPPort.Host
  else TCP_UDPPort.Host:=EditHostName.Text;
end;

procedure UpdateIndex(const Items:array of TPLCStructItem);
const TagSize:array[TTagType] of Integer = (0,1,1,2,2,4,4,4);
var i,index:Integer;
begin
  index:=0;
  for i:=Low(Items) to High(Items) do begin
   Items[i].Index:=index;
   Inc(index,TagSize[Items[i].TagType]);
  end;
end;

procedure UpdateCoilsIndex(const HMICheckBoxCoils: array of THMICheckBox;
                           const PLCBlockElementCoils: array of TPLCBlockElement);
var i:Integer;
begin
  for i:=Low(PLCBlockElementCoils) to High(PLCBlockElementCoils) do PLCBlockElementCoils[i].Index:=i;
  for i:=Max(Low(PLCBlockElementCoils),Low(HMICheckBoxCoils))
      to Min(High(PLCBlockElementCoils),High(HMICheckBoxCoils)) do
      HMICheckBoxCoils[i].PLCTag:=PLCBlockElementCoils[i];
end;

procedure TFormCctbTester.FormCreate(Sender: TObject);
begin
  inherited ;
  UpdateIndex([PLCStructItemParamP11,PLCStructItemStateP11,
               PLCStructItemParamP12,PLCStructItemStateP12,
               PLCStructItemParamP21,PLCStructItemStateP21,
               PLCStructItemParamP22,PLCStructItemStateP22,
               PLCStructItemParamP31,PLCStructItemStateP31,
               PLCStructItemParamP32,PLCStructItemStateP32,
               PLCStructItemParamP41,PLCStructItemStateP41,
               PLCStructItemParamP42,PLCStructItemStateP42,
               PLCStructItemParamP51,PLCStructItemStateP51,
               PLCStructItemParamP52,PLCStructItemStateP52,
               PLCStructItemParamT11,PLCStructItemStateT11,
               PLCStructItemParamT12,PLCStructItemStateT12,
               PLCStructItemParamT13,PLCStructItemStateT13,
               PLCStructItemParamT14,PLCStructItemStateT14,
               PLCStructItemParamT21,PLCStructItemStateT21,
               PLCStructItemParamT22,PLCStructItemStateT22,
               PLCStructItemParamT23,PLCStructItemStateT23,
               PLCStructItemParamT24,PLCStructItemStateT24,
               PLCStructItemParamT31,PLCStructItemStateT31,
               PLCStructItemParamT32,PLCStructItemStateT32,
               PLCStructItemParamT33,PLCStructItemStateT33,
               PLCStructItemParamT34,PLCStructItemStateT34,
               PLCStructItemParamT41,PLCStructItemStateT41,
               PLCStructItemParamT42,PLCStructItemStateT42,
               PLCStructItemParamT43,PLCStructItemStateT43,
               PLCStructItemParamT44,PLCStructItemStateT44,
               PLCStructItemParamT51,PLCStructItemStateT51,
               PLCStructItemParamT52,PLCStructItemStateT52,
               PLCStructItemParamT53,PLCStructItemStateT53,
               PLCStructItemParamT54,PLCStructItemStateT54,
               PLCStructItemParamG1,PLCStructItemStateG1,
               PLCStructItemParamG2,PLCStructItemStateG2,
               PLCStructItemStateReady]);
  UpdateCoilsIndex([HMICheckBoxCoils0,HMICheckBoxCoils1,HMICheckBoxCoils2,HMICheckBoxCoils3,
                    HMICheckBoxCoils4,HMICheckBoxCoils5,HMICheckBoxCoils6,HMICheckBoxCoils7,
                    HMICheckBoxCoils8,HMICheckBoxCoils9,HMICheckBoxCoils10,HMICheckBoxCoils11,
                    HMICheckBoxCoils12,HMICheckBoxCoils13,HMICheckBoxCoils14,HMICheckBoxCoils15,
                    HMICheckBoxCoils16,HMICheckBoxCoils17,HMICheckBoxCoils18,HMICheckBoxCoils19,
                    HMICheckBoxCoils20,HMICheckBoxCoils21,HMICheckBoxCoils22,HMICheckBoxCoils23,
                    HMICheckBoxCoils24,HMICheckBoxCoils25,HMICheckBoxCoils26,HMICheckBoxCoils27,
                    HMICheckBoxCoils28,HMICheckBoxCoils29,HMICheckBoxCoils30,HMICheckBoxCoils31,
                    HMICheckBoxCoils32,HMICheckBoxCoils33,HMICheckBoxCoils34,HMICheckBoxCoils35,
                    HMICheckBoxCoils36],
                   [PLCBlockElementCoils0,PLCBlockElementCoils1,PLCBlockElementCoils2,PLCBlockElementCoils3,
                    PLCBlockElementCoils4,PLCBlockElementCoils5,PLCBlockElementCoils6,PLCBlockElementCoils7,
                    PLCBlockElementCoils8,PLCBlockElementCoils9,PLCBlockElementCoils10,PLCBlockElementCoils11,
                    PLCBlockElementCoils12,PLCBlockElementCoils13,PLCBlockElementCoils14,PLCBlockElementCoils15,
                    PLCBlockElementCoils16,PLCBlockElementCoils17,PLCBlockElementCoils18,PLCBlockElementCoils19,
                    PLCBlockElementCoils20,PLCBlockElementCoils21,PLCBlockElementCoils22,PLCBlockElementCoils23,
                    PLCBlockElementCoils24,PLCBlockElementCoils25,PLCBlockElementCoils26,PLCBlockElementCoils27,
                    PLCBlockElementCoils28,PLCBlockElementCoils29,PLCBlockElementCoils30,PLCBlockElementCoils31,
                    PLCBlockElementCoils32,PLCBlockElementCoils33,PLCBlockElementCoils34,PLCBlockElementCoils35,
                    PLCBlockElementCoils36]);
  SpinEditPollRateChange(Self);
  SpinEditPLCStation.Value:=PLCStructParams.PLCStation;
  SpinEditTcpPort.Value:=TCP_UDPPort.Port;
  EditHostName.Text:=TCP_UDPPort.Host;
end;

procedure UpdateParam(Edit,Sender:TObject);
begin
  if (Sender is TPLCStructItem) and (Edit is TEdit) then
  (Edit as TEdit).Text:=Format('%7.3f',[(Sender as TPLCStructItem).Value]);
end;

procedure UpdateState(Edit,Sender:TObject);
begin
  if (Sender is TPLCStructItem) and (Edit is TEdit) then
  (Edit as TEdit).Text:=Format('%d',[Round((Sender as TPLCStructItem).Value)]);
end;

procedure TFormCctbTester.PLCStructParamsValueChange(Sender: TObject);
begin
  UpdateParam(EditParamP11,PLCStructItemParamP11);
  UpdateState(EditStateP11,PLCStructItemStateP11);
  UpdateParam(EditParamP12,PLCStructItemParamP12);
  UpdateState(EditStateP12,PLCStructItemStateP12);
  UpdateParam(EditParamT11,PLCStructItemParamT11);
  UpdateState(EditStateT11,PLCStructItemStateT11);
  UpdateParam(EditParamT12,PLCStructItemParamT12);
  UpdateState(EditStateT12,PLCStructItemStateT12);
  UpdateParam(EditParamT13,PLCStructItemParamT13);
  UpdateState(EditStateT13,PLCStructItemStateT13);
  UpdateParam(EditParamT14,PLCStructItemParamT14);
  UpdateState(EditStateT14,PLCStructItemStateT14);
  UpdateParam(EditParamP21,PLCStructItemParamP21);
  UpdateState(EditStateP21,PLCStructItemStateP21);
  UpdateParam(EditParamP22,PLCStructItemParamP22);
  UpdateState(EditStateP22,PLCStructItemStateP22);
  UpdateParam(EditParamT21,PLCStructItemParamT21);
  UpdateState(EditStateT21,PLCStructItemStateT21);
  UpdateParam(EditParamT22,PLCStructItemParamT22);
  UpdateState(EditStateT22,PLCStructItemStateT22);
  UpdateParam(EditParamT23,PLCStructItemParamT23);
  UpdateState(EditStateT23,PLCStructItemStateT23);
  UpdateParam(EditParamT24,PLCStructItemParamT24);
  UpdateState(EditStateT24,PLCStructItemStateT24);
  UpdateParam(EditParamP31,PLCStructItemParamP31);
  UpdateState(EditStateP31,PLCStructItemStateP31);
  UpdateParam(EditParamP32,PLCStructItemParamP32);
  UpdateState(EditStateP32,PLCStructItemStateP32);
  UpdateParam(EditParamT31,PLCStructItemParamT31);
  UpdateState(EditStateT31,PLCStructItemStateT31);
  UpdateParam(EditParamT32,PLCStructItemParamT32);
  UpdateState(EditStateT32,PLCStructItemStateT32);
  UpdateParam(EditParamT33,PLCStructItemParamT33);
  UpdateState(EditStateT33,PLCStructItemStateT33);
  UpdateParam(EditParamT34,PLCStructItemParamT34);
  UpdateState(EditStateT34,PLCStructItemStateT34);
  UpdateParam(EditParamP41,PLCStructItemParamP41);
  UpdateState(EditStateP41,PLCStructItemStateP41);
  UpdateParam(EditParamP42,PLCStructItemParamP42);
  UpdateState(EditStateP42,PLCStructItemStateP42);
  UpdateParam(EditParamT41,PLCStructItemParamT41);
  UpdateState(EditStateT41,PLCStructItemStateT41);
  UpdateParam(EditParamT42,PLCStructItemParamT42);
  UpdateState(EditStateT42,PLCStructItemStateT42);
  UpdateParam(EditParamT43,PLCStructItemParamT43);
  UpdateState(EditStateT43,PLCStructItemStateT43);
  UpdateParam(EditParamT44,PLCStructItemParamT44);
  UpdateState(EditStateT44,PLCStructItemStateT44);
  UpdateParam(EditParamP51,PLCStructItemParamP51);
  UpdateState(EditStateP51,PLCStructItemStateP51);
  UpdateParam(EditParamP52,PLCStructItemParamP52);
  UpdateState(EditStateP52,PLCStructItemStateP52);
  UpdateParam(EditParamT51,PLCStructItemParamT51);
  UpdateState(EditStateT51,PLCStructItemStateT51);
  UpdateParam(EditParamT52,PLCStructItemParamT52);
  UpdateState(EditStateT52,PLCStructItemStateT52);
  UpdateParam(EditParamT53,PLCStructItemParamT53);
  UpdateState(EditStateT53,PLCStructItemStateT53);
  UpdateParam(EditParamT54,PLCStructItemParamT54);
  UpdateState(EditStateT54,PLCStructItemStateT54);
  UpdateParam(EditParamG1,PLCStructItemParamG1);
  UpdateState(EditStateG1,PLCStructItemStateG1);
  UpdateParam(EditParamG2,PLCStructItemParamG2);
  UpdateState(EditStateG2,PLCStructItemStateG2);
  UpdateState(EditStateReady,PLCStructItemStateReady);
end;

procedure TFormCctbTester.SpinEditPLCStationEditingDone(Sender: TObject);
begin
  if TCP_UDPPort.Active
  then SpinEditPLCStation.Value:=PLCStructParams.PLCStation
  else PLCStructParams.PLCStation:=SpinEditPLCStation.Value;
end;

procedure TFormCctbTester.SpinEditPLCStationEnter(Sender: TObject);
begin
  SpinEditPLCStation.Value:=PLCStructParams.PLCStation;
end;

procedure TFormCctbTester.SpinEditPLCStationExit(Sender: TObject);
begin
  SpinEditPLCStationEditingDone(Sender);
end;

procedure TFormCctbTester.SpinEditPollRateChange(Sender: TObject);
begin
  PLCBlockCoils.RefreshTime:=SpinEditPollRate.Value;
  PLCStructParams.RefreshTime:=SpinEditPollRate.Value;
  ModBusTCPDriver.ReadSomethingAlways:=(PLCStructParams.RefreshTime<2);
end;

end.

