 {
 ***********************************************************************
 CCTB - main simulator.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Test n        - Run test number n, for demo and debug.
|********************************************************
[]
 }
program cctb_main_sim;           { CCTB - main simulator            }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 aotags,dotags     : array[0..512] of Integer; { In/Out tags        }
 tagSimWaveNoise   : Integer;    { Wave noise                       }
 tagSimWaveFreq    : Integer;    { Wave frequency                   }
 tagSimWaveAmpl    : Integer;    { Wave amlitude                    }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Simulator initialization
 }
 procedure sim_init;
 var i:Integer;
 begin
  for i:=0 to NumAos-1 do InitTag(aotags[i],'SIM'+Copy(CrvName(RefAo(i)),5),-2);
  for i:=0 to NumDos-1 do InitTag(dotags[i],'SIM'+Copy(CrvName(RefDo(i)),5),-1);
  InitTag(tagSimWaveNoise, ReadIni('tagSim')+'.WAVE.NOISE', 2);
  InitTag(tagSimWaveFreq,  ReadIni('tagSim')+'.WAVE.FREQ',  2);
  InitTag(tagSimWaveAmpl,  ReadIni('tagSim')+'.WAVE.AMPL',  2);
 end;
 {
 Simulator polling
 }
 procedure sim_poll;
 var i,n:Integer;
 begin
  for i:=0 to NumAos-1 do
  if TypeTag(aotags[i])>0 then begin
   UpdateAo(i,time,rGetTag(aotags[i])+rGetTag(tagSimWaveNoise)*Random(-0.5,0.5)
           +rGetTag(tagSimWaveAmpl)*sin(2*pi*(time*TimeUnits/1000*rGetTag(tagSimWaveFreq))+i));
  end;
  for i:=0 to NumDos-1 do
  if TypeTag(dotags[i])>0 then begin
   n:=iGetTag(dotags[i]);
   if i<32 then n:=iSetBit(n,1,Round(diword(i,1)));
   UpdateDo(i,time,n);
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  sim_init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  sim_poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Test 1
   }
   if IsSameText(cmd,'@Test') then begin
    n:=iEvalDef(ExtractWord(1,arg),0);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
