////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin sample.                                        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Демонстрационный пример вывода сообщений на консоль и в окно.
[]
[Manual.Eng]
Demo for console and dialog window output.
[]
[Arguments.Rus]
Аргумент1 = 1
Аргумент2 = 2
[]
[Arguments.Eng]
Argument1 = 1
Argument2 = 2
[]
}

library hello_plugin;

{$I _crw_sysdef}

{$IFDEF FPC}{$mode Delphi}{$ENDIF}{$H+}

{$R *.res}

uses
 _crw_sharemem, // NB: THIS UNIT MUST BE FIRST !!!
 {$IFDEF UNIX} cthreads, dl, {$ENDIF}
 {$IFDEF WINDOWS} windows, {$ENDIF}
 sysutils, classes, math,
 _crw_crwapi;

//////////////////////////////////////////////////
{$I _crw_plugin_declare} // Declare CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:TCrwApi):Integer;
//////////////////////////////////////////////////
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DanApi do begin
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  if Target = ForDataAnalysis then begin
   writeln('Hello,world!');
   Warning('Hello,world!');
   writeln('Plugin Arguments: '+EOL+GetArguments);
   if WindowExists(1)
   then writeln('Source Caption: '+GetWindowCaption(1))
   else writeln('Source Curve Window not found.');
  end else begin
   Result:=-1;
   writeln('Invalid plugin target.');
   writeln('ForDataAnalysis expected.');
  end;
 end;
end;

//////////////////////////////////////////////////
{$I _crw_plugin_exports} // Exports CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID; //
//////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
