/***********************************************************************
 Вычисление числа PI по формуле Фабриса Беллара
 GMP, типы-интерфейсы.

 Компиляция:
	g++ pi_bel_gmp_cpp.cpp -o pi_bel_gmp_cpp -lgmpxx -lgmp
************************************************************************/
#include <iostream>
#include <ctime>
#include <gmp.h>
#include <gmpxx.h>

using namespace std;

const unsigned int prec = 128;
/*
mpf_class power(mpf_class x, unsigned int n)
{
    mpf_class powval(1, x.get_prec());
        for (unsigned int num = n; num != 0; --num)
    {
                powval *= x;
    }
    return powval;
}
*/
mpf_class power(mpf_class x, unsigned int n)
{
  mpf_class count(1.0, x.get_prec());
    
  if (!n) return count;

  while (n)
  {
    if (n % 2 == 0)
    {
      n /= 2;
      x*=x;
    }
    else
    {
      n--;
      count*=x;
    }
  }

  return count;
}

int main()
{  
  mp_exp_t e;
  mpf_class pi_bellard(0.0, prec);
  mpf_class m1(0.0, prec), m2(0.0, prec), m3(0.0, prec), m4(0.0, prec), m5(0.0, prec), m6(0.0, prec), m7(0.0, prec), m8(0.0, prec);
  mpf_class tmp_1(-1.0, prec), tmp1(1.0, prec),tmp2(2.0, prec),tmp3(3.0, prec),tmp5(5.0, prec),tmp7(7.0, prec),tmp9(9.0, prec);
  time_t startt, endt;
  long int k;

  startt=time(NULL);
  
  for( k=0; k<= 20000000; k++)
  {
    m1 = power(tmp_1, k)/power(tmp2, (10*k));
    m2 = -(power(tmp2, 5)/(4*k + tmp1));
    m3 = tmp1/(4*k + tmp3);
    m4 = power(tmp2, 8)/(10*k + tmp1);
    m5 = power(tmp2, 6)/(10*k + tmp3);
    m6 = power(tmp2, 2)/(10*k + tmp5);
    m7 = power(tmp2, 2)/(10*k + tmp7);
    m8 = tmp1/(10*k + tmp9);
    
    pi_bellard = pi_bellard + m1 * (m2 - m3 + m4 - m5 - m6 - m7 + m8);
    
/*    if(k % 100000 == 0)
    {
      printf("%d\n", k);
    }
*/    
  };
  pi_bellard = pi_bellard * tmp1/power(tmp2, 6);

  endt = time(NULL);

  cout.precision(40);
  cout << pi_bellard << endl;
  cout << "Время: " << difftime(endt, startt) << " секунд" << endl;
  cout << "3,14159265358979323846264338327950288" << endl;
 
  return 0;
}
