package spark.skins
{
   import spark.components.supportClasses.Skin;
   import flash.geom.ColorTransform;
   import flash.display.DisplayObject;
   import spark.primitives.supportClasses.GraphicElement;
   
   public class SparkSkin extends Skin
   {
      
      private static const DEFAULT_COLOR_VALUE:uint = 204;
      
      private static const DEFAULT_COLOR:uint = 13421772;
      
      private static const DEFAULT_SYMBOL_COLOR:uint = 0;
      
      private static var colorTransform:ColorTransform = new ColorTransform();
      
      private static var oldContentBackgroundAlpha:Number;
      
      private static var contentBackgroundAlphaSetLocally:Boolean;
       
      protected var useChromeColor:Boolean = false;
      
      private var colorized:Boolean = false;
      
      public function SparkSkin()
      {
         super();
      }
      
      public function get colorizeExclusions() : Array
      {
         return null;
      }
      
      public function get symbolItems() : Array
      {
         return null;
      }
      
      public function get contentItems() : Array
      {
         return null;
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var i:int = 0;
         var symbolColor:uint = 0;
         var contentBackgroundColor:uint = 0;
         var contentBackgroundAlpha:Number = NaN;
         var exclusions:Array = null;
         var exclusionObject:Object = null;
         var symbols:Array = this.symbolItems;
         if(Boolean(symbols) && Boolean(symbols.length > 0))
         {
            symbolColor = getStyle("symbolColor");
            for(i = 0; i < symbols.length; i++)
            {
               if(this[symbols[i]])
               {
                  this[symbols[i]].color = symbolColor;
               }
            }
         }
         var content:Array = this.contentItems;
         if(Boolean(content) && Boolean(content.length > 0))
         {
            contentBackgroundColor = getStyle("contentBackgroundColor");
            contentBackgroundAlpha = getStyle("contentBackgroundAlpha");
            for(i = 0; i < content.length; i++)
            {
               if(this[content[i]])
               {
                  this[content[i]].color = contentBackgroundColor;
                  this[content[i]].alpha = contentBackgroundAlpha;
               }
            }
         }
         var chromeColor:uint = getStyle("chromeColor");
         if((Boolean(chromeColor != DEFAULT_COLOR) || Boolean(this.colorized)) && Boolean(this.useChromeColor))
         {
            colorTransform.redOffset = ((chromeColor & 255 << 16) >> 16) - DEFAULT_COLOR_VALUE;
            colorTransform.greenOffset = ((chromeColor & 255 << 8) >> 8) - DEFAULT_COLOR_VALUE;
            colorTransform.blueOffset = (chromeColor & 255) - DEFAULT_COLOR_VALUE;
            colorTransform.alphaMultiplier = alpha;
            transform.colorTransform = colorTransform;
            exclusions = this.colorizeExclusions;
            if(Boolean(exclusions) && Boolean(exclusions.length > 0))
            {
               colorTransform.redOffset = -colorTransform.redOffset;
               colorTransform.greenOffset = -colorTransform.greenOffset;
               colorTransform.blueOffset = -colorTransform.blueOffset;
               for(i = 0; i < exclusions.length; i++)
               {
                  exclusionObject = this[exclusions[i]];
                  if(Boolean(exclusionObject) && (Boolean(exclusionObject is DisplayObject) || Boolean(exclusionObject is GraphicElement)))
                  {
                     colorTransform.alphaMultiplier = exclusionObject.alpha;
                     exclusionObject.transform.colorTransform = colorTransform;
                  }
               }
            }
            this.colorized = true;
         }
         super.updateDisplayList(unscaledWidth,unscaledHeight);
      }
      
      override public function beginHighlightBitmapCapture() : Boolean
      {
         var needRedraw:Boolean = super.beginHighlightBitmapCapture();
         if(getStyle("contentBackgroundAlpha") < 0.5)
         {
            if(Boolean(styleDeclaration) && Boolean(styleDeclaration.getStyle("contentBackgroundAlpha") !== null))
            {
               contentBackgroundAlphaSetLocally = true;
            }
            else
            {
               contentBackgroundAlphaSetLocally = false;
            }
            oldContentBackgroundAlpha = getStyle("contentBackgroundAlpha");
            setStyle("contentBackgroundAlpha",0.5);
            needRedraw = true;
         }
         return needRedraw;
      }
      
      override public function endHighlightBitmapCapture() : Boolean
      {
         var needRedraw:Boolean = super.endHighlightBitmapCapture();
         if(!isNaN(oldContentBackgroundAlpha))
         {
            if(contentBackgroundAlphaSetLocally)
            {
               setStyle("contentBackgroundAlpha",oldContentBackgroundAlpha);
            }
            else
            {
               clearStyle("contentBackgroundAlpha");
            }
            needRedraw = true;
            oldContentBackgroundAlpha = NaN;
         }
         return needRedraw;
      }
   }
}
