package spark.primitives.supportClasses
{
   import mx.core.mx_internal;
   import mx.graphics.IFill;
   import flash.events.EventDispatcher;
   import mx.events.PropertyChangeEvent;
   import flash.display.Graphics;
   import flash.geom.Rectangle;
   import flash.geom.Point;
   import flash.events.Event;
   
   use namespace mx_internal;
   
   public class FilledElement extends StrokedElement
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      protected var _fill:IFill;
      
      public function FilledElement()
      {
         super();
      }
      
      [Inspectable(category="General")]
      [Bindable("propertyChange")]
      public function get fill() : IFill
      {
         return this._fill;
      }
      
      public function set fill(value:IFill) : void
      {
         var fillEventDispatcher:EventDispatcher = null;
         var oldValue:IFill = this._fill;
         fillEventDispatcher = this._fill as EventDispatcher;
         if(fillEventDispatcher)
         {
            fillEventDispatcher.removeEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.fill_propertyChangeHandler);
         }
         this._fill = value;
         fillEventDispatcher = this._fill as EventDispatcher;
         if(fillEventDispatcher)
         {
            fillEventDispatcher.addEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.fill_propertyChangeHandler);
         }
         dispatchPropertyChangeEvent("fill",oldValue,this._fill);
         invalidateDisplayList();
      }
      
      override protected function beginDraw(g:Graphics) : void
      {
         var strokeBounds:Rectangle = null;
         var fillBounds:Rectangle = null;
         var origin:Point = new Point(drawX,drawY);
         if(stroke)
         {
            strokeBounds = getStrokeBounds();
            strokeBounds.offset(drawX,drawY);
            stroke.apply(g,strokeBounds,origin);
         }
         else
         {
            g.lineStyle();
         }
         if(this.fill)
         {
            fillBounds = new Rectangle(drawX,drawY,width,height);
            this.fill.begin(g,fillBounds,origin);
         }
      }
      
      override protected function endDraw(g:Graphics) : void
      {
         if(this.fill)
         {
            this.fill.end(g);
         }
      }
      
      private function fill_propertyChangeHandler(event:Event) : void
      {
         invalidateDisplayList();
      }
   }
}
