package spark.layouts.supportClasses
{
   import mx.core.mx_internal;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class LayoutElementHelper
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function LayoutElementHelper()
      {
         super();
      }
      
      public static function pinBetween(val:Number, min:Number, max:Number) : Number
      {
         return Math.min(max,Math.max(min,val));
      }
      
      public static function parseConstraintValue(value:Object) : Number
      {
         if(value is Number)
         {
            return Number(value);
         }
         var str:String = value as String;
         if(!str)
         {
            return NaN;
         }
         var result:Array = parseConstraintExp(str);
         if(Boolean(!result) || Boolean(result.length < 1))
         {
            return NaN;
         }
         return result[0];
      }
      
      private static function parseConstraintExp(val:String) : Array
      {
         if(!val)
         {
            return null;
         }
         var temp:String = val.replace(/:/g," ");
         var args:Array = temp.split(/\s+/);
         return args;
      }
   }
}
