package spark.layouts
{
   import spark.layouts.supportClasses.LayoutBase;
   import mx.core.mx_internal;
   import mx.core.ILayoutElement;
   import spark.layouts.supportClasses.LayoutElementHelper;
   import spark.components.supportClasses.GroupBase;
   import spark.layouts.supportClasses.LinearLayoutVector;
   import mx.events.PropertyChangeEvent;
   import flash.events.Event;
   import flash.geom.Rectangle;
   import spark.core.NavigationUnit;
   import mx.containers.utilityClasses.Flex;
   import spark.layouts.supportClasses.DropLocation;
   import mx.core.IVisualElement;
   import flash.geom.Point;
   
   use namespace mx_internal;
   
   public class VerticalLayout extends LayoutBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var llv:LinearLayoutVector;
      
      private var _gap:int = 6;
      
      private var _rowCount:int = -1;
      
      private var _horizontalAlign:String = "left";
      
      private var _verticalAlign:String = "top";
      
      private var _paddingLeft:Number = 0;
      
      private var _paddingRight:Number = 0;
      
      private var _paddingTop:Number = 0;
      
      private var _paddingBottom:Number = 0;
      
      private var _requestedMinRowCount:int = -1;
      
      private var _requestedRowCount:int = -1;
      
      private var _rowHeight:Number;
      
      private var _variableRowHeight:Boolean = true;
      
      private var _firstIndexInView:int = -1;
      
      private var _lastIndexInView:int = -1;
      
      public function VerticalLayout()
      {
         this.llv = new LinearLayoutVector();
         super();
         dragScrollRegionSizeHorizontal = 0;
         this.llv.defaultMinorSize = 71;
         this.llv.defaultMajorSize = 22;
      }
      
      private static function calculatePercentWidth(layoutElement:ILayoutElement, width:Number) : Number
      {
         var percentWidth:Number = LayoutElementHelper.pinBetween(Math.round(layoutElement.percentWidth * 0.01 * width),layoutElement.getMinBoundsWidth(),layoutElement.getMaxBoundsWidth());
         return percentWidth < width?Number(percentWidth):Number(width);
      }
      
      private static function sizeLayoutElement(layoutElement:ILayoutElement, width:Number, horizontalAlign:String, restrictedWidth:Number, height:Number, variableRowHeight:Boolean, rowHeight:Number) : void
      {
         var newWidth:Number = NaN;
         if(Boolean(horizontalAlign == HorizontalAlign.JUSTIFY) || Boolean(horizontalAlign == HorizontalAlign.CONTENT_JUSTIFY))
         {
            newWidth = restrictedWidth;
         }
         else if(!isNaN(layoutElement.percentWidth))
         {
            newWidth = calculatePercentWidth(layoutElement,width);
         }
         if(variableRowHeight)
         {
            layoutElement.setLayoutBoundsSize(newWidth,height);
         }
         else
         {
            layoutElement.setLayoutBoundsSize(newWidth,rowHeight);
         }
      }
      
      private static function findIndexAt(y:Number, gap:int, g:GroupBase, i0:int, i1:int) : int
      {
         var index:int = (i0 + i1) / 2;
         var element:ILayoutElement = g.getElementAt(index);
         var elementY:Number = element.getLayoutBoundsY();
         var elementHeight:Number = element.getLayoutBoundsHeight();
         if(Boolean(y >= elementY) && Boolean(y < elementY + elementHeight + gap))
         {
            return index;
         }
         if(i0 == i1)
         {
            return -1;
         }
         if(y < elementY)
         {
            return findIndexAt(y,gap,g,i0,Math.max(i0,index - 1));
         }
         return findIndexAt(y,gap,g,Math.min(index + 1,i1),i1);
      }
      
      private static function findLayoutElementIndex(g:GroupBase, i:int, dir:int) : int
      {
         var element:ILayoutElement = null;
         var n:int = g.numElements;
         while(Boolean(i >= 0) && Boolean(i < n))
         {
            element = g.getElementAt(i);
            if(Boolean(element) && Boolean(element.includeInLayout))
            {
               return i;
            }
            i = i + dir;
         }
         return -1;
      }
      
      [Inspectable(category="General")]
      public function get gap() : int
      {
         return this._gap;
      }
      
      public function set gap(value:int) : void
      {
         if(this._gap == value)
         {
            return;
         }
         this._gap = value;
         this.llv.gap = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      [Bindable("propertyChange")]
      public function get rowCount() : int
      {
         return this._rowCount;
      }
      
      private function setRowCount(value:int) : void
      {
         if(this._rowCount == value)
         {
            return;
         }
         var oldValue:int = this._rowCount;
         this._rowCount = value;
         dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"rowCount",oldValue,value));
      }
      
      [Inspectable(defaultValue="left",category="General",enumeration="left,right,center,justify,contentJustify")]
      public function get horizontalAlign() : String
      {
         return this._horizontalAlign;
      }
      
      public function set horizontalAlign(value:String) : void
      {
         if(value == this._horizontalAlign)
         {
            return;
         }
         this._horizontalAlign = value;
         var layoutTarget:GroupBase = target;
         if(layoutTarget)
         {
            layoutTarget.invalidateDisplayList();
         }
      }
      
      [Inspectable(defaultValue="top",category="General",enumeration="top,bottom,middle")]
      public function get verticalAlign() : String
      {
         return this._verticalAlign;
      }
      
      public function set verticalAlign(value:String) : void
      {
         if(value == this._verticalAlign)
         {
            return;
         }
         this._verticalAlign = value;
         var layoutTarget:GroupBase = target;
         if(layoutTarget)
         {
            layoutTarget.invalidateDisplayList();
         }
      }
      
      [Inspectable(category="General")]
      public function get paddingLeft() : Number
      {
         return this._paddingLeft;
      }
      
      public function set paddingLeft(value:Number) : void
      {
         if(this._paddingLeft == value)
         {
            return;
         }
         this._paddingLeft = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingRight() : Number
      {
         return this._paddingRight;
      }
      
      public function set paddingRight(value:Number) : void
      {
         if(this._paddingRight == value)
         {
            return;
         }
         this._paddingRight = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingTop() : Number
      {
         return this._paddingTop;
      }
      
      public function set paddingTop(value:Number) : void
      {
         if(this._paddingTop == value)
         {
            return;
         }
         this._paddingTop = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General")]
      public function get paddingBottom() : Number
      {
         return this._paddingBottom;
      }
      
      public function set paddingBottom(value:Number) : void
      {
         if(this._paddingBottom == value)
         {
            return;
         }
         this._paddingBottom = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(minValue="-1",category="General")]
      public function get requestedMinRowCount() : int
      {
         return this._requestedMinRowCount;
      }
      
      public function set requestedMinRowCount(value:int) : void
      {
         if(this._requestedMinRowCount == value)
         {
            return;
         }
         this._requestedMinRowCount = value;
         if(target)
         {
            target.invalidateSize();
         }
      }
      
      [Inspectable(minValue="-1",category="General")]
      public function get requestedRowCount() : int
      {
         return this._requestedRowCount;
      }
      
      public function set requestedRowCount(value:int) : void
      {
         if(this._requestedRowCount == value)
         {
            return;
         }
         this._requestedRowCount = value;
         if(target)
         {
            target.invalidateSize();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get rowHeight() : Number
      {
         var elt:ILayoutElement = null;
         if(!isNaN(this._rowHeight))
         {
            return this._rowHeight;
         }
         elt = typicalLayoutElement;
         return Boolean(elt)?Number(elt.getPreferredBoundsHeight()):Number(0);
      }
      
      public function set rowHeight(value:Number) : void
      {
         if(this._rowHeight == value)
         {
            return;
         }
         this._rowHeight = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Inspectable(category="General",enumeration="true,false")]
      public function get variableRowHeight() : Boolean
      {
         return this._variableRowHeight;
      }
      
      public function set variableRowHeight(value:Boolean) : void
      {
         if(value == this._variableRowHeight)
         {
            return;
         }
         this._variableRowHeight = value;
         this.invalidateTargetSizeAndDisplayList();
      }
      
      [Bindable("indexInViewChanged")]
      [Inspectable(category="General")]
      public function get firstIndexInView() : int
      {
         return this._firstIndexInView;
      }
      
      [Bindable("indexInViewChanged")]
      [Inspectable(category="General")]
      public function get lastIndexInView() : int
      {
         return this._lastIndexInView;
      }
      
      private function setIndexInView(firstIndex:int, lastIndex:int) : void
      {
         if(Boolean(this._firstIndexInView == firstIndex) && Boolean(this._lastIndexInView == lastIndex))
         {
            return;
         }
         this._firstIndexInView = firstIndex;
         this._lastIndexInView = lastIndex;
         dispatchEvent(new Event("indexInViewChanged"));
      }
      
      override public function set clipAndEnableScrolling(value:Boolean) : void
      {
         var g:GroupBase = null;
         super.clipAndEnableScrolling = value;
         var vAlign:String = this.verticalAlign;
         if(Boolean(vAlign == VerticalAlign.MIDDLE) || Boolean(vAlign == VerticalAlign.BOTTOM))
         {
            g = target;
            if(g)
            {
               g.invalidateDisplayList();
            }
         }
      }
      
      override public function clearVirtualLayoutCache() : void
      {
         this.llv.clear();
      }
      
      override public function getElementBounds(index:int) : Rectangle
      {
         if(!useVirtualLayout)
         {
            return super.getElementBounds(index);
         }
         var g:GroupBase = GroupBase(target);
         if(Boolean(!g) || Boolean(index < 0) || Boolean(index >= g.numElements))
         {
            return null;
         }
         return this.llv.getBounds(index);
      }
      
      public function fractionOfElementInView(index:int) : Number
      {
         var eltY:Number = NaN;
         var eltHeight:Number = NaN;
         var elt:ILayoutElement = null;
         var g:GroupBase = GroupBase(target);
         if(!g)
         {
            return 0;
         }
         if(Boolean(index < 0) || Boolean(index >= g.numElements))
         {
            return 0;
         }
         if(!clipAndEnableScrolling)
         {
            return 1;
         }
         var r0:int = this.firstIndexInView;
         var r1:int = this.lastIndexInView;
         if(Boolean(r0 == -1) || Boolean(r1 == -1) || Boolean(index < r0) || Boolean(index > r1))
         {
            return 0;
         }
         if(Boolean(index > r0) && Boolean(index < r1))
         {
            return 1;
         }
         if(useVirtualLayout)
         {
            eltY = this.llv.start(index);
            eltHeight = this.llv.getMajorSize(index);
         }
         else
         {
            elt = g.getElementAt(index);
            if(Boolean(!elt) || Boolean(!elt.includeInLayout))
            {
               return 0;
            }
            eltY = elt.getLayoutBoundsY();
            eltHeight = elt.getLayoutBoundsHeight();
         }
         var y0:Number = g.verticalScrollPosition;
         var y1:Number = y0 + g.height;
         var iy0:Number = eltY;
         var iy1:Number = iy0 + eltHeight;
         if(iy0 >= iy1)
         {
            return 1;
         }
         if(Boolean(iy0 >= y0) && Boolean(iy1 <= y1))
         {
            return 1;
         }
         return (Math.min(y1,iy1) - Math.max(y0,iy0)) / (iy1 - iy0);
      }
      
      override protected function scrollPositionChanged() : void
      {
         var i0:int = 0;
         var i1:int = 0;
         var index0:int = 0;
         var element0:ILayoutElement = null;
         var element0Y:Number = NaN;
         var elementHeight:Number = NaN;
         var index1:int = 0;
         var element1:ILayoutElement = null;
         var element1Y:Number = NaN;
         var element1Height:Number = NaN;
         super.scrollPositionChanged();
         var g:GroupBase = target;
         if(!g)
         {
            return;
         }
         var n:int = g.numElements - 1;
         if(n < 0)
         {
            this.setIndexInView(-1,-1);
            return;
         }
         var scrollR:Rectangle = getScrollRect();
         if(!scrollR)
         {
            this.setIndexInView(0,n);
            return;
         }
         var y0:Number = scrollR.top;
         var y1:Number = scrollR.bottom - 0.0001;
         if(y1 <= y0)
         {
            this.setIndexInView(-1,-1);
            return;
         }
         if(useVirtualLayout)
         {
            i0 = this.llv.indexOf(y0);
            i1 = this.llv.indexOf(y1);
         }
         else
         {
            i0 = findIndexAt(y0 + this.gap,this.gap,g,0,n);
            i1 = findIndexAt(y1,this.gap,g,0,n);
         }
         if(i0 == -1)
         {
            index0 = findLayoutElementIndex(g,0,1);
            if(index0 != -1)
            {
               element0 = g.getElementAt(index0);
               element0Y = element0.getLayoutBoundsY();
               elementHeight = element0.getLayoutBoundsHeight();
               if(Boolean(element0Y < y1) && Boolean(element0Y + elementHeight > y0))
               {
                  i0 = index0;
               }
            }
         }
         if(i1 == -1)
         {
            index1 = findLayoutElementIndex(g,n,-1);
            if(index1 != -1)
            {
               element1 = g.getElementAt(index1);
               element1Y = element1.getLayoutBoundsY();
               element1Height = element1.getLayoutBoundsHeight();
               if(Boolean(element1Y < y1) && Boolean(element1Y + element1Height > y0))
               {
                  i1 = index1;
               }
            }
         }
         if(useVirtualLayout)
         {
            g.invalidateDisplayList();
         }
         this.setIndexInView(i0,i1);
      }
      
      private function findLayoutElementBounds(g:GroupBase, i:int, dir:int, r:Rectangle) : Rectangle
      {
         var elementR:Rectangle = null;
         var overlapsTop:Boolean = false;
         var overlapsBottom:Boolean = false;
         var n:int = g.numElements;
         if(this.fractionOfElementInView(i) >= 1)
         {
            i = i + dir;
            if(i < 0)
            {
               return new Rectangle(0,0,0,this.paddingTop);
            }
            if(i >= n)
            {
               return new Rectangle(0,this.getElementBounds(n - 1).bottom,0,this.paddingBottom);
            }
         }
         while(Boolean(i >= 0) && Boolean(i < n))
         {
            elementR = this.getElementBounds(i);
            if(elementR)
            {
               overlapsTop = Boolean(dir == -1) && Boolean(elementR.top == r.top) && Boolean(elementR.bottom >= r.bottom);
               overlapsBottom = Boolean(dir == 1) && Boolean(elementR.bottom == r.bottom) && Boolean(elementR.top <= r.top);
               if(!(Boolean(overlapsTop) || Boolean(overlapsBottom)))
               {
                  return elementR;
               }
            }
            i = i + dir;
         }
         return null;
      }
      
      override protected function getElementBoundsAboveScrollRect(scrollRect:Rectangle) : Rectangle
      {
         return this.findLayoutElementBounds(target,this.firstIndexInView,-1,scrollRect);
      }
      
      override protected function getElementBoundsBelowScrollRect(scrollRect:Rectangle) : Rectangle
      {
         return this.findLayoutElementBounds(target,this.lastIndexInView,1,scrollRect);
      }
      
      private function getElementWidth(element:ILayoutElement, justify:Boolean, result:SizesAndLimit) : void
      {
         var elementPreferredWidth:Number = Math.ceil(element.getPreferredBoundsWidth());
         var flexibleWidth:Boolean = Boolean(!isNaN(element.percentWidth)) || Boolean(justify);
         var elementMinWidth:Number = !!flexibleWidth?Number(Math.ceil(element.getMinBoundsWidth())):Number(elementPreferredWidth);
         result.preferredSize = elementPreferredWidth;
         result.minSize = elementMinWidth;
      }
      
      private function getElementHeight(element:ILayoutElement, fixedRowHeight:Number, result:SizesAndLimit) : void
      {
         var elementPreferredHeight:Number = !!isNaN(fixedRowHeight)?Number(Math.ceil(element.getPreferredBoundsHeight())):Number(fixedRowHeight);
         var flexibleHeight:Boolean = !isNaN(element.percentHeight);
         var elementMinHeight:Number = !!flexibleHeight?Number(Math.ceil(element.getMinBoundsHeight())):Number(elementPreferredHeight);
         result.preferredSize = elementPreferredHeight;
         result.minSize = elementMinHeight;
      }
      
      private function measureReal(layoutTarget:GroupBase) : void
      {
         var element:ILayoutElement = null;
         var vgap:Number = NaN;
         var size:SizesAndLimit = new SizesAndLimit();
         var justify:Boolean = this.horizontalAlign == HorizontalAlign.JUSTIFY;
         var numElements:int = layoutTarget.numElements;
         var numElementsInLayout:int = numElements;
         var requestedRowCount:int = this.requestedRowCount;
         var rowsMeasured:int = 0;
         var preferredHeight:Number = 0;
         var preferredWidth:Number = 0;
         var minHeight:Number = 0;
         var minWidth:Number = 0;
         var fixedRowHeight:Number = NaN;
         if(!this.variableRowHeight)
         {
            fixedRowHeight = this.rowHeight;
         }
         for(var i:int = 0; i < numElements; i++)
         {
            element = layoutTarget.getElementAt(i);
            if(Boolean(!element) || Boolean(!element.includeInLayout))
            {
               numElementsInLayout--;
            }
            else
            {
               if(Boolean(requestedRowCount == -1) || Boolean(rowsMeasured < requestedRowCount))
               {
                  this.getElementHeight(element,fixedRowHeight,size);
                  preferredHeight = preferredHeight + size.preferredSize;
                  minHeight = minHeight + size.minSize;
                  rowsMeasured++;
               }
               this.getElementWidth(element,justify,size);
               preferredWidth = Math.max(preferredWidth,size.preferredSize);
               minWidth = Math.max(minWidth,size.minSize);
            }
         }
         var rowsToMeasure:int = requestedRowCount != -1?int(requestedRowCount):int(Math.max(this.requestedMinRowCount,numElementsInLayout));
         if(rowsMeasured < rowsToMeasure)
         {
            element = typicalLayoutElement;
            if(element)
            {
               this.getElementHeight(element,fixedRowHeight,size);
               preferredHeight = preferredHeight + size.preferredSize * (rowsToMeasure - rowsMeasured);
               minHeight = minHeight + size.minSize * (rowsToMeasure - rowsMeasured);
               this.getElementWidth(element,justify,size);
               preferredWidth = Math.max(preferredWidth,size.preferredSize);
               minWidth = Math.max(minWidth,size.minSize);
               rowsMeasured = rowsToMeasure;
            }
         }
         if(rowsMeasured > 1)
         {
            vgap = this.gap * (rowsMeasured - 1);
            preferredHeight = preferredHeight + vgap;
            minHeight = minHeight + vgap;
         }
         var hPadding:Number = this.paddingLeft + this.paddingRight;
         var vPadding:Number = this.paddingTop + this.paddingBottom;
         layoutTarget.measuredHeight = preferredHeight + vPadding;
         layoutTarget.measuredWidth = preferredWidth + hPadding;
         layoutTarget.measuredMinHeight = minHeight + vPadding;
         layoutTarget.measuredMinWidth = minWidth + hPadding;
      }
      
      private function updateLLV(layoutTarget:GroupBase) : void
      {
         var typicalWidth:Number = NaN;
         var typicalHeight:Number = NaN;
         var typicalElt:ILayoutElement = typicalLayoutElement;
         if(typicalElt)
         {
            typicalWidth = typicalElt.getPreferredBoundsWidth();
            typicalHeight = typicalElt.getPreferredBoundsHeight();
            this.llv.defaultMinorSize = typicalWidth;
            this.llv.defaultMajorSize = typicalHeight;
         }
         if(layoutTarget)
         {
            this.llv.length = layoutTarget.numElements;
         }
         this.llv.gap = this.gap;
         this.llv.majorAxisOffset = this.paddingTop;
      }
      
      override public function elementAdded(index:int) : void
      {
         if(Boolean(index >= 0) && Boolean(useVirtualLayout))
         {
            this.llv.insert(index);
         }
      }
      
      override public function elementRemoved(index:int) : void
      {
         if(Boolean(index >= 0) && Boolean(useVirtualLayout))
         {
            this.llv.remove(index);
         }
      }
      
      private function measureVirtual(layoutTarget:GroupBase) : void
      {
         var oldLength:int = 0;
         var vgap:Number = NaN;
         var eltCount:uint = layoutTarget.numElements;
         var measuredEltCount:int = this.requestedRowCount != -1?int(this.requestedRowCount):int(Math.max(this.requestedMinRowCount,eltCount));
         var hPadding:Number = this.paddingLeft + this.paddingRight;
         var vPadding:Number = this.paddingTop + this.paddingBottom;
         if(measuredEltCount <= 0)
         {
            layoutTarget.measuredWidth = layoutTarget.measuredMinWidth = hPadding;
            layoutTarget.measuredHeight = layoutTarget.measuredMinHeight = vPadding;
            return;
         }
         this.updateLLV(layoutTarget);
         if(this.variableRowHeight)
         {
            oldLength = -1;
            if(measuredEltCount > this.llv.length)
            {
               oldLength = this.llv.length;
               this.llv.length = measuredEltCount;
            }
            layoutTarget.measuredHeight = this.llv.end(measuredEltCount - 1) + this.paddingBottom;
            if(oldLength != -1)
            {
               this.llv.length = oldLength;
            }
         }
         else
         {
            vgap = measuredEltCount > 1?Number((measuredEltCount - 1) * this.gap):Number(0);
            layoutTarget.measuredHeight = measuredEltCount * this.rowHeight + vgap + vPadding;
         }
         layoutTarget.measuredWidth = this.llv.minorSize + hPadding;
         layoutTarget.measuredMinWidth = this.horizontalAlign == HorizontalAlign.JUSTIFY?Number(this.llv.minMinorSize + hPadding):Number(layoutTarget.measuredWidth);
         layoutTarget.measuredMinHeight = layoutTarget.measuredHeight;
      }
      
      override public function measure() : void
      {
         var layoutTarget:GroupBase = target;
         if(!layoutTarget)
         {
            return;
         }
         if(useVirtualLayout)
         {
            this.measureVirtual(layoutTarget);
         }
         else
         {
            this.measureReal(layoutTarget);
         }
         layoutTarget.measuredWidth = Math.ceil(layoutTarget.measuredWidth);
         layoutTarget.measuredHeight = Math.ceil(layoutTarget.measuredHeight);
         layoutTarget.measuredMinWidth = Math.ceil(layoutTarget.measuredMinWidth);
         layoutTarget.measuredMinHeight = Math.ceil(layoutTarget.measuredMinHeight);
      }
      
      override public function getNavigationDestinationIndex(currentIndex:int, navigationUnit:uint, arrowKeysWrapFocus:Boolean) : int
      {
         var newIndex:int = 0;
         var bounds:Rectangle = null;
         var y:Number = NaN;
         var firstVisible:int = 0;
         var firstFullyVisible:int = 0;
         var lastVisible:int = 0;
         var lastFullyVisible:int = 0;
         if(Boolean(!target) || Boolean(target.numElements < 1))
         {
            return -1;
         }
         var maxIndex:int = target.numElements - 1;
         if(currentIndex == -1)
         {
            if(navigationUnit == NavigationUnit.UP)
            {
               return !!arrowKeysWrapFocus?int(maxIndex):int(-1);
            }
            if(navigationUnit == NavigationUnit.DOWN)
            {
               return 0;
            }
         }
         currentIndex = Math.max(0,Math.min(maxIndex,currentIndex));
         switch(navigationUnit)
         {
            case NavigationUnit.UP:
               if(Boolean(arrowKeysWrapFocus) && Boolean(currentIndex == 0))
               {
                  newIndex = maxIndex;
               }
               else
               {
                  newIndex = currentIndex - 1;
               }
               break;
            case NavigationUnit.DOWN:
               if(Boolean(arrowKeysWrapFocus) && Boolean(currentIndex == maxIndex))
               {
                  newIndex = 0;
               }
               else
               {
                  newIndex = currentIndex + 1;
               }
               break;
            case NavigationUnit.PAGE_UP:
               firstVisible = this.firstIndexInView;
               firstFullyVisible = firstVisible;
               if(this.fractionOfElementInView(firstFullyVisible) < 1)
               {
                  firstFullyVisible = firstFullyVisible + 1;
               }
               if(Boolean(firstFullyVisible < currentIndex) && Boolean(currentIndex <= this.lastIndexInView))
               {
                  newIndex = firstFullyVisible;
               }
               else
               {
                  if(Boolean(currentIndex == firstFullyVisible) || Boolean(currentIndex == firstVisible))
                  {
                     y = getVerticalScrollPositionDelta(NavigationUnit.PAGE_UP) + getScrollRect().top;
                  }
                  else
                  {
                     y = this.getElementBounds(currentIndex).bottom - getScrollRect().height;
                  }
                  newIndex = currentIndex - 1;
                  while(0 <= newIndex)
                  {
                     bounds = this.getElementBounds(newIndex);
                     if(Boolean(bounds) && Boolean(bounds.top < y))
                     {
                        newIndex = Math.min(currentIndex - 1,newIndex + 1);
                        break;
                     }
                     newIndex--;
                  }
               }
               break;
            case NavigationUnit.PAGE_DOWN:
               lastVisible = this.lastIndexInView;
               lastFullyVisible = lastVisible;
               if(this.fractionOfElementInView(lastFullyVisible) < 1)
               {
                  lastFullyVisible = lastFullyVisible - 1;
               }
               if(Boolean(this.firstIndexInView <= currentIndex) && Boolean(currentIndex < lastFullyVisible))
               {
                  newIndex = lastFullyVisible;
               }
               else
               {
                  if(Boolean(currentIndex == lastFullyVisible) || Boolean(currentIndex == lastVisible))
                  {
                     y = getVerticalScrollPositionDelta(NavigationUnit.PAGE_DOWN) + getScrollRect().bottom;
                  }
                  else
                  {
                     y = this.getElementBounds(currentIndex).top + getScrollRect().height;
                  }
                  newIndex = currentIndex + 1;
                  while(newIndex <= maxIndex)
                  {
                     bounds = this.getElementBounds(newIndex);
                     if(Boolean(bounds) && Boolean(bounds.bottom > y))
                     {
                        newIndex = Math.max(currentIndex + 1,newIndex - 1);
                        break;
                     }
                     newIndex++;
                  }
               }
               break;
            default:
               return super.getNavigationDestinationIndex(currentIndex,navigationUnit,arrowKeysWrapFocus);
         }
         return Math.max(0,Math.min(maxIndex,newIndex));
      }
      
      private function calculateElementWidth(elt:ILayoutElement, targetWidth:Number, containerWidth:Number) : Number
      {
         var width:Number = NaN;
         var percentWidth:Number = elt.percentWidth;
         if(!isNaN(percentWidth))
         {
            width = percentWidth * 0.01 * targetWidth;
            return Math.min(targetWidth,Math.min(elt.getMaxBoundsWidth(),Math.max(elt.getMinBoundsWidth(),width)));
         }
         switch(this.horizontalAlign)
         {
            case HorizontalAlign.JUSTIFY:
               return targetWidth;
            case HorizontalAlign.CONTENT_JUSTIFY:
               return Math.max(elt.getPreferredBoundsWidth(),containerWidth);
            default:
               return NaN;
         }
      }
      
      private function calculateElementX(elt:ILayoutElement, eltWidth:Number, containerWidth:Number) : Number
      {
         switch(this.horizontalAlign)
         {
            case HorizontalAlign.CENTER:
               return Math.round((containerWidth - eltWidth) * 0.5);
            case HorizontalAlign.RIGHT:
               return containerWidth - eltWidth;
            default:
               return 0;
         }
      }
      
      private function updateDisplayListVirtual() : void
      {
         var elt:ILayoutElement = null;
         var w:Number = NaN;
         var h:Number = NaN;
         var x:Number = NaN;
         var excessHeight:Number = NaN;
         var dy:Number = NaN;
         var vAlign:String = null;
         var layoutTarget:GroupBase = target;
         var eltCount:int = layoutTarget.numElements;
         var targetWidth:Number = Math.max(0,layoutTarget.width - this.paddingLeft - this.paddingRight);
         var minVisibleY:Number = layoutTarget.verticalScrollPosition;
         var maxVisibleY:Number = minVisibleY + layoutTarget.height;
         this.updateLLV(layoutTarget);
         var startIndex:int = this.llv.indexOf(Math.max(0,minVisibleY + this.gap));
         if(startIndex == -1)
         {
            return;
         }
         var fixedRowHeight:Number = NaN;
         if(!this.variableRowHeight)
         {
            fixedRowHeight = this.rowHeight;
         }
         var justifyWidths:Boolean = this.horizontalAlign == HorizontalAlign.JUSTIFY;
         var eltWidth:Number = !!justifyWidths?Number(targetWidth):Number(NaN);
         var eltHeight:Number = NaN;
         var contentWidth:Number = !!justifyWidths?Number(Math.max(this.llv.minMinorSize,targetWidth)):Number(this.llv.minorSize);
         var containerWidth:Number = Math.max(contentWidth,targetWidth);
         var y:Number = this.llv.start(startIndex);
         var index:int = startIndex;
         var x0:Number = this.paddingLeft;
         while(Boolean(y < maxVisibleY) && Boolean(index < eltCount))
         {
            elt = layoutTarget.getVirtualElementAt(index,eltWidth,eltHeight);
            w = this.calculateElementWidth(elt,targetWidth,containerWidth);
            h = fixedRowHeight;
            elt.setLayoutBoundsSize(w,h);
            w = elt.getLayoutBoundsWidth();
            h = elt.getLayoutBoundsHeight();
            x = x0 + this.calculateElementX(elt,w,containerWidth);
            elt.setLayoutBoundsPosition(x,y);
            this.llv.cacheDimensions(index,elt);
            y = y + (h + this.gap);
            index++;
         }
         var endIndex:int = index - 1;
         if(Boolean(!justifyWidths) && Boolean(this.llv.minorSize != contentWidth))
         {
            contentWidth = this.llv.minorSize;
            containerWidth = Math.max(contentWidth,targetWidth);
            if(this.horizontalAlign != HorizontalAlign.LEFT)
            {
               for(index = startIndex; index <= endIndex; index++)
               {
                  elt = layoutTarget.getVirtualElementAt(index,eltWidth,eltHeight);
                  w = this.calculateElementWidth(elt,targetWidth,containerWidth);
                  elt.setLayoutBoundsSize(w,elt.getLayoutBoundsHeight());
                  w = elt.getLayoutBoundsWidth();
                  x = x0 + this.calculateElementX(elt,w,containerWidth);
                  elt.setLayoutBoundsPosition(x,elt.getLayoutBoundsY());
               }
            }
         }
         var contentHeight:Number = this.llv.end(this.llv.length - 1) - this.paddingTop;
         var targetHeight:Number = Math.max(0,layoutTarget.height - this.paddingTop - this.paddingBottom);
         if(contentHeight < targetHeight)
         {
            excessHeight = targetHeight - contentHeight;
            dy = 0;
            vAlign = this.verticalAlign;
            if(vAlign == VerticalAlign.MIDDLE)
            {
               dy = Math.round(excessHeight / 2);
            }
            else if(vAlign == VerticalAlign.BOTTOM)
            {
               dy = excessHeight;
            }
            if(dy > 0)
            {
               for(index = startIndex; index <= endIndex; index++)
               {
                  elt = layoutTarget.getVirtualElementAt(index,NaN,NaN);
                  elt.setLayoutBoundsPosition(elt.getLayoutBoundsX(),dy + elt.getLayoutBoundsY());
               }
               contentHeight = contentHeight + dy;
            }
         }
         this.setRowCount(index - startIndex);
         this.setIndexInView(startIndex,endIndex);
         var paddedContentWidth:Number = Math.ceil(contentWidth + this.paddingLeft + this.paddingRight);
         var paddedContentHeight:Number = Math.ceil(contentHeight + this.paddingTop + this.paddingBottom);
         layoutTarget.setContentSize(paddedContentWidth,paddedContentHeight);
      }
      
      private function updateDisplayListReal() : void
      {
         var layoutElement:ILayoutElement = null;
         var i:int = 0;
         var layoutElementWidth:Number = NaN;
         var vAlign:String = null;
         var dx:Number = NaN;
         var dy:Number = NaN;
         var x:Number = NaN;
         var layoutTarget:GroupBase = target;
         var targetWidth:Number = Math.max(0,layoutTarget.width - this.paddingLeft - this.paddingRight);
         var targetHeight:Number = Math.max(0,layoutTarget.height - this.paddingTop - this.paddingBottom);
         var count:uint = layoutTarget.numElements;
         var containerWidth:Number = targetWidth;
         if(Boolean(this.horizontalAlign == HorizontalAlign.CONTENT_JUSTIFY) || Boolean(clipAndEnableScrolling) && (Boolean(this.horizontalAlign == HorizontalAlign.CENTER) || Boolean(this.horizontalAlign == HorizontalAlign.RIGHT)))
         {
            for(i = 0; i < count; i++)
            {
               layoutElement = layoutTarget.getElementAt(i);
               if(!(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout)))
               {
                  if(!isNaN(layoutElement.percentWidth))
                  {
                     layoutElementWidth = calculatePercentWidth(layoutElement,targetWidth);
                  }
                  else
                  {
                     layoutElementWidth = layoutElement.getPreferredBoundsWidth();
                  }
                  containerWidth = Math.max(containerWidth,Math.ceil(layoutElementWidth));
               }
            }
         }
         var excessHeight:Number = this.distributeHeight(targetWidth,targetHeight,containerWidth);
         var hAlign:Number = 0;
         if(this.horizontalAlign == HorizontalAlign.CENTER)
         {
            hAlign = 0.5;
         }
         else if(this.horizontalAlign == HorizontalAlign.RIGHT)
         {
            hAlign = 1;
         }
         var visibleRows:uint = 0;
         var minVisibleY:Number = layoutTarget.verticalScrollPosition;
         var maxVisibleY:Number = minVisibleY + targetHeight;
         var x0:Number = this.paddingLeft;
         var y:Number = this.paddingTop;
         var maxX:Number = this.paddingLeft;
         var maxY:Number = this.paddingTop;
         var firstRowInView:int = -1;
         var lastRowInView:int = -1;
         if(Boolean(excessHeight > 0) || Boolean(!clipAndEnableScrolling))
         {
            vAlign = this.verticalAlign;
            if(vAlign == VerticalAlign.MIDDLE)
            {
               y = this.paddingTop + Math.round(excessHeight / 2);
            }
            else if(vAlign == VerticalAlign.BOTTOM)
            {
               y = this.paddingTop + excessHeight;
            }
         }
         for(var index:int = 0; index < count; index++)
         {
            layoutElement = layoutTarget.getElementAt(index);
            if(!(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout)))
            {
               dx = Math.ceil(layoutElement.getLayoutBoundsWidth());
               dy = Math.ceil(layoutElement.getLayoutBoundsHeight());
               x = x0 + (containerWidth - dx) * hAlign;
               if(hAlign == 0.5)
               {
                  x = Math.round(x);
               }
               layoutElement.setLayoutBoundsPosition(x,y);
               maxX = Math.max(maxX,x + dx);
               maxY = Math.max(maxY,y + dy);
               if(Boolean(!clipAndEnableScrolling) || Boolean(y < maxVisibleY) && Boolean(y + dy > minVisibleY) || Boolean(dy <= 0) && (Boolean(y == maxVisibleY) || Boolean(y == minVisibleY)))
               {
                  visibleRows = visibleRows + 1;
                  if(firstRowInView == -1)
                  {
                     firstRowInView = lastRowInView = index;
                  }
                  else
                  {
                     lastRowInView = index;
                  }
               }
               y = y + (dy + this.gap);
            }
         }
         this.setRowCount(visibleRows);
         this.setIndexInView(firstRowInView,lastRowInView);
         layoutTarget.setContentSize(Math.ceil(maxX + this.paddingRight),Math.ceil(maxY + this.paddingBottom));
      }
      
      private function distributeHeight(width:Number, height:Number, restrictedWidth:Number) : Number
      {
         var childInfo:LayoutElementFlexChildInfo = null;
         var layoutElement:ILayoutElement = null;
         var roundOff:Number = NaN;
         var childSize:int = 0;
         var spaceToDistribute:Number = height;
         var totalPercentHeight:Number = 0;
         var childInfoArray:Array = [];
         var rh:Number = !!this.variableRowHeight?Number(0):Number(Math.ceil(this.rowHeight));
         var count:uint = target.numElements;
         var totalCount:uint = count;
         for(var index:int = 0; index < count; index++)
         {
            layoutElement = target.getElementAt(index);
            if(Boolean(!layoutElement) || Boolean(!layoutElement.includeInLayout))
            {
               totalCount--;
            }
            else if(Boolean(!isNaN(layoutElement.percentHeight)) && Boolean(this.variableRowHeight))
            {
               totalPercentHeight = totalPercentHeight + layoutElement.percentHeight;
               childInfo = new LayoutElementFlexChildInfo();
               childInfo.layoutElement = layoutElement;
               childInfo.percent = layoutElement.percentHeight;
               childInfo.min = layoutElement.getMinBoundsHeight();
               childInfo.max = layoutElement.getMaxBoundsHeight();
               childInfoArray.push(childInfo);
            }
            else
            {
               sizeLayoutElement(layoutElement,width,this.horizontalAlign,restrictedWidth,NaN,this.variableRowHeight,rh);
               spaceToDistribute = spaceToDistribute - Math.ceil(layoutElement.getLayoutBoundsHeight());
            }
         }
         if(totalCount > 1)
         {
            spaceToDistribute = spaceToDistribute - (totalCount - 1) * this.gap;
         }
         if(totalPercentHeight)
         {
            Flex.flexChildrenProportionally(height,spaceToDistribute,totalPercentHeight,childInfoArray);
            roundOff = 0;
            for each(childInfo in childInfoArray)
            {
               childSize = Math.round(childInfo.size + roundOff);
               roundOff = roundOff + (childInfo.size - childSize);
               sizeLayoutElement(childInfo.layoutElement,width,this.horizontalAlign,restrictedWidth,childSize,this.variableRowHeight,rh);
               spaceToDistribute = spaceToDistribute - childSize;
            }
         }
         return spaceToDistribute;
      }
      
      override public function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         var layoutTarget:GroupBase = target;
         if(!layoutTarget)
         {
            return;
         }
         if(Boolean(layoutTarget.numElements == 0) || Boolean(unscaledWidth == 0) || Boolean(unscaledHeight == 0))
         {
            this.setRowCount(0);
            this.setIndexInView(-1,-1);
            if(layoutTarget.numElements == 0)
            {
               layoutTarget.setContentSize(Math.ceil(this.paddingLeft + this.paddingRight),Math.ceil(this.paddingTop + this.paddingBottom));
            }
            return;
         }
         if(useVirtualLayout)
         {
            this.updateDisplayListVirtual();
         }
         else
         {
            this.updateDisplayListReal();
         }
      }
      
      private function invalidateTargetSizeAndDisplayList() : void
      {
         var g:GroupBase = target;
         if(!g)
         {
            return;
         }
         g.invalidateSize();
         g.invalidateDisplayList();
      }
      
      override protected function calculateDropIndex(x:Number, y:Number) : int
      {
         var elementBounds:Rectangle = null;
         var curDistance:Number = NaN;
         var centerY:Number = NaN;
         var layoutTarget:GroupBase = target;
         var count:int = layoutTarget.numElements;
         if(count == 0)
         {
            return 0;
         }
         var minDistance:Number = Number.MAX_VALUE;
         var bestIndex:int = -1;
         var start:int = this.firstIndexInView;
         var end:int = this.lastIndexInView;
         for(var i:int = start; i <= end; i++)
         {
            elementBounds = this.getElementBounds(i);
            if(elementBounds)
            {
               if(Boolean(elementBounds.top <= y) && Boolean(y <= elementBounds.bottom))
               {
                  centerY = elementBounds.y + elementBounds.height / 2;
                  return y < centerY?int(i):int(i + 1);
               }
               curDistance = Math.min(Math.abs(y - elementBounds.top),Math.abs(y - elementBounds.bottom));
               if(curDistance < minDistance)
               {
                  minDistance = curDistance;
                  bestIndex = y < elementBounds.top?int(i):int(i + 1);
               }
            }
         }
         if(bestIndex == -1)
         {
            bestIndex = this.getElementBounds(0).y < y?int(count):int(0);
         }
         return bestIndex;
      }
      
      override protected function calculateDropIndicatorBounds(dropLocation:DropLocation) : Rectangle
      {
         var element:IVisualElement = null;
         var dropIndex:int = dropLocation.dropIndex;
         var count:int = target.numElements;
         var gap:Number = this.gap;
         if(Boolean(gap < 0) && Boolean(dropIndex == count))
         {
            gap = 0;
         }
         var emptySpace:Number = 0 < gap?Number(gap):Number(0);
         var emptySpaceTop:Number = 0;
         if(target.numElements > 0)
         {
            emptySpaceTop = dropIndex < count?Number(this.getElementBounds(dropIndex).top - emptySpace):Number(this.getElementBounds(dropIndex - 1).bottom + gap - emptySpace);
         }
         var width:Number = Math.max(target.width,target.contentWidth) - this.paddingLeft - this.paddingRight;
         var height:Number = emptySpace;
         if(dropIndicator is IVisualElement)
         {
            element = IVisualElement(dropIndicator);
            height = Math.max(Math.min(height,element.getMaxBoundsHeight(false)),element.getMinBoundsHeight(false));
         }
         var x:Number = this.paddingLeft;
         var y:Number = emptySpaceTop + Math.round((emptySpace - height) / 2);
         y = Math.max(-1,Math.min(target.contentHeight - height + 1,y));
         return new Rectangle(x,y,width,height);
      }
      
      override protected function calculateDragScrollDelta(dropLocation:DropLocation, elapsedTime:Number) : Point
      {
         var delta:Point = super.calculateDragScrollDelta(dropLocation,elapsedTime);
         if(delta)
         {
            delta.x = 0;
         }
         return delta;
      }
   }
}

import mx.containers.utilityClasses.FlexChildInfo;
import mx.core.ILayoutElement;

class LayoutElementFlexChildInfo extends FlexChildInfo
{
    
   public var layoutElement:ILayoutElement;
   
   function LayoutElementFlexChildInfo()
   {
      super();
   }
}

class SizesAndLimit
{
    
   public var preferredSize:Number;
   
   public var minSize:Number;
   
   function SizesAndLimit()
   {
      super();
   }
}
