package spark.core
{
   import flashx.textLayout.formats.ITextLayoutFormat;
   import mx.core.mx_internal;
   import mx.styles.IStyleClient;
   import flash.text.engine.FontLookup;
   import flash.text.engine.Kerning;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class CSSTextLayoutFormat implements ITextLayoutFormat
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var client:IStyleClient;
      
      public function CSSTextLayoutFormat(client:IStyleClient)
      {
         super();
         this.client = client;
      }
      
      public function get alignmentBaseline() : *
      {
         return this.client.getStyle("alignmentBaseline");
      }
      
      public function get backgroundAlpha() : *
      {
         return this.client.getStyle("backgroundAlpha");
      }
      
      public function get backgroundColor() : *
      {
         return this.client.getStyle("backgroundColor");
      }
      
      public function get baselineShift() : *
      {
         return this.client.getStyle("baselineShift");
      }
      
      public function get blockProgression() : *
      {
         return this.client.getStyle("blockProgression");
      }
      
      public function get breakOpportunity() : *
      {
         return this.client.getStyle("breakOpportunity");
      }
      
      public function get cffHinting() : *
      {
         return this.client.getStyle("cffHinting");
      }
      
      public function get color() : *
      {
         return this.client.getStyle("color");
      }
      
      public function get columnCount() : *
      {
         return this.client.getStyle("columnCount");
      }
      
      public function get columnGap() : *
      {
         return this.client.getStyle("columnGap");
      }
      
      public function get columnWidth() : *
      {
         return this.client.getStyle("columnWidth");
      }
      
      public function get digitCase() : *
      {
         return this.client.getStyle("digitCase");
      }
      
      public function get digitWidth() : *
      {
         return this.client.getStyle("digitWidth");
      }
      
      public function get direction() : *
      {
         return this.client.getStyle("direction");
      }
      
      public function get dominantBaseline() : *
      {
         return this.client.getStyle("dominantBaseline");
      }
      
      public function get firstBaselineOffset() : *
      {
         return this.client.getStyle("firstBaselineOffset");
      }
      
      public function get fontFamily() : *
      {
         return this.client.getStyle("fontFamily");
      }
      
      public function get fontLookup() : *
      {
         var value:String = this.client.getStyle("fontLookup");
         if(value == "auto")
         {
            if(this.client.mx_internal::embeddedFontContext)
            {
               value = FontLookup.EMBEDDED_CFF;
            }
            else
            {
               value = FontLookup.DEVICE;
            }
         }
         return value;
      }
      
      public function get fontSize() : *
      {
         return this.client.getStyle("fontSize");
      }
      
      public function get fontStyle() : *
      {
         return this.client.getStyle("fontStyle");
      }
      
      public function get fontWeight() : *
      {
         return this.client.getStyle("fontWeight");
      }
      
      public function get justificationRule() : *
      {
         return this.client.getStyle("justificationRule");
      }
      
      public function get justificationStyle() : *
      {
         return this.client.getStyle("justificationStyle");
      }
      
      public function get kerning() : *
      {
         var kerning:Object = this.client.getStyle("kerning");
         if(kerning === "default")
         {
            kerning = Kerning.AUTO;
         }
         else if(kerning === true)
         {
            kerning = Kerning.ON;
         }
         else if(kerning === false)
         {
            kerning = Kerning.OFF;
         }
         return kerning;
      }
      
      public function get leadingModel() : *
      {
         return this.client.getStyle("leadingModel");
      }
      
      public function get ligatureLevel() : *
      {
         return this.client.getStyle("ligatureLevel");
      }
      
      public function get lineBreak() : *
      {
         return this.client.getStyle("lineBreak");
      }
      
      public function get lineHeight() : *
      {
         return this.client.getStyle("lineHeight");
      }
      
      public function get lineThrough() : *
      {
         return this.client.getStyle("lineThrough");
      }
      
      public function get locale() : *
      {
         return this.client.getStyle("locale");
      }
      
      public function get marginBottom() : *
      {
         return this.client.getStyle("marginBottom");
      }
      
      public function get marginLeft() : *
      {
         return this.client.getStyle("marginLeft");
      }
      
      public function get marginRight() : *
      {
         return this.client.getStyle("marginRight");
      }
      
      public function get marginTop() : *
      {
         return this.client.getStyle("marginTop");
      }
      
      public function get paddingBottom() : *
      {
         return this.client.getStyle("paddingBottom");
      }
      
      public function get paddingLeft() : *
      {
         return this.client.getStyle("paddingLeft");
      }
      
      public function get paddingRight() : *
      {
         return this.client.getStyle("paddingRight");
      }
      
      public function get paddingTop() : *
      {
         return this.client.getStyle("paddingTop");
      }
      
      public function get paragraphEndIndent() : *
      {
         return this.client.getStyle("paragraphEndIndent");
      }
      
      public function get paragraphSpaceAfter() : *
      {
         return this.client.getStyle("paragraphSpaceAfter");
      }
      
      public function get paragraphSpaceBefore() : *
      {
         return this.client.getStyle("paragraphSpaceBefore");
      }
      
      public function get paragraphStartIndent() : *
      {
         return this.client.getStyle("paragraphStartIndent");
      }
      
      public function get renderingMode() : *
      {
         return this.client.getStyle("renderingMode");
      }
      
      public function get tabStops() : *
      {
         return this.client.getStyle("tabStops");
      }
      
      public function get textAlign() : *
      {
         return this.client.getStyle("textAlign");
      }
      
      public function get textAlignLast() : *
      {
         return this.client.getStyle("textAlignLast");
      }
      
      public function get textAlpha() : *
      {
         return this.client.getStyle("textAlpha");
      }
      
      public function get textDecoration() : *
      {
         return this.client.getStyle("textDecoration");
      }
      
      public function get textIndent() : *
      {
         return this.client.getStyle("textIndent");
      }
      
      public function get textJustify() : *
      {
         return this.client.getStyle("textJustify");
      }
      
      public function get textRotation() : *
      {
         return this.client.getStyle("textRotation");
      }
      
      public function get trackingLeft() : *
      {
         return this.client.getStyle("trackingLeft");
      }
      
      public function get trackingRight() : *
      {
         return this.client.getStyle("trackingRight");
      }
      
      public function get typographicCase() : *
      {
         return this.client.getStyle("typographicCase");
      }
      
      public function get verticalAlign() : *
      {
         return this.client.getStyle("verticalAlign");
      }
      
      public function get whiteSpaceCollapse() : *
      {
         return this.client.getStyle("whiteSpaceCollapse");
      }
   }
}
