package spark.components.supportClasses
{
   import spark.components.DataRenderer;
   import spark.components.IItemRenderer;
   import mx.core.mx_internal;
   import flash.events.Event;
   import flash.geom.Point;
   import spark.components.ResizeMode;
   import flash.events.MouseEvent;
   
   use namespace mx_internal;
   
   public class ItemRenderer extends DataRenderer implements IItemRenderer
   {
       
      private var rendererStateIsDirty:Boolean = false;
      
      mx_internal var playTransitions:Boolean = true;
      
      private var _autoDrawBackground:Boolean = true;
      
      private var _hovered:Boolean = false;
      
      private var _itemIndex:int;
      
      public var labelDisplay:spark.components.supportClasses.TextBase;
      
      private var _showsCaret:Boolean = false;
      
      private var _selected:Boolean = false;
      
      private var _dragging:Boolean = false;
      
      private var _label:String = "";
      
      public function ItemRenderer()
      {
         super();
         this.rendererStateIsDirty = true;
         this.addHandlers();
      }
      
      public function get autoDrawBackground() : Boolean
      {
         return this._autoDrawBackground;
      }
      
      public function set autoDrawBackground(value:Boolean) : void
      {
         if(this._autoDrawBackground == value)
         {
            return;
         }
         this._autoDrawBackground = value;
         if(this._autoDrawBackground)
         {
            redrawRequested = true;
            super.$invalidateDisplayList();
         }
      }
      
      protected function get hovered() : Boolean
      {
         return this._hovered;
      }
      
      protected function set hovered(value:Boolean) : void
      {
         if(value != this._hovered)
         {
            this._hovered = value;
            setCurrentState(this.getCurrentRendererState(),this.playTransitions);
            if(this.autoDrawBackground)
            {
               redrawRequested = true;
               super.$invalidateDisplayList();
            }
         }
      }
      
      [Bindable("itemIndexChanged")]
      public function get itemIndex() : int
      {
         return this._itemIndex;
      }
      
      public function set itemIndex(value:int) : void
      {
         if(value == this._itemIndex)
         {
            return;
         }
         this._itemIndex = value;
         if(this.autoDrawBackground)
         {
            redrawRequested = true;
            super.$invalidateDisplayList();
         }
         dispatchEvent(new Event("itemIndexChanged"));
      }
      
      public function get showsCaret() : Boolean
      {
         return this._showsCaret;
      }
      
      public function set showsCaret(value:Boolean) : void
      {
         if(value == this._showsCaret)
         {
            return;
         }
         this._showsCaret = value;
         setCurrentState(this.getCurrentRendererState(),this.playTransitions);
         if(this.autoDrawBackground)
         {
            redrawRequested = true;
            super.$invalidateDisplayList();
         }
      }
      
      public function get selected() : Boolean
      {
         return this._selected;
      }
      
      public function set selected(value:Boolean) : void
      {
         if(value != this._selected)
         {
            this._selected = value;
            setCurrentState(this.getCurrentRendererState(),this.playTransitions);
            if(this.autoDrawBackground)
            {
               redrawRequested = true;
               super.$invalidateDisplayList();
            }
         }
      }
      
      public function get dragging() : Boolean
      {
         return this._dragging;
      }
      
      public function set dragging(value:Boolean) : void
      {
         if(value != this._dragging)
         {
            this._dragging = value;
            setCurrentState(this.getCurrentRendererState(),this.playTransitions);
         }
      }
      
      [Bindable("labelChanged")]
      public function get label() : String
      {
         return this._label;
      }
      
      public function set label(value:String) : void
      {
         if(value == this._label)
         {
            return;
         }
         this._label = value;
         if(this.labelDisplay)
         {
            this.labelDisplay.text = this._label;
         }
         dispatchEvent(new Event("labelChanged"));
      }
      
      override public function get baselinePosition() : Number
      {
         if(Boolean(!validateBaselinePosition()) || Boolean(!this.labelDisplay))
         {
            return super.baselinePosition;
         }
         var labelPosition:Point = globalToLocal(this.labelDisplay.parent.localToGlobal(new Point(this.labelDisplay.x,this.labelDisplay.y)));
         return labelPosition.y + this.labelDisplay.baselinePosition;
      }
      
      protected function getCurrentRendererState() : String
      {
         if(Boolean(this.dragging) && Boolean(hasState("dragging")))
         {
            return "dragging";
         }
         if(Boolean(this.selected) && Boolean(this.showsCaret) && Boolean(hasState("selectedAndShowsCaret")))
         {
            return "selectedAndShowsCaret";
         }
         if(Boolean(this.hovered) && Boolean(this.showsCaret) && Boolean(hasState("hoveredAndShowsCaret")))
         {
            return "hoveredAndShowsCaret";
         }
         if(Boolean(this.showsCaret) && Boolean(hasState("normalAndShowsCaret")))
         {
            return "normalAndShowsCaret";
         }
         if(Boolean(this.selected) && Boolean(hasState("selected")))
         {
            return "selected";
         }
         if(Boolean(this.hovered) && Boolean(hasState("hovered")))
         {
            return "hovered";
         }
         if(hasState("normal"))
         {
            return "normal";
         }
         return null;
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(this.rendererStateIsDirty)
         {
            setCurrentState(this.getCurrentRendererState(),this.playTransitions);
            this.rendererStateIsDirty = false;
         }
      }
      
      override public function styleChanged(styleName:String) : void
      {
         var allStyles:Boolean = Boolean(styleName == null) || Boolean(styleName == "styleName");
         super.styleChanged(styleName);
         if(Boolean(this.autoDrawBackground) && (Boolean(allStyles) || Boolean(styleName == "alternatingItemColors") || Boolean(styleName == "contentBackgroundColor") || Boolean(styleName == "rollOverColor") || Boolean(styleName == "selectionColor")))
         {
            redrawRequested = true;
            super.$invalidateDisplayList();
         }
      }
      
      override mx_internal function drawBackground() : void
      {
         var backgroundColor:uint = 0;
         var alternatingColors:Array = null;
         if(!this.autoDrawBackground)
         {
            super.drawBackground();
            return;
         }
         var w:Number = resizeMode == ResizeMode.SCALE?Number(measuredWidth):Number(unscaledWidth);
         var h:Number = resizeMode == ResizeMode.SCALE?Number(measuredHeight):Number(unscaledHeight);
         if(Boolean(isNaN(w)) || Boolean(isNaN(h)))
         {
            return;
         }
         graphics.clear();
         var drawBackground:Boolean = true;
         if(this.selected)
         {
            backgroundColor = getStyle("selectionColor");
         }
         else if(this.hovered)
         {
            backgroundColor = getStyle("rollOverColor");
         }
         else
         {
            alternatingColors = getStyle("alternatingItemColors");
            if(Boolean(alternatingColors) && Boolean(alternatingColors.length > 0))
            {
               styleManager.getColorNames(alternatingColors);
               backgroundColor = alternatingColors[this.itemIndex % alternatingColors.length];
            }
            else
            {
               drawBackground = false;
            }
         }
         graphics.beginFill(backgroundColor,!!drawBackground?Number(1):Number(0));
         if(this.showsCaret)
         {
            graphics.lineStyle(1,getStyle("selectionColor"));
            graphics.drawRect(0.5,0.5,w - 1,h - 1);
         }
         else
         {
            graphics.lineStyle();
            graphics.drawRect(0,0,w,h);
         }
         graphics.endFill();
      }
      
      private function addHandlers() : void
      {
         addEventListener(MouseEvent.ROLL_OVER,this.itemRenderer_rollOverHandler);
         addEventListener(MouseEvent.ROLL_OUT,this.itemRenderer_rollOutHandler);
      }
      
      private function anyButtonDown(event:MouseEvent) : Boolean
      {
         var type:String = event.type;
         return Boolean(event.buttonDown) || Boolean(type == "middleMouseDown") || Boolean(type == "rightMouseDown");
      }
      
      protected function itemRenderer_rollOverHandler(event:MouseEvent) : void
      {
         if(!this.anyButtonDown(event))
         {
            this.hovered = true;
         }
      }
      
      protected function itemRenderer_rollOutHandler(event:MouseEvent) : void
      {
         this.hovered = false;
      }
   }
}
