package spark.components
{
   import spark.components.supportClasses.SkinnableContainerBase;
   import mx.core.IDeferredContentOwner;
   import mx.core.IVisualElementContainer;
   import mx.core.mx_internal;
   import mx.core.IFlexModuleFactory;
   import spark.events.ElementExistenceEvent;
   import mx.core.ContainerCreationPolicy;
   import mx.utils.BitFlagUtil;
   import spark.layouts.supportClasses.LayoutBase;
   import mx.core.IDeferredInstance;
   import mx.core.IVisualElement;
   import mx.events.FlexEvent;
   
   use namespace mx_internal;
   
   [DefaultProperty("mxmlContentFactory")]
   [IconFile("SkinnableContainer.png")]
   [Style(inherit="yes",name="symbolColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="rollOverColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="contentBackgroundColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="contentBackgroundAlpha",theme="spark",type="Number")]
   [Style(inherit="no",name="backgroundColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="no",name="backgroundAlpha",theme="spark",type="Number")]
   [Style(arrayType="uint",inherit="yes",name="alternatingItemColors",format="Color",theme="spark",type="Array")]
   [Style(inherit="yes",name="accentColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="unfocusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="inactiveTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="focusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="whiteSpaceCollapse",type="String",enumeration="collapse,preserve")]
   [Style(inherit="yes",name="textRotation",type="String",enumeration="auto,rotate0,rotate90,rotate180,rotate270")]
   [Style(minValue="0.0",inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="yes",name="tabStops",type="String")]
   [Style(inherit="yes",name="paragraphStartIndent",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceBefore",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceAfter",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphEndIndent",format="length",type="Number")]
   [Style(inherit="yes",name="leadingModel",type="String",enumeration="auto,romanUp,ideographicTopUp,ideographicCenterUp,ideographicTopDown,ideographicCenterDown,ascentDescentUp")]
   [Style(inherit="yes",name="firstBaselineOffset",type="Object")]
   [Style(inherit="yes",name="breakOpportunity",type="String",enumeration="auto,all,any,none")]
   [Style(inherit="yes",name="blockProgression",type="String",enumeration="tb,rl")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Event(name="elementRemove",type="spark.events.ElementExistenceEvent")]
   [Event(name="elementAdd",type="spark.events.ElementExistenceEvent")]
   [Event(name="contentCreationComplete",type="mx.events.FlexEvent")]
   public class SkinnableContainer extends SkinnableContainerBase implements IDeferredContentOwner, IVisualElementContainer
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const AUTO_LAYOUT_PROPERTY_FLAG:uint = 1 << 0;
      
      private static const LAYOUT_PROPERTY_FLAG:uint = 1 << 1;
       
      [SkinPart(required="false")]
      public var contentGroup:spark.components.Group;
      
      private var contentGroupProperties:Object;
      
      private var _placeHolderGroup:spark.components.Group;
      
      private var creationPolicyNone:Boolean = false;
      
      private var _mxmlContent:Array;
      
      private var _contentModified:Boolean = false;
      
      private var _mxmlContentFactory:IDeferredInstance;
      
      private var mxmlContentCreated:Boolean = false;
      
      private var _deferredContentCreated:Boolean;
      
      public function SkinnableContainer()
      {
         this.contentGroupProperties = {};
         super();
      }
      
      override public function set moduleFactory(moduleFactory:IFlexModuleFactory) : void
      {
         super.moduleFactory = moduleFactory;
         styleManager.registerInheritingStyle("_creationPolicy");
      }
      
      mx_internal function get currentContentGroup() : spark.components.Group
      {
         this.createContentIfNeeded();
         if(!this.contentGroup)
         {
            if(!this._placeHolderGroup)
            {
               this._placeHolderGroup = new spark.components.Group();
               if(this._mxmlContent)
               {
                  this._placeHolderGroup.mxmlContent = this._mxmlContent;
                  this._mxmlContent = null;
               }
               this._placeHolderGroup.addEventListener(ElementExistenceEvent.ELEMENT_ADD,this.contentGroup_elementAddedHandler);
               this._placeHolderGroup.addEventListener(ElementExistenceEvent.ELEMENT_REMOVE,this.contentGroup_elementRemovedHandler);
            }
            return this._placeHolderGroup;
         }
         return this.contentGroup;
      }
      
      [Inspectable(defaultValue="auto",enumeration="auto,all,none")]
      public function get creationPolicy() : String
      {
         var result:String = getStyle("_creationPolicy");
         if(result == null)
         {
            result = ContainerCreationPolicy.AUTO;
         }
         if(this.creationPolicyNone)
         {
            result = ContainerCreationPolicy.NONE;
         }
         return result;
      }
      
      public function set creationPolicy(value:String) : void
      {
         if(value == ContainerCreationPolicy.NONE)
         {
            this.creationPolicyNone = true;
            value = ContainerCreationPolicy.AUTO;
         }
         else
         {
            this.creationPolicyNone = false;
         }
         setStyle("_creationPolicy",value);
      }
      
      [Inspectable(defaultValue="true")]
      public function get autoLayout() : Boolean
      {
         var v:* = undefined;
         if(this.contentGroup)
         {
            return this.contentGroup.autoLayout;
         }
         v = this.contentGroupProperties.autoLayout;
         return v === undefined?Boolean(true):Boolean(v);
      }
      
      public function set autoLayout(value:Boolean) : void
      {
         if(this.contentGroup)
         {
            this.contentGroup.autoLayout = value;
            this.contentGroupProperties = BitFlagUtil.update(this.contentGroupProperties as uint,AUTO_LAYOUT_PROPERTY_FLAG,true);
         }
         else
         {
            this.contentGroupProperties.autoLayout = value;
         }
      }
      
      public function get layout() : LayoutBase
      {
         return Boolean(this.contentGroup)?this.contentGroup.layout:this.contentGroupProperties.layout;
      }
      
      public function set layout(value:LayoutBase) : void
      {
         if(this.contentGroup)
         {
            this.contentGroup.layout = value;
            this.contentGroupProperties = BitFlagUtil.update(this.contentGroupProperties as uint,LAYOUT_PROPERTY_FLAG,true);
         }
         else
         {
            this.contentGroupProperties.layout = value;
         }
      }
      
      [ArrayElementType("mx.core.IVisualElement")]
      public function set mxmlContent(value:Array) : void
      {
         if(this.contentGroup)
         {
            this.contentGroup.mxmlContent = value;
         }
         else if(this._placeHolderGroup)
         {
            this._placeHolderGroup.mxmlContent = value;
         }
         else
         {
            this._mxmlContent = value;
         }
         if(value != null)
         {
            this._contentModified = true;
         }
      }
      
      [ArrayElementType("mx.core.IVisualElement")]
      [InstanceType("Array")]
      public function set mxmlContentFactory(value:IDeferredInstance) : void
      {
         if(value == this._mxmlContentFactory)
         {
            return;
         }
         this._mxmlContentFactory = value;
         this.mxmlContentCreated = false;
      }
      
      public function get numElements() : int
      {
         return this.currentContentGroup.numElements;
      }
      
      public function getElementAt(index:int) : IVisualElement
      {
         return this.currentContentGroup.getElementAt(index);
      }
      
      public function getElementIndex(element:IVisualElement) : int
      {
         return this.currentContentGroup.getElementIndex(element);
      }
      
      public function addElement(element:IVisualElement) : IVisualElement
      {
         this._contentModified = true;
         return this.currentContentGroup.addElement(element);
      }
      
      public function addElementAt(element:IVisualElement, index:int) : IVisualElement
      {
         this._contentModified = true;
         return this.currentContentGroup.addElementAt(element,index);
      }
      
      public function removeElement(element:IVisualElement) : IVisualElement
      {
         this._contentModified = true;
         return this.currentContentGroup.removeElement(element);
      }
      
      public function removeElementAt(index:int) : IVisualElement
      {
         this._contentModified = true;
         return this.currentContentGroup.removeElementAt(index);
      }
      
      public function removeAllElements() : void
      {
         this._contentModified = true;
         this.currentContentGroup.removeAllElements();
      }
      
      public function setElementIndex(element:IVisualElement, index:int) : void
      {
         this._contentModified = true;
         this.currentContentGroup.setElementIndex(element,index);
      }
      
      public function swapElements(element1:IVisualElement, element2:IVisualElement) : void
      {
         this._contentModified = true;
         this.currentContentGroup.swapElements(element1,element2);
      }
      
      public function swapElementsAt(index1:int, index2:int) : void
      {
         this._contentModified = true;
         this.currentContentGroup.swapElementsAt(index1,index2);
      }
      
      override protected function createChildren() : void
      {
         super.createChildren();
         this.createContentIfNeeded();
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         var newContentGroupProperties:uint = 0;
         var sourceContent:Array = null;
         var i:int = 0;
         super.partAdded(partName,instance);
         if(instance == this.contentGroup)
         {
            if(this._contentModified)
            {
               if(this._placeHolderGroup != null)
               {
                  sourceContent = this._placeHolderGroup.getMXMLContent();
                  for(i = this._placeHolderGroup.numElements; i > 0; i--)
                  {
                     this._placeHolderGroup.removeElementAt(0);
                  }
                  this.contentGroup.mxmlContent = Boolean(sourceContent)?sourceContent.slice():null;
               }
               else if(this._mxmlContent != null)
               {
                  this.contentGroup.mxmlContent = this._mxmlContent;
                  this._mxmlContent = null;
               }
            }
            newContentGroupProperties = 0;
            if(this.contentGroupProperties.autoLayout !== undefined)
            {
               this.contentGroup.autoLayout = this.contentGroupProperties.autoLayout;
               newContentGroupProperties = BitFlagUtil.update(newContentGroupProperties,AUTO_LAYOUT_PROPERTY_FLAG,true);
            }
            if(this.contentGroupProperties.layout !== undefined)
            {
               this.contentGroup.layout = this.contentGroupProperties.layout;
               newContentGroupProperties = BitFlagUtil.update(newContentGroupProperties,LAYOUT_PROPERTY_FLAG,true);
            }
            this.contentGroupProperties = newContentGroupProperties;
            this.contentGroup.addEventListener(ElementExistenceEvent.ELEMENT_ADD,this.contentGroup_elementAddedHandler);
            this.contentGroup.addEventListener(ElementExistenceEvent.ELEMENT_REMOVE,this.contentGroup_elementRemovedHandler);
            if(this._placeHolderGroup)
            {
               this._placeHolderGroup.removeEventListener(ElementExistenceEvent.ELEMENT_ADD,this.contentGroup_elementAddedHandler);
               this._placeHolderGroup.removeEventListener(ElementExistenceEvent.ELEMENT_REMOVE,this.contentGroup_elementRemovedHandler);
               this._placeHolderGroup = null;
            }
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         var newContentGroupProperties:Object = null;
         var myMxmlContent:Array = null;
         super.partRemoved(partName,instance);
         if(instance == this.contentGroup)
         {
            this.contentGroup.removeEventListener(ElementExistenceEvent.ELEMENT_ADD,this.contentGroup_elementAddedHandler);
            this.contentGroup.removeEventListener(ElementExistenceEvent.ELEMENT_REMOVE,this.contentGroup_elementRemovedHandler);
            newContentGroupProperties = {};
            if(BitFlagUtil.isSet(this.contentGroupProperties as uint,AUTO_LAYOUT_PROPERTY_FLAG))
            {
               newContentGroupProperties.autoLayout = this.contentGroup.autoLayout;
            }
            if(BitFlagUtil.isSet(this.contentGroupProperties as uint,LAYOUT_PROPERTY_FLAG))
            {
               newContentGroupProperties.layout = this.contentGroup.layout;
            }
            this.contentGroupProperties = newContentGroupProperties;
            myMxmlContent = this.contentGroup.getMXMLContent();
            if(Boolean(this._contentModified) && Boolean(myMxmlContent))
            {
               this._placeHolderGroup = new spark.components.Group();
               this._placeHolderGroup.mxmlContent = myMxmlContent;
               this._placeHolderGroup.addEventListener(ElementExistenceEvent.ELEMENT_ADD,this.contentGroup_elementAddedHandler);
               this._placeHolderGroup.addEventListener(ElementExistenceEvent.ELEMENT_REMOVE,this.contentGroup_elementRemovedHandler);
            }
            this.contentGroup.mxmlContent = null;
            this.contentGroup.layout = null;
         }
      }
      
      public function createDeferredContent() : void
      {
         var deferredContent:Object = null;
         if(!this.mxmlContentCreated)
         {
            this.mxmlContentCreated = true;
            if(this._mxmlContentFactory)
            {
               deferredContent = this._mxmlContentFactory.getInstance();
               this.mxmlContent = deferredContent as Array;
               this._deferredContentCreated = true;
               dispatchEvent(new FlexEvent(FlexEvent.CONTENT_CREATION_COMPLETE));
            }
         }
      }
      
      public function get deferredContentCreated() : Boolean
      {
         return this._deferredContentCreated;
      }
      
      private function createContentIfNeeded() : void
      {
         if(Boolean(!this.mxmlContentCreated) && Boolean(this.creationPolicy != ContainerCreationPolicy.NONE))
         {
            this.createDeferredContent();
         }
      }
      
      private function contentGroup_elementAddedHandler(event:ElementExistenceEvent) : void
      {
         event.element.owner = this;
         dispatchEvent(event);
      }
      
      private function contentGroup_elementRemovedHandler(event:ElementExistenceEvent) : void
      {
         event.element.owner = null;
         dispatchEvent(event);
      }
   }
}
