package spark.components
{
   import mx.core.UIComponent;
   import mx.core.mx_internal;
   import mx.core.IFlexDisplayObject;
   import mx.styles.ISimpleStyleClient;
   import flash.events.Event;
   import flash.geom.Point;
   import flash.geom.Rectangle;
   import mx.utils.MatrixUtil;
   import flash.geom.Matrix;
   import flash.display.DisplayObject;
   import mx.core.LayoutDirection;
   import mx.managers.PopUpManager;
   import flash.geom.ColorTransform;
   import flash.display.Stage;
   import flash.display.StageDisplayState;
   
   use namespace mx_internal;
   
   [DefaultProperty("popUp")]
   public class PopUpAnchor extends UIComponent
   {
      
      private static var decomposition:Vector.<Number> = new <Number>[0,0,0,0,0];
       
      private var popUpWidth:Number = 0;
      
      private var popUpHeight:Number = 0;
      
      private var popUpIsDisplayed:Boolean = false;
      
      private var addedToStage:Boolean = false;
      
      private var popUpSizeCaptured:Boolean = false;
      
      private var _popUpHeightMatchesAnchorHeight:Boolean = false;
      
      private var _popUpWidthMatchesAnchorWidth:Boolean = false;
      
      private var _displayPopUp:Boolean = false;
      
      private var _popUp:IFlexDisplayObject;
      
      private var _popUpPosition:String = "topLeft";
      
      public function PopUpAnchor()
      {
         super();
         addEventListener(Event.ADDED_TO_STAGE,this.addedToStageHandler);
         addEventListener(Event.REMOVED_FROM_STAGE,this.removedFromStageHandler);
      }
      
      public function set popUpHeightMatchesAnchorHeight(value:Boolean) : void
      {
         if(this._popUpHeightMatchesAnchorHeight == value)
         {
            return;
         }
         this._popUpHeightMatchesAnchorHeight = value;
         invalidateDisplayList();
      }
      
      public function get popUpHeightMatchesAnchorHeight() : Boolean
      {
         return this._popUpHeightMatchesAnchorHeight;
      }
      
      public function set popUpWidthMatchesAnchorWidth(value:Boolean) : void
      {
         if(this._popUpWidthMatchesAnchorWidth == value)
         {
            return;
         }
         this._popUpWidthMatchesAnchorWidth = value;
         invalidateDisplayList();
      }
      
      public function get popUpWidthMatchesAnchorWidth() : Boolean
      {
         return this._popUpWidthMatchesAnchorWidth;
      }
      
      public function set displayPopUp(value:Boolean) : void
      {
         if(this._displayPopUp == value)
         {
            return;
         }
         this._displayPopUp = value;
         this.addOrRemovePopUp();
      }
      
      public function get displayPopUp() : Boolean
      {
         return this._displayPopUp;
      }
      
      [Bindable("popUpChanged")]
      public function set popUp(value:IFlexDisplayObject) : void
      {
         if(this._popUp == value)
         {
            return;
         }
         this._popUp = value;
         if(this._popUp is ISimpleStyleClient)
         {
            ISimpleStyleClient(this._popUp).styleName = this;
         }
         dispatchEvent(new Event("popUpChanged"));
      }
      
      public function get popUp() : IFlexDisplayObject
      {
         return this._popUp;
      }
      
      [Inspectable(defaultValue="topLeft",category="General",enumeration="left,right,above,below,center,topLeft")]
      public function set popUpPosition(value:String) : void
      {
         if(this._popUpPosition == value)
         {
            return;
         }
         this._popUpPosition = value;
         invalidateDisplayList();
      }
      
      public function get popUpPosition() : String
      {
         return this._popUpPosition;
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         this.applyPopUpTransform(unscaledWidth,unscaledHeight);
      }
      
      public function updatePopUpTransform() : void
      {
         this.applyPopUpTransform(width,height);
      }
      
      protected function calculatePopUpPosition() : Point
      {
         var adjustedPosition:String = null;
         var adjustedRegPoint:Point = null;
         var adjustedBounds:Rectangle = null;
         var matrix:Matrix = MatrixUtil.getConcatenatedMatrix(this);
         var regPoint:Point = new Point();
         if(!matrix)
         {
            return regPoint;
         }
         var popUpBounds:Rectangle = new Rectangle();
         var popUpAsDisplayObject:DisplayObject = this.popUp as DisplayObject;
         this.determinePosition(this.popUpPosition,popUpAsDisplayObject.width,popUpAsDisplayObject.height,matrix,regPoint,popUpBounds);
         if(screen)
         {
            switch(this.popUpPosition)
            {
               case PopUpPosition.BELOW:
                  if(popUpBounds.bottom > screen.bottom)
                  {
                     adjustedPosition = PopUpPosition.ABOVE;
                  }
                  break;
               case PopUpPosition.ABOVE:
                  if(popUpBounds.top < screen.top)
                  {
                     adjustedPosition = PopUpPosition.BELOW;
                  }
                  break;
               case PopUpPosition.LEFT:
                  if(popUpBounds.left < screen.left)
                  {
                     adjustedPosition = PopUpPosition.RIGHT;
                  }
                  break;
               case PopUpPosition.RIGHT:
                  if(popUpBounds.right > screen.right)
                  {
                     adjustedPosition = PopUpPosition.LEFT;
                  }
            }
         }
         if(adjustedPosition != null)
         {
            adjustedRegPoint = new Point();
            adjustedBounds = new Rectangle();
            this.determinePosition(adjustedPosition,popUpAsDisplayObject.width,popUpAsDisplayObject.height,matrix,adjustedRegPoint,adjustedBounds);
            if(screen)
            {
               switch(adjustedPosition)
               {
                  case PopUpPosition.BELOW:
                     if(adjustedBounds.bottom > screen.bottom)
                     {
                        adjustedPosition = null;
                     }
                     break;
                  case PopUpPosition.ABOVE:
                     if(adjustedBounds.top < screen.top)
                     {
                        adjustedPosition = null;
                     }
                     break;
                  case PopUpPosition.LEFT:
                     if(adjustedBounds.left < screen.left)
                     {
                        adjustedPosition = null;
                     }
                     break;
                  case PopUpPosition.RIGHT:
                     if(adjustedBounds.right > screen.right)
                     {
                        adjustedPosition = null;
                     }
               }
            }
            if(adjustedPosition != null)
            {
               regPoint = adjustedRegPoint;
               popUpBounds = adjustedBounds;
            }
         }
         MatrixUtil.decomposeMatrix(decomposition,matrix,0,0);
         var concatScaleX:Number = decomposition[3];
         var concatScaleY:Number = decomposition[4];
         if(popUpBounds.top < screen.top)
         {
            regPoint.y = regPoint.y + (screen.top - popUpBounds.top) / concatScaleY;
         }
         else if(popUpBounds.bottom > screen.bottom)
         {
            regPoint.y = regPoint.y - (popUpBounds.bottom - screen.bottom) / concatScaleY;
         }
         if(popUpBounds.left < screen.left)
         {
            regPoint.x = regPoint.x + (screen.left - popUpBounds.left) / concatScaleX;
         }
         else if(popUpBounds.right > screen.right)
         {
            regPoint.x = regPoint.x - (popUpBounds.right - screen.right) / concatScaleX;
         }
         if(layoutDirection == LayoutDirection.RTL)
         {
            regPoint.x = regPoint.x + popUpBounds.width;
         }
         return MatrixUtil.getConcatenatedComputedMatrix(this).transformPoint(regPoint);
      }
      
      private function addOrRemovePopUp() : void
      {
         if(!this.addedToStage)
         {
            return;
         }
         if(this.popUp == null)
         {
            return;
         }
         if(Boolean(DisplayObject(this.popUp).parent == null) && Boolean(this.displayPopUp))
         {
            PopUpManager.addPopUp(this.popUp,this,false);
            this.popUpIsDisplayed = true;
            if(Boolean(this.popUp is UIComponent) && Boolean(!this.popUpSizeCaptured))
            {
               this.popUpWidth = UIComponent(this.popUp).explicitWidth;
               this.popUpHeight = UIComponent(this.popUp).explicitHeight;
               UIComponent(this.popUp).validateNow();
               this.popUpSizeCaptured = true;
            }
            this.applyPopUpTransform(width,height);
         }
         else if(Boolean(DisplayObject(this.popUp).parent != null) && Boolean(this.displayPopUp == false))
         {
            this.removeAndResetPopUp();
         }
      }
      
      private function removeAndResetPopUp() : void
      {
         PopUpManager.removePopUp(this.popUp);
         this.popUpIsDisplayed = false;
      }
      
      mx_internal function determinePosition(placement:String, popUpWidth:Number, popUpHeight:Number, matrix:Matrix, registrationPoint:Point, bounds:Rectangle) : void
      {
         switch(placement)
         {
            case PopUpPosition.BELOW:
               registrationPoint.x = 0;
               registrationPoint.y = unscaledHeight;
               break;
            case PopUpPosition.ABOVE:
               registrationPoint.x = 0;
               registrationPoint.y = -popUpHeight;
               break;
            case PopUpPosition.LEFT:
               registrationPoint.x = -popUpWidth;
               registrationPoint.y = 0;
               break;
            case PopUpPosition.RIGHT:
               registrationPoint.x = unscaledWidth;
               registrationPoint.y = 0;
               break;
            case PopUpPosition.CENTER:
               registrationPoint.x = (unscaledWidth - popUpWidth) / 2;
               registrationPoint.y = (unscaledHeight - popUpHeight) / 2;
               break;
            case PopUpPosition.TOP_LEFT:
         }
         var popUpAsDisplayObject:DisplayObject = this.popUp as DisplayObject;
         var globalTL:Point = matrix.transformPoint(registrationPoint);
         registrationPoint.y = registrationPoint.y + popUpAsDisplayObject.height;
         var globalBL:Point = matrix.transformPoint(registrationPoint);
         registrationPoint.x = registrationPoint.x + popUpAsDisplayObject.width;
         var globalBR:Point = matrix.transformPoint(registrationPoint);
         registrationPoint.y = registrationPoint.y - popUpAsDisplayObject.height;
         var globalTR:Point = matrix.transformPoint(registrationPoint);
         registrationPoint.x = registrationPoint.x - popUpAsDisplayObject.width;
         bounds.left = Math.min(globalTL.x,globalBL.x,globalBR.x,globalTR.x);
         bounds.right = Math.max(globalTL.x,globalBL.x,globalBR.x,globalTR.x);
         bounds.top = Math.min(globalTL.y,globalBL.y,globalBR.y,globalTR.y);
         bounds.bottom = Math.max(globalTL.y,globalBL.y,globalBR.y,globalTR.y);
      }
      
      private function applyPopUpTransform(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var w:Number = NaN;
         var h:Number = NaN;
         var smStage:Stage = null;
         if(!this.popUpIsDisplayed)
         {
            return;
         }
         var m:Matrix = MatrixUtil.getConcatenatedMatrix(this);
         if(this.popUp is UIComponent)
         {
            if(this.popUpWidthMatchesAnchorWidth)
            {
               UIComponent(this.popUp).width = unscaledWidth;
            }
            else
            {
               UIComponent(this.popUp).explicitWidth = this.popUpWidth;
            }
            if(this.popUpHeightMatchesAnchorHeight)
            {
               UIComponent(this.popUp).height = unscaledHeight;
            }
            else
            {
               UIComponent(this.popUp).explicitHeight = this.popUpHeight;
            }
         }
         else
         {
            w = !!this.popUpWidthMatchesAnchorWidth?Number(unscaledWidth):Number(this.popUp.measuredWidth);
            h = !!this.popUpHeightMatchesAnchorHeight?Number(unscaledHeight):Number(this.popUp.measuredHeight);
            this.popUp.setActualSize(w,h);
         }
         var popUpPoint:Point = this.calculatePopUpPosition();
         try
         {
            smStage = systemManager.stage;
            if(Boolean(smStage) && Boolean(smStage.displayState != StageDisplayState.NORMAL) && Boolean(smStage.fullScreenSourceRect))
            {
               popUpPoint.x = popUpPoint.x + smStage.fullScreenSourceRect.x;
               popUpPoint.y = popUpPoint.y + smStage.fullScreenSourceRect.y;
            }
         }
         catch(e:Error)
         {
         }
         if(!m)
         {
            return;
         }
         m.tx = popUpPoint.x;
         m.ty = popUpPoint.y;
         if(this.popUp is UIComponent)
         {
            UIComponent(this.popUp).setLayoutMatrix(m,false);
         }
         else if(this.popUp is DisplayObject)
         {
            DisplayObject(this.popUp).transform.matrix = m;
         }
         var oldAlpha:Number = DisplayObject(this.popUp).alpha;
         var tmpColorTransform:ColorTransform = $transform.concatenatedColorTransform;
         if(tmpColorTransform != null)
         {
            tmpColorTransform.alphaMultiplier = oldAlpha;
            tmpColorTransform.alphaOffset = 0;
         }
         DisplayObject(this.popUp).transform.colorTransform = tmpColorTransform;
      }
      
      private function addedToStageHandler(event:Event) : void
      {
         this.addedToStage = true;
         this.addOrRemovePopUp();
      }
      
      private function removedFromStageHandler(event:Event) : void
      {
         if(Boolean(this.popUp != null) && Boolean(DisplayObject(this.popUp).parent != null))
         {
            this.removeAndResetPopUp();
         }
         this.addedToStage = false;
      }
   }
}
