package spark.components
{
   import spark.components.supportClasses.ListBase;
   import mx.managers.IFocusManagerComponent;
   import mx.core.mx_internal;
   import flash.geom.Point;
   import mx.core.IFactory;
   import mx.collections.IList;
   import mx.events.DragEvent;
   import mx.core.EventPriority;
   import spark.events.RendererExistenceEvent;
   import spark.events.IndexChangeEvent;
   import mx.events.FlexEvent;
   import mx.core.DragSource;
   import mx.managers.DragManager;
   import mx.core.IFlexDisplayObject;
   import mx.core.IVisualElement;
   import flash.events.MouseEvent;
   import mx.events.SandboxMouseEvent;
   import flash.display.DisplayObject;
   import flash.events.Event;
   import spark.layouts.supportClasses.DropLocation;
   import mx.utils.ObjectUtil;
   import mx.core.IUID;
   import mx.utils.UIDUtil;
   import flash.events.KeyboardEvent;
   import flash.ui.Keyboard;
   import spark.core.NavigationUnit;
   import flash.text.TextField;
   import flash.system.ApplicationDomain;
   
   use namespace mx_internal;
   
   [IconFile("List.png")]
   [DefaultTriggerEvent("change")]
   [AccessibilityClass(implementation="spark.accessibility.ListAccImpl")]
   [Style(inherit="yes",name="symbolColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="selectionColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="rollOverColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="no",name="dropIndicatorSkin",type="Class")]
   [Style(inherit="no",name="dragIndicatorClass",type="Class")]
   [Style(inherit="yes",name="contentBackgroundColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="contentBackgroundAlpha",theme="spark",type="Number")]
   [Style(inherit="no",name="borderVisible",theme="spark",type="Boolean")]
   [Style(inherit="no",name="borderColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="borderAlpha",theme="spark",type="Number")]
   [Style(arrayType="uint",inherit="yes",name="alternatingItemColors",format="Color",theme="spark",type="Array")]
   public class List extends ListBase implements IFocusManagerComponent
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var createAccessibilityImplementation:Function;
       
      mx_internal var mouseDownPoint:Point;
      
      mx_internal var mouseDownIndex:int = -1;
      
      mx_internal var pendingSelectionOnMouseUp:Boolean = false;
      
      mx_internal var pendingSelectionShiftKey:Boolean;
      
      mx_internal var pendingSelectionCtrlKey:Boolean;
      
      private var richEditableTextClass:Class;
      
      [SkinPart(type="flash.display.DisplayObject",required="false")]
      public var dropIndicator:IFactory;
      
      [SkinPart(required="false")]
      public var scroller:spark.components.Scroller;
      
      private var _allowMultipleSelection:Boolean = false;
      
      private var _dragEnabled:Boolean = false;
      
      private var _dragMoveEnabled:Boolean = false;
      
      private var _dropEnabled:Boolean = false;
      
      private var _selectedIndices:Vector.<int>;
      
      private var _proposedSelectedIndices:Vector.<int>;
      
      private var multipleSelectionChanged:Boolean;
      
      public function List()
      {
         this._selectedIndices = new Vector.<int>();
         this._proposedSelectedIndices = new Vector.<int>();
         super();
         this.useVirtualLayout = true;
         if(ApplicationDomain.currentDomain.hasDefinition("spark.components.RichEditableText"))
         {
            this.richEditableTextClass = Class(ApplicationDomain.currentDomain.getDefinition("spark.components.RichEditableText"));
         }
      }
      
      override public function set hasFocusableChildren(value:Boolean) : void
      {
         super.hasFocusableChildren = value;
         if(this.scroller)
         {
            this.scroller.hasFocusableChildren = value;
         }
      }
      
      override public function get useVirtualLayout() : Boolean
      {
         return super.useVirtualLayout;
      }
      
      override public function set useVirtualLayout(value:Boolean) : void
      {
         super.useVirtualLayout = value;
      }
      
      override public function set dataProvider(value:IList) : void
      {
         if(Boolean(!this.isEmpty(this._proposedSelectedIndices)) || Boolean(!this.isEmpty(this.selectedIndices)))
         {
            this._proposedSelectedIndices.length = 0;
            this.multipleSelectionChanged = true;
            invalidateProperties();
         }
         super.dataProvider = value;
      }
      
      public function get allowMultipleSelection() : Boolean
      {
         return this._allowMultipleSelection;
      }
      
      public function set allowMultipleSelection(value:Boolean) : void
      {
         if(value == this._allowMultipleSelection)
         {
            return;
         }
         this._allowMultipleSelection = value;
      }
      
      [Inspectable(defaultValue="false")]
      public function get dragEnabled() : Boolean
      {
         return this._dragEnabled;
      }
      
      public function set dragEnabled(value:Boolean) : void
      {
         if(value == this._dragEnabled)
         {
            return;
         }
         this._dragEnabled = value;
         if(this._dragEnabled)
         {
            addEventListener(DragEvent.DRAG_START,this.dragStartHandler,false,EventPriority.DEFAULT_HANDLER);
            addEventListener(DragEvent.DRAG_COMPLETE,this.dragCompleteHandler,false,EventPriority.DEFAULT_HANDLER);
         }
         else
         {
            removeEventListener(DragEvent.DRAG_START,this.dragStartHandler,false);
            removeEventListener(DragEvent.DRAG_COMPLETE,this.dragCompleteHandler,false);
         }
      }
      
      [Inspectable(defaultValue="false")]
      public function get dragMoveEnabled() : Boolean
      {
         return this._dragMoveEnabled;
      }
      
      public function set dragMoveEnabled(value:Boolean) : void
      {
         this._dragMoveEnabled = value;
      }
      
      [Inspectable(defaultValue="false")]
      public function get dropEnabled() : Boolean
      {
         return this._dropEnabled;
      }
      
      public function set dropEnabled(value:Boolean) : void
      {
         if(value == this._dropEnabled)
         {
            return;
         }
         this._dropEnabled = value;
         if(this._dropEnabled)
         {
            addEventListener(DragEvent.DRAG_ENTER,this.dragEnterHandler,false,EventPriority.DEFAULT_HANDLER);
            addEventListener(DragEvent.DRAG_EXIT,this.dragExitHandler,false,EventPriority.DEFAULT_HANDLER);
            addEventListener(DragEvent.DRAG_OVER,this.dragOverHandler,false,EventPriority.DEFAULT_HANDLER);
            addEventListener(DragEvent.DRAG_DROP,this.dragDropHandler,false,EventPriority.DEFAULT_HANDLER);
         }
         else
         {
            removeEventListener(DragEvent.DRAG_ENTER,this.dragEnterHandler,false);
            removeEventListener(DragEvent.DRAG_EXIT,this.dragExitHandler,false);
            removeEventListener(DragEvent.DRAG_OVER,this.dragOverHandler,false);
            removeEventListener(DragEvent.DRAG_DROP,this.dragDropHandler,false);
         }
      }
      
      [Bindable("valueCommit")]
      [Bindable("change")]
      public function get selectedIndices() : Vector.<int>
      {
         return this._selectedIndices;
      }
      
      public function set selectedIndices(value:Vector.<int>) : void
      {
         this.setSelectedIndices(value,false);
      }
      
      mx_internal function setSelectedIndices(value:Vector.<int>, dispatchChangeEvent:Boolean = false) : void
      {
         if(Boolean(this._proposedSelectedIndices == value) || Boolean(value && value.length == 1 && this.selectedIndices && this.selectedIndices.length == 1) && Boolean(value[0] == this.selectedIndices[0]))
         {
            return;
         }
         if(dispatchChangeEvent)
         {
            dispatchChangeAfterSelection = dispatchChangeEvent;
         }
         if(value)
         {
            this._proposedSelectedIndices = value;
         }
         else
         {
            this._proposedSelectedIndices = new Vector.<int>();
         }
         this.multipleSelectionChanged = true;
         invalidateProperties();
      }
      
      [Bindable("valueCommit")]
      [Bindable("change")]
      public function get selectedItems() : Vector.<Object>
      {
         var count:int = 0;
         var i:int = 0;
         var result:Vector.<Object> = new Vector.<Object>();
         if(this.selectedIndices)
         {
            count = this.selectedIndices.length;
            for(i = 0; i < count; i++)
            {
               result[i] = dataProvider.getItemAt(this.selectedIndices[i]);
            }
         }
         return result;
      }
      
      public function set selectedItems(value:Vector.<Object>) : void
      {
         var count:int = 0;
         var i:int = 0;
         var index:int = 0;
         var indices:Vector.<int> = new Vector.<int>();
         if(value)
         {
            count = value.length;
            for(i = 0; i < count; i++)
            {
               index = dataProvider.getItemIndex(value[i]);
               if(index != -1)
               {
                  indices.splice(0,0,index);
               }
               if(index == -1)
               {
                  indices = new Vector.<int>();
                  break;
               }
            }
         }
         this._proposedSelectedIndices = indices;
         this.multipleSelectionChanged = true;
         invalidateProperties();
      }
      
      override protected function initializeAccessibility() : void
      {
         if(List.createAccessibilityImplementation != null)
         {
            List.createAccessibilityImplementation(this);
         }
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(this.multipleSelectionChanged)
         {
            this.commitSelection();
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         super.partAdded(partName,instance);
         if(instance == dataGroup)
         {
            dataGroup.addEventListener(RendererExistenceEvent.RENDERER_ADD,this.dataGroup_rendererAddHandler);
            dataGroup.addEventListener(RendererExistenceEvent.RENDERER_REMOVE,this.dataGroup_rendererRemoveHandler);
         }
         else if(instance == this.scroller)
         {
            this.scroller.hasFocusableChildren = hasFocusableChildren;
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         if(instance == dataGroup)
         {
            dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_ADD,this.dataGroup_rendererAddHandler);
            dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_REMOVE,this.dataGroup_rendererRemoveHandler);
         }
         super.partRemoved(partName,instance);
      }
      
      override protected function itemAdded(index:int) : void
      {
         this.adjustSelection(index,true);
      }
      
      override protected function itemRemoved(index:int) : void
      {
         this.adjustSelection(index,false);
      }
      
      private function isValidIndex(item:int, index:int, v:Vector.<int>) : Boolean
      {
         return Boolean(dataProvider != null) && Boolean(item >= 0) && Boolean(item < dataProvider.length);
      }
      
      override protected function commitSelection(dispatchChangedEvents:Boolean = true) : Boolean
      {
         var temp:Vector.<int> = null;
         var e:IndexChangeEvent = null;
         this.multipleSelectionChanged = false;
         var oldSelectedIndex:Number = _selectedIndex;
         var oldCaretIndex:Number = _caretIndex;
         this._proposedSelectedIndices = this._proposedSelectedIndices.filter(this.isValidIndex);
         if(Boolean(!this.allowMultipleSelection) && Boolean(!this.isEmpty(this._proposedSelectedIndices)))
         {
            temp = new Vector.<int>();
            temp.push(this._proposedSelectedIndices[0]);
            this._proposedSelectedIndices = temp;
         }
         if(!this.isEmpty(this._proposedSelectedIndices))
         {
            _proposedSelectedIndex = this.getFirstItemValue(this._proposedSelectedIndices);
         }
         var retVal:Boolean = super.commitSelection(false);
         if(!retVal)
         {
            return false;
         }
         if(selectedIndex > NO_SELECTION)
         {
            if(Boolean(this._proposedSelectedIndices) && Boolean(this._proposedSelectedIndices.indexOf(selectedIndex) == -1))
            {
               this._proposedSelectedIndices.push(selectedIndex);
            }
         }
         this.commitMultipleSelection();
         setCurrentCaretIndex(selectedIndex);
         if(Boolean(dispatchChangedEvents) && Boolean(retVal))
         {
            if(dispatchChangeAfterSelection)
            {
               e = new IndexChangeEvent(IndexChangeEvent.CHANGE);
               e.oldIndex = oldSelectedIndex;
               e.newIndex = _selectedIndex;
               dispatchEvent(e);
               dispatchChangeAfterSelection = false;
            }
            else
            {
               dispatchEvent(new FlexEvent(FlexEvent.VALUE_COMMIT));
            }
            e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
            e.oldIndex = oldCaretIndex;
            e.newIndex = caretIndex;
            dispatchEvent(e);
         }
         return retVal;
      }
      
      protected function commitMultipleSelection() : void
      {
         var i:int = 0;
         var count:int = 0;
         var removedItems:Vector.<int> = new Vector.<int>();
         var addedItems:Vector.<int> = new Vector.<int>();
         if(Boolean(!this.isEmpty(this._selectedIndices)) && Boolean(!this.isEmpty(this._proposedSelectedIndices)))
         {
            count = this._proposedSelectedIndices.length;
            for(i = 0; i < count; i++)
            {
               if(this._selectedIndices.indexOf(this._proposedSelectedIndices[i]) < 0)
               {
                  addedItems.push(this._proposedSelectedIndices[i]);
               }
            }
            count = this._selectedIndices.length;
            for(i = 0; i < count; i++)
            {
               if(this._proposedSelectedIndices.indexOf(this._selectedIndices[i]) < 0)
               {
                  removedItems.push(this._selectedIndices[i]);
               }
            }
         }
         else if(!this.isEmpty(this._selectedIndices))
         {
            removedItems = this._selectedIndices;
         }
         else if(!this.isEmpty(this._proposedSelectedIndices))
         {
            addedItems = this._proposedSelectedIndices;
         }
         this._selectedIndices = this._proposedSelectedIndices;
         if(removedItems.length > 0)
         {
            count = removedItems.length;
            for(i = 0; i < count; i++)
            {
               this.itemSelected(removedItems[i],false);
            }
         }
         if(!this.isEmpty(this._proposedSelectedIndices))
         {
            count = this._proposedSelectedIndices.length;
            for(i = 0; i < count; i++)
            {
               this.itemSelected(this._proposedSelectedIndices[i],true);
            }
         }
         this._proposedSelectedIndices = new Vector.<int>();
      }
      
      override protected function itemSelected(index:int, selected:Boolean) : void
      {
         super.itemSelected(index,selected);
         var renderer:Object = Boolean(dataGroup)?dataGroup.getElementAt(index):null;
         if(renderer is IItemRenderer)
         {
            IItemRenderer(renderer).selected = selected;
         }
      }
      
      override protected function itemShowingCaret(index:int, showsCaret:Boolean) : void
      {
         super.itemShowingCaret(index,showsCaret);
         var renderer:Object = Boolean(dataGroup)?dataGroup.getElementAt(index):null;
         if(renderer is IItemRenderer)
         {
            IItemRenderer(renderer).showsCaret = showsCaret;
         }
      }
      
      override mx_internal function isItemIndexSelected(index:int) : Boolean
      {
         if(Boolean(this.allowMultipleSelection) && Boolean(this.selectedIndices != null))
         {
            return this.selectedIndices.indexOf(index) != -1;
         }
         return index == selectedIndex;
      }
      
      private function getLastSelectedIndex() : int
      {
         if(Boolean(this.selectedIndices) && Boolean(this.selectedIndices.length > 0))
         {
            return this.selectedIndices[this.selectedIndices.length - 1];
         }
         return 0;
      }
      
      private function getFirstItemValue(v:Vector.<int>) : int
      {
         if(Boolean(v) && Boolean(v.length > 0))
         {
            return v[0];
         }
         return -1;
      }
      
      private function isEmpty(v:Vector.<int>) : Boolean
      {
         return Boolean(v == null) || Boolean(v.length == 0);
      }
      
      protected function calculateSelectedIndices(index:int, shiftKey:Boolean, ctrlKey:Boolean) : Vector.<int>
      {
         var i:int = 0;
         var found:Boolean = false;
         var start:int = 0;
         var end:int = 0;
         var interval:Vector.<int> = new Vector.<int>();
         if(!shiftKey)
         {
            if(ctrlKey)
            {
               if(!this.isEmpty(this.selectedIndices))
               {
                  if(Boolean(this.selectedIndices.length == 1) && Boolean(this.selectedIndices[0] == index))
                  {
                     if(!requireSelection)
                     {
                        return interval;
                     }
                     interval.splice(0,0,this.selectedIndices[0]);
                     return interval;
                  }
                  found = false;
                  for(i = 0; i < this._selectedIndices.length; i++)
                  {
                     if(this._selectedIndices[i] == index)
                     {
                        found = true;
                     }
                     else if(this._selectedIndices[i] != index)
                     {
                        interval.splice(0,0,this._selectedIndices[i]);
                     }
                  }
                  if(!found)
                  {
                     interval.splice(0,0,index);
                  }
                  return interval;
               }
               interval.splice(0,0,index);
               return interval;
            }
            interval.splice(0,0,index);
            return interval;
         }
         start = !this.isEmpty(this.selectedIndices)?int(this.selectedIndices[this.selectedIndices.length - 1]):int(0);
         end = index;
         if(start < end)
         {
            for(i = start; i <= end; i++)
            {
               interval.splice(0,0,i);
            }
         }
         else
         {
            for(i = start; i >= end; i--)
            {
               interval.splice(0,0,i);
            }
         }
         return interval;
      }
      
      protected function dragStartHandler(event:DragEvent) : void
      {
         if(event.isDefaultPrevented())
         {
            return;
         }
         var dragSource:DragSource = new DragSource();
         this.addDragData(dragSource);
         DragManager.doDrag(this,dragSource,event,this.createDragIndicator(),0,0,0.5,this.dragMoveEnabled);
      }
      
      private function compareValues(a:int, b:int) : int
      {
         return a - b;
      }
      
      protected function dragCompleteHandler(event:DragEvent) : void
      {
         if(event.isDefaultPrevented())
         {
            return;
         }
         if(Boolean(!this.dragMoveEnabled) || Boolean(event.action != DragManager.MOVE) || Boolean(event.relatedObject == this))
         {
            return;
         }
         var movedIndices:Vector.<int> = this.selectedIndices;
         this.setSelectedIndices(new Vector.<int>(),true);
         validateProperties();
         movedIndices.sort(this.compareValues);
         var count:int = movedIndices.length;
         for(var i:int = count - 1; i >= 0; i--)
         {
            dataProvider.removeItemAt(movedIndices[i]);
         }
      }
      
      public function createDragIndicator() : IFlexDisplayObject
      {
         var dragIndicator:IFlexDisplayObject = null;
         var dragIndicatorClass:Class = Class(getStyle("dragIndicatorClass"));
         if(dragIndicatorClass)
         {
            dragIndicator = new dragIndicatorClass();
            if(dragIndicator is IVisualElement)
            {
               IVisualElement(dragIndicator).owner = this;
            }
         }
         return dragIndicator;
      }
      
      public function addDragData(dragSource:DragSource) : void
      {
         dragSource.addHandler(this.copySelectedItemsForDragDrop,"itemsByIndex");
         var caretIndex:int = 0;
         var draggedIndices:Vector.<int> = this.selectedIndices;
         var count:int = draggedIndices.length;
         for(var i:int = 0; i < count; i++)
         {
            if(this.mouseDownIndex > draggedIndices[i])
            {
               caretIndex++;
            }
         }
         dragSource.addData(caretIndex,"caretIndex");
      }
      
      private function copySelectedItemsForDragDrop() : Vector.<Object>
      {
         var draggedIndices:Vector.<int> = this.selectedIndices.slice(0,this.selectedIndices.length);
         var result:Vector.<Object> = new Vector.<Object>(draggedIndices.length);
         draggedIndices.sort(this.compareValues);
         var count:int = draggedIndices.length;
         for(var i:int = 0; i < count; i++)
         {
            result[i] = dataProvider.getItemAt(draggedIndices[i]);
         }
         return result;
      }
      
      protected function item_mouseDownHandler(event:MouseEvent) : void
      {
         var newIndex:int = 0;
         var currentRenderer:IItemRenderer = null;
         if(event.currentTarget is IItemRenderer)
         {
            newIndex = IItemRenderer(event.currentTarget).itemIndex;
         }
         else
         {
            newIndex = dataGroup.getElementIndex(event.currentTarget as IVisualElement);
         }
         if(!this.allowMultipleSelection)
         {
            if(caretIndex >= 0)
            {
               currentRenderer = dataGroup.getElementAt(caretIndex) as IItemRenderer;
               if(currentRenderer)
               {
                  currentRenderer.showsCaret = false;
               }
            }
            if(Boolean(event.ctrlKey) && Boolean(selectedIndex == newIndex))
            {
               this.pendingSelectionOnMouseUp = true;
               this.pendingSelectionCtrlKey = true;
               this.pendingSelectionShiftKey = event.shiftKey;
            }
            else
            {
               setSelectedIndex(newIndex,true);
            }
         }
         else if(this.isItemIndexSelected(newIndex))
         {
            this.pendingSelectionOnMouseUp = true;
            this.pendingSelectionShiftKey = event.shiftKey;
            this.pendingSelectionCtrlKey = event.ctrlKey;
         }
         else
         {
            this.setSelectedIndices(this.calculateSelectedIndices(newIndex,event.shiftKey,event.ctrlKey),true);
         }
         if(!this.pendingSelectionOnMouseUp)
         {
            validateProperties();
         }
         this.mouseDownPoint = event.target.localToGlobal(new Point(event.localX,event.localY));
         this.mouseDownIndex = newIndex;
         var listenForDrag:Boolean = Boolean(this.dragEnabled) && Boolean(this.selectedIndices) && Boolean(this.selectedIndices.indexOf(newIndex) != -1);
         if(listenForDrag)
         {
            systemManager.getSandboxRoot().addEventListener(MouseEvent.MOUSE_MOVE,this.mouseMoveHandler,false,0,true);
         }
         if(Boolean(this.pendingSelectionOnMouseUp) || Boolean(listenForDrag))
         {
            systemManager.getSandboxRoot().addEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.mouseUpHandler,false,0,true);
            systemManager.getSandboxRoot().addEventListener(MouseEvent.MOUSE_UP,this.mouseUpHandler,false,0,true);
         }
      }
      
      protected function mouseMoveHandler(event:MouseEvent) : void
      {
         var dragEvent:DragEvent = null;
         var localMouseDownPoint:Point = null;
         if(Boolean(!this.mouseDownPoint) || Boolean(!this.dragEnabled))
         {
            return;
         }
         var pt:Point = new Point(event.localX,event.localY);
         pt = DisplayObject(event.target).localToGlobal(pt);
         var DRAG_THRESHOLD:int = 5;
         if(Boolean(Math.abs(this.mouseDownPoint.x - pt.x) > DRAG_THRESHOLD) || Boolean(Math.abs(this.mouseDownPoint.y - pt.y) > DRAG_THRESHOLD))
         {
            dragEvent = new DragEvent(DragEvent.DRAG_START);
            dragEvent.dragInitiator = this;
            localMouseDownPoint = this.globalToLocal(this.mouseDownPoint);
            dragEvent.localX = localMouseDownPoint.x;
            dragEvent.localY = localMouseDownPoint.y;
            dragEvent.buttonDown = true;
            dispatchEvent(dragEvent);
            this.removeMouseHandlersForDragStart();
         }
      }
      
      private function removeMouseHandlersForDragStart() : void
      {
         if(Boolean(this.pendingSelectionOnMouseUp) && Boolean(!DragManager.isDragging))
         {
            if(this.allowMultipleSelection)
            {
               this.setSelectedIndices(this.calculateSelectedIndices(this.mouseDownIndex,this.pendingSelectionShiftKey,this.pendingSelectionCtrlKey),true);
            }
            else
            {
               setSelectedIndex(NO_SELECTION,true);
            }
         }
         this.pendingSelectionOnMouseUp = false;
         this.mouseDownPoint = null;
         this.mouseDownIndex = -1;
         systemManager.getSandboxRoot().removeEventListener(MouseEvent.MOUSE_MOVE,this.mouseMoveHandler,false);
         systemManager.getSandboxRoot().removeEventListener(MouseEvent.MOUSE_UP,this.mouseUpHandler,false);
         systemManager.getSandboxRoot().removeEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.mouseUpHandler,false);
      }
      
      protected function mouseUpHandler(event:Event) : void
      {
         this.removeMouseHandlersForDragStart();
      }
      
      private function calculateDropLocation(event:DragEvent) : DropLocation
      {
         if(Boolean(!enabled) || Boolean(!event.dragSource.hasFormat("itemsByIndex")))
         {
            return null;
         }
         return layout.calculateDropLocation(event);
      }
      
      public function createDropIndicator() : DisplayObject
      {
         var dropIndicatorInstance:DisplayObject = null;
         var dropIndicatorClass:Class = null;
         if(layout.dropIndicator)
         {
            return layout.dropIndicator;
         }
         if(this.dropIndicator)
         {
            dropIndicatorInstance = DisplayObject(createDynamicPartInstance("dropIndicator"));
         }
         else
         {
            dropIndicatorClass = Class(getStyle("dropIndicatorSkin"));
            if(dropIndicatorClass)
            {
               dropIndicatorInstance = new dropIndicatorClass();
            }
         }
         if(dropIndicatorInstance is IVisualElement)
         {
            IVisualElement(dropIndicatorInstance).owner = this;
         }
         layout.dropIndicator = dropIndicatorInstance;
         return dropIndicatorInstance;
      }
      
      public function destroyDropIndicator() : DisplayObject
      {
         var dropIndicatorInstance:DisplayObject = layout.dropIndicator;
         if(!dropIndicatorInstance)
         {
            return null;
         }
         layout.dropIndicator = null;
         var count:int = numDynamicParts("dropIndicator");
         for(var i:int = 0; i < count; i++)
         {
            if(dropIndicatorInstance == getDynamicPartAt("dropIndicator",i))
            {
               removeDynamicPartInstance("dropIndicator",dropIndicatorInstance);
               break;
            }
         }
         return dropIndicatorInstance;
      }
      
      protected function dragEnterHandler(event:DragEvent) : void
      {
         if(event.isDefaultPrevented())
         {
            return;
         }
         var dropLocation:DropLocation = this.calculateDropLocation(event);
         if(dropLocation)
         {
            DragManager.acceptDragDrop(this);
            this.createDropIndicator();
            drawFocusAnyway = true;
            drawFocus(true);
            DragManager.showFeedback(!!event.ctrlKey?DragManager.COPY:DragManager.MOVE);
            layout.showDropIndicator(dropLocation);
         }
         else
         {
            DragManager.showFeedback(DragManager.NONE);
         }
      }
      
      protected function dragOverHandler(event:DragEvent) : void
      {
         if(event.isDefaultPrevented())
         {
            return;
         }
         var dropLocation:DropLocation = this.calculateDropLocation(event);
         if(dropLocation)
         {
            drawFocusAnyway = true;
            drawFocus(true);
            DragManager.showFeedback(!!event.ctrlKey?DragManager.COPY:DragManager.MOVE);
            layout.showDropIndicator(dropLocation);
         }
         else
         {
            layout.hideDropIndicator();
            drawFocus(false);
            drawFocusAnyway = false;
            DragManager.showFeedback(DragManager.NONE);
         }
      }
      
      protected function dragExitHandler(event:DragEvent) : void
      {
         if(event.isDefaultPrevented())
         {
            return;
         }
         layout.hideDropIndicator();
         drawFocus(false);
         drawFocusAnyway = false;
         this.destroyDropIndicator();
      }
      
      protected function dragDropHandler(event:DragEvent) : void
      {
         var i:int = 0;
         var item:Object = null;
         var delta:Point = null;
         var loopCount:int = 0;
         if(event.isDefaultPrevented())
         {
            return;
         }
         layout.hideDropIndicator();
         this.destroyDropIndicator();
         drawFocus(false);
         drawFocusAnyway = false;
         var dropLocation:DropLocation = this.calculateDropLocation(event);
         if(!dropLocation)
         {
            return;
         }
         var dropIndex:int = dropLocation.dropIndex;
         DragManager.showFeedback(!!event.ctrlKey?DragManager.COPY:DragManager.MOVE);
         var dragSource:DragSource = event.dragSource;
         var items:Vector.<Object> = dragSource.dataForFormat("itemsByIndex") as Vector.<Object>;
         var caretIndex:int = -1;
         if(dragSource.hasFormat("caretIndex"))
         {
            caretIndex = event.dragSource.dataForFormat("caretIndex") as int;
         }
         var indices:Vector.<int> = this.selectedIndices;
         this.setSelectedIndices(new Vector.<int>(),false);
         validateProperties();
         if(Boolean(this.dragMoveEnabled) && Boolean(event.action == DragManager.MOVE) && Boolean(event.dragInitiator == this))
         {
            indices.sort(this.compareValues);
            for(i = indices.length - 1; i >= 0; i--)
            {
               if(indices[i] < dropIndex)
               {
                  dropIndex--;
               }
               dataProvider.removeItemAt(indices[i]);
            }
         }
         var newSelection:Vector.<int> = new Vector.<int>();
         if(caretIndex != -1)
         {
            newSelection.push(dropIndex + caretIndex);
         }
         var copyItems:Boolean = event.action == DragManager.COPY;
         for(i = 0; i < items.length; i++)
         {
            item = items[i];
            if(copyItems)
            {
               item = this.copyItemWithUID(item);
            }
            dataProvider.addItemAt(item,dropIndex + i);
            if(i != caretIndex)
            {
               newSelection.push(dropIndex + i);
            }
         }
         this.setSelectedIndices(newSelection,false);
         if(caretIndex != -1)
         {
            loopCount = 0;
            while(loopCount++ < 10)
            {
               validateNow();
               delta = layout.getScrollPositionDeltaToElement(dropIndex + caretIndex);
               if(Boolean(!delta) || Boolean(delta.x == 0) && Boolean(delta.y == 0))
               {
                  break;
               }
               layout.horizontalScrollPosition = layout.horizontalScrollPosition + delta.x;
               layout.verticalScrollPosition = layout.verticalScrollPosition + delta.y;
            }
         }
      }
      
      protected function copyItemWithUID(item:Object) : Object
      {
         var copyObj:Object = ObjectUtil.copy(item);
         if(copyObj is IUID)
         {
            IUID(copyObj).uid = UIDUtil.createUID();
         }
         else if(Boolean(copyObj is Object) && Boolean("mx_internal_uid" in copyObj))
         {
            copyObj.mx_internal_uid = UIDUtil.createUID();
         }
         return copyObj;
      }
      
      private function dataGroup_rendererAddHandler(event:RendererExistenceEvent) : void
      {
         var index:int = event.index;
         var renderer:IVisualElement = event.renderer;
         if(!renderer)
         {
            return;
         }
         renderer.addEventListener(MouseEvent.MOUSE_DOWN,this.item_mouseDownHandler);
      }
      
      private function dataGroup_rendererRemoveHandler(event:RendererExistenceEvent) : void
      {
         var index:int = event.index;
         var renderer:Object = event.renderer;
         if(!renderer)
         {
            return;
         }
         renderer.removeEventListener(MouseEvent.MOUSE_DOWN,this.item_mouseDownHandler);
      }
      
      public function ensureIndexIsVisible(index:int) : void
      {
         if(!layout)
         {
            return;
         }
         var spDelta:Point = dataGroup.layout.getScrollPositionDeltaToElement(index);
         if(spDelta)
         {
            dataGroup.horizontalScrollPosition = dataGroup.horizontalScrollPosition + spDelta.x;
            dataGroup.verticalScrollPosition = dataGroup.verticalScrollPosition + spDelta.y;
         }
      }
      
      override protected function adjustSelection(index:int, add:Boolean = false) : void
      {
         var i:int = 0;
         var curr:Number = NaN;
         var e:IndexChangeEvent = null;
         var oldIndex:Number = NaN;
         var newInterval:Vector.<int> = new Vector.<int>();
         if(Boolean(selectedIndex == NO_SELECTION) || Boolean(doingWholesaleChanges))
         {
            if(Boolean(dataProvider) && Boolean(dataProvider.length == 1) && Boolean(requireSelection))
            {
               newInterval.push(0);
               this._selectedIndices = newInterval;
               _selectedIndex = 0;
               this.itemShowingCaret(0,true);
               dispatchEvent(new FlexEvent(FlexEvent.VALUE_COMMIT));
               e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
               e.oldIndex = -1;
               e.newIndex = _caretIndex;
               dispatchEvent(e);
            }
            return;
         }
         if(Boolean(!this.selectedIndices) && Boolean(selectedIndex > NO_SELECTION) || Boolean(selectedIndex > NO_SELECTION) && Boolean(this.selectedIndices.indexOf(selectedIndex) == -1))
         {
            this.commitSelection();
         }
         if(add)
         {
            for(i = 0; i < this.selectedIndices.length; i++)
            {
               curr = this.selectedIndices[i];
               if(curr >= index)
               {
                  newInterval.push(curr + 1);
               }
               else
               {
                  newInterval.push(curr);
               }
            }
         }
         else if(Boolean(!this.isEmpty(this.selectedIndices)) && Boolean(this.selectedIndices.length == 1) && Boolean(index == selectedIndex) && Boolean(requireSelection))
         {
            if(dataProvider.length == 0)
            {
               newInterval = new Vector.<int>();
            }
            else
            {
               if(index == 0)
               {
                  _proposedSelectedIndex = 0;
                  invalidateProperties();
                  return;
               }
               newInterval.push(0);
            }
         }
         else
         {
            for(i = 0; i < this.selectedIndices.length; i++)
            {
               curr = this.selectedIndices[i];
               if(curr > index)
               {
                  newInterval.push(curr - 1);
               }
               else if(curr < index)
               {
                  newInterval.push(curr);
               }
            }
         }
         if(caretIndex == selectedIndex)
         {
            oldIndex = caretIndex;
            _caretIndex = this.getFirstItemValue(newInterval);
            e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
            e.oldIndex = oldIndex;
            e.newIndex = caretIndex;
            dispatchEvent(e);
         }
         else
         {
            this.itemShowingCaret(caretIndex,false);
            caretIndexAdjusted = true;
            invalidateProperties();
         }
         var oldIndices:Vector.<int> = this.selectedIndices;
         this._selectedIndices = newInterval;
         _selectedIndex = this.getFirstItemValue(newInterval);
         if(this._selectedIndices != oldIndices)
         {
            selectedIndexAdjusted = true;
            invalidateProperties();
         }
      }
      
      mx_internal function findKey(eventCode:int) : Boolean
      {
         var tmpCode:int = eventCode;
         return Boolean(tmpCode >= 33) && Boolean(tmpCode <= 126) && Boolean(this.findString(String.fromCharCode(tmpCode)));
      }
      
      mx_internal function findString(str:String) : Boolean
      {
         var startIndex:int = 0;
         var stopIndex:int = 0;
         var retVal:Number = NaN;
         if(Boolean(!dataProvider) || Boolean(dataProvider.length == 0))
         {
            return false;
         }
         if(Boolean(selectedIndex == NO_SELECTION) || Boolean(selectedIndex == CUSTOM_SELECTED_ITEM))
         {
            startIndex = 0;
            stopIndex = dataProvider.length;
            retVal = this.findStringLoop(str,startIndex,stopIndex);
         }
         else
         {
            startIndex = selectedIndex + 1;
            stopIndex = dataProvider.length;
            retVal = this.findStringLoop(str,startIndex,stopIndex);
            if(retVal == -1)
            {
               retVal = this.findStringLoop(str,0,selectedIndex);
            }
         }
         if(retVal != -1)
         {
            setSelectedIndex(retVal,true);
            this.ensureIndexIsVisible(retVal);
            return true;
         }
         return false;
      }
      
      mx_internal function findStringLoop(str:String, startIndex:int, stopIndex:int) : Number
      {
         for(var itmStr:String = null; startIndex != stopIndex; )
         {
            itmStr = itemToLabel(dataProvider.getItemAt(startIndex));
            itmStr = itmStr.substring(0,str.length);
            if(Boolean(str == itmStr) || Boolean(str.toUpperCase() == itmStr.toUpperCase()))
            {
               return startIndex;
            }
            startIndex++;
         }
         return -1;
      }
      
      override protected function keyDownHandler(event:KeyboardEvent) : void
      {
         super.keyDownHandler(event);
         if(Boolean(!dataProvider) || Boolean(!layout) || Boolean(event.isDefaultPrevented()))
         {
            return;
         }
         if(this.isEditableTarget(event.target))
         {
            return;
         }
         if(event.keyCode == Keyboard.SPACE)
         {
            setSelectedIndex(caretIndex,true);
            event.preventDefault();
            return;
         }
         if(this.findKey(event.charCode))
         {
            event.preventDefault();
            return;
         }
         this.adjustSelectionAndCaretUponNavigation(event);
      }
      
      protected function adjustSelectionAndCaretUponNavigation(event:KeyboardEvent) : void
      {
         var startIndex:Number = NaN;
         var newInterval:Vector.<int> = null;
         var i:int = 0;
         var oldCaretIndex:Number = NaN;
         var e:IndexChangeEvent = null;
         var navigationUnit:uint = mapKeycodeForLayoutDirection(event);
         if(!NavigationUnit.isNavigationUnit(event.keyCode))
         {
            return;
         }
         var proposedNewIndex:int = layout.getNavigationDestinationIndex(caretIndex,navigationUnit,arrowKeysWrapFocus);
         if(proposedNewIndex == -1)
         {
            return;
         }
         event.preventDefault();
         if(Boolean(this.allowMultipleSelection) && Boolean(event.shiftKey) && Boolean(this.selectedIndices))
         {
            startIndex = this.getLastSelectedIndex();
            newInterval = new Vector.<int>();
            if(startIndex <= proposedNewIndex)
            {
               for(i = startIndex; i <= proposedNewIndex; i++)
               {
                  newInterval.splice(0,0,i);
               }
            }
            else
            {
               for(i = startIndex; i >= proposedNewIndex; i--)
               {
                  newInterval.splice(0,0,i);
               }
            }
            this.setSelectedIndices(newInterval,true);
            this.ensureIndexIsVisible(proposedNewIndex);
         }
         else if(event.ctrlKey)
         {
            oldCaretIndex = caretIndex;
            setCurrentCaretIndex(proposedNewIndex);
            e = new IndexChangeEvent(IndexChangeEvent.CARET_CHANGE);
            e.oldIndex = oldCaretIndex;
            e.newIndex = caretIndex;
            dispatchEvent(e);
            this.ensureIndexIsVisible(proposedNewIndex);
         }
         else
         {
            setSelectedIndex(proposedNewIndex,true);
            this.ensureIndexIsVisible(proposedNewIndex);
         }
      }
      
      protected function isEditableTarget(target:Object) : Boolean
      {
         var focusObj:Object = getFocus();
         return Boolean(focusObj is TextField) && Boolean(focusObj.type == "input") || Boolean(this.richEditableTextClass && focusObj is this.richEditableTextClass) && Boolean(focusObj.editable == true);
      }
   }
}
