package spark.components
{
   import spark.components.supportClasses.ScrollBarBase;
   import mx.core.mx_internal;
   import spark.core.IViewport;
   import flash.events.MouseEvent;
   import mx.core.EventPriority;
   import flash.geom.Point;
   import spark.core.NavigationUnit;
   import mx.events.PropertyChangeEvent;
   import mx.events.ResizeEvent;
   import mx.core.IInvalidating;
   
   use namespace mx_internal;
   
   [DefaultTriggerEvent("change")]
   [IconFile("HScrollBar.png")]
   public class HScrollBar extends ScrollBarBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function HScrollBar()
      {
         super();
      }
      
      private function updateMaximumAndPageSize() : void
      {
         var hsp:Number = viewport.horizontalScrollPosition;
         var viewportWidth:Number = !!isNaN(viewport.width)?Number(0):Number(viewport.width);
         var cWidth:Number = viewport.contentWidth;
         maximum = cWidth == 0?Number(hsp):Number(cWidth - viewportWidth);
         pageSize = viewportWidth;
      }
      
      override public function set viewport(newViewport:IViewport) : void
      {
         var oldViewport:IViewport = super.viewport;
         if(oldViewport == newViewport)
         {
            return;
         }
         if(oldViewport)
         {
            oldViewport.removeEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler);
            removeEventListener(MouseEvent.MOUSE_WHEEL,this.hsb_mouseWheelHandler,true);
         }
         super.viewport = newViewport;
         if(newViewport)
         {
            this.updateMaximumAndPageSize();
            value = newViewport.horizontalScrollPosition;
            newViewport.addEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler,false,EventPriority.DEFAULT_HANDLER);
            addEventListener(MouseEvent.MOUSE_WHEEL,this.hsb_mouseWheelHandler,true);
         }
      }
      
      override protected function pointToValue(x:Number, y:Number) : Number
      {
         if(Boolean(!thumb) || Boolean(!track))
         {
            return 0;
         }
         var r:Number = track.getLayoutBoundsWidth() - thumb.getLayoutBoundsWidth();
         return minimum + (r != 0?x / r * (maximum - minimum):0);
      }
      
      override protected function updateSkinDisplayList() : void
      {
         var thumbPos:Point = null;
         if(Boolean(!thumb) || Boolean(!track))
         {
            return;
         }
         var trackSize:Number = track.getLayoutBoundsWidth();
         var range:Number = maximum - minimum;
         var thumbPosTrackX:Number = 0;
         var thumbPosParentX:Number = 0;
         var thumbSize:Number = trackSize;
         if(range > 0)
         {
            if(getStyle("fixedThumbSize") === false)
            {
               thumbSize = Math.min(pageSize / (range + pageSize) * trackSize,trackSize);
               thumbSize = Math.max(thumb.minWidth,thumbSize);
            }
            else
            {
               thumbSize = Boolean(thumb)?Number(thumb.width):Number(0);
            }
            thumbPosTrackX = (value - minimum) * ((trackSize - thumbSize) / range);
         }
         if(getStyle("fixedThumbSize") === false)
         {
            thumb.setLayoutBoundsSize(thumbSize,NaN);
         }
         if(getStyle("autoThumbVisibility") === true)
         {
            thumb.visible = thumbSize < trackSize;
         }
         thumbPos = track.localToGlobal(new Point(thumbPosTrackX,0));
         thumbPosParentX = thumb.parent.globalToLocal(thumbPos).x;
         thumb.setLayoutBoundsPosition(Math.round(thumbPosParentX),thumb.getLayoutBoundsY());
      }
      
      override protected function setValue(value:Number) : void
      {
         super.setValue(value);
         if(viewport)
         {
            viewport.horizontalScrollPosition = value;
         }
      }
      
      override public function changeValueByPage(increase:Boolean = true) : void
      {
         var oldPageSize:Number = NaN;
         if(viewport)
         {
            oldPageSize = pageSize;
            pageSize = Math.abs(viewport.getHorizontalScrollPositionDelta(!!increase?uint(NavigationUnit.PAGE_RIGHT):uint(NavigationUnit.PAGE_LEFT)));
         }
         super.changeValueByPage(increase);
         if(viewport)
         {
            pageSize = oldPageSize;
         }
      }
      
      override protected function animatePaging(newValue:Number, pageSize:Number) : void
      {
         var vpPageSize:Number = NaN;
         if(viewport)
         {
            vpPageSize = Math.abs(viewport.getHorizontalScrollPositionDelta(newValue > value?uint(NavigationUnit.PAGE_RIGHT):uint(NavigationUnit.PAGE_LEFT)));
            super.animatePaging(newValue,vpPageSize);
            return;
         }
         super.animatePaging(newValue,pageSize);
      }
      
      override public function changeValueByStep(increase:Boolean = true) : void
      {
         var oldStepSize:Number = NaN;
         if(viewport)
         {
            oldStepSize = stepSize;
            stepSize = Math.abs(viewport.getHorizontalScrollPositionDelta(!!increase?uint(NavigationUnit.RIGHT):uint(NavigationUnit.LEFT)));
         }
         super.changeValueByStep(increase);
         if(viewport)
         {
            stepSize = oldStepSize;
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         if(instance == thumb)
         {
            thumb.setConstraintValue("left",undefined);
            thumb.setConstraintValue("right",undefined);
            thumb.setConstraintValue("horizontalCenter",undefined);
         }
         super.partAdded(partName,instance);
      }
      
      override mx_internal function viewportHorizontalScrollPositionChangeHandler(event:PropertyChangeEvent) : void
      {
         if(viewport)
         {
            value = viewport.horizontalScrollPosition;
         }
      }
      
      override mx_internal function viewportResizeHandler(event:ResizeEvent) : void
      {
         if(viewport)
         {
            this.updateMaximumAndPageSize();
         }
      }
      
      override mx_internal function viewportContentWidthChangeHandler(event:PropertyChangeEvent) : void
      {
         var viewportWidth:Number = NaN;
         if(viewport)
         {
            viewportWidth = !!isNaN(viewport.width)?Number(0):Number(viewport.width);
            maximum = viewport.contentWidth - viewportWidth;
         }
      }
      
      mx_internal function mouseWheelHandler(event:MouseEvent) : void
      {
         var navigationUnit:uint = 0;
         var hspDelta:Number = NaN;
         var vp:IViewport = viewport;
         if(Boolean(event.isDefaultPrevented()) || Boolean(!vp) || Boolean(!vp.visible))
         {
            return;
         }
         var nSteps:uint = Math.abs(event.delta);
         navigationUnit = event.delta < 0?uint(NavigationUnit.RIGHT):uint(NavigationUnit.LEFT);
         for(var hStep:int = 0; hStep < nSteps; hStep++)
         {
            hspDelta = vp.getHorizontalScrollPositionDelta(navigationUnit);
            if(!isNaN(hspDelta))
            {
               vp.horizontalScrollPosition = vp.horizontalScrollPosition + hspDelta;
               if(vp is IInvalidating)
               {
                  IInvalidating(vp).validateNow();
               }
            }
         }
         event.preventDefault();
      }
      
      private function hsb_mouseWheelHandler(event:MouseEvent) : void
      {
         var vp:IViewport = viewport;
         if(Boolean(event.isDefaultPrevented()) || Boolean(!vp) || Boolean(!vp.visible))
         {
            return;
         }
         event.stopImmediatePropagation();
         vp.dispatchEvent(event);
      }
   }
}
