package spark.accessibility
{
   import mx.accessibility.AccImpl;
   import mx.core.mx_internal;
   import spark.components.RichEditableText;
   import mx.core.UIComponent;
   import flash.events.Event;
   import mx.accessibility.AccConst;
   import flash.accessibility.Accessibility;
   
   use namespace mx_internal;
   
   public class RichEditableTextAccImpl extends AccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function RichEditableTextAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_TEXT;
      }
      
      public static function enableAccessibility() : void
      {
         RichEditableText.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         component.accessibilityImplementation = new RichEditableTextAccImpl(component);
      }
      
      override protected function get eventsToHandle() : Array
      {
         return super.eventsToHandle.concat([Event.CHANGE]);
      }
      
      public function get selectionActiveIndex() : int
      {
         return RichEditableText(master).selectionActivePosition;
      }
      
      public function get selectionAnchorIndex() : int
      {
         return RichEditableText(master).selectionAnchorPosition;
      }
      
      override public function get_accValue(childID:uint) : String
      {
         return RichEditableText(master).text;
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = getState(childID);
         if(!RichEditableText(master).editable)
         {
            accState = accState | AccConst.STATE_SYSTEM_READONLY;
         }
         if(RichEditableText(master).displayAsPassword)
         {
            accState = accState | AccConst.STATE_SYSTEM_PROTECTED;
         }
         return accState;
      }
      
      override protected function eventHandler(event:Event) : void
      {
         $eventHandler(event);
         switch(event.type)
         {
            case Event.CHANGE:
               Accessibility.sendEvent(master,0,AccConst.EVENT_OBJECT_VALUECHANGE,true);
         }
      }
      
      override protected function getName(childID:uint) : String
      {
         return "";
      }
   }
}
