package org.alivepdf.tools
{
   public function sprintf(format:String, ... args) : String
   {
      var next:* = undefined;
      var str:String = null;
      var c:String = null;
      var pastFieldWidth:Boolean = false;
      var pastFlags:Boolean = false;
      var flagAlternateForm:Boolean = false;
      var flagZeroPad:Boolean = false;
      var flagLeftJustify:Boolean = false;
      var flagSpace:Boolean = false;
      var flagSign:Boolean = false;
      var fieldWidth:String = null;
      var precision:String = null;
      var capitalise:Boolean = false;
      var prepend:Boolean = false;
      var result:String = "";
      var length:int = format.length;
      for(var i:int = 0; i < length; i++)
      {
         c = format.charAt(i);
         if(c == "%")
         {
            pastFieldWidth = false;
            pastFlags = false;
            flagAlternateForm = false;
            flagZeroPad = false;
            flagLeftJustify = false;
            flagSpace = false;
            flagSign = false;
            fieldWidth = "";
            precision = "";
            c = format.charAt(++i);
            while(Boolean(c != "d") && Boolean(c != "i") && Boolean(c != "o") && Boolean(c != "u") && Boolean(c != "x") && Boolean(c != "X") && Boolean(c != "f") && Boolean(c != "F") && Boolean(c != "c") && Boolean(c != "s") && Boolean(c != "%"))
            {
               if(!pastFlags)
               {
                  if(Boolean(!flagAlternateForm) && Boolean(c == "#"))
                  {
                     flagAlternateForm = true;
                  }
                  else if(Boolean(!flagZeroPad) && Boolean(c == "0"))
                  {
                     flagZeroPad = true;
                  }
                  else if(Boolean(!flagLeftJustify) && Boolean(c == "-"))
                  {
                     flagLeftJustify = true;
                  }
                  else if(Boolean(!flagSpace) && Boolean(c == " "))
                  {
                     flagSpace = true;
                  }
                  else if(Boolean(!flagSign) && Boolean(c == "+"))
                  {
                     flagSign = true;
                  }
                  else
                  {
                     pastFlags = true;
                  }
               }
               if(Boolean(!pastFieldWidth) && Boolean(c == "."))
               {
                  pastFlags = true;
                  pastFieldWidth = true;
                  c = format.charAt(++i);
               }
               else
               {
                  if(pastFlags)
                  {
                     if(!pastFieldWidth)
                     {
                        fieldWidth = fieldWidth + c;
                     }
                     else
                     {
                        precision = precision + c;
                     }
                  }
                  c = format.charAt(++i);
               }
            }
            switch(c)
            {
               case "d":
               case "i":
                  next = args.shift();
                  str = String(Math.abs(int(next)));
                  if(precision != "")
                  {
                     str = leftPad(str,int(precision),"0");
                  }
                  if(int(next) < 0)
                  {
                     str = "-" + str;
                  }
                  else if(Boolean(flagSign) && Boolean(int(next) >= 0))
                  {
                     str = "+" + str;
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else if(Boolean(flagZeroPad) && Boolean(precision == ""))
                     {
                        str = leftPad(str,int(fieldWidth),"0");
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "o":
                  next = args.shift();
                  str = uint(next).toString(8);
                  if(Boolean(flagAlternateForm) && Boolean(str != "0"))
                  {
                     str = "0" + str;
                  }
                  if(precision != "")
                  {
                     str = leftPad(str,int(precision),"0");
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else if(Boolean(flagZeroPad) && Boolean(precision == ""))
                     {
                        str = leftPad(str,int(fieldWidth),"0");
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "u":
                  next = args.shift();
                  str = uint(next).toString(10);
                  if(precision != "")
                  {
                     str = leftPad(str,int(precision),"0");
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else if(Boolean(flagZeroPad) && Boolean(precision == ""))
                     {
                        str = leftPad(str,int(fieldWidth),"0");
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "X":
                  capitalise = true;
               case "x":
                  next = args.shift();
                  str = uint(next).toString(16);
                  if(precision != "")
                  {
                     str = leftPad(str,int(precision),"0");
                  }
                  prepend = Boolean(flagAlternateForm) && Boolean(uint(next) != 0);
                  if(Boolean(fieldWidth != "") && Boolean(!flagLeftJustify) && Boolean(flagZeroPad) && Boolean(precision == ""))
                  {
                     str = leftPad(str,!!prepend?int(int(fieldWidth) - 2):int(int(fieldWidth)),"0");
                  }
                  if(prepend)
                  {
                     str = "0x" + str;
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  if(capitalise)
                  {
                     str = str.toUpperCase();
                  }
                  result = result + str;
                  break;
               case "f":
               case "F":
                  next = args.shift();
                  str = Math.abs(Number(next)).toFixed(precision != ""?Number(precision):6);
                  if(Number(next) < 0)
                  {
                     str = "-" + str;
                  }
                  else if(Boolean(flagSign) && Boolean(int(next) >= 0))
                  {
                     str = "+" + str;
                  }
                  if(Boolean(flagAlternateForm) && Boolean(str.indexOf(".") == -1))
                  {
                     str = str + ".";
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else if(Boolean(flagZeroPad) && Boolean(precision == ""))
                     {
                        str = leftPad(str,int(fieldWidth),"0");
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "c":
                  next = args.shift();
                  str = String.fromCharCode(int(next));
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "s":
                  next = args.shift();
                  str = String(next);
                  if(precision != "")
                  {
                     str = str.substring(0,int(precision));
                  }
                  if(fieldWidth != "")
                  {
                     if(flagLeftJustify)
                     {
                        str = rightPad(str,int(fieldWidth));
                     }
                     else
                     {
                        str = leftPad(str,int(fieldWidth));
                     }
                  }
                  result = result + str;
                  break;
               case "%":
                  result = result + "%";
            }
         }
         else
         {
            result = result + c;
         }
      }
      return result;
   }
}

function leftPad(source:String, targetLength:int, padChar:String = " "):String
{
   var padding:String = null;
   if(source.length < targetLength)
   {
      padding = "";
      while(padding.length + source.length < targetLength)
      {
         padding = padding + padChar;
      }
      return padding + source;
   }
   return source;
}
function rightPad(source:String, targetLength:int, padChar:String = " "):String
{
   while(source.length < targetLength)
   {
      source = source + padChar;
   }
   return source;
}