package org.alivepdf.images.gif.decoder
{
   import flash.geom.Rectangle;
   import flash.utils.ByteArray;
   import flash.display.BitmapData;
   import org.alivepdf.images.gif.frames.GIFFrame;
   import org.alivepdf.images.gif.errors.FileTypeError;
   
   public class GIFDecoder
   {
      
      private static var STATUS_OK:int = 0;
      
      private static var STATUS_FORMAT_ERROR:int = 1;
      
      private static var STATUS_OPEN_ERROR:int = 2;
      
      private static var frameRect:Rectangle = new Rectangle();
      
      private static var MaxStackSize:int = 4096;
       
      private var inStream:ByteArray;
      
      private var status:int;
      
      private var width:int;
      
      private var height:int;
      
      private var gctFlag:Boolean;
      
      private var gctSize:int;
      
      private var loopCount:int = 1;
      
      private var gct:Array;
      
      private var lct:Array;
      
      private var act:Array;
      
      private var bgIndex:int;
      
      private var bgColor:int;
      
      private var lastBgColor:int;
      
      private var pixelAspect:int;
      
      private var lctFlag:Boolean;
      
      private var interlace:Boolean;
      
      private var lctSize:int;
      
      private var ix:int;
      
      private var iy:int;
      
      private var iw:int;
      
      private var ih:int;
      
      private var lastRect:Rectangle;
      
      private var image:BitmapData;
      
      private var bitmap:BitmapData;
      
      private var lastImage:BitmapData;
      
      private var block:ByteArray;
      
      private var blockSize:int = 0;
      
      private var dispose:int = 0;
      
      private var lastDispose:int = 0;
      
      private var transparency:Boolean = false;
      
      private var delay:int = 0;
      
      private var transIndex:int;
      
      private var prefix:Array;
      
      private var suffix:Array;
      
      private var pixelStack:Array;
      
      private var pixels:Array;
      
      private var frames:Array;
      
      private var frameCount:int;
      
      public function GIFDecoder()
      {
         super();
         this.block = new ByteArray();
      }
      
      public function get disposeValue() : int
      {
         return this.dispose;
      }
      
      public function getDelay(n:int) : int
      {
         this.delay = -1;
         if(Boolean(n >= 0) && Boolean(n < this.frameCount))
         {
            this.delay = this.frames[n].delay;
         }
         return this.delay;
      }
      
      public function getFrameCount() : int
      {
         return this.frameCount;
      }
      
      public function getImage() : GIFFrame
      {
         return this.getFrame(0);
      }
      
      public function getLoopCount() : int
      {
         return this.loopCount;
      }
      
      private function getPixels(bitmap:BitmapData) : Array
      {
         var color:int = 0;
         var tw:int = 0;
         var pixels:Array = new Array(4 * this.image.width * this.image.height);
         var count:int = 0;
         var lngWidth:int = this.image.width;
         var lngHeight:int = this.image.height;
         for(var th:int = 0; th < lngHeight; th++)
         {
            for(tw = 0; tw < lngWidth; tw++)
            {
               color = bitmap.getPixel(th,tw);
               pixels[count++] = (color & 16711680) >> 16;
               pixels[count++] = (color & 65280) >> 8;
               pixels[count++] = color & 255;
            }
         }
         return pixels;
      }
      
      private function setPixels(pixels:Array) : void
      {
         var color:int = 0;
         var tw:int = 0;
         var count:int = 0;
         pixels.position = 0;
         var lngWidth:int = this.image.width;
         var lngHeight:int = this.image.height;
         this.bitmap.lock();
         for(var th:int = 0; th < lngHeight; th++)
         {
            for(tw = 0; tw < lngWidth; tw++)
            {
               color = pixels[int(count++)];
               this.bitmap.setPixel32(tw,th,color);
            }
         }
         this.bitmap.unlock();
      }
      
      private function transferPixels() : void
      {
         var n:int = 0;
         var prev:Array = null;
         var c:Number = NaN;
         var line:int = 0;
         var k:int = 0;
         var dx:int = 0;
         var dlim:int = 0;
         var sx:int = 0;
         var index:int = 0;
         var tmp:int = 0;
         var dest:Array = this.getPixels(this.bitmap);
         if(this.lastDispose > 0)
         {
            if(this.lastDispose == 3)
            {
               n = this.frameCount - 2;
               this.lastImage = n > 0?this.getFrame(n - 1).bitmapData:null;
            }
            if(this.lastImage != null)
            {
               prev = this.getPixels(this.lastImage);
               dest = prev.slice();
               if(this.lastDispose == 2)
               {
                  c = !!this.transparency?Number(0):Number(this.lastBgColor);
                  this.image.fillRect(this.lastRect,c);
               }
            }
         }
         var pass:int = 1;
         var inc:int = 8;
         var iline:int = 0;
         for(var i:int = 0; i < this.ih; i++)
         {
            line = i;
            if(this.interlace)
            {
               if(iline >= this.ih)
               {
                  pass++;
                  switch(pass)
                  {
                     case 2:
                        iline = 4;
                        break;
                     case 3:
                        iline = 2;
                        inc = 4;
                        break;
                     case 4:
                        iline = 1;
                        inc = 2;
                  }
               }
               line = iline;
               iline = iline + inc;
            }
            line = line + this.iy;
            if(line < this.height)
            {
               k = line * this.width;
               dx = k + this.ix;
               dlim = dx + this.iw;
               if(k + this.width < dlim)
               {
                  dlim = k + this.width;
               }
               sx = i * this.iw;
               while(dx < dlim)
               {
                  index = this.pixels[sx++] & 255;
                  tmp = this.act[index];
                  if(tmp != 0)
                  {
                     dest[dx] = tmp;
                  }
                  dx++;
               }
            }
         }
         this.setPixels(dest);
      }
      
      public function getFrame(n:int) : GIFFrame
      {
         var im:GIFFrame = null;
         if(Boolean(n >= 0) && Boolean(n < this.frameCount))
         {
            im = this.frames[n];
            return im;
         }
         throw new RangeError("Wrong frame number passed");
      }
      
      public function getFrameSize() : Rectangle
      {
         var rect:Rectangle = GIFDecoder.frameRect;
         rect.x = rect.y = 0;
         rect.width = this.width;
         rect.height = this.height;
         return rect;
      }
      
      public function read(inStream:ByteArray) : int
      {
         this.init();
         if(inStream != null)
         {
            this.inStream = inStream;
            this.readHeader();
            if(!this.hasError())
            {
               this.readContents();
               if(this.frameCount < 0)
               {
                  this.status = STATUS_FORMAT_ERROR;
               }
            }
         }
         else
         {
            this.status = STATUS_OPEN_ERROR;
         }
         return this.status;
      }
      
      private function decodeImageData() : void
      {
         var available:int = 0;
         var clear:int = 0;
         var code_mask:int = 0;
         var code_size:int = 0;
         var end_of_information:int = 0;
         var in_code:int = 0;
         var old_code:int = 0;
         var bits:int = 0;
         var code:int = 0;
         var count:int = 0;
         var i:int = 0;
         var datum:int = 0;
         var data_size:int = 0;
         var first:int = 0;
         var top:int = 0;
         var bi:int = 0;
         var pi:int = 0;
         var NullCode:int = -1;
         var npix:int = this.iw * this.ih;
         if(Boolean(this.pixels == null) || Boolean(this.pixels.length < npix))
         {
            this.pixels = new Array(npix);
         }
         if(this.prefix == null)
         {
            this.prefix = new Array(MaxStackSize);
         }
         if(this.suffix == null)
         {
            this.suffix = new Array(MaxStackSize);
         }
         if(this.pixelStack == null)
         {
            this.pixelStack = new Array(MaxStackSize + 1);
         }
         data_size = this.readSingleByte();
         clear = 1 << data_size;
         end_of_information = clear + 1;
         available = clear + 2;
         old_code = NullCode;
         code_size = data_size + 1;
         code_mask = (1 << code_size) - 1;
         for(code = 0; code < clear; code++)
         {
            this.prefix[int(code)] = 0;
            this.suffix[int(code)] = code;
         }
         datum = bits = count = first = top = pi = bi = 0;
         for(i = 0; i < npix; )
         {
            if(top == 0)
            {
               if(bits < code_size)
               {
                  if(count == 0)
                  {
                     count = this.readBlock();
                     if(count <= 0)
                     {
                        break;
                     }
                     bi = 0;
                  }
                  datum = datum + ((int(this.block[int(bi)]) & 255) << bits);
                  bits = bits + 8;
                  bi++;
                  count--;
                  continue;
               }
               code = datum & code_mask;
               datum = datum >> code_size;
               bits = bits - code_size;
               if(Boolean(code > available) || Boolean(code == end_of_information))
               {
                  break;
               }
               if(code == clear)
               {
                  code_size = data_size + 1;
                  code_mask = (1 << code_size) - 1;
                  available = clear + 2;
                  old_code = NullCode;
                  continue;
               }
               if(old_code == NullCode)
               {
                  this.pixelStack[int(top++)] = this.suffix[int(code)];
                  old_code = code;
                  first = code;
                  continue;
               }
               in_code = code;
               if(code == available)
               {
                  this.pixelStack[int(top++)] = first;
                  code = old_code;
               }
               while(code > clear)
               {
                  this.pixelStack[int(top++)] = this.suffix[int(code)];
                  code = this.prefix[int(code)];
               }
               first = this.suffix[int(code)] & 255;
               if(available >= MaxStackSize)
               {
                  break;
               }
               this.pixelStack[int(top++)] = first;
               this.prefix[int(available)] = old_code;
               this.suffix[int(available)] = first;
               available++;
               if(Boolean((available & code_mask) == 0) && Boolean(available < MaxStackSize))
               {
                  code_size++;
                  code_mask = code_mask + available;
               }
               old_code = in_code;
            }
            top--;
            this.pixels[int(pi++)] = this.pixelStack[int(top)];
            i++;
         }
         for(i = pi; i < npix; i++)
         {
            this.pixels[int(i)] = 0;
         }
      }
      
      private function hasError() : Boolean
      {
         return this.status != STATUS_OK;
      }
      
      private function init() : void
      {
         this.status = STATUS_OK;
         this.frameCount = 0;
         this.frames = new Array();
         this.gct = null;
         this.lct = null;
      }
      
      private function readSingleByte() : int
      {
         var curByte:int = 0;
         try
         {
            curByte = this.inStream.readUnsignedByte();
         }
         catch(e:Error)
         {
            status = STATUS_FORMAT_ERROR;
         }
         return curByte;
      }
      
      private function readBlock() : int
      {
         var count:int = 0;
         this.blockSize = this.readSingleByte();
         var n:int = 0;
         if(this.blockSize > 0)
         {
            try
            {
               count = 0;
               while(n < this.blockSize)
               {
                  this.inStream.readBytes(this.block,n,this.blockSize - n);
                  if(this.blockSize - n == -1)
                  {
                     break;
                  }
                  n = n + (this.blockSize - n);
               }
            }
            catch(e:Error)
            {
            }
            if(n < this.blockSize)
            {
               this.status = STATUS_FORMAT_ERROR;
            }
         }
         return n;
      }
      
      private function readColorTable(ncolors:int) : Array
      {
         var i:int = 0;
         var j:int = 0;
         var r:int = 0;
         var g:int = 0;
         var b:int = 0;
         var nbytes:int = 3 * ncolors;
         var tab:Array = null;
         var c:ByteArray = new ByteArray();
         var n:int = 0;
         try
         {
            this.inStream.readBytes(c,0,nbytes);
            n = nbytes;
         }
         catch(e:Error)
         {
         }
         if(n < nbytes)
         {
            this.status = STATUS_FORMAT_ERROR;
         }
         else
         {
            tab = new Array(256);
            i = 0;
            j = 0;
            while(i < ncolors)
            {
               r = c[j++] & 255;
               g = c[j++] & 255;
               b = c[j++] & 255;
               tab[i++] = 4278190080 | r << 16 | g << 8 | b;
            }
         }
         return tab;
      }
      
      private function readContents() : void
      {
         var code:int = 0;
         var app:String = null;
         var i:int = 0;
         var done:Boolean = false;
         while(!(Boolean(done) || Boolean(this.hasError())))
         {
            code = this.readSingleByte();
            switch(code)
            {
               case 44:
                  this.readImage();
                  continue;
               case 33:
                  code = this.readSingleByte();
                  switch(code)
                  {
                     case 249:
                        this.readGraphicControlExt();
                        break;
                     case 255:
                        this.readBlock();
                        app = "";
                        for(i = 0; i < 11; i++)
                        {
                           app = app + this.block[int(i)];
                        }
                        if(app == "NETSCAPE2.0")
                        {
                           this.readNetscapeExt();
                        }
                        else
                        {
                           this.skip();
                        }
                        break;
                     default:
                        this.skip();
                  }
                  continue;
               case 59:
                  done = true;
                  continue;
               case 0:
                  continue;
               default:
                  this.status = STATUS_FORMAT_ERROR;
                  continue;
            }
         }
      }
      
      private function readGraphicControlExt() : void
      {
         this.readSingleByte();
         var packed:int = this.readSingleByte();
         this.dispose = (packed & 28) >> 2;
         if(this.dispose == 0)
         {
            this.dispose = 1;
         }
         this.transparency = (packed & 1) != 0;
         this.delay = this.readShort() * 10;
         this.transIndex = this.readSingleByte();
         this.readSingleByte();
      }
      
      private function readHeader() : void
      {
         var id:String = "";
         for(var i:int = 0; i < 6; i++)
         {
            id = id + String.fromCharCode(this.readSingleByte());
         }
         if(id.indexOf("GIF") != 0)
         {
            this.status = STATUS_FORMAT_ERROR;
            throw new FileTypeError("Invalid file type");
         }
         this.readLSD();
         if(Boolean(this.gctFlag) && Boolean(!this.hasError()))
         {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
         }
      }
      
      private function readImage() : void
      {
         this.ix = this.readShort();
         this.iy = this.readShort();
         this.iw = this.readShort();
         this.ih = this.readShort();
         var packed:int = this.readSingleByte();
         this.lctFlag = (packed & 128) != 0;
         this.interlace = (packed & 64) != 0;
         this.lctSize = 2 << (packed & 7);
         if(this.lctFlag)
         {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
         }
         else
         {
            this.act = this.gct;
            if(this.bgIndex == this.transIndex)
            {
               this.bgColor = 0;
            }
         }
         var save:int = 0;
         if(this.transparency)
         {
            save = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
         }
         if(this.act == null)
         {
            this.status = STATUS_FORMAT_ERROR;
         }
         if(this.hasError())
         {
            return;
         }
         this.decodeImageData();
         this.skip();
         if(this.hasError())
         {
            return;
         }
         this.frameCount++;
         this.bitmap = new BitmapData(this.width,this.height,false);
         this.image = this.bitmap;
         this.transferPixels();
         this.frames.push(new GIFFrame(this.bitmap,this.delay));
         if(this.transparency)
         {
            this.act[this.transIndex] = save;
         }
         this.resetFrame();
      }
      
      private function readLSD() : void
      {
         this.width = this.readShort();
         this.height = this.readShort();
         var packed:int = this.readSingleByte();
         this.gctFlag = (packed & 128) != 0;
         this.gctSize = 2 << (packed & 7);
         this.bgIndex = this.readSingleByte();
         this.pixelAspect = this.readSingleByte();
      }
      
      private function readNetscapeExt() : void
      {
         var b1:int = 0;
         var b2:int = 0;
         do
         {
            this.readBlock();
            if(this.block[0] == 1)
            {
               b1 = this.block[1] & 255;
               b2 = this.block[2] & 255;
               this.loopCount = b2 << 8 | b1;
            }
         }
         while(Boolean(this.blockSize > 0) && Boolean(!this.hasError()));
         
      }
      
      private function readShort() : int
      {
         return this.readSingleByte() | this.readSingleByte() << 8;
      }
      
      private function resetFrame() : void
      {
         this.lastDispose = this.dispose;
         this.lastRect = new Rectangle(this.ix,this.iy,this.iw,this.ih);
         this.lastImage = this.image;
         this.lastBgColor = this.bgColor;
         var transparency:Boolean = false;
         var delay:int = 0;
         this.lct = null;
      }
      
      private function skip() : void
      {
         do
         {
            this.readBlock();
         }
         while(Boolean(this.blockSize > 0) && Boolean(!this.hasError()));
         
      }
   }
}
