package org.alivepdf.encoding
{
   import flash.filters.ColorMatrixFilter;
   import flash.geom.Point;
   import flash.utils.ByteArray;
   import flash.display.BitmapData;
   
   public final class JPEGEncoder
   {
      
      private static const ZigZagList:org.alivepdf.encoding.IntList = IntList.create([0,1,5,6,14,15,27,28,2,4,7,13,16,26,29,42,3,8,12,17,25,30,41,43,9,11,18,24,31,40,44,53,10,19,23,32,39,45,52,54,20,22,33,38,46,51,55,60,21,34,37,47,50,56,59,61,35,36,48,49,57,58,62,63]);
      
      private static const YQTList:org.alivepdf.encoding.IntList = IntList.create([16,11,10,16,24,40,51,61,12,12,14,19,26,58,60,55,14,13,16,24,40,57,69,56,14,17,22,29,51,87,80,62,18,22,37,56,68,109,103,77,24,35,55,64,81,104,113,92,49,64,78,87,103,121,120,101,72,92,95,98,112,100,103,99]);
      
      private static const UVQTList:org.alivepdf.encoding.IntList = IntList.create([17,18,24,47,99,99,99,99,18,21,26,66,99,99,99,99,24,26,56,99,99,99,99,99,47,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99]);
      
      private static const aasf:Array = [1,1.387039845,1.306562965,1.175875602,1,0.785694958,0.5411961,0.275899379];
      
      private static const aanscalesList:org.alivepdf.encoding.IntList = IntList.create([16384,22725,21407,19266,16384,12873,8867,4520,22725,31521,29692,26722,22725,17855,12299,6270,21407,29692,27969,25172,21407,16819,11585,5906,19266,26722,25172,22654,19266,15137,10426,5315,16384,22725,21407,19266,16384,12873,8867,4520,12873,17855,16819,15137,12873,10114,6967,3552,8867,12299,11585,10426,8867,6967,4799,2446,4520,6270,5906,5315,4520,3552,2446,1247]);
      
      private static const std_dc_luminance_nrcodesList:org.alivepdf.encoding.IntList = IntList.create([0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0]);
      
      private static const std_dc_luminance_valuesList:org.alivepdf.encoding.IntList = IntList.create([0,1,2,3,4,5,6,7,8,9,10,11]);
      
      private static const std_ac_luminance_nrcodesList:org.alivepdf.encoding.IntList = IntList.create([0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125]);
      
      private static const std_ac_luminance_valuesList:org.alivepdf.encoding.IntList = IntList.create([1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250]);
      
      private static const std_dc_chrominance_nrcodesList:org.alivepdf.encoding.IntList = IntList.create([0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0]);
      
      private static const std_dc_chrominance_valuesList:org.alivepdf.encoding.IntList = IntList.create([0,1,2,3,4,5,6,7,8,9,10,11]);
      
      private static const std_ac_chrominance_nrcodesList:org.alivepdf.encoding.IntList = IntList.create([0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119]);
      
      private static const std_ac_chrominance_valuesList:org.alivepdf.encoding.IntList = IntList.create([0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250]);
      
      private static const fltrRGB2YUV:ColorMatrixFilter = new ColorMatrixFilter([0.299,0.587,0.114,0,0,-0.16874,-0.33126,0.5,0,128,0.5,-0.41869,-0.08131,0,128,0,0,0,1,0]);
      
      private static const orgn:Point = new Point();
       
      private const YTable:Array = new Array(64);
      
      private const UVTable:Array = new Array(64);
      
      private const fdtbl_YList:org.alivepdf.encoding.IntList = IntList.create(new Array(64));
      
      private const fdtbl_UVList:org.alivepdf.encoding.IntList = IntList.create(new Array(64));
      
      private var YDC_HT:Array;
      
      private var UVDC_HT:Array;
      
      private var YAC_HT:Array;
      
      private var UVAC_HT:Array;
      
      private const bitcode:Array = new Array(65535);
      
      private const category:Array = new Array(65535);
      
      private var byteout:ByteArray;
      
      private var bytenew:int = 0;
      
      private var bytepos:int = 7;
      
      private const DU:Array = new Array(64);
      
      private const YDUBlock:org.alivepdf.encoding.IntBlock = IntBlock.create8_8(new Array(64));
      
      private const UDUBlock:org.alivepdf.encoding.IntBlock = IntBlock.create8_8(new Array(64));
      
      private const VDUBlock:org.alivepdf.encoding.IntBlock = IntBlock.create8_8(new Array(64));
      
      public function JPEGEncoder(quality:Number = 50)
      {
         super();
         if(quality <= 0)
         {
            quality = 1;
         }
         if(quality > 100)
         {
            quality = 100;
         }
         var sf:int = 0;
         if(quality < 50)
         {
            sf = 5000 / quality;
         }
         else
         {
            sf = 200 - quality * 2;
         }
         this.initHuffmanTbl();
         this.initCategoryNumber();
         this.initQuantTables(sf);
      }
      
      private function initQuantTables(sf:int) : void
      {
         var i:int = 0;
         var t:int = 0;
         var ZigZag:org.alivepdf.encoding.IntList = ZigZagList;
         var YQT:org.alivepdf.encoding.IntList = YQTList;
         for(i = 0; i < 64; i++)
         {
            t = (YQTList.data * sf + 50) / 100;
            YQT = YQT.next;
            if(t < 1)
            {
               t = 1;
            }
            else if(t > 255)
            {
               t = 255;
            }
            this.YTable[ZigZag.data] = t;
            ZigZag = ZigZag.next;
         }
         ZigZag = ZigZagList;
         var UVQT:org.alivepdf.encoding.IntList = UVQTList;
         for(i = 0; i < 64; i++)
         {
            t = (UVQT.data * sf + 50) / 100;
            UVQT = UVQT.next;
            if(t < 1)
            {
               t = 1;
            }
            else if(t > 255)
            {
               t = 255;
            }
            this.UVTable[ZigZag.data] = t;
            ZigZag = ZigZag.next;
         }
         ZigZag = ZigZagList;
         var fdtbl_Y:org.alivepdf.encoding.IntList = this.fdtbl_YList;
         var fdtbl_UV:org.alivepdf.encoding.IntList = this.fdtbl_UVList;
         for(i = 0; i < 64; i++)
         {
            fdtbl_Y.data = this.YTable[ZigZag.data] << 3;
            fdtbl_UV.data = this.UVTable[ZigZag.data] << 3;
            ZigZag = ZigZag.next;
            fdtbl_Y = fdtbl_Y.next;
            fdtbl_UV = fdtbl_UV.next;
         }
      }
      
      private function computeHuffmanTbl(nrcodesList:org.alivepdf.encoding.IntList, std_tableList:org.alivepdf.encoding.IntList) : Array
      {
         var nr:int = 0;
         var j:int = 0;
         var codevalue:int = 0;
         var nrcodes:org.alivepdf.encoding.IntList = nrcodesList.next;
         var std_table:org.alivepdf.encoding.IntList = std_tableList;
         var HT:Array = new Array(251);
         for(var k:int = 1; k <= 16; k++)
         {
            nr = nrcodes.data;
            for(j = 1; j <= nr; j++)
            {
               HT[std_table.data] = new BitString(codevalue,k);
               std_table = std_table.next;
               codevalue++;
            }
            nrcodes = nrcodes.next;
            codevalue = codevalue << 1;
         }
         return HT;
      }
      
      private function initHuffmanTbl() : void
      {
         this.YDC_HT = this.computeHuffmanTbl(std_dc_luminance_nrcodesList,std_dc_luminance_valuesList);
         this.UVDC_HT = this.computeHuffmanTbl(std_dc_chrominance_nrcodesList,std_dc_chrominance_valuesList);
         this.YAC_HT = this.computeHuffmanTbl(std_ac_luminance_nrcodesList,std_ac_luminance_valuesList);
         this.UVAC_HT = this.computeHuffmanTbl(std_ac_chrominance_nrcodesList,std_ac_chrominance_valuesList);
      }
      
      private function initCategoryNumber() : void
      {
         var nr:int = 0;
         var n:int = 0;
         var nrlower:int = 1;
         var nrupper:int = 2;
         for(var cat:int = 1; cat <= 15; cat++)
         {
            for(nr = nrlower; nr < nrupper; nr++)
            {
               n = 32767 + nr;
               this.category[n] = cat;
               this.bitcode[n] = new BitString(nr,cat);
            }
            for(nr = -(nrupper - 1); nr <= -nrlower; nr++)
            {
               n = 32767 + nr;
               this.category[n] = cat;
               this.bitcode[n] = new BitString(nrupper - 1 + nr,cat);
            }
            nrlower = nrlower << 1;
            nrupper = nrupper << 1;
         }
      }
      
      private function writeBits(bs:BitString) : void
      {
         var value:int = bs.val;
         var posval:int = bs.len - 1;
         while(posval >= 0)
         {
            if(value & 1 << posval)
            {
               this.bytenew = this.bytenew | 1 << this.bytepos;
            }
            posval--;
            this.bytepos--;
            if(this.bytepos < 0)
            {
               if(this.bytenew == 255)
               {
                  this.writeByte(255);
                  this.writeByte(0);
               }
               else
               {
                  this.writeByte(this.bytenew);
               }
               this.bytepos = 7;
               this.bytenew = 0;
            }
         }
      }
      
      private function writeByte(value:int) : void
      {
         this.byteout.writeByte(value);
      }
      
      private function writeWord(value:int) : void
      {
         this.writeByte(value >> 8);
         this.writeByte(value);
      }
      
      private function fDCTQuant(data:org.alivepdf.encoding.IntBlock, fdtbl:org.alivepdf.encoding.IntList) : org.alivepdf.encoding.IntBlock
      {
         var tmp0:int = 0;
         var tmp1:int = 0;
         var tmp2:int = 0;
         var tmp3:int = 0;
         var tmp4:int = 0;
         var tmp5:int = 0;
         var tmp6:int = 0;
         var tmp7:int = 0;
         var tmp10:int = 0;
         var tmp11:int = 0;
         var tmp12:int = 0;
         var tmp13:int = 0;
         var d0:int = 0;
         var d1:int = 0;
         var d2:int = 0;
         var d3:int = 0;
         var d4:int = 0;
         var d5:int = 0;
         var d6:int = 0;
         var d7:int = 0;
         var z1:int = 0;
         var z2:int = 0;
         var z3:int = 0;
         var z4:int = 0;
         var z5:int = 0;
         var i:int = 0;
         var row:org.alivepdf.encoding.IntBlock = null;
         var col:org.alivepdf.encoding.IntBlock = null;
         var dataOff:org.alivepdf.encoding.IntBlock = null;
         var qval:int = 0;
         var temp:int = 0;
         row = data;
         for(i = 0; i < 8; i++)
         {
            dataOff = row;
            d0 = dataOff.data;
            dataOff = dataOff.next;
            d1 = dataOff.data;
            dataOff = dataOff.next;
            d2 = dataOff.data;
            dataOff = dataOff.next;
            d3 = dataOff.data;
            dataOff = dataOff.next;
            d4 = dataOff.data;
            dataOff = dataOff.next;
            d5 = dataOff.data;
            dataOff = dataOff.next;
            d6 = dataOff.data;
            dataOff = dataOff.next;
            d7 = dataOff.data;
            tmp0 = d0 + d7;
            tmp7 = d0 - d7;
            tmp1 = d1 + d6;
            tmp6 = d1 - d6;
            tmp2 = d2 + d5;
            tmp5 = d2 - d5;
            tmp3 = d3 + d4;
            tmp4 = d3 - d4;
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            z1 = (tmp12 + tmp13) * 4433;
            dataOff = row;
            dataOff.data = tmp10 + tmp11 << 2;
            dataOff = dataOff.next.next;
            dataOff.data = z1 + tmp13 * 6270 + 1024 >> 11;
            dataOff = dataOff.next.next;
            dataOff.data = tmp10 - tmp11 << 2;
            dataOff = dataOff.next.next;
            dataOff.data = z1 - tmp12 * 15137 + 1024 >> 11;
            z1 = tmp4 + tmp7;
            z2 = tmp5 + tmp6;
            z3 = tmp4 + tmp6;
            z4 = tmp5 + tmp7;
            z5 = (z3 + z4) * 9633;
            tmp4 = tmp4 * 2446;
            tmp5 = tmp5 * 16819;
            tmp6 = tmp6 * 25172;
            tmp7 = tmp7 * 12299;
            z1 = -z1 * 7373;
            z2 = -z2 * 20995;
            z3 = -z3 * 16069;
            z4 = -z4 * 3196;
            z3 = z3 + z5;
            z4 = z4 + z5;
            dataOff = row.next;
            dataOff.data = tmp7 + z1 + z4 + 1024 >> 11;
            dataOff = dataOff.next.next;
            dataOff.data = tmp6 + z2 + z3 + 1024 >> 11;
            dataOff = dataOff.next.next;
            dataOff.data = tmp5 + z2 + z4 + 1024 >> 11;
            dataOff = dataOff.next.next;
            dataOff.data = tmp4 + z1 + z3 + 1024 >> 11;
            row = row.down;
         }
         col = data;
         for(i = 0; i < 8; i++)
         {
            dataOff = col;
            d0 = dataOff.data;
            dataOff = dataOff.down;
            d1 = dataOff.data;
            dataOff = dataOff.down;
            d2 = dataOff.data;
            dataOff = dataOff.down;
            d3 = dataOff.data;
            dataOff = dataOff.down;
            d4 = dataOff.data;
            dataOff = dataOff.down;
            d5 = dataOff.data;
            dataOff = dataOff.down;
            d6 = dataOff.data;
            dataOff = dataOff.down;
            d7 = dataOff.data;
            tmp0 = d0 + d7;
            tmp7 = d0 - d7;
            tmp1 = d1 + d6;
            tmp6 = d1 - d6;
            tmp2 = d2 + d5;
            tmp5 = d2 - d5;
            tmp3 = d3 + d4;
            tmp4 = d3 - d4;
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            z1 = (tmp12 + tmp13) * 4433;
            dataOff = col;
            dataOff.data = tmp10 + tmp11 + 2 >> 2;
            dataOff = dataOff.down.down;
            dataOff.data = z1 + tmp13 * 6270 + 16384 >> 15;
            dataOff = dataOff.down.down;
            dataOff.data = tmp10 - tmp11 + 2 >> 2;
            dataOff = dataOff.down.down;
            dataOff.data = z1 - tmp12 * 15137 + 16384 >> 15;
            z1 = tmp4 + tmp7;
            z2 = tmp5 + tmp6;
            z3 = tmp4 + tmp6;
            z4 = tmp5 + tmp7;
            z5 = (z3 + z4) * 9633;
            tmp4 = tmp4 * 2446;
            tmp5 = tmp5 * 16819;
            tmp6 = tmp6 * 25172;
            tmp7 = tmp7 * 12299;
            z1 = -z1 * 7373;
            z2 = -z2 * 20995;
            z3 = -z3 * 16069;
            z4 = -z4 * 3196;
            z3 = z3 + z5;
            z4 = z4 + z5;
            dataOff = col.down;
            dataOff.data = tmp7 + z1 + z4 + 16384 >> 15;
            dataOff = dataOff.down.down;
            dataOff.data = tmp6 + z2 + z3 + 16384 >> 15;
            dataOff = dataOff.down.down;
            dataOff.data = tmp5 + z2 + z4 + 16384 >> 15;
            dataOff = dataOff.down.down;
            dataOff.data = tmp4 + z1 + z3 + 16384 >> 15;
            col = col.next;
         }
         dataOff = data;
         for(i = 0; i < 64; i++)
         {
            qval = fdtbl.data;
            fdtbl = fdtbl.next;
            temp = dataOff.data;
            if(temp < 0)
            {
               temp = -temp;
               temp = temp + (qval >> 1);
               if(temp >= qval)
               {
                  temp = temp / qval;
               }
               else
               {
                  temp = 0;
               }
               temp = -temp;
            }
            else
            {
               temp = temp + (qval >> 1);
               if(temp >= qval)
               {
                  temp = temp / qval;
               }
               else
               {
                  temp = 0;
               }
            }
            dataOff.data = temp;
            dataOff = dataOff.next;
         }
         return data;
      }
      
      private function writeAPP0() : void
      {
         this.writeWord(65504);
         this.writeWord(16);
         this.writeByte(74);
         this.writeByte(70);
         this.writeByte(73);
         this.writeByte(70);
         this.writeByte(0);
         this.writeByte(1);
         this.writeByte(1);
         this.writeByte(0);
         this.writeWord(1);
         this.writeWord(1);
         this.writeByte(0);
         this.writeByte(0);
      }
      
      private function writeSOF0(width:int, height:int) : void
      {
         this.writeWord(65472);
         this.writeWord(17);
         this.writeByte(8);
         this.writeWord(height);
         this.writeWord(width);
         this.writeByte(3);
         this.writeByte(1);
         this.writeByte(17);
         this.writeByte(0);
         this.writeByte(2);
         this.writeByte(17);
         this.writeByte(1);
         this.writeByte(3);
         this.writeByte(17);
         this.writeByte(1);
      }
      
      private function writeDQT() : void
      {
         var i:int = 0;
         this.writeWord(65499);
         this.writeWord(132);
         this.writeByte(0);
         for(i = 0; i < 64; i++)
         {
            this.writeByte(this.YTable[i]);
         }
         this.writeByte(1);
         for(i = 0; i < 64; i++)
         {
            this.writeByte(this.UVTable[i]);
         }
      }
      
      private function writeDHT() : void
      {
         var i:int = 0;
         this.writeWord(65476);
         this.writeWord(418);
         this.writeByte(0);
         var std_dc_luminance_nrcodes:org.alivepdf.encoding.IntList = std_dc_luminance_nrcodesList.next;
         for(i = 1; i <= 16; i++)
         {
            this.writeByte(std_dc_luminance_nrcodes.data);
            std_dc_luminance_nrcodes = std_dc_luminance_nrcodes.next;
         }
         var std_dc_luminance_values:org.alivepdf.encoding.IntList = std_dc_luminance_valuesList;
         for(i = 0; i <= 11; i++)
         {
            this.writeByte(std_dc_luminance_values.data);
            std_dc_luminance_values = std_dc_luminance_values.next;
         }
         this.writeByte(16);
         var std_ac_luminance_nrcodes:org.alivepdf.encoding.IntList = std_ac_luminance_nrcodesList.next;
         for(i = 1; i <= 16; i++)
         {
            this.writeByte(std_ac_luminance_nrcodes.data);
            std_ac_luminance_nrcodes = std_ac_luminance_nrcodes.next;
         }
         var std_ac_luminance_values:org.alivepdf.encoding.IntList = std_ac_luminance_valuesList;
         for(i = 0; i <= 161; i++)
         {
            this.writeByte(std_ac_luminance_values.data);
            std_ac_luminance_values = std_ac_luminance_values.next;
         }
         this.writeByte(1);
         var std_dc_chrominance_nrcodes:org.alivepdf.encoding.IntList = std_dc_chrominance_nrcodesList.next;
         for(i = 1; i <= 16; i++)
         {
            this.writeByte(std_dc_chrominance_nrcodes.data);
            std_dc_chrominance_nrcodes = std_dc_chrominance_nrcodes.next;
         }
         var std_dc_chrominance_values:org.alivepdf.encoding.IntList = std_dc_chrominance_valuesList;
         for(i = 0; i <= 11; i++)
         {
            this.writeByte(std_dc_chrominance_values.data);
            std_dc_chrominance_values = std_dc_chrominance_values.next;
         }
         this.writeByte(17);
         var std_ac_chrominance_nrcodes:org.alivepdf.encoding.IntList = std_ac_chrominance_nrcodesList.next;
         for(i = 1; i <= 16; i++)
         {
            this.writeByte(std_ac_chrominance_nrcodes.data);
            std_ac_chrominance_nrcodes = std_ac_chrominance_nrcodes.next;
         }
         var std_ac_chrominance_values:org.alivepdf.encoding.IntList = std_ac_chrominance_valuesList;
         for(i = 0; i <= 161; i++)
         {
            this.writeByte(std_ac_chrominance_values.data);
            std_ac_chrominance_values = std_ac_chrominance_values.next;
         }
      }
      
      private function writeSOS() : void
      {
         this.writeWord(65498);
         this.writeWord(12);
         this.writeByte(3);
         this.writeByte(1);
         this.writeByte(0);
         this.writeByte(2);
         this.writeByte(17);
         this.writeByte(3);
         this.writeByte(17);
         this.writeByte(0);
         this.writeByte(63);
         this.writeByte(0);
      }
      
      private function processDU(CDU:org.alivepdf.encoding.IntBlock, fdtbl:org.alivepdf.encoding.IntList, DC:int, HTDC:Array, HTAC:Array) : int
      {
         var i:int = 0;
         var startpos:int = 0;
         var nrzeroes:int = 0;
         var n:int = 0;
         var nrmarker:int = 0;
         var EOB:BitString = HTAC[0];
         var M16zeroes:BitString = HTAC[240];
         var DU_DCT:org.alivepdf.encoding.IntBlock = this.fDCTQuant(CDU,fdtbl);
         var ZigZag:org.alivepdf.encoding.IntList = ZigZagList;
         for(i = 0; i < 64; i++)
         {
            this.DU[ZigZag.data] = DU_DCT.data;
            ZigZag = ZigZag.next;
            DU_DCT = DU_DCT.next;
         }
         var Diff:int = this.DU[0] - DC;
         DC = this.DU[0];
         if(Diff == 0)
         {
            this.writeBits(HTDC[0]);
         }
         else
         {
            i = 32767 + Diff;
            this.writeBits(HTDC[this.category[i] >> 0]);
            this.writeBits(this.bitcode[i]);
         }
         var end0pos:int = 63;
         while(Boolean(end0pos > 0) && Boolean(this.DU[end0pos] == 0))
         {
            end0pos--;
         }
         if(end0pos == 0)
         {
            this.writeBits(EOB);
            return DC;
         }
         i = 1;
         while(i <= end0pos)
         {
            startpos = i;
            while(Boolean(this.DU[i] == 0) && Boolean(i <= end0pos))
            {
               i++;
            }
            nrzeroes = i - startpos;
            if(nrzeroes >= 16)
            {
               n = nrzeroes / 16;
               for(nrmarker = 1; nrmarker <= n; nrmarker++)
               {
                  this.writeBits(M16zeroes);
               }
               nrzeroes = nrzeroes & 15;
            }
            n = 32767 + this.DU[i];
            this.writeBits(HTAC[(nrzeroes << 4) + this.category[n] >> 0]);
            this.writeBits(this.bitcode[n]);
            i++;
         }
         if(end0pos != 63)
         {
            this.writeBits(EOB);
         }
         return DC;
      }
      
      private function RGB2YUV(img:BitmapData, xpos:int, ypos:int) : void
      {
         var x:int = 0;
         var P:int = 0;
         var R:int = 0;
         var G:int = 0;
         var B:int = 0;
         var YDU:org.alivepdf.encoding.IntBlock = this.YDUBlock;
         var UDU:org.alivepdf.encoding.IntBlock = this.UDUBlock;
         var VDU:org.alivepdf.encoding.IntBlock = this.VDUBlock;
         for(var y:int = 0; y < 8; y++)
         {
            for(x = 0; x < 8; x++)
            {
               P = img.getPixel(xpos + x,ypos + y);
               R = P >> 16 & 255;
               G = P >> 8 & 255;
               B = P & 255;
               YDU.data = R - 128;
               UDU.data = G - 128;
               VDU.data = B - 128;
               YDU = YDU.next;
               UDU = UDU.next;
               VDU = VDU.next;
            }
         }
      }
      
      public function encode(image:BitmapData) : ByteArray
      {
         var xpos:int = 0;
         var img:BitmapData = image.clone();
         img.applyFilter(img,img.rect,orgn,fltrRGB2YUV);
         var height:int = img.height;
         var width:int = img.width;
         this.byteout = new ByteArray();
         this.bytenew = 0;
         this.bytepos = 7;
         this.writeWord(65496);
         this.writeAPP0();
         this.writeDQT();
         this.writeSOF0(width,height);
         this.writeDHT();
         this.writeSOS();
         var DCY:int = 0;
         var DCU:int = 0;
         var DCV:int = 0;
         for(var ypos:int = 0; ypos < height; ypos = ypos + 8)
         {
            for(xpos = 0; xpos < width; xpos = xpos + 8)
            {
               this.RGB2YUV(img,xpos,ypos);
               DCY = this.processDU(this.YDUBlock,this.fdtbl_YList,DCY,this.YDC_HT,this.YAC_HT);
               DCU = this.processDU(this.UDUBlock,this.fdtbl_UVList,DCU,this.UVDC_HT,this.UVAC_HT);
               DCV = this.processDU(this.VDUBlock,this.fdtbl_UVList,DCV,this.UVDC_HT,this.UVAC_HT);
            }
         }
         img.dispose();
         if(this.bytepos >= 0)
         {
            this.writeBits(new BitString((1 << this.bytepos + 1) - 1,this.bytepos + 1));
         }
         this.writeWord(65497);
         return this.byteout;
      }
   }
}
