package mx.effects.effectClasses
{
   import mx.core.mx_internal;
   import flash.events.Event;
   import mx.events.FlexEvent;
   import flash.events.MouseEvent;
   import mx.effects.EffectManager;
   
   use namespace mx_internal;
   
   public class ZoomInstance extends TweenEffectInstance
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var origScaleX:Number;
      
      private var origScaleY:Number;
      
      private var origX:Number;
      
      private var origY:Number;
      
      private var newX:Number;
      
      private var newY:Number;
      
      private var scaledOriginX:Number;
      
      private var scaledOriginY:Number;
      
      private var origPercentWidth:Number;
      
      private var origPercentHeight:Number;
      
      private var _mouseHasMoved:Boolean = false;
      
      private var show:Boolean = true;
      
      public var captureRollEvents:Boolean;
      
      public var originX:Number;
      
      public var originY:Number;
      
      public var zoomHeightFrom:Number;
      
      public var zoomHeightTo:Number;
      
      public var zoomWidthFrom:Number;
      
      public var zoomWidthTo:Number;
      
      public function ZoomInstance(target:Object)
      {
         super(target);
      }
      
      override public function initEffect(event:Event) : void
      {
         super.initEffect(event);
         if(Boolean(event.type == FlexEvent.HIDE) || Boolean(event.type == Event.REMOVED))
         {
            this.show = false;
         }
      }
      
      override public function play() : void
      {
         super.play();
         this.applyPropertyChanges();
         if(Boolean(isNaN(this.zoomWidthFrom)) && Boolean(isNaN(this.zoomWidthTo)) && Boolean(isNaN(this.zoomHeightFrom)) && Boolean(isNaN(this.zoomHeightTo)))
         {
            if(this.show)
            {
               this.zoomWidthFrom = this.zoomHeightFrom = 0;
               this.zoomWidthTo = target.scaleX;
               this.zoomHeightTo = target.scaleY;
            }
            else
            {
               this.zoomWidthFrom = target.scaleX;
               this.zoomHeightFrom = target.scaleY;
               this.zoomWidthTo = this.zoomHeightTo = 0;
            }
         }
         else
         {
            if(Boolean(isNaN(this.zoomWidthFrom)) && Boolean(isNaN(this.zoomWidthTo)))
            {
               this.zoomWidthFrom = this.zoomWidthTo = target.scaleX;
            }
            else if(Boolean(isNaN(this.zoomHeightFrom)) && Boolean(isNaN(this.zoomHeightTo)))
            {
               this.zoomHeightFrom = this.zoomHeightTo = target.scaleY;
            }
            if(isNaN(this.zoomWidthFrom))
            {
               this.zoomWidthFrom = target.scaleX;
            }
            else if(isNaN(this.zoomWidthTo))
            {
               this.zoomWidthTo = this.zoomWidthFrom == 1?Number(0):Number(1);
            }
            if(isNaN(this.zoomHeightFrom))
            {
               this.zoomHeightFrom = target.scaleY;
            }
            else if(isNaN(this.zoomHeightTo))
            {
               this.zoomHeightTo = this.zoomHeightFrom == 1?Number(0):Number(1);
            }
         }
         if(this.zoomWidthFrom < 0.01)
         {
            this.zoomWidthFrom = 0.01;
         }
         if(this.zoomWidthTo < 0.01)
         {
            this.zoomWidthTo = 0.01;
         }
         if(this.zoomHeightFrom < 0.01)
         {
            this.zoomHeightFrom = 0.01;
         }
         if(this.zoomHeightTo < 0.01)
         {
            this.zoomHeightTo = 0.01;
         }
         this.origScaleX = target.scaleX;
         this.origScaleY = target.scaleY;
         this.newX = this.origX = target.x;
         this.newY = this.origY = target.y;
         if(isNaN(this.originX))
         {
            this.scaledOriginX = target.width / 2;
         }
         else
         {
            this.scaledOriginX = this.originX * this.origScaleX;
         }
         if(isNaN(this.originY))
         {
            this.scaledOriginY = target.height / 2;
         }
         else
         {
            this.scaledOriginY = this.originY * this.origScaleY;
         }
         this.scaledOriginX = Number(this.scaledOriginX.toFixed(1));
         this.scaledOriginY = Number(this.scaledOriginY.toFixed(1));
         this.origPercentWidth = target.percentWidth;
         if(!isNaN(this.origPercentWidth))
         {
            target.width = target.width;
         }
         this.origPercentHeight = target.percentHeight;
         if(!isNaN(this.origPercentHeight))
         {
            target.height = target.height;
         }
         tween = createTween(this,[this.zoomWidthFrom,this.zoomHeightFrom],[this.zoomWidthTo,this.zoomHeightTo],duration);
         if(this.captureRollEvents)
         {
            target.addEventListener(MouseEvent.ROLL_OVER,this.mouseEventHandler,false);
            target.addEventListener(MouseEvent.ROLL_OUT,this.mouseEventHandler,false);
            target.addEventListener(MouseEvent.MOUSE_MOVE,this.mouseEventHandler,false);
         }
      }
      
      override public function onTweenUpdate(value:Object) : void
      {
         EffectManager.suspendEventHandling();
         if(Math.abs(this.newX - target.x) > 0.1)
         {
            this.origX = this.origX + (Number(target.x.toFixed(1)) - this.newX);
         }
         if(Math.abs(this.newY - target.y) > 0.1)
         {
            this.origY = this.origY + (Number(target.y.toFixed(1)) - this.newY);
         }
         target.scaleX = value[0];
         target.scaleY = value[1];
         var ratioX:Number = value[0] / this.origScaleX;
         var ratioY:Number = value[1] / this.origScaleY;
         var newOriginX:Number = this.scaledOriginX * ratioX;
         var newOriginY:Number = this.scaledOriginY * ratioY;
         this.newX = this.scaledOriginX - newOriginX + this.origX;
         this.newY = this.scaledOriginY - newOriginY + this.origY;
         this.newX = Number(this.newX.toFixed(1));
         this.newY = Number(this.newY.toFixed(1));
         target.move(this.newX,this.newY);
         if(tween)
         {
            tween.needToLayout = true;
         }
         else
         {
            needToLayout = true;
         }
         EffectManager.resumeEventHandling();
      }
      
      override public function onTweenEnd(value:Object) : void
      {
         var curWidth:Number = NaN;
         var curHeight:Number = NaN;
         if(!isNaN(this.origPercentWidth))
         {
            curWidth = target.width;
            target.percentWidth = this.origPercentWidth;
            if(Boolean(target.parent) && Boolean(target.parent.autoLayout == false))
            {
               target._width = curWidth;
            }
         }
         if(!isNaN(this.origPercentHeight))
         {
            curHeight = target.height;
            target.percentHeight = this.origPercentHeight;
            if(Boolean(target.parent) && Boolean(target.parent.autoLayout == false))
            {
               target._height = curHeight;
            }
         }
         super.onTweenEnd(value);
         if(hideOnEffectEnd)
         {
            EffectManager.suspendEventHandling();
            target.scaleX = this.origScaleX;
            target.scaleY = this.origScaleY;
            target.move(this.origX,this.origY);
            EffectManager.resumeEventHandling();
         }
      }
      
      override public function finishEffect() : void
      {
         if(this.captureRollEvents)
         {
            target.removeEventListener(MouseEvent.ROLL_OVER,this.mouseEventHandler,false);
            target.removeEventListener(MouseEvent.ROLL_OUT,this.mouseEventHandler,false);
            target.removeEventListener(MouseEvent.MOUSE_MOVE,this.mouseEventHandler,false);
         }
         super.finishEffect();
      }
      
      private function applyPropertyChanges() : void
      {
         var useSize:Boolean = false;
         var useScale:Boolean = false;
         var values:PropertyChanges = propertyChanges;
         if(values)
         {
            useSize = false;
            useScale = false;
            if(values.end["scaleX"] !== undefined)
            {
               this.zoomWidthFrom = !!isNaN(this.zoomWidthFrom)?Number(target.scaleX):Number(this.zoomWidthFrom);
               this.zoomWidthTo = !!isNaN(this.zoomWidthTo)?Number(values.end["scaleX"]):Number(this.zoomWidthTo);
               useScale = true;
            }
            if(values.end["scaleY"] !== undefined)
            {
               this.zoomHeightFrom = !!isNaN(this.zoomHeightFrom)?Number(target.scaleY):Number(this.zoomHeightFrom);
               this.zoomHeightTo = !!isNaN(this.zoomHeightTo)?Number(values.end["scaleY"]):Number(this.zoomHeightTo);
               useScale = true;
            }
            if(useScale)
            {
               return;
            }
            if(values.end["width"] !== undefined)
            {
               this.zoomWidthFrom = !!isNaN(this.zoomWidthFrom)?Number(this.getScaleFromWidth(target.width)):Number(this.zoomWidthFrom);
               this.zoomWidthTo = !!isNaN(this.zoomWidthTo)?Number(this.getScaleFromWidth(values.end["width"])):Number(this.zoomWidthTo);
               useSize = true;
            }
            if(values.end["height"] !== undefined)
            {
               this.zoomHeightFrom = !!isNaN(this.zoomHeightFrom)?Number(this.getScaleFromHeight(target.height)):Number(this.zoomHeightFrom);
               this.zoomHeightTo = !!isNaN(this.zoomHeightTo)?Number(this.getScaleFromHeight(values.end["height"])):Number(this.zoomHeightTo);
               useSize = true;
            }
            if(useSize)
            {
               return;
            }
            if(values.end["visible"] !== undefined)
            {
               this.show = values.end["visible"];
            }
         }
      }
      
      private function getScaleFromWidth(value:Number) : Number
      {
         return value / (target.width / Math.abs(target.scaleX));
      }
      
      private function getScaleFromHeight(value:Number) : Number
      {
         return value / (target.height / Math.abs(target.scaleY));
      }
      
      private function mouseEventHandler(event:MouseEvent) : void
      {
         if(event.type == MouseEvent.MOUSE_MOVE)
         {
            this._mouseHasMoved = true;
         }
         else if(Boolean(event.type == MouseEvent.ROLL_OUT) || Boolean(event.type == MouseEvent.ROLL_OVER))
         {
            if(!this._mouseHasMoved)
            {
               event.stopImmediatePropagation();
            }
            this._mouseHasMoved = false;
         }
      }
   }
}
