package mx.effects
{
   import mx.core.mx_internal;
   import mx.effects.effectClasses.FadeInstance;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.effects.Fade",since="4.0")]
   public class Fade extends TweenEffect
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var AFFECTED_PROPERTIES:Array = ["alpha","visible"];
       
      [Inspectable(defaultValue="undefined",category="General")]
      public var alphaFrom:Number;
      
      [Inspectable(defaultValue="NaN",category="General")]
      public var alphaTo:Number;
      
      public function Fade(target:Object = null)
      {
         super(target);
         instanceClass = FadeInstance;
      }
      
      override public function getAffectedProperties() : Array
      {
         return AFFECTED_PROPERTIES;
      }
      
      override protected function initInstance(instance:IEffectInstance) : void
      {
         super.initInstance(instance);
         var fadeInstance:FadeInstance = FadeInstance(instance);
         fadeInstance.alphaFrom = this.alphaFrom;
         fadeInstance.alphaTo = this.alphaTo;
      }
   }
}
