package mx.effects
{
   import flash.events.EventDispatcher;
   import mx.core.mx_internal;
   import flash.utils.Dictionary;
   import mx.resources.IResourceManager;
   import mx.resources.ResourceManager;
   import mx.core.IUIComponent;
   import mx.core.EventPriority;
   import flash.system.ApplicationDomain;
   import mx.core.FlexGlobals;
   import mx.core.UIComponent;
   import mx.core.IDeferredInstantiationUIComponent;
   import mx.core.UIComponentCachePolicy;
   import flash.events.Event;
   import flash.events.FocusEvent;
   import flash.display.DisplayObject;
   import flash.display.DisplayObjectContainer;
   import mx.core.IFlexDisplayObject;
   import mx.events.MoveEvent;
   import mx.events.ResizeEvent;
   import mx.events.FlexEvent;
   import mx.events.EffectEvent;
   import mx.core.IVisualElementContainer;
   import mx.core.IVisualElement;
   
   use namespace mx_internal;
   
   [ResourceBundle("effects")]
   public class EffectManager extends EventDispatcher
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var effectsPlaying:Array = [];
      
      private static var effectTriggersForEvent:Object = {};
      
      private static var eventsForEffectTriggers:Object = {};
      
      private static var targetsInfo:Array = [];
      
      private static var eventHandlingSuspendCount:Number = 0;
      
      private static var weakKeys:Dictionary;
      
      private static var _resourceManager:IResourceManager;
      
      private static var effects:Dictionary = new Dictionary(true);
       
      public function EffectManager()
      {
         super();
      }
      
      mx_internal static function set lastEffectCreated(effect:Effect) : void
      {
         weakKeys = new Dictionary(true);
         weakKeys[effect] = true;
      }
      
      mx_internal static function get lastEffectCreated() : Effect
      {
         var item:* = undefined;
         for(item in weakKeys)
         {
            return item;
         }
         return null;
      }
      
      private static function get resourceManager() : IResourceManager
      {
         if(!_resourceManager)
         {
            _resourceManager = ResourceManager.getInstance();
         }
         return _resourceManager;
      }
      
      public static function suspendEventHandling() : void
      {
         eventHandlingSuspendCount++;
      }
      
      public static function resumeEventHandling() : void
      {
         eventHandlingSuspendCount--;
      }
      
      public static function endEffectsForTarget(target:IUIComponent) : void
      {
         var otherInst:EffectInstance = null;
         var n:int = effectsPlaying.length;
         for(var i:int = n - 1; i >= 0; i--)
         {
            otherInst = effectsPlaying[i].instance;
            if(otherInst.target == target)
            {
               otherInst.end();
            }
         }
      }
      
      mx_internal static function setStyle(styleProp:String, target:*) : void
      {
         var eventName:String = eventsForEffectTriggers[styleProp];
         if(Boolean(eventName != null) && Boolean(eventName != ""))
         {
            target.addEventListener(eventName,EffectManager.eventHandler,false,EventPriority.EFFECT);
         }
      }
      
      mx_internal static function createEffectForType(target:Object, type:String) : Effect
      {
         var effectClass:Class = null;
         var cls:Class = null;
         var effectObj:Effect = null;
         var doc:Object = null;
         var appDomain:ApplicationDomain = null;
         var trigger:String = effectTriggersForEvent[type];
         if(trigger == "")
         {
            trigger = type + "Effect";
         }
         var value:Object = target.getStyle(trigger);
         if(!value)
         {
            return null;
         }
         if(value is Class)
         {
            cls = Class(value);
            return new cls(target);
         }
         try
         {
            if(value is String)
            {
               doc = target.parentDocument;
               if(!doc)
               {
                  doc = FlexGlobals.topLevelApplication;
               }
               effectObj = doc[value];
            }
            else if(value is Effect)
            {
               effectObj = Effect(value);
            }
            if(effectObj)
            {
               effectObj.target = target;
               return effectObj;
            }
         }
         catch(e:Error)
         {
         }
         if(Boolean(target is UIComponent) && Boolean(target.moduleFactory))
         {
            appDomain = target.moduleFactory.info()["currentDomain"];
            if(appDomain.hasDefinition("mx.effects." + value))
            {
               effectClass = Class(appDomain.getDefinition("mx.effects." + value));
            }
         }
         if(!effectClass)
         {
            effectClass = Class(target.systemManager.getDefinitionByName("mx.effects." + value));
         }
         if(effectClass)
         {
            return new effectClass(target);
         }
         return null;
      }
      
      private static function animateSameProperty(a:Effect, b:Effect, c:EffectInstance) : Boolean
      {
         var aProps:Array = null;
         var bProps:Array = null;
         var n:int = 0;
         var m:int = 0;
         var i:int = 0;
         var j:int = 0;
         if(a.target == c.target)
         {
            aProps = a.getAffectedProperties();
            bProps = b.getAffectedProperties();
            n = aProps.length;
            m = bProps.length;
            for(i = 0; i < n; i++)
            {
               for(j = 0; j < m; j++)
               {
                  if(aProps[i] == bProps[j])
                  {
                     return true;
                  }
               }
            }
         }
         return false;
      }
      
      mx_internal static function startBitmapEffect(target:IUIComponent) : void
      {
         cacheOrUncacheTargetAsBitmap(target,true,true);
      }
      
      mx_internal static function endBitmapEffect(target:IUIComponent) : void
      {
         cacheOrUncacheTargetAsBitmap(target,false,true);
      }
      
      mx_internal static function startVectorEffect(target:IUIComponent) : void
      {
         cacheOrUncacheTargetAsBitmap(target,true,false);
      }
      
      mx_internal static function endVectorEffect(target:IUIComponent) : void
      {
         cacheOrUncacheTargetAsBitmap(target,false,false);
      }
      
      private static function cacheOrUncacheTargetAsBitmap(target:IUIComponent, effectStart:Boolean = true, bitmapEffect:Boolean = true) : void
      {
         var n:int = 0;
         var i:int = 0;
         var info:Object = null;
         n = targetsInfo.length;
         for(i = 0; i < n; i++)
         {
            if(targetsInfo[i].target == target)
            {
               info = targetsInfo[i];
               break;
            }
         }
         if(!info)
         {
            info = {
               "target":target,
               "bitmapEffectsCount":0,
               "vectorEffectsCount":0
            };
            targetsInfo.push(info);
         }
         if(effectStart)
         {
            if(bitmapEffect)
            {
               info.bitmapEffectsCount++;
               if(Boolean(info.vectorEffectsCount == 0) && Boolean(target is IDeferredInstantiationUIComponent))
               {
                  IDeferredInstantiationUIComponent(target).cacheHeuristic = true;
               }
            }
            else if(Boolean(info.vectorEffectsCount++ == 0) && Boolean(target is IDeferredInstantiationUIComponent) && Boolean(IDeferredInstantiationUIComponent(target).cachePolicy == UIComponentCachePolicy.AUTO))
            {
               target.cacheAsBitmap = false;
            }
         }
         else
         {
            if(bitmapEffect)
            {
               if(info.bitmapEffectsCount != 0)
               {
                  info.bitmapEffectsCount--;
               }
               if(target is IDeferredInstantiationUIComponent)
               {
                  IDeferredInstantiationUIComponent(target).cacheHeuristic = false;
               }
            }
            else if(info.vectorEffectsCount != 0)
            {
               if(Boolean(--info.vectorEffectsCount == 0) && Boolean(info.bitmapEffectsCount != 0))
               {
                  n = info.bitmapEffectsCount;
                  for(i = 0; i < n; i++)
                  {
                     if(target is IDeferredInstantiationUIComponent)
                     {
                        IDeferredInstantiationUIComponent(target).cacheHeuristic = true;
                     }
                  }
               }
            }
            if(Boolean(info.bitmapEffectsCount == 0) && Boolean(info.vectorEffectsCount == 0))
            {
               n = targetsInfo.length;
               for(i = 0; i < n; i++)
               {
                  if(targetsInfo[i].target == target)
                  {
                     targetsInfo.splice(i,1);
                     break;
                  }
               }
            }
         }
      }
      
      mx_internal static function registerEffectTrigger(name:String, event:String) : void
      {
         var strLen:Number = NaN;
         if(name != "")
         {
            if(event == "")
            {
               strLen = name.length;
               if(Boolean(strLen > 6) && Boolean(name.substring(strLen - 6) == "Effect"))
               {
                  event = name.substring(0,strLen - 6);
               }
            }
            if(event != "")
            {
               effectTriggersForEvent[event] = name;
               eventsForEffectTriggers[name] = event;
            }
         }
      }
      
      mx_internal static function getEventForEffectTrigger(effectTrigger:String) : String
      {
         if(eventsForEffectTriggers)
         {
            try
            {
               return eventsForEffectTriggers[effectTrigger];
            }
            catch(e:Error)
            {
               return "";
            }
            return "";
         }
         return "";
      }
      
      mx_internal static function eventHandler(eventObj:Event) : void
      {
         var focusEventObj:FocusEvent = null;
         var targ:DisplayObject = null;
         var i:int = 0;
         var parent:DisplayObjectContainer = null;
         var index:int = 0;
         if(!(eventObj.currentTarget is IFlexDisplayObject))
         {
            return;
         }
         if(eventHandlingSuspendCount > 0)
         {
            return;
         }
         if(Boolean(eventObj is FocusEvent) && (Boolean(eventObj.type == FocusEvent.FOCUS_OUT) || Boolean(eventObj.type == FocusEvent.FOCUS_IN)))
         {
            focusEventObj = FocusEvent(eventObj);
            if(Boolean(focusEventObj.relatedObject) && (Boolean(focusEventObj.currentTarget.contains(focusEventObj.relatedObject)) || Boolean(focusEventObj.currentTarget == focusEventObj.relatedObject)))
            {
               return;
            }
         }
         if((Boolean(eventObj.type == Event.ADDED) || Boolean(eventObj.type == Event.REMOVED)) && Boolean(eventObj.target != eventObj.currentTarget))
         {
            return;
         }
         if(eventObj.type == Event.REMOVED)
         {
            if(eventObj.target is UIComponent)
            {
               if(UIComponent(eventObj.target).initialized == false)
               {
                  return;
               }
               if(UIComponent(eventObj.target).isEffectStarted)
               {
                  for(i = 0; i < UIComponent(eventObj.target)._effectsStarted.length; i++)
                  {
                     if(UIComponent(eventObj.target)._effectsStarted[i].triggerEvent.type == Event.REMOVED)
                     {
                        return;
                     }
                  }
               }
            }
            targ = eventObj.target as DisplayObject;
            if(targ != null)
            {
               parent = targ.parent as DisplayObjectContainer;
               if(parent != null)
               {
                  index = parent.getChildIndex(targ);
                  if(index >= 0)
                  {
                     if(targ is UIComponent)
                     {
                        UIComponent(targ).callLater(removedEffectHandler,[targ,parent,index,eventObj]);
                     }
                  }
               }
            }
         }
         else
         {
            createAndPlayEffect(eventObj,eventObj.currentTarget);
         }
      }
      
      private static function createAndPlayEffect(eventObj:Event, target:Object) : void
      {
         var n:int = 0;
         var i:int = 0;
         var m:int = 0;
         var j:int = 0;
         var message:String = null;
         var type:String = null;
         var tweeningProperties:Array = null;
         var effectProperties:Array = null;
         var affectedProps:Array = null;
         var runningInstances:Array = null;
         var otherInst:EffectInstance = null;
         var effectInst:Effect = createEffectForType(target,eventObj.type);
         if(!effectInst)
         {
            return;
         }
         if(Boolean(effectInst is Zoom) && Boolean(eventObj.type == MoveEvent.MOVE))
         {
            message = resourceManager.getString("effects","incorrectTrigger");
            throw new Error(message);
         }
         if(target.initialized == false)
         {
            type = eventObj.type;
            if(Boolean(type == MoveEvent.MOVE) || Boolean(type == ResizeEvent.RESIZE) || Boolean(type == FlexEvent.SHOW) || Boolean(type == FlexEvent.HIDE) || Boolean(type == Event.CHANGE))
            {
               effectInst = null;
               return;
            }
         }
         if(effectInst.target is IUIComponent)
         {
            tweeningProperties = IUIComponent(effectInst.target).tweeningProperties;
            if(Boolean(tweeningProperties) && Boolean(tweeningProperties.length > 0))
            {
               effectProperties = effectInst.getAffectedProperties();
               n = tweeningProperties.length;
               m = effectProperties.length;
               for(i = 0; i < n; i++)
               {
                  for(j = 0; j < m; j++)
                  {
                     if(tweeningProperties[i] == effectProperties[j])
                     {
                        effectInst = null;
                        return;
                     }
                  }
               }
            }
         }
         if(Boolean(effectInst.target is UIComponent) && Boolean(UIComponent(effectInst.target).isEffectStarted))
         {
            affectedProps = effectInst.getAffectedProperties();
            for(i = 0; i < affectedProps.length; i++)
            {
               runningInstances = effectInst.target.getEffectsForProperty(affectedProps[i]);
               if(runningInstances.length > 0)
               {
                  if(eventObj.type == ResizeEvent.RESIZE)
                  {
                     return;
                  }
                  for(j = 0; j < runningInstances.length; j++)
                  {
                     otherInst = runningInstances[j];
                     if(Boolean(eventObj.type == FlexEvent.SHOW) && Boolean(otherInst.hideOnEffectEnd))
                     {
                        otherInst.target.removeEventListener(FlexEvent.SHOW,otherInst.eventHandler);
                        otherInst.hideOnEffectEnd = false;
                     }
                     otherInst.end();
                  }
               }
            }
         }
         effectInst.triggerEvent = eventObj;
         effectInst.addEventListener(EffectEvent.EFFECT_END,EffectManager.effectEndHandler);
         lastEffectCreated = effectInst;
         var instances:Array = effectInst.play();
         n = instances.length;
         for(i = 0; i < n; i++)
         {
            effectsPlaying.push(new EffectNode(effectInst,instances[i]));
         }
         if(effectInst.suspendBackgroundProcessing)
         {
            UIComponent.suspendBackgroundProcessing();
         }
      }
      
      private static function removedEffectHandler(target:DisplayObject, parent:DisplayObjectContainer, index:int, eventObj:Event) : void
      {
         suspendEventHandling();
         if(Boolean(parent is IVisualElementContainer) && Boolean(target is IVisualElement))
         {
            IVisualElementContainer(parent).addElementAt(target as IVisualElement,index);
         }
         else
         {
            parent.addChildAt(target,index);
         }
         resumeEventHandling();
         createAndPlayEffect(eventObj,target);
      }
      
      mx_internal static function effectEndHandler(event:EffectEvent) : void
      {
         var targ:DisplayObject = null;
         var parent:DisplayObjectContainer = null;
         var effectInst:IEffectInstance = event.effectInstance;
         var n:int = effectsPlaying.length;
         for(var i:int = n - 1; i >= 0; i--)
         {
            if(effectsPlaying[i].instance == effectInst)
            {
               effectsPlaying.splice(i,1);
               break;
            }
         }
         if(Object(effectInst).hideOnEffectEnd == true)
         {
            effectInst.target.removeEventListener(FlexEvent.SHOW,Object(effectInst).eventHandler);
            effectInst.target.setVisible(false,true);
         }
         if(Boolean(effectInst.triggerEvent) && Boolean(effectInst.triggerEvent.type == Event.REMOVED))
         {
            targ = effectInst.target as DisplayObject;
            if(targ != null)
            {
               parent = targ.parent as DisplayObjectContainer;
               if(parent != null)
               {
                  suspendEventHandling();
                  if(Boolean(parent is IVisualElementContainer) && Boolean(targ is IVisualElement))
                  {
                     IVisualElementContainer(parent).removeElement(targ as IVisualElement);
                  }
                  else
                  {
                     parent.removeChild(targ);
                  }
                  resumeEventHandling();
               }
            }
         }
         if(effectInst.suspendBackgroundProcessing)
         {
            UIComponent.resumeBackgroundProcessing();
         }
      }
      
      mx_internal static function effectStarted(effect:EffectInstance) : void
      {
         effects[effect] = 1;
      }
      
      mx_internal static function effectFinished(effect:EffectInstance) : void
      {
         delete effects[effect];
      }
      
      mx_internal static function effectsInEffect() : Boolean
      {
         var i:* = undefined;
         for(i in effects)
         {
            return true;
         }
         return false;
      }
   }
}

import mx.effects.Effect;
import mx.effects.EffectInstance;

class EffectNode
{
    
   public var factory:Effect;
   
   public var instance:EffectInstance;
   
   function EffectNode(factory:Effect, instance:EffectInstance)
   {
      super();
      this.factory = factory;
      this.instance = instance;
   }
}
