package mx.core
{
   import flash.utils.Dictionary;
   import flash.text.TextField;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class TextFieldFactory implements mx.core.ITextFieldFactory
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var instance:mx.core.ITextFieldFactory;
       
      private var textFields:Dictionary;
      
      private var fteTextFields:Dictionary;
      
      public function TextFieldFactory()
      {
         this.textFields = new Dictionary(true);
         this.fteTextFields = new Dictionary(true);
         super();
      }
      
      public static function getInstance() : mx.core.ITextFieldFactory
      {
         if(!instance)
         {
            instance = new TextFieldFactory();
         }
         return instance;
      }
      
      public function createTextField(moduleFactory:IFlexModuleFactory) : TextField
      {
         var iter:* = null;
         var textField:TextField = null;
         var textFieldDictionary:Dictionary = this.textFields[moduleFactory];
         if(textFieldDictionary)
         {
            for(iter in textFieldDictionary)
            {
               textField = TextField(iter);
            }
         }
         if(!textField)
         {
            if(moduleFactory)
            {
               textField = TextField(moduleFactory.create("flash.text.TextField"));
            }
            else
            {
               textField = new TextField();
            }
            if(!textFieldDictionary)
            {
               textFieldDictionary = new Dictionary(true);
            }
            textFieldDictionary[textField] = 1;
            this.textFields[moduleFactory] = textFieldDictionary;
         }
         return textField;
      }
      
      public function createFTETextField(moduleFactory:IFlexModuleFactory) : Object
      {
         var iter:Object = null;
         var fteTextField:* = null;
         var fteTextFieldDictionary:Dictionary = this.fteTextFields[moduleFactory];
         if(fteTextFieldDictionary)
         {
            for(fteTextField in fteTextFieldDictionary)
            {
            }
         }
         if(!fteTextField)
         {
            if(moduleFactory)
            {
               fteTextField = moduleFactory.create("mx.core.FTETextField");
               fteTextField.fontContext = moduleFactory;
            }
            if(!fteTextFieldDictionary)
            {
               fteTextFieldDictionary = new Dictionary(true);
            }
            fteTextFieldDictionary[fteTextField] = 1;
            this.fteTextFields[moduleFactory] = fteTextFieldDictionary;
         }
         return fteTextField;
      }
   }
}
