package mx.controls
{
   import mx.core.UIComponent;
   import mx.core.IToolTip;
   import mx.core.IFontContextComponent;
   import mx.core.mx_internal;
   import mx.core.IFlexDisplayObject;
   import mx.core.EdgeMetrics;
   import mx.core.IRectangularBorder;
   import mx.core.IFlexModuleFactory;
   import mx.core.IUITextField;
   import mx.styles.ISimpleStyleClient;
   import flash.display.DisplayObject;
   import flash.text.TextFormat;
   import mx.core.UITextField;
   import flash.text.TextFieldAutoSize;
   
   use namespace mx_internal;
   
   [Style(inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(inherit="no",name="cornerRadius",format="Length",theme="halo, spark",type="Number")]
   [Style(inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="no",name="textFieldClass",type="Class")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="left,center,right")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="letterSpacing",type="Number")]
   [Style(inherit="yes",name="kerning",type="Boolean")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontThickness",type="Number")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontSharpness",type="Number")]
   [Style(inherit="yes",name="fontGridFitType",type="String",enumeration="none,pixel,subpixel")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="fontAntiAliasType",type="String",enumeration="normal,advanced")]
   [Style(inherit="yes",name="disabledColor",format="Color",type="uint")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl,inherit")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="no",name="paddingRight",format="Length",type="Number")]
   [Style(inherit="no",name="paddingLeft",format="Length",type="Number")]
   [Style(inherit="yes",name="leading",format="Length",type="Number")]
   [Style(inherit="no",name="shadowDistance",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="shadowDirection",theme="halo",type="String",enumeration="left,center,right")]
   [Style(inherit="yes",name="dropShadowColor",format="Color",theme="halo",type="uint")]
   [Style(inherit="no",name="dropShadowVisible",theme="spark",type="Boolean")]
   [Style(inherit="no",name="dropShadowEnabled",theme="halo",type="Boolean")]
   [Style(inherit="no",name="borderVisible",theme="spark",type="Boolean")]
   [Style(inherit="no",name="borderThickness",format="Length",theme="halo",type="Number")]
   [Style(inherit="no",name="borderStyle",type="String",enumeration="inset,outset,solid,none")]
   [Style(inherit="no",name="borderSkin",type="Class")]
   [Style(inherit="no",name="borderSides",theme="halo",type="String")]
   [Style(inherit="no",name="borderColor",format="Color",theme="halo, spark",type="uint")]
   [Style(inherit="no",name="borderAlpha",theme="spark",type="Number")]
   [Style(inherit="no",name="backgroundSize",theme="halo",type="String")]
   [Style(inherit="no",name="backgroundImage",format="File",theme="halo",type="Object")]
   [Style(inherit="yes",name="backgroundDisabledColor",format="Color",theme="halo",type="uint")]
   [Style(inherit="no",name="backgroundColor",format="Color",theme="halo, spark",type="uint")]
   [Style(inherit="no",name="backgroundAlpha",theme="halo, spark",type="Number")]
   public class ToolTip extends UIComponent implements IToolTip, IFontContextComponent
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      [Inspectable(category="Other")]
      public static var maxWidth:Number = 300;
       
      mx_internal var border:IFlexDisplayObject;
      
      private var _text:String;
      
      private var textChanged:Boolean;
      
      protected var textField:IUITextField;
      
      public function ToolTip()
      {
         super();
         mouseEnabled = false;
      }
      
      private function get borderMetrics() : EdgeMetrics
      {
         if(this.border is IRectangularBorder)
         {
            return IRectangularBorder(this.border).borderMetrics;
         }
         return EdgeMetrics.EMPTY;
      }
      
      public function get fontContext() : IFlexModuleFactory
      {
         return moduleFactory;
      }
      
      public function set fontContext(moduleFactory:IFlexModuleFactory) : void
      {
         this.moduleFactory = moduleFactory;
      }
      
      public function get text() : String
      {
         return this._text;
      }
      
      public function set text(value:String) : void
      {
         this._text = value;
         this.textChanged = true;
         invalidateProperties();
         invalidateSize();
         invalidateDisplayList();
      }
      
      override protected function createChildren() : void
      {
         var borderClass:Class = null;
         super.createChildren();
         if(!this.border)
         {
            borderClass = getStyle("borderSkin");
            this.border = new borderClass();
            if(this.border is ISimpleStyleClient)
            {
               ISimpleStyleClient(this.border).styleName = this;
            }
            addChild(DisplayObject(this.border));
         }
         this.createTextField(-1);
      }
      
      override protected function commitProperties() : void
      {
         var index:int = 0;
         var textFormat:TextFormat = null;
         super.commitProperties();
         if(Boolean(hasFontContextChanged()) && Boolean(this.textField != null))
         {
            index = getChildIndex(DisplayObject(this.textField));
            this.removeTextField();
            this.createTextField(index);
            invalidateSize();
            this.textChanged = true;
         }
         if(this.textChanged)
         {
            textFormat = this.textField.getTextFormat();
            textFormat.leftMargin = 0;
            textFormat.rightMargin = 0;
            this.textField.defaultTextFormat = textFormat;
            this.textField.text = this._text;
            this.textChanged = false;
         }
      }
      
      override protected function measure() : void
      {
         var heightSlop:Number = NaN;
         super.measure();
         var bm:EdgeMetrics = this.borderMetrics;
         var leftInset:Number = bm.left + getStyle("paddingLeft");
         var topInset:Number = bm.top + getStyle("paddingTop");
         var rightInset:Number = bm.right + getStyle("paddingRight");
         var bottomInset:Number = bm.bottom + getStyle("paddingBottom");
         var widthSlop:Number = leftInset + rightInset;
         heightSlop = topInset + bottomInset;
         this.textField.wordWrap = false;
         if(this.textField.textWidth + widthSlop > ToolTip.maxWidth)
         {
            this.textField.width = ToolTip.maxWidth - widthSlop;
            this.textField.wordWrap = true;
         }
         measuredWidth = this.textField.width + widthSlop;
         measuredHeight = this.textField.height + heightSlop;
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         var bm:EdgeMetrics = this.borderMetrics;
         var leftInset:Number = bm.left + getStyle("paddingLeft");
         var topInset:Number = bm.top + getStyle("paddingTop");
         var rightInset:Number = bm.right + getStyle("paddingRight");
         var bottomInset:Number = bm.bottom + getStyle("paddingBottom");
         var widthSlop:Number = leftInset + rightInset;
         var heightSlop:Number = topInset + bottomInset;
         this.border.setActualSize(unscaledWidth,unscaledHeight);
         this.textField.move(leftInset,topInset);
         this.textField.setActualSize(unscaledWidth - widthSlop,unscaledHeight - heightSlop);
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         super.styleChanged(styleProp);
         if(Boolean(styleProp == "borderStyle") || Boolean(styleProp == "styleName") || Boolean(styleProp == null))
         {
            invalidateDisplayList();
         }
      }
      
      mx_internal function createTextField(childIndex:int) : void
      {
         if(!this.textField)
         {
            this.textField = IUITextField(createInFontContext(UITextField));
            this.textField.autoSize = TextFieldAutoSize.LEFT;
            this.textField.mouseEnabled = false;
            this.textField.multiline = true;
            this.textField.selectable = false;
            this.textField.wordWrap = false;
            this.textField.styleName = this;
            if(childIndex == -1)
            {
               addChild(DisplayObject(this.textField));
            }
            else
            {
               addChildAt(DisplayObject(this.textField),childIndex);
            }
         }
      }
      
      mx_internal function removeTextField() : void
      {
         if(this.textField)
         {
            removeChild(DisplayObject(this.textField));
            this.textField = null;
         }
      }
      
      mx_internal function getTextField() : IUITextField
      {
         return this.textField;
      }
   }
}
