package mx.controls
{
   import mx.controls.scrollClasses.ScrollBar;
   import mx.core.mx_internal;
   import flash.geom.Matrix;
   import flash.ui.Keyboard;
   import mx.core.LayoutDirection;
   import mx.controls.scrollClasses.ScrollBarDirection;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.HScrollBar",since="4.0")]
   [IconFile("HScrollBar.png")]
   [DefaultTriggerEvent("scroll")]
   [DefaultBindingProperty(destination="scrollPosition",source="scrollPosition")]
   [Exclude(kind="property",name="direction")]
   [Style(inherit="no",name="repeatInterval",format="Time",type="Number")]
   [Style(inherit="no",name="repeatDelay",format="Time",type="Number")]
   [Event(name="scroll",type="mx.events.ScrollEvent")]
   public class HScrollBar extends ScrollBar
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function HScrollBar()
      {
         super();
         super.direction = ScrollBarDirection.HORIZONTAL;
         scaleX = -1;
         rotation = -90;
      }
      
      [Inspectable(environment="none")]
      override public function set direction(value:String) : void
      {
      }
      
      override public function get minWidth() : Number
      {
         return _minHeight;
      }
      
      override public function get minHeight() : Number
      {
         return _minWidth;
      }
      
      override mx_internal function get virtualHeight() : Number
      {
         return unscaledWidth;
      }
      
      override mx_internal function get virtualWidth() : Number
      {
         return unscaledHeight;
      }
      
      override protected function measure() : void
      {
         super.measure();
         measuredWidth = _minHeight;
         measuredHeight = _minWidth;
      }
      
      override protected function nonDeltaLayoutMatrix() : Matrix
      {
         var m:Matrix = new Matrix(0,1,1,0);
         var m1:Matrix = super.nonDeltaLayoutMatrix();
         if(m1)
         {
            m.concat(m1);
         }
         return m;
      }
      
      override mx_internal function isScrollBarKey(key:uint) : Boolean
      {
         var direction:int = 0;
         if(key == Keyboard.LEFT)
         {
            direction = Boolean(LayoutDirection.LTR)?int(-1):int(1);
            lineScroll(direction);
            return true;
         }
         if(key == Keyboard.RIGHT)
         {
            direction = Boolean(LayoutDirection.LTR)?int(1):int(-1);
            lineScroll(direction);
            return true;
         }
         return super.isScrollBarKey(key);
      }
   }
}
