package mx.containers
{
   import mx.core.mx_internal;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.TitleWindow",since="4.0")]
   [IconFile("TitleWindow.png")]
   [AccessibilityClass(implementation="mx.accessibility.TitleWindowAccImpl")]
   [Exclude(kind="effect",name="focusOutEffect")]
   [Exclude(kind="effect",name="focusInEffect")]
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusSkin")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Exclude(kind="event",name="focusOut")]
   [Exclude(kind="event",name="focusIn")]
   [Style(inherit="no",name="closeButtonUpSkin",type="Class")]
   [Style(inherit="no",name="closeButtonOverSkin",type="Class")]
   [Style(inherit="no",name="closeButtonDownSkin",type="Class")]
   [Style(inherit="no",name="closeButtonDisabledSkin",type="Class")]
   [Style(inherit="no",name="closeButtonSkin",type="Class",states="up, over, down, disabled")]
   [Event(name="close",type="mx.events.CloseEvent")]
   public class TitleWindow extends Panel
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var createAccessibilityImplementation:Function;
       
      public function TitleWindow()
      {
         super();
      }
      
      [Inspectable(category="General")]
      public function get showCloseButton() : Boolean
      {
         return _showCloseButton;
      }
      
      public function set showCloseButton(value:Boolean) : void
      {
         _showCloseButton = value;
      }
      
      override protected function initializeAccessibility() : void
      {
         if(TitleWindow.createAccessibilityImplementation != null)
         {
            TitleWindow.createAccessibilityImplementation(this);
         }
      }
   }
}
