package mx.accessibility
{
   import mx.core.mx_internal;
   import mx.containers.TitleWindow;
   import mx.core.UIComponent;
   import flash.accessibility.Accessibility;
   import flash.events.Event;
   import mx.containers.Panel;
   import flash.events.MouseEvent;
   
   use namespace mx_internal;
   
   public class TitleWindowAccImpl extends PanelAccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function TitleWindowAccImpl(master:UIComponent)
      {
         super(master);
         Panel(master).getTitleBar().addEventListener(MouseEvent.MOUSE_UP,this.eventHandler);
         Panel(master).closeButton.addEventListener(MouseEvent.MOUSE_UP,this.eventHandler);
      }
      
      public static function enableAccessibility() : void
      {
         TitleWindow.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         var titleBar:UIComponent = TitleWindow(component).getTitleBar();
         titleBar.accessibilityImplementation = new TitleWindowAccImpl(component);
         Accessibility.sendEvent(titleBar,0,AccConst.EVENT_OBJECT_CREATE);
         Accessibility.updateProperties();
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = getState(childID);
         accState = accState | AccConst.STATE_SYSTEM_MOVEABLE;
         return accState;
      }
      
      override protected function eventHandler(event:Event) : void
      {
         $eventHandler(event);
         switch(event.type)
         {
            case MouseEvent.MOUSE_UP:
               if(event.target == Panel(master).getTitleBar())
               {
                  Accessibility.sendEvent(Panel(master).getTitleBar(),0,AccConst.EVENT_OBJECT_LOCATIONCHANGE,true);
               }
               if(event.target == Panel(master).closeButton)
               {
                  Accessibility.sendEvent(Panel(master).getTitleBar(),0,AccConst.EVENT_OBJECT_DESTROY,true);
               }
               Accessibility.updateProperties();
         }
      }
   }
}
