package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.FormatValue;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class UintProperty extends Property
   {
       
      public function UintProperty(nameValue:String, defaultValue:uint, inherited:Boolean, category:String)
      {
         super(nameValue,defaultValue,inherited,category);
      }
      
      tlf_internal static function doHash(val:uint, seed:uint) : uint
      {
         return seed << 5 ^ seed >> 27 ^ val;
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         var newVal:* = undefined;
         var str:String = null;
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject == FormatValue.INHERIT))
         {
            return newObject;
         }
         if(newObject is String)
         {
            str = String(newObject);
            if(str.substr(0,1) == "#")
            {
               str = "0x" + str.substr(1,str.length - 1);
            }
            newVal = str.toLowerCase().substr(0,2) == "0x"?parseInt(str):NaN;
         }
         else if(Boolean(newObject is Number) || Boolean(newObject is int) || Boolean(newObject is uint))
         {
            newVal = Number(newObject);
         }
         else
         {
            newVal = NaN;
         }
         if(isNaN(newVal))
         {
            Property.errorHandler(this,str);
            return currVal;
         }
         if(newVal is Number)
         {
            if(Boolean(newVal < 0) || Boolean(newVal > 4294967295))
            {
               Property.errorHandler(this,newObject);
               return currVal;
            }
         }
         return newVal;
      }
      
      override public function toXMLString(val:Object) : String
      {
         if(val == FormatValue.INHERIT)
         {
            return String(val);
         }
         var result:String = val.toString(16);
         if(result.length < 6)
         {
            result = "000000".substr(0,6 - result.length) + result;
         }
         result = "#" + result;
         return result;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         if(val == FormatValue.INHERIT)
         {
            return UintProperty.doHash(inheritHashValue,seed);
         }
         return doHash(val as uint,seed);
      }
   }
}
