package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.FormatValue;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class EnumStringProperty extends Property
   {
      
      tlf_internal static var nextEnumHashValue:uint = 217287;
       
      private var _range:Object;
      
      public function EnumStringProperty(nameValue:String, defaultValue:String, inherited:Boolean, category:String, ... rest)
      {
         super(nameValue,defaultValue,inherited,category);
         this._range = createRange(rest);
      }
      
      tlf_internal static function createRange(rest:Array) : Object
      {
         var range:Object = new Object();
         for(var i:int = 0; i < rest.length; i++)
         {
            range[rest[i]] = nextEnumHashValue++;
         }
         range[FormatValue.INHERIT] = nextEnumHashValue++;
         return range;
      }
      
      public function get range() : Object
      {
         return Property.shallowCopy(this._range);
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(newObject === undefined)
         {
            return newObject;
         }
         if(this._range.hasOwnProperty(newObject))
         {
            return newObject;
         }
         Property.errorHandler(this,newObject);
         return currVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         return UintProperty.doHash(this._range[val],seed);
      }
   }
}
