package flashx.textLayout.formats
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.property.Property;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class TextLayoutFormatValueHolder implements ITextLayoutFormat
   {
      
      private static const emptyCoreStyles:Object = new Object();
       
      private var _coreStyles:Object;
      
      public function TextLayoutFormatValueHolder(initialValues:ITextLayoutFormat = null)
      {
         super();
         this._coreStyles = emptyCoreStyles;
         this.initialize(initialValues);
      }
      
      public static function resetModifiedNoninheritedStyles(stylesObject:Object) : void
      {
         if(stylesObject.backgroundColor != TextLayoutFormat.backgroundColorProperty.defaultValue)
         {
            stylesObject.backgroundColor = TextLayoutFormat.backgroundColorProperty.defaultValue;
         }
         if(stylesObject.backgroundAlpha != TextLayoutFormat.backgroundAlphaProperty.defaultValue)
         {
            stylesObject.backgroundAlpha = TextLayoutFormat.backgroundAlphaProperty.defaultValue;
         }
         if(stylesObject.columnGap != TextLayoutFormat.columnGapProperty.defaultValue)
         {
            stylesObject.columnGap = TextLayoutFormat.columnGapProperty.defaultValue;
         }
         if(stylesObject.paddingLeft != TextLayoutFormat.paddingLeftProperty.defaultValue)
         {
            stylesObject.paddingLeft = TextLayoutFormat.paddingLeftProperty.defaultValue;
         }
         if(stylesObject.paddingTop != TextLayoutFormat.paddingTopProperty.defaultValue)
         {
            stylesObject.paddingTop = TextLayoutFormat.paddingTopProperty.defaultValue;
         }
         if(stylesObject.paddingRight != TextLayoutFormat.paddingRightProperty.defaultValue)
         {
            stylesObject.paddingRight = TextLayoutFormat.paddingRightProperty.defaultValue;
         }
         if(stylesObject.paddingBottom != TextLayoutFormat.paddingBottomProperty.defaultValue)
         {
            stylesObject.paddingBottom = TextLayoutFormat.paddingBottomProperty.defaultValue;
         }
         if(stylesObject.columnCount != TextLayoutFormat.columnCountProperty.defaultValue)
         {
            stylesObject.columnCount = TextLayoutFormat.columnCountProperty.defaultValue;
         }
         if(stylesObject.columnWidth != TextLayoutFormat.columnWidthProperty.defaultValue)
         {
            stylesObject.columnWidth = TextLayoutFormat.columnWidthProperty.defaultValue;
         }
         if(stylesObject.verticalAlign != TextLayoutFormat.verticalAlignProperty.defaultValue)
         {
            stylesObject.verticalAlign = TextLayoutFormat.verticalAlignProperty.defaultValue;
         }
         if(stylesObject.lineBreak != TextLayoutFormat.lineBreakProperty.defaultValue)
         {
            stylesObject.lineBreak = TextLayoutFormat.lineBreakProperty.defaultValue;
         }
      }
      
      private function initialize(initialValues:ITextLayoutFormat) : void
      {
         var prop:Property = null;
         var val:* = undefined;
         var holder:TextLayoutFormatValueHolder = null;
         var holderCoreStyles:Object = null;
         var s:* = null;
         if(initialValues)
         {
            holder = initialValues as TextLayoutFormatValueHolder;
            if(holder)
            {
               holderCoreStyles = holder._coreStyles;
               for(s in holderCoreStyles)
               {
                  this.writableCoreStyles()[s] = holderCoreStyles[s];
               }
            }
            else if(initialValues is TextLayoutFormat)
            {
               for each(prop in TextLayoutFormat.description)
               {
                  val = initialValues[prop.name];
                  if(val !== undefined)
                  {
                     this.writableCoreStyles()[prop.name] = val;
                  }
               }
            }
            else
            {
               for each(prop in TextLayoutFormat.description)
               {
                  val = initialValues[prop.name];
                  if(val !== undefined)
                  {
                     this[prop.name] = val;
                  }
               }
            }
         }
      }
      
      private function writableCoreStyles() : Object
      {
         if(this._coreStyles == emptyCoreStyles)
         {
            this._coreStyles = new Object();
         }
         return this._coreStyles;
      }
      
      public function get coreStyles() : Object
      {
         return this._coreStyles == emptyCoreStyles?null:this._coreStyles;
      }
      
      public function set coreStyles(val:Object) : void
      {
         this._coreStyles = Boolean(val)?val:emptyCoreStyles;
      }
      
      private function getCoreStyle(styleProp:String) : *
      {
         return this._coreStyles[styleProp];
      }
      
      private function setCoreStyle(styleProp:Property, currValue:*, newValue:*) : void
      {
         newValue = styleProp.setHelper(currValue,newValue);
         if(newValue !== undefined)
         {
            this.writableCoreStyles()[styleProp.name] = newValue;
         }
         else
         {
            delete this._coreStyles[styleProp.name];
         }
      }
      
      public function set format(incoming:ITextLayoutFormat) : void
      {
         var val:* = undefined;
         if(incoming == null)
         {
            this._coreStyles = emptyCoreStyles;
            return;
         }
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            this._coreStyles = holder._coreStyles == emptyCoreStyles?emptyCoreStyles:Property.shallowCopy(holder._coreStyles);
            return;
         }
         this._coreStyles = emptyCoreStyles;
         if((val = incoming.color) !== undefined)
         {
            this.color = val;
         }
         if((val = incoming.backgroundColor) !== undefined)
         {
            this.backgroundColor = val;
         }
         if((val = incoming.lineThrough) !== undefined)
         {
            this.lineThrough = val;
         }
         if((val = incoming.textAlpha) !== undefined)
         {
            this.textAlpha = val;
         }
         if((val = incoming.backgroundAlpha) !== undefined)
         {
            this.backgroundAlpha = val;
         }
         if((val = incoming.fontSize) !== undefined)
         {
            this.fontSize = val;
         }
         if((val = incoming.baselineShift) !== undefined)
         {
            this.baselineShift = val;
         }
         if((val = incoming.trackingLeft) !== undefined)
         {
            this.trackingLeft = val;
         }
         if((val = incoming.trackingRight) !== undefined)
         {
            this.trackingRight = val;
         }
         if((val = incoming.lineHeight) !== undefined)
         {
            this.lineHeight = val;
         }
         if((val = incoming.breakOpportunity) !== undefined)
         {
            this.breakOpportunity = val;
         }
         if((val = incoming.digitCase) !== undefined)
         {
            this.digitCase = val;
         }
         if((val = incoming.digitWidth) !== undefined)
         {
            this.digitWidth = val;
         }
         if((val = incoming.dominantBaseline) !== undefined)
         {
            this.dominantBaseline = val;
         }
         if((val = incoming.kerning) !== undefined)
         {
            this.kerning = val;
         }
         if((val = incoming.ligatureLevel) !== undefined)
         {
            this.ligatureLevel = val;
         }
         if((val = incoming.alignmentBaseline) !== undefined)
         {
            this.alignmentBaseline = val;
         }
         if((val = incoming.locale) !== undefined)
         {
            this.locale = val;
         }
         if((val = incoming.typographicCase) !== undefined)
         {
            this.typographicCase = val;
         }
         if((val = incoming.fontFamily) !== undefined)
         {
            this.fontFamily = val;
         }
         if((val = incoming.textDecoration) !== undefined)
         {
            this.textDecoration = val;
         }
         if((val = incoming.fontWeight) !== undefined)
         {
            this.fontWeight = val;
         }
         if((val = incoming.fontStyle) !== undefined)
         {
            this.fontStyle = val;
         }
         if((val = incoming.whiteSpaceCollapse) !== undefined)
         {
            this.whiteSpaceCollapse = val;
         }
         if((val = incoming.renderingMode) !== undefined)
         {
            this.renderingMode = val;
         }
         if((val = incoming.cffHinting) !== undefined)
         {
            this.cffHinting = val;
         }
         if((val = incoming.fontLookup) !== undefined)
         {
            this.fontLookup = val;
         }
         if((val = incoming.textRotation) !== undefined)
         {
            this.textRotation = val;
         }
         if((val = incoming.textIndent) !== undefined)
         {
            this.textIndent = val;
         }
         if((val = incoming.paragraphStartIndent) !== undefined)
         {
            this.paragraphStartIndent = val;
         }
         if((val = incoming.paragraphEndIndent) !== undefined)
         {
            this.paragraphEndIndent = val;
         }
         if((val = incoming.paragraphSpaceBefore) !== undefined)
         {
            this.paragraphSpaceBefore = val;
         }
         if((val = incoming.paragraphSpaceAfter) !== undefined)
         {
            this.paragraphSpaceAfter = val;
         }
         if((val = incoming.textAlign) !== undefined)
         {
            this.textAlign = val;
         }
         if((val = incoming.textAlignLast) !== undefined)
         {
            this.textAlignLast = val;
         }
         if((val = incoming.textJustify) !== undefined)
         {
            this.textJustify = val;
         }
         if((val = incoming.justificationRule) !== undefined)
         {
            this.justificationRule = val;
         }
         if((val = incoming.justificationStyle) !== undefined)
         {
            this.justificationStyle = val;
         }
         if((val = incoming.direction) !== undefined)
         {
            this.direction = val;
         }
         if((val = incoming.tabStops) !== undefined)
         {
            this.tabStops = val;
         }
         if((val = incoming.leadingModel) !== undefined)
         {
            this.leadingModel = val;
         }
         if((val = incoming.columnGap) !== undefined)
         {
            this.columnGap = val;
         }
         if((val = incoming.paddingLeft) !== undefined)
         {
            this.paddingLeft = val;
         }
         if((val = incoming.paddingTop) !== undefined)
         {
            this.paddingTop = val;
         }
         if((val = incoming.paddingRight) !== undefined)
         {
            this.paddingRight = val;
         }
         if((val = incoming.paddingBottom) !== undefined)
         {
            this.paddingBottom = val;
         }
         if((val = incoming.columnCount) !== undefined)
         {
            this.columnCount = val;
         }
         if((val = incoming.columnWidth) !== undefined)
         {
            this.columnWidth = val;
         }
         if((val = incoming.firstBaselineOffset) !== undefined)
         {
            this.firstBaselineOffset = val;
         }
         if((val = incoming.verticalAlign) !== undefined)
         {
            this.verticalAlign = val;
         }
         if((val = incoming.blockProgression) !== undefined)
         {
            this.blockProgression = val;
         }
         if((val = incoming.lineBreak) !== undefined)
         {
            this.lineBreak = val;
         }
      }
      
      public function concat(incoming:ITextLayoutFormat) : void
      {
         var holderCoreStyles:Object = null;
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            holderCoreStyles = holder._coreStyles;
            for(key in holderCoreStyles)
            {
               this[key] = TextLayoutFormat.description[key].concatHelper(this[key],holderCoreStyles[key]);
            }
            return;
         }
         this.color = TextLayoutFormat.colorProperty.concatHelper(this.color,incoming.color);
         this.backgroundColor = TextLayoutFormat.backgroundColorProperty.concatHelper(this.backgroundColor,incoming.backgroundColor);
         this.lineThrough = TextLayoutFormat.lineThroughProperty.concatHelper(this.lineThrough,incoming.lineThrough);
         this.textAlpha = TextLayoutFormat.textAlphaProperty.concatHelper(this.textAlpha,incoming.textAlpha);
         this.backgroundAlpha = TextLayoutFormat.backgroundAlphaProperty.concatHelper(this.backgroundAlpha,incoming.backgroundAlpha);
         this.fontSize = TextLayoutFormat.fontSizeProperty.concatHelper(this.fontSize,incoming.fontSize);
         this.baselineShift = TextLayoutFormat.baselineShiftProperty.concatHelper(this.baselineShift,incoming.baselineShift);
         this.trackingLeft = TextLayoutFormat.trackingLeftProperty.concatHelper(this.trackingLeft,incoming.trackingLeft);
         this.trackingRight = TextLayoutFormat.trackingRightProperty.concatHelper(this.trackingRight,incoming.trackingRight);
         this.lineHeight = TextLayoutFormat.lineHeightProperty.concatHelper(this.lineHeight,incoming.lineHeight);
         this.breakOpportunity = TextLayoutFormat.breakOpportunityProperty.concatHelper(this.breakOpportunity,incoming.breakOpportunity);
         this.digitCase = TextLayoutFormat.digitCaseProperty.concatHelper(this.digitCase,incoming.digitCase);
         this.digitWidth = TextLayoutFormat.digitWidthProperty.concatHelper(this.digitWidth,incoming.digitWidth);
         this.dominantBaseline = TextLayoutFormat.dominantBaselineProperty.concatHelper(this.dominantBaseline,incoming.dominantBaseline);
         this.kerning = TextLayoutFormat.kerningProperty.concatHelper(this.kerning,incoming.kerning);
         this.ligatureLevel = TextLayoutFormat.ligatureLevelProperty.concatHelper(this.ligatureLevel,incoming.ligatureLevel);
         this.alignmentBaseline = TextLayoutFormat.alignmentBaselineProperty.concatHelper(this.alignmentBaseline,incoming.alignmentBaseline);
         this.locale = TextLayoutFormat.localeProperty.concatHelper(this.locale,incoming.locale);
         this.typographicCase = TextLayoutFormat.typographicCaseProperty.concatHelper(this.typographicCase,incoming.typographicCase);
         this.fontFamily = TextLayoutFormat.fontFamilyProperty.concatHelper(this.fontFamily,incoming.fontFamily);
         this.textDecoration = TextLayoutFormat.textDecorationProperty.concatHelper(this.textDecoration,incoming.textDecoration);
         this.fontWeight = TextLayoutFormat.fontWeightProperty.concatHelper(this.fontWeight,incoming.fontWeight);
         this.fontStyle = TextLayoutFormat.fontStyleProperty.concatHelper(this.fontStyle,incoming.fontStyle);
         this.whiteSpaceCollapse = TextLayoutFormat.whiteSpaceCollapseProperty.concatHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse);
         this.renderingMode = TextLayoutFormat.renderingModeProperty.concatHelper(this.renderingMode,incoming.renderingMode);
         this.cffHinting = TextLayoutFormat.cffHintingProperty.concatHelper(this.cffHinting,incoming.cffHinting);
         this.fontLookup = TextLayoutFormat.fontLookupProperty.concatHelper(this.fontLookup,incoming.fontLookup);
         this.textRotation = TextLayoutFormat.textRotationProperty.concatHelper(this.textRotation,incoming.textRotation);
         this.textIndent = TextLayoutFormat.textIndentProperty.concatHelper(this.textIndent,incoming.textIndent);
         this.paragraphStartIndent = TextLayoutFormat.paragraphStartIndentProperty.concatHelper(this.paragraphStartIndent,incoming.paragraphStartIndent);
         this.paragraphEndIndent = TextLayoutFormat.paragraphEndIndentProperty.concatHelper(this.paragraphEndIndent,incoming.paragraphEndIndent);
         this.paragraphSpaceBefore = TextLayoutFormat.paragraphSpaceBeforeProperty.concatHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore);
         this.paragraphSpaceAfter = TextLayoutFormat.paragraphSpaceAfterProperty.concatHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter);
         this.textAlign = TextLayoutFormat.textAlignProperty.concatHelper(this.textAlign,incoming.textAlign);
         this.textAlignLast = TextLayoutFormat.textAlignLastProperty.concatHelper(this.textAlignLast,incoming.textAlignLast);
         this.textJustify = TextLayoutFormat.textJustifyProperty.concatHelper(this.textJustify,incoming.textJustify);
         this.justificationRule = TextLayoutFormat.justificationRuleProperty.concatHelper(this.justificationRule,incoming.justificationRule);
         this.justificationStyle = TextLayoutFormat.justificationStyleProperty.concatHelper(this.justificationStyle,incoming.justificationStyle);
         this.direction = TextLayoutFormat.directionProperty.concatHelper(this.direction,incoming.direction);
         this.tabStops = TextLayoutFormat.tabStopsProperty.concatHelper(this.tabStops,incoming.tabStops);
         this.leadingModel = TextLayoutFormat.leadingModelProperty.concatHelper(this.leadingModel,incoming.leadingModel);
         this.columnGap = TextLayoutFormat.columnGapProperty.concatHelper(this.columnGap,incoming.columnGap);
         this.paddingLeft = TextLayoutFormat.paddingLeftProperty.concatHelper(this.paddingLeft,incoming.paddingLeft);
         this.paddingTop = TextLayoutFormat.paddingTopProperty.concatHelper(this.paddingTop,incoming.paddingTop);
         this.paddingRight = TextLayoutFormat.paddingRightProperty.concatHelper(this.paddingRight,incoming.paddingRight);
         this.paddingBottom = TextLayoutFormat.paddingBottomProperty.concatHelper(this.paddingBottom,incoming.paddingBottom);
         this.columnCount = TextLayoutFormat.columnCountProperty.concatHelper(this.columnCount,incoming.columnCount);
         this.columnWidth = TextLayoutFormat.columnWidthProperty.concatHelper(this.columnWidth,incoming.columnWidth);
         this.firstBaselineOffset = TextLayoutFormat.firstBaselineOffsetProperty.concatHelper(this.firstBaselineOffset,incoming.firstBaselineOffset);
         this.verticalAlign = TextLayoutFormat.verticalAlignProperty.concatHelper(this.verticalAlign,incoming.verticalAlign);
         this.blockProgression = TextLayoutFormat.blockProgressionProperty.concatHelper(this.blockProgression,incoming.blockProgression);
         this.lineBreak = TextLayoutFormat.lineBreakProperty.concatHelper(this.lineBreak,incoming.lineBreak);
      }
      
      public function concatInheritOnly(incoming:ITextLayoutFormat) : void
      {
         var holderCoreStyles:Object = null;
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            holderCoreStyles = holder._coreStyles;
            for(key in holderCoreStyles)
            {
               this[key] = TextLayoutFormat.description[key].concatInheritOnlyHelper(this[key],holderCoreStyles[key]);
            }
            return;
         }
         this.color = TextLayoutFormat.colorProperty.concatInheritOnlyHelper(this.color,incoming.color);
         this.backgroundColor = TextLayoutFormat.backgroundColorProperty.concatInheritOnlyHelper(this.backgroundColor,incoming.backgroundColor);
         this.lineThrough = TextLayoutFormat.lineThroughProperty.concatInheritOnlyHelper(this.lineThrough,incoming.lineThrough);
         this.textAlpha = TextLayoutFormat.textAlphaProperty.concatInheritOnlyHelper(this.textAlpha,incoming.textAlpha);
         this.backgroundAlpha = TextLayoutFormat.backgroundAlphaProperty.concatInheritOnlyHelper(this.backgroundAlpha,incoming.backgroundAlpha);
         this.fontSize = TextLayoutFormat.fontSizeProperty.concatInheritOnlyHelper(this.fontSize,incoming.fontSize);
         this.baselineShift = TextLayoutFormat.baselineShiftProperty.concatInheritOnlyHelper(this.baselineShift,incoming.baselineShift);
         this.trackingLeft = TextLayoutFormat.trackingLeftProperty.concatInheritOnlyHelper(this.trackingLeft,incoming.trackingLeft);
         this.trackingRight = TextLayoutFormat.trackingRightProperty.concatInheritOnlyHelper(this.trackingRight,incoming.trackingRight);
         this.lineHeight = TextLayoutFormat.lineHeightProperty.concatInheritOnlyHelper(this.lineHeight,incoming.lineHeight);
         this.breakOpportunity = TextLayoutFormat.breakOpportunityProperty.concatInheritOnlyHelper(this.breakOpportunity,incoming.breakOpportunity);
         this.digitCase = TextLayoutFormat.digitCaseProperty.concatInheritOnlyHelper(this.digitCase,incoming.digitCase);
         this.digitWidth = TextLayoutFormat.digitWidthProperty.concatInheritOnlyHelper(this.digitWidth,incoming.digitWidth);
         this.dominantBaseline = TextLayoutFormat.dominantBaselineProperty.concatInheritOnlyHelper(this.dominantBaseline,incoming.dominantBaseline);
         this.kerning = TextLayoutFormat.kerningProperty.concatInheritOnlyHelper(this.kerning,incoming.kerning);
         this.ligatureLevel = TextLayoutFormat.ligatureLevelProperty.concatInheritOnlyHelper(this.ligatureLevel,incoming.ligatureLevel);
         this.alignmentBaseline = TextLayoutFormat.alignmentBaselineProperty.concatInheritOnlyHelper(this.alignmentBaseline,incoming.alignmentBaseline);
         this.locale = TextLayoutFormat.localeProperty.concatInheritOnlyHelper(this.locale,incoming.locale);
         this.typographicCase = TextLayoutFormat.typographicCaseProperty.concatInheritOnlyHelper(this.typographicCase,incoming.typographicCase);
         this.fontFamily = TextLayoutFormat.fontFamilyProperty.concatInheritOnlyHelper(this.fontFamily,incoming.fontFamily);
         this.textDecoration = TextLayoutFormat.textDecorationProperty.concatInheritOnlyHelper(this.textDecoration,incoming.textDecoration);
         this.fontWeight = TextLayoutFormat.fontWeightProperty.concatInheritOnlyHelper(this.fontWeight,incoming.fontWeight);
         this.fontStyle = TextLayoutFormat.fontStyleProperty.concatInheritOnlyHelper(this.fontStyle,incoming.fontStyle);
         this.whiteSpaceCollapse = TextLayoutFormat.whiteSpaceCollapseProperty.concatInheritOnlyHelper(this.whiteSpaceCollapse,incoming.whiteSpaceCollapse);
         this.renderingMode = TextLayoutFormat.renderingModeProperty.concatInheritOnlyHelper(this.renderingMode,incoming.renderingMode);
         this.cffHinting = TextLayoutFormat.cffHintingProperty.concatInheritOnlyHelper(this.cffHinting,incoming.cffHinting);
         this.fontLookup = TextLayoutFormat.fontLookupProperty.concatInheritOnlyHelper(this.fontLookup,incoming.fontLookup);
         this.textRotation = TextLayoutFormat.textRotationProperty.concatInheritOnlyHelper(this.textRotation,incoming.textRotation);
         this.textIndent = TextLayoutFormat.textIndentProperty.concatInheritOnlyHelper(this.textIndent,incoming.textIndent);
         this.paragraphStartIndent = TextLayoutFormat.paragraphStartIndentProperty.concatInheritOnlyHelper(this.paragraphStartIndent,incoming.paragraphStartIndent);
         this.paragraphEndIndent = TextLayoutFormat.paragraphEndIndentProperty.concatInheritOnlyHelper(this.paragraphEndIndent,incoming.paragraphEndIndent);
         this.paragraphSpaceBefore = TextLayoutFormat.paragraphSpaceBeforeProperty.concatInheritOnlyHelper(this.paragraphSpaceBefore,incoming.paragraphSpaceBefore);
         this.paragraphSpaceAfter = TextLayoutFormat.paragraphSpaceAfterProperty.concatInheritOnlyHelper(this.paragraphSpaceAfter,incoming.paragraphSpaceAfter);
         this.textAlign = TextLayoutFormat.textAlignProperty.concatInheritOnlyHelper(this.textAlign,incoming.textAlign);
         this.textAlignLast = TextLayoutFormat.textAlignLastProperty.concatInheritOnlyHelper(this.textAlignLast,incoming.textAlignLast);
         this.textJustify = TextLayoutFormat.textJustifyProperty.concatInheritOnlyHelper(this.textJustify,incoming.textJustify);
         this.justificationRule = TextLayoutFormat.justificationRuleProperty.concatInheritOnlyHelper(this.justificationRule,incoming.justificationRule);
         this.justificationStyle = TextLayoutFormat.justificationStyleProperty.concatInheritOnlyHelper(this.justificationStyle,incoming.justificationStyle);
         this.direction = TextLayoutFormat.directionProperty.concatInheritOnlyHelper(this.direction,incoming.direction);
         this.tabStops = TextLayoutFormat.tabStopsProperty.concatInheritOnlyHelper(this.tabStops,incoming.tabStops);
         this.leadingModel = TextLayoutFormat.leadingModelProperty.concatInheritOnlyHelper(this.leadingModel,incoming.leadingModel);
         this.columnGap = TextLayoutFormat.columnGapProperty.concatInheritOnlyHelper(this.columnGap,incoming.columnGap);
         this.paddingLeft = TextLayoutFormat.paddingLeftProperty.concatInheritOnlyHelper(this.paddingLeft,incoming.paddingLeft);
         this.paddingTop = TextLayoutFormat.paddingTopProperty.concatInheritOnlyHelper(this.paddingTop,incoming.paddingTop);
         this.paddingRight = TextLayoutFormat.paddingRightProperty.concatInheritOnlyHelper(this.paddingRight,incoming.paddingRight);
         this.paddingBottom = TextLayoutFormat.paddingBottomProperty.concatInheritOnlyHelper(this.paddingBottom,incoming.paddingBottom);
         this.columnCount = TextLayoutFormat.columnCountProperty.concatInheritOnlyHelper(this.columnCount,incoming.columnCount);
         this.columnWidth = TextLayoutFormat.columnWidthProperty.concatInheritOnlyHelper(this.columnWidth,incoming.columnWidth);
         this.firstBaselineOffset = TextLayoutFormat.firstBaselineOffsetProperty.concatInheritOnlyHelper(this.firstBaselineOffset,incoming.firstBaselineOffset);
         this.verticalAlign = TextLayoutFormat.verticalAlignProperty.concatInheritOnlyHelper(this.verticalAlign,incoming.verticalAlign);
         this.blockProgression = TextLayoutFormat.blockProgressionProperty.concatInheritOnlyHelper(this.blockProgression,incoming.blockProgression);
         this.lineBreak = TextLayoutFormat.lineBreakProperty.concatInheritOnlyHelper(this.lineBreak,incoming.lineBreak);
      }
      
      public function apply(incoming:ITextLayoutFormat) : void
      {
         var val:* = undefined;
         var holderCoreStyles:Object = null;
         var key:* = null;
         var holder:TextLayoutFormatValueHolder = incoming as TextLayoutFormatValueHolder;
         if(holder)
         {
            holderCoreStyles = holder._coreStyles;
            for(key in holderCoreStyles)
            {
               this[key] = holderCoreStyles[key];
            }
            return;
         }
         if((val = incoming.color) !== undefined)
         {
            this.color = val;
         }
         if((val = incoming.backgroundColor) !== undefined)
         {
            this.backgroundColor = val;
         }
         if((val = incoming.lineThrough) !== undefined)
         {
            this.lineThrough = val;
         }
         if((val = incoming.textAlpha) !== undefined)
         {
            this.textAlpha = val;
         }
         if((val = incoming.backgroundAlpha) !== undefined)
         {
            this.backgroundAlpha = val;
         }
         if((val = incoming.fontSize) !== undefined)
         {
            this.fontSize = val;
         }
         if((val = incoming.baselineShift) !== undefined)
         {
            this.baselineShift = val;
         }
         if((val = incoming.trackingLeft) !== undefined)
         {
            this.trackingLeft = val;
         }
         if((val = incoming.trackingRight) !== undefined)
         {
            this.trackingRight = val;
         }
         if((val = incoming.lineHeight) !== undefined)
         {
            this.lineHeight = val;
         }
         if((val = incoming.breakOpportunity) !== undefined)
         {
            this.breakOpportunity = val;
         }
         if((val = incoming.digitCase) !== undefined)
         {
            this.digitCase = val;
         }
         if((val = incoming.digitWidth) !== undefined)
         {
            this.digitWidth = val;
         }
         if((val = incoming.dominantBaseline) !== undefined)
         {
            this.dominantBaseline = val;
         }
         if((val = incoming.kerning) !== undefined)
         {
            this.kerning = val;
         }
         if((val = incoming.ligatureLevel) !== undefined)
         {
            this.ligatureLevel = val;
         }
         if((val = incoming.alignmentBaseline) !== undefined)
         {
            this.alignmentBaseline = val;
         }
         if((val = incoming.locale) !== undefined)
         {
            this.locale = val;
         }
         if((val = incoming.typographicCase) !== undefined)
         {
            this.typographicCase = val;
         }
         if((val = incoming.fontFamily) !== undefined)
         {
            this.fontFamily = val;
         }
         if((val = incoming.textDecoration) !== undefined)
         {
            this.textDecoration = val;
         }
         if((val = incoming.fontWeight) !== undefined)
         {
            this.fontWeight = val;
         }
         if((val = incoming.fontStyle) !== undefined)
         {
            this.fontStyle = val;
         }
         if((val = incoming.whiteSpaceCollapse) !== undefined)
         {
            this.whiteSpaceCollapse = val;
         }
         if((val = incoming.renderingMode) !== undefined)
         {
            this.renderingMode = val;
         }
         if((val = incoming.cffHinting) !== undefined)
         {
            this.cffHinting = val;
         }
         if((val = incoming.fontLookup) !== undefined)
         {
            this.fontLookup = val;
         }
         if((val = incoming.textRotation) !== undefined)
         {
            this.textRotation = val;
         }
         if((val = incoming.textIndent) !== undefined)
         {
            this.textIndent = val;
         }
         if((val = incoming.paragraphStartIndent) !== undefined)
         {
            this.paragraphStartIndent = val;
         }
         if((val = incoming.paragraphEndIndent) !== undefined)
         {
            this.paragraphEndIndent = val;
         }
         if((val = incoming.paragraphSpaceBefore) !== undefined)
         {
            this.paragraphSpaceBefore = val;
         }
         if((val = incoming.paragraphSpaceAfter) !== undefined)
         {
            this.paragraphSpaceAfter = val;
         }
         if((val = incoming.textAlign) !== undefined)
         {
            this.textAlign = val;
         }
         if((val = incoming.textAlignLast) !== undefined)
         {
            this.textAlignLast = val;
         }
         if((val = incoming.textJustify) !== undefined)
         {
            this.textJustify = val;
         }
         if((val = incoming.justificationRule) !== undefined)
         {
            this.justificationRule = val;
         }
         if((val = incoming.justificationStyle) !== undefined)
         {
            this.justificationStyle = val;
         }
         if((val = incoming.direction) !== undefined)
         {
            this.direction = val;
         }
         if((val = incoming.tabStops) !== undefined)
         {
            this.tabStops = val;
         }
         if((val = incoming.leadingModel) !== undefined)
         {
            this.leadingModel = val;
         }
         if((val = incoming.columnGap) !== undefined)
         {
            this.columnGap = val;
         }
         if((val = incoming.paddingLeft) !== undefined)
         {
            this.paddingLeft = val;
         }
         if((val = incoming.paddingTop) !== undefined)
         {
            this.paddingTop = val;
         }
         if((val = incoming.paddingRight) !== undefined)
         {
            this.paddingRight = val;
         }
         if((val = incoming.paddingBottom) !== undefined)
         {
            this.paddingBottom = val;
         }
         if((val = incoming.columnCount) !== undefined)
         {
            this.columnCount = val;
         }
         if((val = incoming.columnWidth) !== undefined)
         {
            this.columnWidth = val;
         }
         if((val = incoming.firstBaselineOffset) !== undefined)
         {
            this.firstBaselineOffset = val;
         }
         if((val = incoming.verticalAlign) !== undefined)
         {
            this.verticalAlign = val;
         }
         if((val = incoming.blockProgression) !== undefined)
         {
            this.blockProgression = val;
         }
         if((val = incoming.lineBreak) !== undefined)
         {
            this.lineBreak = val;
         }
      }
      
      public function get color() : *
      {
         return this._coreStyles.color;
      }
      
      public function set color(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.colorProperty,this.color,value);
      }
      
      public function get backgroundColor() : *
      {
         return this._coreStyles.backgroundColor;
      }
      
      public function set backgroundColor(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.backgroundColorProperty,this.backgroundColor,value);
      }
      
      public function get lineThrough() : *
      {
         return this._coreStyles.lineThrough;
      }
      
      public function set lineThrough(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.lineThroughProperty,this.lineThrough,value);
      }
      
      public function get textAlpha() : *
      {
         return this._coreStyles.textAlpha;
      }
      
      public function set textAlpha(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textAlphaProperty,this.textAlpha,value);
      }
      
      public function get backgroundAlpha() : *
      {
         return this._coreStyles.backgroundAlpha;
      }
      
      public function set backgroundAlpha(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.backgroundAlphaProperty,this.backgroundAlpha,value);
      }
      
      public function get fontSize() : *
      {
         return this._coreStyles.fontSize;
      }
      
      public function set fontSize(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.fontSizeProperty,this.fontSize,value);
      }
      
      public function get baselineShift() : *
      {
         return this._coreStyles.baselineShift;
      }
      
      public function set baselineShift(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.baselineShiftProperty,this.baselineShift,value);
      }
      
      public function get trackingLeft() : *
      {
         return this._coreStyles.trackingLeft;
      }
      
      public function set trackingLeft(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.trackingLeftProperty,this.trackingLeft,value);
      }
      
      public function get trackingRight() : *
      {
         return this._coreStyles.trackingRight;
      }
      
      public function set trackingRight(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.trackingRightProperty,this.trackingRight,value);
      }
      
      public function get lineHeight() : *
      {
         return this._coreStyles.lineHeight;
      }
      
      public function set lineHeight(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.lineHeightProperty,this.lineHeight,value);
      }
      
      public function get breakOpportunity() : *
      {
         return this._coreStyles.breakOpportunity;
      }
      
      public function set breakOpportunity(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.breakOpportunityProperty,this.breakOpportunity,value);
      }
      
      public function get digitCase() : *
      {
         return this._coreStyles.digitCase;
      }
      
      public function set digitCase(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.digitCaseProperty,this.digitCase,value);
      }
      
      public function get digitWidth() : *
      {
         return this._coreStyles.digitWidth;
      }
      
      public function set digitWidth(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.digitWidthProperty,this.digitWidth,value);
      }
      
      public function get dominantBaseline() : *
      {
         return this._coreStyles.dominantBaseline;
      }
      
      public function set dominantBaseline(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.dominantBaselineProperty,this.dominantBaseline,value);
      }
      
      public function get kerning() : *
      {
         return this._coreStyles.kerning;
      }
      
      public function set kerning(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.kerningProperty,this.kerning,value);
      }
      
      public function get ligatureLevel() : *
      {
         return this._coreStyles.ligatureLevel;
      }
      
      public function set ligatureLevel(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.ligatureLevelProperty,this.ligatureLevel,value);
      }
      
      public function get alignmentBaseline() : *
      {
         return this._coreStyles.alignmentBaseline;
      }
      
      public function set alignmentBaseline(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.alignmentBaselineProperty,this.alignmentBaseline,value);
      }
      
      public function get locale() : *
      {
         return this._coreStyles.locale;
      }
      
      public function set locale(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.localeProperty,this.locale,value);
      }
      
      public function get typographicCase() : *
      {
         return this._coreStyles.typographicCase;
      }
      
      public function set typographicCase(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.typographicCaseProperty,this.typographicCase,value);
      }
      
      public function get fontFamily() : *
      {
         return this._coreStyles.fontFamily;
      }
      
      public function set fontFamily(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.fontFamilyProperty,this.fontFamily,value);
      }
      
      public function get textDecoration() : *
      {
         return this._coreStyles.textDecoration;
      }
      
      public function set textDecoration(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textDecorationProperty,this.textDecoration,value);
      }
      
      public function get fontWeight() : *
      {
         return this._coreStyles.fontWeight;
      }
      
      public function set fontWeight(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.fontWeightProperty,this.fontWeight,value);
      }
      
      public function get fontStyle() : *
      {
         return this._coreStyles.fontStyle;
      }
      
      public function set fontStyle(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.fontStyleProperty,this.fontStyle,value);
      }
      
      public function get whiteSpaceCollapse() : *
      {
         return this._coreStyles.whiteSpaceCollapse;
      }
      
      public function set whiteSpaceCollapse(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.whiteSpaceCollapseProperty,this.whiteSpaceCollapse,value);
      }
      
      public function get renderingMode() : *
      {
         return this._coreStyles.renderingMode;
      }
      
      public function set renderingMode(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.renderingModeProperty,this.renderingMode,value);
      }
      
      public function get cffHinting() : *
      {
         return this._coreStyles.cffHinting;
      }
      
      public function set cffHinting(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.cffHintingProperty,this.cffHinting,value);
      }
      
      public function get fontLookup() : *
      {
         return this._coreStyles.fontLookup;
      }
      
      public function set fontLookup(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.fontLookupProperty,this.fontLookup,value);
      }
      
      public function get textRotation() : *
      {
         return this._coreStyles.textRotation;
      }
      
      public function set textRotation(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textRotationProperty,this.textRotation,value);
      }
      
      public function get textIndent() : *
      {
         return this._coreStyles.textIndent;
      }
      
      public function set textIndent(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textIndentProperty,this.textIndent,value);
      }
      
      public function get paragraphStartIndent() : *
      {
         return this._coreStyles.paragraphStartIndent;
      }
      
      public function set paragraphStartIndent(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paragraphStartIndentProperty,this.paragraphStartIndent,value);
      }
      
      public function get paragraphEndIndent() : *
      {
         return this._coreStyles.paragraphEndIndent;
      }
      
      public function set paragraphEndIndent(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paragraphEndIndentProperty,this.paragraphEndIndent,value);
      }
      
      public function get paragraphSpaceBefore() : *
      {
         return this._coreStyles.paragraphSpaceBefore;
      }
      
      public function set paragraphSpaceBefore(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paragraphSpaceBeforeProperty,this.paragraphSpaceBefore,value);
      }
      
      public function get paragraphSpaceAfter() : *
      {
         return this._coreStyles.paragraphSpaceAfter;
      }
      
      public function set paragraphSpaceAfter(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paragraphSpaceAfterProperty,this.paragraphSpaceAfter,value);
      }
      
      public function get textAlign() : *
      {
         return this._coreStyles.textAlign;
      }
      
      public function set textAlign(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textAlignProperty,this.textAlign,value);
      }
      
      public function get textAlignLast() : *
      {
         return this._coreStyles.textAlignLast;
      }
      
      public function set textAlignLast(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textAlignLastProperty,this.textAlignLast,value);
      }
      
      public function get textJustify() : *
      {
         return this._coreStyles.textJustify;
      }
      
      public function set textJustify(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.textJustifyProperty,this.textJustify,value);
      }
      
      public function get justificationRule() : *
      {
         return this._coreStyles.justificationRule;
      }
      
      public function set justificationRule(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.justificationRuleProperty,this.justificationRule,value);
      }
      
      public function get justificationStyle() : *
      {
         return this._coreStyles.justificationStyle;
      }
      
      public function set justificationStyle(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.justificationStyleProperty,this.justificationStyle,value);
      }
      
      public function get direction() : *
      {
         return this._coreStyles.direction;
      }
      
      public function set direction(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.directionProperty,this.direction,value);
      }
      
      public function get tabStops() : *
      {
         return this._coreStyles.tabStops;
      }
      
      public function set tabStops(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.tabStopsProperty,this.tabStops,value);
      }
      
      public function get leadingModel() : *
      {
         return this._coreStyles.leadingModel;
      }
      
      public function set leadingModel(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.leadingModelProperty,this.leadingModel,value);
      }
      
      public function get columnGap() : *
      {
         return this._coreStyles.columnGap;
      }
      
      public function set columnGap(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.columnGapProperty,this.columnGap,value);
      }
      
      public function get paddingLeft() : *
      {
         return this._coreStyles.paddingLeft;
      }
      
      public function set paddingLeft(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paddingLeftProperty,this.paddingLeft,value);
      }
      
      public function get paddingTop() : *
      {
         return this._coreStyles.paddingTop;
      }
      
      public function set paddingTop(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paddingTopProperty,this.paddingTop,value);
      }
      
      public function get paddingRight() : *
      {
         return this._coreStyles.paddingRight;
      }
      
      public function set paddingRight(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paddingRightProperty,this.paddingRight,value);
      }
      
      public function get paddingBottom() : *
      {
         return this._coreStyles.paddingBottom;
      }
      
      public function set paddingBottom(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.paddingBottomProperty,this.paddingBottom,value);
      }
      
      public function get columnCount() : *
      {
         return this._coreStyles.columnCount;
      }
      
      public function set columnCount(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.columnCountProperty,this.columnCount,value);
      }
      
      public function get columnWidth() : *
      {
         return this._coreStyles.columnWidth;
      }
      
      public function set columnWidth(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.columnWidthProperty,this.columnWidth,value);
      }
      
      public function get firstBaselineOffset() : *
      {
         return this._coreStyles.firstBaselineOffset;
      }
      
      public function set firstBaselineOffset(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.firstBaselineOffsetProperty,this.firstBaselineOffset,value);
      }
      
      public function get verticalAlign() : *
      {
         return this._coreStyles.verticalAlign;
      }
      
      public function set verticalAlign(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.verticalAlignProperty,this.verticalAlign,value);
      }
      
      public function get blockProgression() : *
      {
         return this._coreStyles.blockProgression;
      }
      
      public function set blockProgression(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.blockProgressionProperty,this.blockProgression,value);
      }
      
      public function get lineBreak() : *
      {
         return this._coreStyles.lineBreak;
      }
      
      public function set lineBreak(value:*) : void
      {
         this.setCoreStyle(TextLayoutFormat.lineBreakProperty,this.lineBreak,value);
      }
   }
}
