package flashx.textLayout.formats
{
   import flashx.textLayout.property.NumberProperty;
   import flashx.textLayout.property.EnumStringProperty;
   import flashx.textLayout.property.StringProperty;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.property.Property;
   import flash.text.engine.TabAlignment;
   
   use namespace tlf_internal;
   
   public class TabStopFormat implements flashx.textLayout.formats.ITabStopFormat
   {
      
      private static var _positionProperty:NumberProperty = new NumberProperty("position",0,false,Category.TABSTOP,0,10000);
      
      private static var _alignmentProperty:EnumStringProperty = new EnumStringProperty("alignment",TabAlignment.START,false,Category.TABSTOP,TabAlignment.START,TabAlignment.CENTER,TabAlignment.END,TabAlignment.DECIMAL);
      
      private static var _decimalAlignmentTokenProperty:StringProperty = new StringProperty("decimalAlignmentToken",null,false,Category.TABSTOP);
      
      private static var _description:Object = {
         "position":_positionProperty,
         "alignment":_alignmentProperty,
         "decimalAlignmentToken":_decimalAlignmentTokenProperty
      };
      
      private static var _emptyTabStopFormat:flashx.textLayout.formats.ITabStopFormat;
      
      private static var _defaults:flashx.textLayout.formats.TabStopFormat;
       
      private var _position;
      
      private var _alignment;
      
      private var _decimalAlignmentToken;
      
      public function TabStopFormat(initialValues:flashx.textLayout.formats.ITabStopFormat = null)
      {
         super();
         if(initialValues)
         {
            this.apply(initialValues);
         }
      }
      
      tlf_internal static function get positionProperty() : NumberProperty
      {
         return _positionProperty;
      }
      
      tlf_internal static function get alignmentProperty() : EnumStringProperty
      {
         return _alignmentProperty;
      }
      
      tlf_internal static function get decimalAlignmentTokenProperty() : StringProperty
      {
         return _decimalAlignmentTokenProperty;
      }
      
      tlf_internal static function get description() : Object
      {
         return _description;
      }
      
      tlf_internal static function get emptyTabStopFormat() : flashx.textLayout.formats.ITabStopFormat
      {
         if(_emptyTabStopFormat == null)
         {
            _emptyTabStopFormat = new flashx.textLayout.formats.TabStopFormat();
         }
         return _emptyTabStopFormat;
      }
      
      public static function isEqual(p1:flashx.textLayout.formats.ITabStopFormat, p2:flashx.textLayout.formats.ITabStopFormat) : Boolean
      {
         if(p1 == null)
         {
            p1 = emptyTabStopFormat;
         }
         if(p2 == null)
         {
            p2 = emptyTabStopFormat;
         }
         if(p1 == p2)
         {
            return true;
         }
         if(!_positionProperty.equalHelper(p1.position,p2.position))
         {
            return false;
         }
         if(!_alignmentProperty.equalHelper(p1.alignment,p2.alignment))
         {
            return false;
         }
         if(!_decimalAlignmentTokenProperty.equalHelper(p1.decimalAlignmentToken,p2.decimalAlignmentToken))
         {
            return false;
         }
         return true;
      }
      
      public static function get defaultFormat() : flashx.textLayout.formats.ITabStopFormat
      {
         if(_defaults == null)
         {
            _defaults = new flashx.textLayout.formats.TabStopFormat();
            Property.defaultsAllHelper(_description,_defaults);
         }
         return _defaults;
      }
      
      public function get position() : *
      {
         return this._position;
      }
      
      public function set position(newValue:*) : void
      {
         this._position = _positionProperty.setHelper(this._position,newValue);
      }
      
      public function get alignment() : *
      {
         return this._alignment;
      }
      
      public function set alignment(newValue:*) : void
      {
         this._alignment = _alignmentProperty.setHelper(this._alignment,newValue);
      }
      
      public function get decimalAlignmentToken() : *
      {
         return this._decimalAlignmentToken;
      }
      
      public function set decimalAlignmentToken(newValue:*) : void
      {
         this._decimalAlignmentToken = _decimalAlignmentTokenProperty.setHelper(this._decimalAlignmentToken,newValue);
      }
      
      public function copy(values:flashx.textLayout.formats.ITabStopFormat) : void
      {
         if(values == null)
         {
            values = emptyTabStopFormat;
         }
         this.position = values.position;
         this.alignment = values.alignment;
         this.decimalAlignmentToken = values.decimalAlignmentToken;
      }
      
      public function concat(incoming:flashx.textLayout.formats.ITabStopFormat) : void
      {
         this.position = _positionProperty.concatHelper(this.position,incoming.position);
         this.alignment = _alignmentProperty.concatHelper(this.alignment,incoming.alignment);
         this.decimalAlignmentToken = _decimalAlignmentTokenProperty.concatHelper(this.decimalAlignmentToken,incoming.decimalAlignmentToken);
      }
      
      public function concatInheritOnly(incoming:flashx.textLayout.formats.ITabStopFormat) : void
      {
         this.position = _positionProperty.concatInheritOnlyHelper(this.position,incoming.position);
         this.alignment = _alignmentProperty.concatInheritOnlyHelper(this.alignment,incoming.alignment);
         this.decimalAlignmentToken = _decimalAlignmentTokenProperty.concatInheritOnlyHelper(this.decimalAlignmentToken,incoming.decimalAlignmentToken);
      }
      
      public function apply(incoming:flashx.textLayout.formats.ITabStopFormat) : void
      {
         var val:* = undefined;
         if((val = incoming.position) !== undefined)
         {
            this.position = val;
         }
         if((val = incoming.alignment) !== undefined)
         {
            this.alignment = val;
         }
         if((val = incoming.decimalAlignmentToken) !== undefined)
         {
            this.decimalAlignmentToken = val;
         }
      }
      
      public function removeMatching(incoming:flashx.textLayout.formats.ITabStopFormat) : void
      {
         if(incoming == null)
         {
            return;
         }
         if(_positionProperty.equalHelper(this.position,incoming.position))
         {
            this.position = undefined;
         }
         if(_alignmentProperty.equalHelper(this.alignment,incoming.alignment))
         {
            this.alignment = undefined;
         }
         if(_decimalAlignmentTokenProperty.equalHelper(this.decimalAlignmentToken,incoming.decimalAlignmentToken))
         {
            this.decimalAlignmentToken = undefined;
         }
      }
      
      public function removeClashing(incoming:flashx.textLayout.formats.ITabStopFormat) : void
      {
         if(incoming == null)
         {
            return;
         }
         if(!_positionProperty.equalHelper(this.position,incoming.position))
         {
            this.position = undefined;
         }
         if(!_alignmentProperty.equalHelper(this.alignment,incoming.alignment))
         {
            this.alignment = undefined;
         }
         if(!_decimalAlignmentTokenProperty.equalHelper(this.decimalAlignmentToken,incoming.decimalAlignmentToken))
         {
            this.decimalAlignmentToken = undefined;
         }
      }
   }
}
