package flashx.textLayout.factory
{
   import flash.display.Sprite;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.compose.SimpleCompose;
   import flash.geom.Rectangle;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.compose.ISWFContext;
   import flash.text.engine.TextLine;
   import flash.text.engine.TextBlock;
   import flash.text.engine.TextLineValidity;
   import flashx.textLayout.compose.IFlowComposer;
   import flashx.textLayout.container.ScrollPolicy;
   
   use namespace tlf_internal;
   
   [Exclude(kind="method",name="getNextTruncationPosition")]
   [Exclude(kind="method",name="doesComposedTextFit")]
   [Exclude(kind="method",name="callbackWithTextLines")]
   [Exclude(kind="method",name="setContentBounds")]
   [Exclude(kind="property",name="containerController")]
   public class TextLineFactoryBase
   {
      
      private static var _tc:Sprite = new Sprite();
      
      tlf_internal static var _factoryComposer:SimpleCompose = new SimpleCompose();
      
      protected static var _truncationLineIndex:int;
      
      protected static var _pass0Lines:Array;
       
      private var _compositionBounds:Rectangle;
      
      private var _contentBounds:Rectangle;
      
      protected var _isTruncated:Boolean = false;
      
      private var _horizontalScrollPolicy:String;
      
      private var _verticalScrollPolicy:String;
      
      private var _truncationOptions:flashx.textLayout.factory.TruncationOptions;
      
      private var _containerController:ContainerController;
      
      private var _swfContext:ISWFContext;
      
      public function TextLineFactoryBase()
      {
         super();
         this._containerController = new ContainerController(_tc);
         this._horizontalScrollPolicy = this._verticalScrollPolicy = String(ScrollPolicy.scrollPolicyPropertyDefinition.defaultValue);
      }
      
      tlf_internal static function getDefaultFlowComposerClass() : Class
      {
         return FactoryDisplayComposer;
      }
      
      public function get compositionBounds() : Rectangle
      {
         return this._compositionBounds;
      }
      
      public function set compositionBounds(value:Rectangle) : void
      {
         this._compositionBounds = value;
      }
      
      public function getContentBounds() : Rectangle
      {
         return this._contentBounds;
      }
      
      protected function setContentBounds(controllerBounds:Rectangle) : void
      {
         this._contentBounds = controllerBounds;
         this._contentBounds.offset(this.compositionBounds.left,this.compositionBounds.top);
      }
      
      public function get swfContext() : ISWFContext
      {
         return this._swfContext;
      }
      
      public function set swfContext(value:ISWFContext) : void
      {
         this._swfContext = value;
      }
      
      public function get truncationOptions() : flashx.textLayout.factory.TruncationOptions
      {
         return this._truncationOptions;
      }
      
      public function set truncationOptions(value:flashx.textLayout.factory.TruncationOptions) : void
      {
         this._truncationOptions = value;
      }
      
      public function get isTruncated() : Boolean
      {
         return this._isTruncated;
      }
      
      public function get horizontalScrollPolicy() : String
      {
         return this._horizontalScrollPolicy;
      }
      
      public function set horizontalScrollPolicy(scrollPolicy:String) : void
      {
         this._horizontalScrollPolicy = scrollPolicy;
      }
      
      public function get verticalScrollPolicy() : String
      {
         return this._verticalScrollPolicy;
      }
      
      public function set verticalScrollPolicy(scrollPolicy:String) : void
      {
         this._verticalScrollPolicy = scrollPolicy;
      }
      
      protected function get containerController() : ContainerController
      {
         return this._containerController;
      }
      
      protected function callbackWithTextLines(callback:Function, delx:Number, dely:Number) : void
      {
         var textLine:TextLine = null;
         var textBlock:TextBlock = null;
         for each(textLine in _factoryComposer._lines)
         {
            textBlock = textLine.textBlock;
            if(textBlock)
            {
               textBlock.releaseLines(textBlock.firstLine,textBlock.lastLine);
            }
            textLine.userData = null;
            textLine.x = textLine.x + delx;
            textLine.y = textLine.y + dely;
            textLine.validity = TextLineValidity.STATIC;
            callback(textLine);
         }
      }
      
      protected function doesComposedTextFit(lineCountLimit:int, textLength:uint, blockProgression:String) : Boolean
      {
         if(Boolean(lineCountLimit != TruncationOptions.NO_LINE_COUNT_LIMIT) && Boolean(_factoryComposer._lines.length > lineCountLimit))
         {
            return false;
         }
         var lines:Array = _factoryComposer._lines;
         if(!lines.length)
         {
            return Boolean(textLength)?Boolean(false):Boolean(true);
         }
         var lastLine:TextLine = lines[lines.length - 1] as TextLine;
         return lastLine.userData + lastLine.rawTextLength == textLength;
      }
      
      protected function getNextTruncationPosition(truncateAtCharPosition:int, multiPara:Boolean = false) : int
      {
         truncateAtCharPosition--;
         var line:TextLine = _pass0Lines[_truncationLineIndex] as TextLine;
         while(!(Boolean(truncateAtCharPosition >= line.userData) && Boolean(truncateAtCharPosition < line.userData + line.rawTextLength)))
         {
            if(truncateAtCharPosition < line.userData)
            {
               line = _pass0Lines[--_truncationLineIndex] as TextLine;
            }
            if(false)
            {
               break;
            }
         }
         var paraStart:int = !!multiPara?int(line.userData - line.textBlockBeginIndex):int(0);
         var atomIndex:int = line.getAtomIndexAtCharIndex(truncateAtCharPosition - paraStart);
         var nextTruncationPosition:int = line.getAtomTextBlockBeginIndex(atomIndex) + paraStart;
         line.flushAtomData();
         return nextTruncationPosition;
      }
      
      tlf_internal function createFlowComposer() : IFlowComposer
      {
         return new FactoryDisplayComposer();
      }
      
      tlf_internal function computeLastAllowedLineIndex(lineCountLimit:int) : void
      {
         _truncationLineIndex = _factoryComposer._lines.length - 1;
         if(Boolean(lineCountLimit != TruncationOptions.NO_LINE_COUNT_LIMIT) && Boolean(lineCountLimit <= _truncationLineIndex))
         {
            _truncationLineIndex = lineCountLimit - 1;
         }
      }
   }
}

import flashx.textLayout.compose.StandardFlowComposer;
import flashx.textLayout.tlf_internal;
import flashx.textLayout.container.ContainerController;
import flashx.textLayout.factory.TextLineFactoryBase;
import flashx.textLayout.compose.SimpleCompose;
import flashx.textLayout.elements.BackgroundManager;

class FactoryDisplayComposer extends StandardFlowComposer
{
    
   function FactoryDisplayComposer()
   {
      super();
   }
   
   override tlf_internal function callTheComposer(absoluteEndPosition:int, controllerEndIndex:int) : ContainerController
   {
      clearCompositionResults();
      var state:SimpleCompose = TextLineFactoryBase._factoryComposer;
      state.composeTextFlow(textFlow,-1,-1);
      state.releaseAnyReferences();
      return getControllerAt(0);
   }
   
   override protected function preCompose() : Boolean
   {
      return true;
   }
   
   override public function createBackgroundManager() : BackgroundManager
   {
      return new FactoryBackgroundManager();
   }
}

import flashx.textLayout.elements.BackgroundManager;
import flashx.textLayout.compose.TextFlowLine;
import flash.text.engine.TextLine;
import flashx.textLayout.tlf_internal;

use namespace tlf_internal;

class FactoryBackgroundManager extends BackgroundManager
{
    
   function FactoryBackgroundManager()
   {
      super();
   }
   
   override public function finalizeLine(line:TextFlowLine) : void
   {
      var obj:Object = null;
      var textLine:TextLine = line.getTextLine();
      var array:Array = lineDict[textLine];
      if(array)
      {
         obj = array[0];
         if(obj)
         {
            obj.columnRect = line.controller.columnState.getColumnAt(line.columnIndex);
         }
      }
   }
}
