package flashx.textLayout.elements
{
   import flashx.textLayout.tlf_internal;
   import flash.text.engine.GroupElement;
   import flash.text.engine.ContentElement;
   import flash.events.EventDispatcher;
   import flash.utils.getQualifiedClassName;
   
   use namespace tlf_internal;
   
   public class SubParagraphGroupElement extends FlowGroupElement
   {
      
      tlf_internal static const NO_ATTACHED_LISTENERS:uint = 0;
      
      tlf_internal static const INTERNAL_ATTACHED_LISTENERS:uint = 1;
      
      tlf_internal static const CLIENT_ATTACHED_LISTENERS:uint = 2;
      
      tlf_internal static const kMaxSPGEPrecedence:uint = 1000;
      
      tlf_internal static const kMinSPGEPrecedence:uint = 0;
       
      private var _groupElement:GroupElement;
      
      private var _attachedListenerStatus:uint;
      
      private var _canMerge:Boolean;
      
      public function SubParagraphGroupElement()
      {
         this._canMerge = true;
         this._attachedListenerStatus = NO_ATTACHED_LISTENERS;
         super();
      }
      
      override tlf_internal function createContentElement() : void
      {
         var child:FlowElement = null;
         if(this._groupElement)
         {
            return;
         }
         computedFormat;
         this._groupElement = new GroupElement(null);
         for(var i:int = 0; i < numChildren; i++)
         {
            child = getChildAt(i);
            child.createContentElement();
         }
         if(parent)
         {
            parent.insertBlockElement(this,this._groupElement);
         }
      }
      
      override tlf_internal function releaseContentElement() : void
      {
         var child:FlowElement = null;
         if(Boolean(!this.canReleaseContentElement()) || Boolean(this.groupElement == null))
         {
            return;
         }
         for(var i:int = 0; i < numChildren; i++)
         {
            child = getChildAt(i);
            child.releaseContentElement();
         }
         this._groupElement = null;
         if(_computedFormat)
         {
            _computedFormat = null;
         }
      }
      
      override tlf_internal function canReleaseContentElement() : Boolean
      {
         return this._attachedListenerStatus == NO_ATTACHED_LISTENERS;
      }
      
      tlf_internal function get precedence() : uint
      {
         return kMaxSPGEPrecedence;
      }
      
      tlf_internal function get groupElement() : GroupElement
      {
         return this._groupElement;
      }
      
      tlf_internal function get attachedListenerStatus() : int
      {
         return this._attachedListenerStatus;
      }
      
      override tlf_internal function createContentAsGroup() : GroupElement
      {
         return this.groupElement;
      }
      
      override tlf_internal function removeBlockElement(child:FlowElement, block:ContentElement) : void
      {
         var idx:int = this.getChildIndex(child);
         this.groupElement.replaceElements(idx,idx + 1,null);
      }
      
      override tlf_internal function insertBlockElement(child:FlowElement, block:ContentElement) : void
      {
         var idx:int = 0;
         var gc:Vector.<ContentElement> = null;
         var para:ParagraphElement = null;
         if(this.groupElement)
         {
            idx = this.getChildIndex(child);
            gc = new Vector.<ContentElement>();
            gc.push(block);
            this.groupElement.replaceElements(idx,idx,gc);
         }
         else
         {
            child.releaseContentElement();
            para = getParagraph();
            if(para)
            {
               para.createTextBlock();
            }
         }
      }
      
      override tlf_internal function hasBlockElement() : Boolean
      {
         return this.groupElement != null;
      }
      
      override tlf_internal function setParentAndRelativeStart(newParent:FlowGroupElement, newStart:int) : void
      {
         if(newParent == parent)
         {
            return;
         }
         if(Boolean(parent) && Boolean(parent.hasBlockElement()) && Boolean(this.groupElement))
         {
            parent.removeBlockElement(this,this.groupElement);
         }
         if(Boolean(newParent) && Boolean(!newParent.hasBlockElement()) && Boolean(this.groupElement))
         {
            newParent.createContentElement();
         }
         super.setParentAndRelativeStart(newParent,newStart);
         if(Boolean(parent) && Boolean(parent.hasBlockElement()))
         {
            if(!this.groupElement)
            {
               this.createContentElement();
            }
            else
            {
               parent.insertBlockElement(this,this.groupElement);
            }
         }
      }
      
      override public function replaceChildren(beginChildIndex:int, endChildIndex:int, ... rest) : void
      {
         var p:ParagraphElement = this.getParagraph();
         var oldLastLeaf:FlowLeafElement = Boolean(p)?p.getLastLeaf():null;
         var applyParams:Array = [beginChildIndex,endChildIndex];
         super.replaceChildren.apply(this,applyParams.concat(rest));
         if(p)
         {
            p.ensureTerminatorAfterReplace(oldLastLeaf);
         }
      }
      
      tlf_internal function getEventMirror(statusMask:uint = 2) : EventDispatcher
      {
         var para:ParagraphElement = null;
         if(!this._groupElement)
         {
            para = getParagraph();
            if(para)
            {
               para.getTextBlock();
            }
            else
            {
               this.createContentElement();
            }
         }
         if(this._groupElement.eventMirror == null)
         {
            this._groupElement.eventMirror = new EventDispatcher();
         }
         this._attachedListenerStatus = this._attachedListenerStatus | statusMask;
         return this._groupElement.eventMirror;
      }
      
      override tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
         var child:FlowElement = null;
         var origChildEnd:int = 0;
         var newChildEnd:int = 0;
         var prevElement:FlowElement = null;
         var s:SpanElement = null;
         var idx:int = findChildIndexAtPosition(normalizeStart);
         if(Boolean(idx != -1) && Boolean(idx < numChildren))
         {
            child = getChildAt(idx);
            for(normalizeStart = normalizeStart - child.parentRelativeStart; true; )
            {
               origChildEnd = child.parentRelativeStart + child.textLength;
               child.normalizeRange(normalizeStart,normalizeEnd - child.parentRelativeStart);
               newChildEnd = child.parentRelativeStart + child.textLength;
               normalizeEnd = normalizeEnd + (newChildEnd - origChildEnd);
               if(Boolean(child.textLength == 0) && Boolean(!child.bindableElement))
               {
                  this.replaceChildren(idx,idx + 1);
               }
               else if(child.mergeToPreviousIfPossible())
               {
                  prevElement = this.getChildAt(idx - 1);
                  prevElement.normalizeRange(0,prevElement.textLength);
               }
               else
               {
                  idx++;
               }
               if(idx == numChildren)
               {
                  break;
               }
               child = getChildAt(idx);
               if(child.parentRelativeStart > normalizeEnd)
               {
                  break;
               }
               normalizeStart = 0;
            }
         }
         if(Boolean(numChildren == 0) && Boolean(parent != null))
         {
            s = new SpanElement();
            this.replaceChildren(0,0,s);
            s.normalizeRange(0,s.textLength);
         }
      }
      
      override tlf_internal function canOwnFlowElement(elem:FlowElement) : Boolean
      {
         var myClass:String = null;
         var elemClass:String = null;
         var parentClass:String = null;
         var i:int = 0;
         if(elem is FlowLeafElement)
         {
            return true;
         }
         var subParagraphGroupElem:SubParagraphGroupElement = elem as SubParagraphGroupElement;
         if(subParagraphGroupElem)
         {
            myClass = getQualifiedClassName(this);
            elemClass = getQualifiedClassName(elem);
            parentClass = Boolean(parent)?getQualifiedClassName(parent):null;
            if(Boolean(elemClass == myClass) || Boolean(elemClass == parentClass))
            {
               return false;
            }
            for(i = 0; i < subParagraphGroupElem.numChildren; i++)
            {
               if(getQualifiedClassName(subParagraphGroupElem.getChildAt(i)) == myClass)
               {
                  return false;
               }
            }
            return true;
         }
         return false;
      }
      
      tlf_internal function acceptTextBefore() : Boolean
      {
         return true;
      }
      
      tlf_internal function acceptTextAfter() : Boolean
      {
         return true;
      }
   }
}
